/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl_flash.h
* DATE CREATED.. Thu 06/15/2001 
* LAST MODIFIED. Thu 06/15/2001 
*
\******************************************************************************/
#ifndef _BSL_FLASH_H_
#define _BSL_FLASH_H_

#include <csl_emif.h>
#include "bsl_board.h"

#if (FLASH_SUPPORT)
/****************************************\
* FLASH scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _FLASH_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* FLASH global macro declarations
\****************************************/

#if (BOARD_6711DSK | BOARD_6211DSK)
/* Address FLASH ROM in lower half of CE1 */
#define FLASH_START_ADDR    0x90000000
#define FLASH_END_ADDR      0x90020000
#define FLASH_SIZE          (FLASH_END_ADDR - FLASH_START_ADDR)
#define FLASH_PAGE_SIZE     0x80
#define FLASH_PAGE_ADDR(x)  (FLASH_START_ADDR + x*FLASH_PAGE_SIZE)
#define FLASH_ERASE_ALL     0xFFFFFFFF
#endif

/****************************************\
* FLASH global typedef declarations
\****************************************/

/****************************************\
* FLASH global variable declarations
\****************************************/

/****************************************\
* FLASH global function declarations
\****************************************/

BSLAPI void _FLASH_init();
BSLAPI Uint32 FLASH_checksum(Uint32 locator, Uint32 length);
BSLAPI void FLASH_erase(Uint32 locator, Uint32 length);
BSLAPI void FLASH_read(Uint32 locator, Uint32 dst, Uint32 length);
BSLAPI void FLASH_write(Uint32 src, Uint32 locator, Uint32 length);

/****************************************\
* FLASH inline function declarations
\****************************************/

/****************************************\
* FLASH inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* FLASH_SUPPORT */
#endif /* _BSL_FLASH_H_ */
/******************************************************************************\
* End of bsl_flash.h
\******************************************************************************/

