/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl_board.h
* DATE CREATED.. Thu 06/15/2001 
* LAST MODIFIED. Thu 06/15/2001 
*
\******************************************************************************/
#ifndef _BSL_BOARD_H_
#define _BSL_BOARD_H_

#include <csl_stdinc.h>
#include <csl_timer.h>

/****************************************\
* BOARD scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _BOARD_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* BOARD global macro declarations
\****************************************/
#ifndef BOARD_6711DSK
#define BOARD_6711DSK 0
#else
#define CHIP_6711 1
#endif

#ifndef BOARD_6211DSK
#define BOARD_6211DSK 0
#else
#define CHIP_6211 1
#endif

#ifndef BOARD_6201EVM
#define BOARD_6201EVM 0
#else
#define CHIP_6201 1
#endif

#if ((BOARD_6711DSK | BOARD_6211DSK | BOARD_6201EVM)==0)
#error NO BOARD DEFINED
#endif

#include <csl.h>

#define BOARD_NONE 0

#define BOARD_SUPPORT(c0,c1,c2,c3,c4,c5,c6,c7) ( \
  ( c0*BOARD_6711DSK)  | \
  ( c1*BOARD_6211DSK)  | \
  ( c2*BOARD_6201EVM)  | \
  ( c3*BOARD_NONE)  | \
  ( c4*BOARD_NONE)  | \
  ( c5*BOARD_NONE)  | \
  ( c6*BOARD_NONE)  | \
  ( c7*BOARD_NONE)    \
)


/*----------------------------------------------------------------*/
/*                                      6 6 6                     */
/*                                      7 2 2                     */
/*                                      1 1 0                     */
/*                                      1 1 1                     */
/*                                      D D E                     */
/*                                      S S V                     */
/*                                      K K M                     */
/*                                                                */
/*----------------------------------------------------------------*/
#define LED_SUPPORT       BOARD_SUPPORT(1,1,1,0,0,0,0,0)
#define DIP_SUPPORT       BOARD_SUPPORT(1,1,1,0,0,0,0,0)
#define FLASH_SUPPORT     BOARD_SUPPORT(1,1,0,0,0,0,0,0)
#define AD535_SUPPORT     BOARD_SUPPORT(1,1,0,0,0,0,0,0)

#define _BOARD_REGISTER(x)    REG32(x)

#if (BOARD_6711DSK | BOARD_6211DSK)
  #define _BOARD_IOPORT		REG32(0x90080000)
#endif

#if (BOARD_6201EVM)
  #define _BOARD_LED_REG      REG32(_BOARD_cpldBaseAddr + \
                                    (Uint32)BOARD_REG_CPLD_CNTL)
  #define _BOARD_DIP_REG      REG32(_BOARD_cpldBaseAddr + \
                                    (Uint32)BOARD_REG_CPLD_DSPOPT)
#endif

/*----------------------------------------------------------------*/

/****************************************\
* BOARD global typedef declarations
\****************************************/

#if (BOARD_6711DSK | BOARD_6211DSK)
typedef enum {
  BOARD_REG_IOPORT = (int)0x90080000  /* IOPORT (includes LEDs and DIP switch)*/
} BOARD_Reg;
#endif

#if (BOARD_6201EVM)
typedef enum{
  BOARD_REG_CPLD_CNTL      = 0x00,
  BOARD_REG_CPLD_STAT      = 0x04,
  BOARD_REG_CPLD_DIPOPT    = 0x08,
  BOARD_REG_CPLD_DIPBOOT   = 0x0C,
  BOARD_REG_CPLD_DSPOPT    = 0x10,
  BOARD_REG_CPLD_DSPBOOT   = 0x14,
  BOARD_REG_CPLD_FIFOSTAT  = 0x18,
  BOARD_REG_CPLD_SDCNTL    = 0x1C,
  BOARD_REG_CPLD_OSCB      = 0x20,
  BOARD_REG_CPLD_RSEM1     = 0x24,
  BOARD_REG_CPLD_RSEM2     = 0x28,
  BOARD_REG_CPLD_FALC_CNTL = 0x2C,    /* McEVM only */
  BOARD_REG_CPLD_INT_CNTL  = 0x30,    /* McEVM only */
  BOARD_REG_CPLD_MISC_CNTL = 0x34     /* McEVM only */
} BOARD_Reg;
#endif

/****************************************\
* BOARD global variable declarations
\****************************************/
#if (BOARD_6201EVM)
  extern far Uint32 _BOARD_cpldBaseAddr;
#endif

/****************************************\
* BOARD global function declarations
\****************************************/

BSLAPI void _BOARD_init();

/****************************************\
* BOARD inline function declarations
\****************************************/

IDECL Uint32 BOARD_readReg(BOARD_Reg boardRegister);
IDECL void BOARD_writeReg(BOARD_Reg boardRegister, Uint32 val);

/****************************************\
* BOARD inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/

IDEF Uint32 BOARD_readReg(BOARD_Reg boardRegister){
#if (BOARD_6711DSK | BOARD_6211DSK)
  Uint32 temp = _BOARD_REGISTER(boardRegister);
#endif

#if (BOARD_6201EVM)
  Uint32 temp = _BOARD_REGISTER(boardRegister + _BOARD_cpldBaseAddr);
#endif

  return (temp);
}
/*----------------------------------------------------------------------------*/

IDEF void BOARD_writeReg(BOARD_Reg boardRegister, Uint32 val){
#if (BOARD_6711DSK | BOARD_6211DSK)
  Uint32 regAddr = boardRegister;
#endif

#if (BOARD_6201EVM)
  Uint32 regAddr = boardRegister + _BOARD_cpldBaseAddr;
#endif

  _BOARD_REGISTER(regAddr) = val;
}
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* _BSL_BOARD_H_ */
/******************************************************************************\
* End of bsl_board.h
\******************************************************************************/

