;******************************************************************************
;* TMS320C6x ANSI C Codegen                               Version 4.00.beta 1 *
;* Date/Time created: Tue Feb 22 18:11:19 2000                                *
;******************************************************************************

;******************************************************************************
;* GLOBAL FILE PARAMETERS                                                     *
;*                                                                            *
;*   Architecture      : TMS320C620x                                          *
;*   Optimization      : Enabled at level 3                                   *
;*   Optimizing for    : Speed                                                *
;*                       Based on options: -o3, no -ms                        *
;*   Endian            : Little                                               *
;*   Interrupt Thrshld : Disabled                                             *
;*   Memory Model      : Small                                                *
;*   Calls to RTS      : Near                                                 *
;*   Pipelining        : Enabled                                              *
;*   Speculative Load  : Disabled                                             *
;*   Memory Aliases    : Presume not aliases (optimistic)                     *
;*   Debug Info        : Debug                                                *
;*                                                                            *
;******************************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15
	.global	$bss

;	opt6x -h2 -t -n2 -O3 C:\TEMP\TI219_2 C:\TEMP\TI219_4 
	.file	"dtmf.c"
	.file	"C:\ti\c6000\bios\include\std.h"
	.file	"C:\ti\c6000\bios\include\log.h"
	.file	"dtmf.h"
	.file	"C:\ti\c6000\bios\include\log.h"
	.stag	_LOG_Obj, 192
	.member	_bufend, 0, 14, 8, 32
	.member	_flag, 32, 14, 8, 32
	.member	_seqnum, 64, 14, 8, 32
	.member	_curptr, 96, 14, 8, 32
	.member	_lenmask, 128, 14, 8, 32
	.member	_bufbeg, 160, 14, 8, 32
	.eos
	.sym	_Uns, 0, 14, 13, 32
	.sym	_LOG_Obj, 0, 8, 13, 192,_LOG_Obj
	.sym	_String, 0, 18, 13, 32
	.file	"dtmf.c"
	.stag	_T0, 16
	.member	_state, 0, 12, 8, 8
	.member	_flags, 8, 12, 8, 8
	.eos
	.sym	_DTMF_DecObj, 0, 8, 13, 16,_T0
	.file	"dtmf.h"
	.file	"dtmf.c"

	.sect	".cinit"
	.align	8
	.field  	IR_1,32
	.field  	_energy+0,32
	.field  	0,16			; _energy[0] @ 0
	.field  	0,16			; _energy[1] @ 16
	.field  	0,16			; _energy[2] @ 32
	.field  	0,16			; _energy[3] @ 48
	.field  	0,16			; _energy[4] @ 64
	.field  	0,16			; _energy[5] @ 80
	.field  	0,16			; _energy[6] @ 96
	.field  	0,16			; _energy[7] @ 112
	.field  	0,16			; _energy[8] @ 128
	.field  	0,16			; _energy[9] @ 144
	.field  	0,16			; _energy[10] @ 160
	.field  	0,16			; _energy[11] @ 176
IR_1:	.set	24

	.sect	".text"
	.global	_energy
	.bss	_energy,24,4
	.sym	_energy,_energy, 51, 2, 192,, 12

	.sect	".cinit:c"
	.align	8
	.field  	(CIR - $) - 8, 32
	.field  	_coef10+0,32
	.field  	0x694c6d4c,32			; _coef10 @ 0

	.sect	".text"
	.global	_coef10
_coef10:	.usect	".bss:c",4,4
	.sym	_coef10,_coef10, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x5e9b6465,32			; _coef32 @ 0

	.sect	".text"
	.global	_coef32
_coef32:	.usect	".bss:c",4,4
	.sym	_coef32,_coef32, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x3fc54a81,32			; _coef54 @ 0

	.sect	".text"
	.global	_coef54
_coef54:	.usect	".bss:c",4,4
	.sym	_coef54,_coef54, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x2463331d,32			; _coef76 @ 0

	.sect	".text"
	.global	_coef76
_coef76:	.usect	".bss:c",4,4
	.sym	_coef76,_coef76, 4, 2, 32

	.sect	".cinit"
	.align	8
	.field  	IR_2,32
	.field  	_coef1st+0,32
	.field  	0x6d4c,16			; _coef1st[0] @ 0
	.field  	0x694c,16			; _coef1st[1] @ 16
	.field  	0x6465,16			; _coef1st[2] @ 32
	.field  	0x5e9b,16			; _coef1st[3] @ 48
	.field  	0x4a81,16			; _coef1st[4] @ 64
	.field  	0x3fc5,16			; _coef1st[5] @ 80
	.field  	0x331d,16			; _coef1st[6] @ 96
	.field  	0x2463,16			; _coef1st[7] @ 112
IR_2:	.set	16

	.sect	".text"
	.global	_coef1st
	.bss	_coef1st,16,4
	.sym	_coef1st,_coef1st, 51, 2, 128,, 8

	.sect	".cinit"
	.align	8
	.field  	IR_3,32
	.field  	_coef2nd+0,32
	.field  	0x3993,16			; _coef2nd[0] @ 0
	.field  	0x2c96,16			; _coef2nd[1] @ 16
	.field  	0x1d7d,16			; _coef2nd[2] @ 32
	.field  	0xbd8,16			; _coef2nd[3] @ 48
	.field  	0xd6bb,16			; _coef2nd[4] @ 64
	.field  	0xbf89,16			; _coef2nd[5] @ 80
	.field  	0xa8d2,16			; _coef2nd[6] @ 96
	.field  	0x94b0,16			; _coef2nd[7] @ 112
IR_3:	.set	16

	.sect	".text"
	.global	_coef2nd
	.bss	_coef2nd,16,4
	.sym	_coef2nd,_coef2nd, 51, 2, 128,, 8

	.sect	".cinit"
	.align	8
	.field  	IR_4,32
	.field  	_keys+0,32
	.field  	0x1,8			; _keys[0] @ 0
	.field  	0x2,8			; _keys[1] @ 8
	.field  	0x3,8			; _keys[2] @ 16
	.field  	0xa,8			; _keys[3] @ 24
	.field  	0x4,8			; _keys[4] @ 32
	.field  	0x5,8			; _keys[5] @ 40
	.field  	0x6,8			; _keys[6] @ 48
	.field  	0xb,8			; _keys[7] @ 56
	.field  	0x7,8			; _keys[8] @ 64
	.field  	0x8,8			; _keys[9] @ 72
	.field  	0x9,8			; _keys[10] @ 80
	.field  	0xc,8			; _keys[11] @ 88
	.field  	0xe,8			; _keys[12] @ 96
	.field  	0,8			; _keys[13] @ 104
	.field  	0xf,8			; _keys[14] @ 112
	.field  	0xd,8			; _keys[15] @ 120
IR_4:	.set	16

	.sect	".text"
	.global	_keys
	.bss	_keys,16,4
	.sym	_keys,_keys, 60, 2, 128,, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1b85,16			; _thresSignalStrength @ 0

	.sect	".text"
	.global	_thresSignalStrength
_thresSignalStrength:	.usect	".bss:c",2,2
	.sym	_thresSignalStrength,_thresSignalStrength, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x5dc,16			; _thresPauseStrength @ 0

	.sect	".text"
	.global	_thresPauseStrength
_thresPauseStrength:	.usect	".bss:c",2,2
	.sym	_thresPauseStrength,_thresPauseStrength, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x101d,16			; _thresReverseTwist @ 0

	.sect	".text"
	.global	_thresReverseTwist
_thresReverseTwist:	.usect	".bss:c",2,2
	.sym	_thresReverseTwist,_thresReverseTwist, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x2027,16			; _thresStandardTwist @ 0

	.sect	".text"
	.global	_thresStandardTwist
_thresStandardTwist:	.usect	".bss:c",2,2
	.sym	_thresStandardTwist,_thresStandardTwist, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1999,16			; _thresRelativePeak @ 0

	.sect	".text"
	.global	_thresRelativePeak
_thresRelativePeak:	.usect	".bss:c",2,2
	.sym	_thresRelativePeak,_thresRelativePeak, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1999,16			; _thres2ndHarmonics @ 0

	.sect	".text"
	.global	_thres2ndHarmonics
_thres2ndHarmonics:	.usect	".bss:c",2,2
	.sym	_thres2ndHarmonics,_thres2ndHarmonics, 3, 2, 16
	.sect	".text"
	.sym	_dtmfNormalize,_dtmfNormalize, 32, 3, 0
	.func	188
;----------------------------------------------------------------------
; 188 | static void dtmfNormalize(short N, short *buffer)                      
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _dtmfNormalize                                              *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,SP                                   *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,SP                                   *
;*   Local Frame Size  : 0 Args + 0 Auto + 8 Save = 8 byte                    *
;******************************************************************************
_dtmfNormalize:
;** --------------------------------------------------------------------------*
	.sym	_buffer,4, 19, 17, 32
;**	Parameter deleted: N == 164;
	.sym	_normScale,20, 3, 4, 16
	.sym	_normAmplitude,0, 3, 4, 16
	.sym	_normPower,4, 4, 4, 32
	.sym	_buffer,10, 19, 4, 32
           STW     .D2T1   A10,*SP--(8)      ; |188| 
           STW     .D2T2   B3,*+SP(4)        ; |188| 
	.line	2
;----------------------------------------------------------------------
; 190 | int     normPower;              /* (Q30)                        */     
; 191 | int     normLimit=0x00018F9C;   /* = 1/(64*164) 0x00018F9C      (Q30)
;     |  */                                                                    
; 192 | short   normConstant=0x4FF6;    /* = sqrt(64/164) 0x4FF6        (Q15)
;     |  */                                                                    
; 193 | short   normLevel=0x008D;       /* = 0.5*sqrt(2)/164 0x008D     (Q15)
;     |  */                                                                    
; 194 | short   normAmplitude;                                                 
; 195 | short   normScale;                                                     
;----------------------------------------------------------------------
	.line	10
;----------------------------------------------------------------------
; 197 | normPower = (int)(dotprod40(buffer,buffer,N) >> 6);                    
; 199 | if(normPower>normLimit)         {                                      
;----------------------------------------------------------------------
           B       .S1     _dotprod40        ; |197| 
           MVKL    .S2     RL0,B3            ; |197| 
           MVKH    .S2     RL0,B3            ; |197| 
           MV      .L1     A4,A10            ; 
           MV      .L2X    A4,B4             ; 
           MVK     .S1     0xa4,A6           ; |197| 
RL0:       ; CALL OCCURS                     ; |197| 
           MVKL    .S2     0x18f9c,B4        ; |197| 

           SHR     .S1     A5:A4,6,A5:A4     ; |197| 
||         MVKH    .S2     0x18f9c,B4        ; |197| 

           CMPGT   .L2X    A4,B4,B0          ; 
   [!B0]   B       .S1     L1                ; |197| 
           NOP             5
           ; BRANCH OCCURS                   ; |197| 
;** --------------------------------------------------------------------------*
	.line	13
;----------------------------------------------------------------------
; 200 | normAmplitude = sqrt(normPower);                                       
;----------------------------------------------------------------------
           B       .S1     _sqrt             ; |200| 
           MVKL    .S2     RL2,B3            ; |200| 
           MVKH    .S2     RL2,B3            ; |200| 
           NOP             3
RL2:       ; CALL OCCURS                     ; |200| 
           MV      .L1     A4,A0             ; 
	.line	14
;----------------------------------------------------------------------
; 201 | normAmplitude = ((int)normAmplitude * (int)normConstant) >> 15;        
;----------------------------------------------------------------------
           MVK     .S1     10235,A3          ; |201| 
           MPY     .M1     A0,A3,A0          ; |201| 
           NOP             1
           EXT     .S1     A0,2,16,A0        ; 
	.line	15
;----------------------------------------------------------------------
; 202 | normScale = div_q15(normLevel,normAmplitude);                          
;----------------------------------------------------------------------
           B       .S1     _div_q15          ; |202| 
           MVKL    .S2     RL4,B3            ; |202| 
           MV      .L2X    A0,B4             ; |202| 
           MVK     .S1     0x8d,A4           ; |202| 
           MVKH    .S2     RL4,B3            ; |202| 
           NOP             1
RL4:       ; CALL OCCURS                     ; |202| 
           MV      .L2X    A4,B4             ; 
	.line	16
;----------------------------------------------------------------------
; 203 | scale_q15(buffer,normScale,N);                                         
;----------------------------------------------------------------------
           B       .S1     _scale_q15        ; |203| 
           MVKL    .S2     RL6,B3            ; |203| 
           MV      .L1     A10,A4            ; |203| 
           MVKH    .S2     RL6,B3            ; |203| 
           MVK     .S1     0xa4,A6           ; |203| 
           NOP             1
RL6:       ; CALL OCCURS                     ; |203| 
;** --------------------------------------------------------------------------*
L1:    
	.line	18
           LDW     .D2T2   *+SP(4),B3        ; |205| 
           LDW     .D2T1   *++SP(8),A10      ; |205| 
           NOP             3
           B       .S2     B3                ; |205| 
           NOP             5
           ; BRANCH OCCURS                   ; |205| 
	.endfunc	205,000080400h,8


	.sect	".text"
	.sym	_dtmfDigitDetect,_dtmfDigitDetect, 36, 3, 0
	.func	104
;----------------------------------------------------------------------
; 104 | static int dtmfDigitDetect(DTMF_DecObj *chxDecObjPtr, short *buffer)   
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _dtmfDigitDetect                                            *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,SP                    *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,DP,SP                 *
;*   Local Frame Size  : 8 Args + 4 Auto + 24 Save = 36 byte                  *
;******************************************************************************
_dtmfDigitDetect:
;** --------------------------------------------------------------------------*
	.sym	_chxDecObjPtr,4, 24, 17, 32, _T0
	.sym	_buffer,20, 19, 17, 32
	.sym	C$1,0, 19, 4, 32
	.sym	C$2,20, 19, 4, 32
	.sym	C$3,28, 19, 4, 32
	.sym	_flags,26, 12, 4, 8
	.sym	_digit,10, 4, 4, 32
	.sym	_colMaxIndex,12, 3, 1, 16
	.sym	_rowMaxIndex,14, 3, 1, 16
	.sym	_chxDecObjPtr,27, 24, 4, 32, _T0
	.sym	_buffer,11, 19, 4, 32
	.sym	U$46,16, 4, 4, 32
	.sym	K$8,28, 19, 4, 32
           STW     .D2T2   B12,*SP--(40)     ; |104| 
           STW     .D2T1   A10,*+SP(20)      ; |104| 
           STW     .D2T1   A11,*+SP(24)      ; |104| 
           STW     .D2T2   B3,*+SP(28)       ; |104| 
           STW     .D2T2   B10,*+SP(32)      ; |104| 
           STW     .D2T2   B11,*+SP(36)      ; |104| 
	.line	2
;----------------------------------------------------------------------
; 106 | short rowMaxIndex, colMaxIndex;                                        
; 107 | int   coef1, coef2;                                                    
; 108 | int digit = -1;                                                        
; 109 | int keysTableIndex;                                                    
; 110 | unsigned char flags;                                                   
;----------------------------------------------------------------------

           MV      .L2X    A4,B11            ; 
||         MV      .L1X    B4,A11            ; 

	.line	9
;----------------------------------------------------------------------
; 112 | flags     = chxDecObjPtr->flags;                                       
;----------------------------------------------------------------------
           LDBU    .D2T2   *+B11(1),B10      ; |112| 
	.line	12
;----------------------------------------------------------------------
; 115 | goertzel(buffer,&energy[0],coef10,coef32,82);                          
;----------------------------------------------------------------------
           MVK     .S2     (_energy-$bss),B4 ; |115| 
           ADD     .L2     DP,B4,B12         ; 

           B       .S1     _goertzel         ; |115| 
||         LDW     .D2T2   *+DP(_coef32),B6  ; |115| 

           LDW     .D2T1   *+DP(_coef10),A6  ; |115| 
           MVKL    .S2     RL8,B3            ; |115| 
           MV      .L2     B12,B4            ; |115| 
           MV      .L1     A11,A4            ; |115| 

           MVKH    .S2     RL8,B3            ; |115| 
||         MVK     .S1     0x52,A8           ; |115| 

RL8:       ; CALL OCCURS                     ; |115| 
	.line	13
;----------------------------------------------------------------------
; 116 | goertzel(buffer,&energy[4],coef54,coef76,82);                          
;----------------------------------------------------------------------

           B       .S1     _goertzel         ; |116| 
||         LDW     .D2T2   *+DP(_coef76),B6  ; |116| 

           LDW     .D2T1   *+DP(_coef54),A6  ; |116| 
           MVKL    .S2     RL10,B3           ; |116| 
           ADD     .L2     8,B12,B4          ; 
           MV      .L1     A11,A4            ; |116| 

           MVKH    .S2     RL10,B3           ; |116| 
||         MVK     .S1     0x52,A8           ; |116| 

RL10:      ; CALL OCCURS                     ; |116| 
	.line	16
;----------------------------------------------------------------------
; 119 | dtmfMaxSearch(      &rowMaxIndex,                                      
; 120 |                     &colMaxIndex    );                                 
;----------------------------------------------------------------------
           B       .S1     _dtmfMaxSearch    ; |119| 
           MVKL    .S2     RL12,B3           ; |119| 
           ADD     .L2     12,SP,B4          ; |119| 
           ADD     .L1X    14,SP,A4          ; 
           MVKH    .S2     RL12,B3           ; |119| 
           NOP             1
RL12:      ; CALL OCCURS                     ; |119| 
	.line	19
;----------------------------------------------------------------------
; 122 | flags = flags & 0x83;                       /* clear all error flags */
;----------------------------------------------------------------------
           MVK     .S2     131,B4            ; |122| 
           AND     .L2     B4,B10,B4         ; |122| 
           EXTU    .S2     B4,24,24,B10      ; |122| 
	.line	5
           MVK     .S1     0xffffffff,A10    ; |108| 
	.line	13
	.line	24
;----------------------------------------------------------------------
; 127 | if (chxDecObjPtr->state == DTMF_SIG_WAIT)   {                          
; 128 |     VERBOSE_LOG_printf(&trace, "Detector in SIG_WAIT ...");            
;----------------------------------------------------------------------
           LDBU    .D2T2   *B11,B0           ; |127| 
           NOP             4
   [ B0]   B       .S1     L2                ; |127| 
           NOP             5
           ; BRANCH OCCURS                   ; |127| 
;** --------------------------------------------------------------------------*
	.line	27
;----------------------------------------------------------------------
; 130 | if((energy[rowMaxIndex]+energy[colMaxIndex])                           
; 131 |    > thresPauseStrength) {                                             
;----------------------------------------------------------------------
           LDH     .D2T2   *+SP(14),B4       ; |130| 
           LDH     .D2T2   *+SP(12),B5       ; |130| 
           LDH     .D2T2   *+DP(_thresPauseStrength),B6 ; |130| 
           NOP             2
           LDH     .D2T2   *+B12[B4],B4      ; |130| 
           LDH     .D2T2   *+B12[B5],B5      ; |130| 
           NOP             4
           ADD     .L2     B5,B4,B4          ; |130| 
           CMPGT   .L2     B4,B6,B0          ; |130| 
   [!B0]   B       .S1     L5                ; |130| 
           NOP             5
           ; BRANCH OCCURS                   ; |130| 
;** --------------------------------------------------------------------------*
	.line	29
;----------------------------------------------------------------------
; 132 | chxDecObjPtr->state = DTMF_DIGIT_STATE; /* enable digit mode */        
;----------------------------------------------------------------------
           MVK     .S1     1,A0              ; |132| 
           STB     .D2T1   A0,*B11           ; |132| 
	.line	30
;----------------------------------------------------------------------
; 133 | LOG_printf(&trace,                                                     
; 134 |            "... strength is adequate, going to DTMF_DIGIT_STATE");     
; 141 | else        {                                                          
; 142 | VERBOSE_LOG_printf(&trace, "Detector in digit mode ...");              
;----------------------------------------------------------------------
           B       .S1     _LOG_printf       ; |133| 
           MVKL    .S2     SL1+0,B4          ; |133| 
           MVKL    .S2     RL14,B3           ; |133| 
           MVKH    .S2     SL1+0,B4          ; |133| 
           MVKL    .S1     _trace,A4         ; |133| 

           STW     .D2T2   B4,*+SP(4)        ; |133| 
||         MVKH    .S2     RL14,B3           ; |133| 
||         MVKH    .S1     _trace,A4         ; |133| 

RL14:      ; CALL OCCURS                     ; |133| 
           B       .S1     L5                ; |133| 
           NOP             5
           ; BRANCH OCCURS                   ; |133| 
;** --------------------------------------------------------------------------*
L2:    
	.line	40
;----------------------------------------------------------------------
; 143 | if(!(flags & 0xFC))                                                    
;----------------------------------------------------------------------
           EXTU    .S2     B10,24,26,B4      ; |143| 
           SHL     .S2     B4,2,B0           ; |143| 
   [ B0]   B       .S1     L3                ; |143| 
           NOP             5
           ; BRANCH OCCURS                   ; |143| 
;** --------------------------------------------------------------------------*
	.line	41
;----------------------------------------------------------------------
; 144 | flags = dtmfCheckRelPeak(rowMaxIndex,colMaxIndex,flags);               
;----------------------------------------------------------------------

           B       .S1     _dtmfCheckRelPeak ; |144| 
||         LDH     .D2T2   *+SP(12),B4       ; |144| 

           LDH     .D2T1   *+SP(14),A4       ; |144| 
           MVKL    .S2     RL16,B3           ; |144| 
           MVKH    .S2     RL16,B3           ; |144| 
           MV      .L1X    B10,A6            ; |144| 
           NOP             1
RL16:      ; CALL OCCURS                     ; |144| 
           MV      .L2X    A4,B10            ; 
           EXTU    .S2     B10,24,26,B4      ; |144| 
           SHL     .S2     B4,2,B0           ; |144| 
;** --------------------------------------------------------------------------*
L3:    
	.line	42
;----------------------------------------------------------------------
; 145 | if(!(flags & 0xFC))     {                                              
; 146 |     coef1 = (coef1st[colMaxIndex] << 16) + coef1st[rowMaxIndex];       
; 147 |     coef2 = (coef2nd[colMaxIndex] << 16) + coef2nd[rowMaxIndex];       
;----------------------------------------------------------------------
   [ B0]   B       .S1     L4                ; |145| 
           NOP             5
           ; BRANCH OCCURS                   ; |145| 
;** --------------------------------------------------------------------------*
	.line	45
;----------------------------------------------------------------------
; 148 | goertzel(&buffer[0],&energy[8],coef1,coef2,164);                       
; 150 | if(!(flags & 0xFC))                                                    
; 151 | flags = dtmfCheck(flags);                                              
;----------------------------------------------------------------------
           MVK     .S2     (_coef2nd-$bss),B4 ; |148| 
           ADD     .L2     DP,B4,B4          ; 
           MVK     .S1     (_coef1st-$bss),A0 ; |148| 
           ADD     .L1X    DP,A0,A0          ; 
           LDH     .D2T1   *+SP(12),A3       ; |148| 
           LDH     .D2T2   *+SP(12),B5       ; |148| 
           LDH     .D2T2   *+SP(14),B6       ; |148| 
           LDH     .D2T1   *+SP(14),A4       ; |148| 
           MVKL    .S2     RL18,B3           ; |148| 
           MVKH    .S2     RL18,B3           ; |148| 
           MVK     .S1     0xa4,A8           ; |148| 

           LDH     .D2T2   *+B4[B5],B5       ; |148| 
||         LDH     .D1T1   *+A0[A3],A3       ; |148| 

           B       .S1     _goertzel         ; |148| 
||         LDH     .D1T1   *+A0[A4],A0       ; |148| 
||         LDH     .D2T2   *+B4[B6],B6       ; |148| 

           MV      .D1     A11,A4            ; |148| 
           ADD     .D2     B12,16,B4         ; |148| 
           NOP             1

           SHL     .S1     A3,16,A3          ; |148| 
||         SHL     .S2     B5,16,B5          ; |148| 

           ADD     .L1     A0,A3,A6          ; 
||         ADD     .L2     B6,B5,B6          ; 

RL18:      ; CALL OCCURS                     ; |148| 
           B       .S1     _dtmfCheck        ; |148| 
           MVKL    .S2     RL20,B3           ; |148| 
           MV      .L1X    B10,A4            ; |148| 
           MVKH    .S2     RL20,B3           ; |148| 
           NOP             2
RL20:      ; CALL OCCURS                     ; |148| 
           MV      .L2X    A4,B10            ; 
           EXTU    .S2     B10,24,26,B4      ; |148| 
           SHL     .S2     B4,2,B0           ; |148| 
;** --------------------------------------------------------------------------*
L4:    
	.line	49
;----------------------------------------------------------------------
; 152 | if(!(flags & 0xFC))     {                                              
; 153 |     keysTableIndex = (rowMaxIndex<<2) + (colMaxIndex-4);               
;----------------------------------------------------------------------
	.line	51
;----------------------------------------------------------------------
; 154 | digit = keys[keysTableIndex]; /* decoded digit      */                 
;----------------------------------------------------------------------
   [!B0]   LDH     .D2T2   *+SP(12),B5       ; |154| 
   [!B0]   LDH     .D2T2   *+SP(14),B6       ; |154| 
   [!B0]   MVK     .S2     (_keys-4-$bss),B4 ; |154| 
   [!B0]   ADD     .L2     DP,B4,B4          ; |154| 
           NOP             2
   [!B0]   ADDAW   .D2     B5,B6,B5          ; |154| 
   [!B0]   LDBU    .D2T1   *+B5[B4],A10      ; |154| 
           NOP             2
	.line	52
;----------------------------------------------------------------------
; 155 | chxDecObjPtr->state = DTMF_SIG_WAIT; /* wait for digit to end */       
;----------------------------------------------------------------------
   [!B0]   ZERO    .L2     B4                ; |155| 
   [!B0]   STB     .D2T2   B4,*B11           ; |155| 
	.line	56
;----------------------------------------------------------------------
; 159 | if (digit != -1) {                                                     
;----------------------------------------------------------------------
           CMPEQ   .L1     A10,-1,A1         ; |159| 
   [ A1]   B       .S1     L5                ; |159| 
           NOP             5
           ; BRANCH OCCURS                   ; |159| 
;** --------------------------------------------------------------------------*
	.line	57
;----------------------------------------------------------------------
; 160 | LOG_printf(&trace, "... digit %x detected", digit);                    
; 161 | } else {                                                               
; 163 | if (flags & DTMF_SIGSTRENGTH) {                                        
; 164 |     VERBOSE_LOG_printf(&trace, "... error, signal strength");          
; 166 | if (flags & DTMF_REVERSETWIST) {                                       
; 167 |     VERBOSE_LOG_printf(&trace, "... error, reverse twist");            
; 169 | if (flags & DTMF_TWIST) {                                              
; 170 |     VERBOSE_LOG_printf(&trace, "... error, standard twist");           
; 172 | if (flags & DTMF_RELPEAK) {                                            
; 173 |     VERBOSE_LOG_printf(&trace, "... error, relative peak");            
; 175 | if (flags & DTMF_2NDHARM) {                                            
; 176 |     VERBOSE_LOG_printf(&trace, "... error, 2nd harmonic");             
;----------------------------------------------------------------------
           B       .S1     _LOG_printf       ; |160| 
           MVKL    .S2     SL2+0,B4          ; |160| 
           MVKL    .S2     RL22,B3           ; |160| 
           MVKH    .S2     SL2+0,B4          ; |160| 

           STW     .D2T1   A10,*+SP(8)       ; |160| 
||         MVKL    .S1     _trace,A4         ; |160| 

           STW     .D2T2   B4,*+SP(4)        ; |160| 
||         MVKH    .S2     RL22,B3           ; |160| 
||         MVKH    .S1     _trace,A4         ; |160| 

RL22:      ; CALL OCCURS                     ; |160| 
;** --------------------------------------------------------------------------*
L5:    
	.line	78
;----------------------------------------------------------------------
; 181 | chxDecObjPtr->flags = flags;                                           
;----------------------------------------------------------------------
           STB     .D2T2   B10,*+B11(1)      ; |181| 
	.line	80
;----------------------------------------------------------------------
; 183 | return digit;                                                          
;----------------------------------------------------------------------
           MV      .L1     A10,A4            ; |183| 
	.line	81
           LDW     .D2T2   *+SP(28),B3       ; |184| 
           LDW     .D2T1   *+SP(24),A11      ; |184| 
           LDW     .D2T2   *+SP(32),B10      ; |184| 
           LDW     .D2T1   *+SP(20),A10      ; |184| 
           LDW     .D2T2   *+SP(36),B11      ; |184| 
           B       .S2     B3                ; |184| 
           LDW     .D2T2   *++SP(40),B12     ; |184| 
           NOP             4
           ; BRANCH OCCURS                   ; |184| 
	.endfunc	184,01c080c00h,40


	.sect	".text"
	.global	_DTMF_decode
	.sym	_DTMF_decode,_DTMF_decode, 36, 2, 0
	.func	93
;----------------------------------------------------------------------
;  93 | int DTMF_decode(DTMF_DecObj *chxDecObjPtr, short *buffer)              
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _DTMF_decode                                                *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,SP                                *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,SP                                *
;*   Local Frame Size  : 0 Args + 0 Auto + 12 Save = 12 byte                  *
;******************************************************************************
_DTMF_decode:
;** --------------------------------------------------------------------------*
	.sym	_chxDecObjPtr,4, 24, 17, 32, _T0
	.sym	_buffer,20, 19, 17, 32
	.sym	_buffer,10, 19, 4, 32
	.sym	_chxDecObjPtr,11, 24, 4, 32, _T0
           STW     .D2T1   A11,*SP--(16)     ; |93| 
           STW     .D2T1   A10,*+SP(8)       ; |93| 
           STW     .D2T2   B3,*+SP(12)       ; |93| 
	.line	2

           MV      .L1     A4,A11            ; 
||         MV      .S1X    B4,A10            ; 

	.line	4
;----------------------------------------------------------------------
;  96 | dtmfNormalize(164, buffer);                                            
;----------------------------------------------------------------------
           B       .S1     _dtmfNormalize    ; |96| 
           MVKL    .S2     RL24,B3           ; |96| 
           MV      .L1     A10,A4            ; |96| 
           MVKH    .S2     RL24,B3           ; |96| 
           NOP             2
RL24:      ; CALL OCCURS                     ; |96| 
	.line	7
;----------------------------------------------------------------------
;  99 | return dtmfDigitDetect(chxDecObjPtr, buffer);                          
;----------------------------------------------------------------------
           B       .S1     _dtmfDigitDetect  ; |99| 
           MVKL    .S2     RL26,B3           ; |99| 
           MV      .L1     A11,A4            ; |99| 
           MVKH    .S2     RL26,B3           ; |99| 
           MV      .L2X    A10,B4            ; |99| 
           NOP             1
RL26:      ; CALL OCCURS                     ; |99| 
	.line	8
           LDW     .D2T2   *+SP(12),B3       ; |100| 
           LDW     .D2T1   *+SP(8),A10       ; |100| 
           LDW     .D2T1   *++SP(16),A11     ; |100| 
           NOP             2
           B       .S2     B3                ; |100| 
           NOP             5
           ; BRANCH OCCURS                   ; |100| 
	.endfunc	100,000080c00h,16


;******************************************************************************
;* MARK THE END OF THE SCALAR INIT RECORD IN CINIT:C                          *
;******************************************************************************
CIR:	.sect	".cinit:c"
;******************************************************************************
;* STRINGS                                                                    *
;******************************************************************************
	.sect	".const"
SL1:	.string	"... strength is adequate, going to DTMF_DIGIT_STATE",0
SL2:	.string	"... digit %x detected",0
;******************************************************************************
;* UNDEFINED EXTERNAL REFERENCES                                              *
;******************************************************************************
	.global	_LOG_printf
	.global	_dtmfCheck
	.global	_dtmfMaxSearch
	.global	_dtmfCheckRelPeak
	.global	_sqrt
	.global	_div_q15
	.global	_dotprod40
	.global	_scale_q15
	.global	_goertzel
	.global	_trace
