/*****************************************************************
* Application: 	DTMF codec
* File:		dtmf.h
* Description:	Include file for DTMF .c and .asm functions
*		
* History:
* Date		Who		Comment
* 07-24-97	Gunter Schmer	creation
*
*****************************************************************/
#ifndef _DTMF_H
#define _DTMF_H

/* Abstract types used by this code. */
typedef short int16;
typedef unsigned short uns16;
typedef unsigned short unsigned16;

#if !defined(NO_RTA)
/* globals in configuration */
extern far LOG_Obj trace;
#endif

/* struct to pass channel info to decode functions */
typedef struct
{
    /* One of DTMF_DIGIT_STATE, DTMF_SIG_WAIT, DTMF_PAUSE_WAIT */
    unsigned char state;
    
    unsigned char flags;		/* detector flags 			*/
					/* b0 - reserved			*/
					/* b1 - reserved			*/
					/* b2 - error signal strength		*/
					/* b3 - error reverse twist		*/
					/* b4 - error standard twist		*/
					/* b5 - error relative peak		*/
					/* b6 - error 2nd harmonic		*/
					/* b7 - not used			*/
					/*	1 - detector in pause mode 	*/
					/*      0 - detector in digit mode	*/
} DTMF_DecObj;

#define DTMF_SIGSTRENGTH 4
#define DTMF_REVERSETWIST 8
#define DTMF_TWIST 0x10
#define DTMF_RELPEAK 0x20
#define DTMF_2NDHARM 0x40
#define DTMF_PAUSED 0x80

#define DTMF_SIG_WAIT 0     /* The detector is waiting for a signal */
#define DTMF_DIGIT_STATE 1  /* Actively trying to decode */
#define DTMF_PAUSE_WAIT 2   /* Waiting for this number's signal to end */


/* DTMF functions */
extern int DTMF_decode(DTMF_DecObj *, int16 *);
void DTMF_fillBuf(int16 *buf, int size);
void DTMF_sumBuf(int16 *buf, int size);
void DTMF_setOutputDigit(int digit);


#endif /* _DTMF_H */
