/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl.h
* DATE CREATED.. Thu 06/15/2000 
* LAST MODIFIED. Thu 06/15/2001 
*
\******************************************************************************/
#ifndef _BSL_H_
#define _BSL_H_

#include <csl.h>
#include <csl_emif.h>
#include <bsl_board.h>
#include "bsl_dip.h"
#include "bsl_flash.h"
#include "bsl_led.h"
#include "bsl_ad535.h"

/****************************************\
* BSL scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _BSL_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* BSL global macro declarations
\****************************************/

/****************************************\
* BSL global typedef declarations
\****************************************/

/****************************************\
* BSL global variable declarations
\****************************************/

/****************************************\
* BSL global function declarations
\****************************************/
BSLAPI void BSL_init();
BSLAPI void BSL6711DSK_LIB_();
BSLAPI void BSL6211DSK_LIB_();
BSLAPI void BSL6201EVM_LIB_();

/****************************************\
* BSL inline function declarations
\****************************************/

/****************************************\
* special CSL inline function
\****************************************/

/****************************************\
* BSL inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* _BSL_H_ */
/******************************************************************************\
* End of bsl.h
\******************************************************************************/

