*****************************************************************
* Application: 	DTMF codec
* File:		dtmf_max.asm
* Description:	Check 2nd harmonics
*		
* History:
* Date		Who		Comment
* 05-05-98	Gunter Schmer	creation
*
*****************************************************************

*************************************************************************
* Function: 	unsigned char dtmfMaxSearch( 	short *rowMaxIndex    --> A4
*						short *colMaxIndex )  --> B4
*
*					    	    B3 retaddr
*
* Description:	This function searches for rowMax and colMax
*
*
* Regs used:	A0,A1,A2,A3,A4,A5,A6,A7,
*		B0,B1,B2,B3,B4,B5,B6,B7,B8
*
* Regs modified:A0,A1,A2,A3,A4,A5,A6,A7
*		B0,B1,B2,B4,B5,B6,B7,B8
*
* Execution:	17 cycles
*
*************************************************************************
		.global	_dtmfMaxSearch
		.global	_energy
		.text
_dtmfMaxSearch:

;
;------ Register Allocation  ------------------------
;	A0 : 		A4 : &rowMaxIndex	A8 : 
;	A1 : 		A5 : rowMax  		A9 : 
;	A2 : 		A6 : rowMaxIndex	A10: 
;	A3 : 		A7 : rowVal		A11: 
;
;	B0 : 		B4 : &colMaxIndex 	B8 : counter 
;	B1 : 		B5 : colMax		B9 : 
;	B2 : 		B6 : colMaxIndex	B10:
;	B3 : ret addr	B7 : colVal		B11:
;
;	B14: DP
;	B15: SP
;
	MVKL	.S1	_energy,A2		;
||	MVKL	.S2	_energy+8,B2		;

	MVKH	.S1	_energy,A2		;A5 = &energy[0]
||	MVKH	.S2	_energy+8,B2		;B5 = &energy[4]

	LDH	.D1	*A2++,A7		;rowVal = energy[0]
||	LDH	.D2	*B2++,B7		;colVal = energy[4]
||	MVK	.S1	0,A6			;init rowMaxIndex = 0
||	MVK	.S2	0,B6			;init colMaxIndex = 0

	MVK	.S1	0,A5			;init rowMax = 0
||	MVK	.S2	0,B5			;init colMax = 0	

	LDH	.D1	*A2++,A7		;rowVal = energy[1]
||	LDH	.D2	*B2++,B7		;colVal = energy[5]

	MVK	.S2	0,B8			;counter=0	

	LDH	.D1	*A2++,A7		;rowVal = energy[2]
||	LDH	.D2	*B2++,B7		;colVal = energy[6]

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowMax<energy[0]) *** counter=0 ***
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colMax<energy[4])

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowMax = energy[0]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colMax = energy[4]
||[A1]	MV	.L1x	B8,A6			;if(A1==1) rowMaxIndex = counter
||[B1]	MV	.L2	B8,B6			;if(B1==1) colMaxIndex = counter
||	LDH	.D1	*A2++,A7		;rowVal = energy[3]
||	LDH	.D2	*B2++,B7		;colVal = energy[7]

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowMax<energy[1]) *** counter=1 ***
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colMax<energy[4])
||	ADD	.S2	B8,1,B8			;counter++

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowMax = energy[1]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colMax = energy[4]
||[A1]	MV	.L1x	B8,A6			;if(A1==1) rowMaxIndex = counter
||[B1]	MV	.L2	B8,B6			;if(B1==1) colMaxIndex = counter
	
	CMPLT	.L1	A5,A7,A1		;A1 = if(rowMax<energy[2]) *** counter=2 ***
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colMax<energy[6])
||	ADD	.S2	B8,1,B8			;counter++

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowMax = energy[2]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colMax = energy[6]
||[A1]	MV	.L1x	B8,A6			;if(A1==1) rowMaxIndex = counter
||[B1]	MV	.L2	B8,B6			;if(B1==1) colMaxIndex = counter

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowMax<energy[3]) *** counter=3 ***
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colMax<energy[7])
||	ADD	.S2	B8,1,B8			;counter++

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowMax = energy[3]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colMax = energy[7]
||[A1]	MV	.L1x	B8,A6			;if(A1==1) rowMaxIndex = counter
||[B1]	MV	.L2	B8,B6			;if(B1==1) colMaxIndex = counter

	STH	.D1	A6,*A4			;store rowMaxIndex
||	ADD	.L2	B6,4,B6			;colMaxIndex = colMaxIndex+4
||	B	.S2	B3			;return

	STH	.D2	B6,*B4			;store colMaxIndex

	NOP		4
