;******************************************************************************
;* TMS320C6x ANSI C Codegen                               Version 4.00.beta 1 *
;* Date/Time created: Thu Feb 24 16:50:47 2000                                *
;******************************************************************************

;******************************************************************************
;* GLOBAL FILE PARAMETERS                                                     *
;*                                                                            *
;*   Architecture      : TMS320C620x                                          *
;*   Optimization      : Enabled at level 3                                   *
;*   Optimizing for    : Speed                                                *
;*                       Based on options: -o3, no -ms                        *
;*   Endian            : Little                                               *
;*   Interrupt Thrshld : Disabled                                             *
;*   Memory Model      : Small                                                *
;*   Calls to RTS      : Near                                                 *
;*   Pipelining        : Enabled                                              *
;*   Speculative Load  : Disabled                                             *
;*   Memory Aliases    : Presume not aliases (optimistic)                     *
;*   Debug Info        : Debug                                                *
;*                                                                            *
;******************************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15
	.global	$bss

;	opt6x -h2 -t -n2 -O3 C:\TEMP\TI191_2 C:\TEMP\TI191_4 
	.file	"dtmf_gen.c"
	.file	"C:\ti\c6000\cgtools\include\string.h"
	.file	"dtmf.h"
	.file	"C:\ti\c6000\cgtools\include\string.h"
	.sym	_size_t, 0, 14, 13, 32
	.file	"dtmf_gen.c"
	.sym	_int16, 0, 3, 13, 16
	.bss	_rowDelta,2,2
	.sym	_rowDelta,_rowDelta, 13, 3, 16
	.bss	_colDelta,2,2
	.sym	_colDelta,_colDelta, 13, 3, 16
	.bss	_rowPhase,2,2
	.sym	_rowPhase,_rowPhase, 13, 3, 16
	.bss	_colPhase,2,2
	.sym	_colPhase,_colPhase, 13, 3, 16
	.bss	_sampCount,2,2
	.sym	_sampCount,_sampCount, 13, 3, 16
	.bss	_bufHead,4,4
	.sym	_bufHead,_bufHead, 19, 3, 32

	.sect	".cinit"
	.align	8
	.field  	IR_1,32
	.field  	_sine_table+0,32
	.field  	0x324,16			; _sine_table[0] @ 0
	.field  	0x648,16			; _sine_table[1] @ 16
	.field  	0x96b,16			; _sine_table[2] @ 32
	.field  	0xc8c,16			; _sine_table[3] @ 48
	.field  	0xfab,16			; _sine_table[4] @ 64
	.field  	0x12c8,16			; _sine_table[5] @ 80
	.field  	0x15e2,16			; _sine_table[6] @ 96
	.field  	0x18f9,16			; _sine_table[7] @ 112
	.field  	0x1c0c,16			; _sine_table[8] @ 128
	.field  	0x1f1a,16			; _sine_table[9] @ 144
	.field  	0x2224,16			; _sine_table[10] @ 160
	.field  	0x2528,16			; _sine_table[11] @ 176
	.field  	0x2827,16			; _sine_table[12] @ 192
	.field  	0x2b1f,16			; _sine_table[13] @ 208
	.field  	0x2e11,16			; _sine_table[14] @ 224
	.field  	0x30fc,16			; _sine_table[15] @ 240
	.field  	0x33df,16			; _sine_table[16] @ 256
	.field  	0x36ba,16			; _sine_table[17] @ 272
	.field  	0x398d,16			; _sine_table[18] @ 288
	.field  	0x3c57,16			; _sine_table[19] @ 304
	.field  	0x3f17,16			; _sine_table[20] @ 320
	.field  	0x41ce,16			; _sine_table[21] @ 336
	.field  	0x447b,16			; _sine_table[22] @ 352
	.field  	0x471d,16			; _sine_table[23] @ 368
	.field  	0x49b4,16			; _sine_table[24] @ 384
	.field  	0x4c40,16			; _sine_table[25] @ 400
	.field  	0x4ec0,16			; _sine_table[26] @ 416
	.field  	0x5134,16			; _sine_table[27] @ 432
	.field  	0x539b,16			; _sine_table[28] @ 448
	.field  	0x55f6,16			; _sine_table[29] @ 464
	.field  	0x5843,16			; _sine_table[30] @ 480
	.field  	0x5a82,16			; _sine_table[31] @ 496
	.field  	0x5cb4,16			; _sine_table[32] @ 512
	.field  	0x5ed7,16			; _sine_table[33] @ 528
	.field  	0x60ec,16			; _sine_table[34] @ 544
	.field  	0x62f2,16			; _sine_table[35] @ 560
	.field  	0x64e9,16			; _sine_table[36] @ 576
	.field  	0x66d0,16			; _sine_table[37] @ 592
	.field  	0x68a7,16			; _sine_table[38] @ 608
	.field  	0x6a6e,16			; _sine_table[39] @ 624
	.field  	0x6c24,16			; _sine_table[40] @ 640
	.field  	0x6dca,16			; _sine_table[41] @ 656
	.field  	0x6f5f,16			; _sine_table[42] @ 672
	.field  	0x70e3,16			; _sine_table[43] @ 688
	.field  	0x7255,16			; _sine_table[44] @ 704
	.field  	0x73b6,16			; _sine_table[45] @ 720
	.field  	0x7505,16			; _sine_table[46] @ 736
	.field  	0x7642,16			; _sine_table[47] @ 752
	.field  	0x776c,16			; _sine_table[48] @ 768
	.field  	0x7885,16			; _sine_table[49] @ 784
	.field  	0x798a,16			; _sine_table[50] @ 800
	.field  	0x7a7d,16			; _sine_table[51] @ 816
	.field  	0x7b5d,16			; _sine_table[52] @ 832
	.field  	0x7c2a,16			; _sine_table[53] @ 848
	.field  	0x7ce4,16			; _sine_table[54] @ 864
	.field  	0x7d8a,16			; _sine_table[55] @ 880
	.field  	0x7e1e,16			; _sine_table[56] @ 896
	.field  	0x7e9d,16			; _sine_table[57] @ 912
	.field  	0x7f0a,16			; _sine_table[58] @ 928
	.field  	0x7f62,16			; _sine_table[59] @ 944
	.field  	0x7fa7,16			; _sine_table[60] @ 960
	.field  	0x7fd9,16			; _sine_table[61] @ 976
	.field  	0x7ff6,16			; _sine_table[62] @ 992
	.field  	0x7fff,16			; _sine_table[63] @ 1008
	.field  	0x7ff6,16			; _sine_table[64] @ 1024
	.field  	0x7fd9,16			; _sine_table[65] @ 1040
	.field  	0x7fa7,16			; _sine_table[66] @ 1056
	.field  	0x7f62,16			; _sine_table[67] @ 1072
	.field  	0x7f0a,16			; _sine_table[68] @ 1088
	.field  	0x7e9d,16			; _sine_table[69] @ 1104
	.field  	0x7e1e,16			; _sine_table[70] @ 1120
	.field  	0x7d8a,16			; _sine_table[71] @ 1136
	.field  	0x7ce4,16			; _sine_table[72] @ 1152
	.field  	0x7c2a,16			; _sine_table[73] @ 1168
	.field  	0x7b5d,16			; _sine_table[74] @ 1184
	.field  	0x7a7d,16			; _sine_table[75] @ 1200
	.field  	0x798a,16			; _sine_table[76] @ 1216
	.field  	0x7885,16			; _sine_table[77] @ 1232
	.field  	0x776c,16			; _sine_table[78] @ 1248
	.field  	0x7642,16			; _sine_table[79] @ 1264
	.field  	0x7505,16			; _sine_table[80] @ 1280
	.field  	0x73b6,16			; _sine_table[81] @ 1296
	.field  	0x7255,16			; _sine_table[82] @ 1312
	.field  	0x70e3,16			; _sine_table[83] @ 1328
	.field  	0x6f5f,16			; _sine_table[84] @ 1344
	.field  	0x6dca,16			; _sine_table[85] @ 1360
	.field  	0x6c24,16			; _sine_table[86] @ 1376
	.field  	0x6a6e,16			; _sine_table[87] @ 1392
	.field  	0x68a7,16			; _sine_table[88] @ 1408
	.field  	0x66d0,16			; _sine_table[89] @ 1424
	.field  	0x64e9,16			; _sine_table[90] @ 1440
	.field  	0x62f2,16			; _sine_table[91] @ 1456
	.field  	0x60ec,16			; _sine_table[92] @ 1472
	.field  	0x5ed7,16			; _sine_table[93] @ 1488
	.field  	0x5cb4,16			; _sine_table[94] @ 1504
	.field  	0x5a82,16			; _sine_table[95] @ 1520
	.field  	0x5843,16			; _sine_table[96] @ 1536
	.field  	0x55f6,16			; _sine_table[97] @ 1552
	.field  	0x539b,16			; _sine_table[98] @ 1568
	.field  	0x5134,16			; _sine_table[99] @ 1584
	.field  	0x4ec0,16			; _sine_table[100] @ 1600
	.field  	0x4c40,16			; _sine_table[101] @ 1616
	.field  	0x49b4,16			; _sine_table[102] @ 1632
	.field  	0x471d,16			; _sine_table[103] @ 1648
	.field  	0x447b,16			; _sine_table[104] @ 1664
	.field  	0x41ce,16			; _sine_table[105] @ 1680
	.field  	0x3f17,16			; _sine_table[106] @ 1696
	.field  	0x3c57,16			; _sine_table[107] @ 1712
	.field  	0x398d,16			; _sine_table[108] @ 1728
	.field  	0x36ba,16			; _sine_table[109] @ 1744
	.field  	0x33df,16			; _sine_table[110] @ 1760
	.field  	0x30fc,16			; _sine_table[111] @ 1776
	.field  	0x2e11,16			; _sine_table[112] @ 1792
	.field  	0x2b1f,16			; _sine_table[113] @ 1808
	.field  	0x2827,16			; _sine_table[114] @ 1824
	.field  	0x2528,16			; _sine_table[115] @ 1840
	.field  	0x2224,16			; _sine_table[116] @ 1856
	.field  	0x1f1a,16			; _sine_table[117] @ 1872
	.field  	0x1c0c,16			; _sine_table[118] @ 1888
	.field  	0x18f9,16			; _sine_table[119] @ 1904
	.field  	0x15e2,16			; _sine_table[120] @ 1920
	.field  	0x12c8,16			; _sine_table[121] @ 1936
	.field  	0xfab,16			; _sine_table[122] @ 1952
	.field  	0xc8c,16			; _sine_table[123] @ 1968
	.field  	0x96b,16			; _sine_table[124] @ 1984
	.field  	0x648,16			; _sine_table[125] @ 2000
	.field  	0x324,16			; _sine_table[126] @ 2016
	.field  	0,16			; _sine_table[127] @ 2032
	.field  	0xfcdc,16			; _sine_table[128] @ 2048
	.field  	0xf9b8,16			; _sine_table[129] @ 2064
	.field  	0xf695,16			; _sine_table[130] @ 2080
	.field  	0xf374,16			; _sine_table[131] @ 2096
	.field  	0xf055,16			; _sine_table[132] @ 2112
	.field  	0xed38,16			; _sine_table[133] @ 2128
	.field  	0xea1e,16			; _sine_table[134] @ 2144
	.field  	0xe707,16			; _sine_table[135] @ 2160
	.field  	0xe3f4,16			; _sine_table[136] @ 2176
	.field  	0xe0e6,16			; _sine_table[137] @ 2192
	.field  	0xdddc,16			; _sine_table[138] @ 2208
	.field  	0xdad8,16			; _sine_table[139] @ 2224
	.field  	0xd7d9,16			; _sine_table[140] @ 2240
	.field  	0xd4e1,16			; _sine_table[141] @ 2256
	.field  	0xd1ef,16			; _sine_table[142] @ 2272
	.field  	0xcf04,16			; _sine_table[143] @ 2288
	.field  	0xcc21,16			; _sine_table[144] @ 2304
	.field  	0xc946,16			; _sine_table[145] @ 2320
	.field  	0xc673,16			; _sine_table[146] @ 2336
	.field  	0xc3a9,16			; _sine_table[147] @ 2352
	.field  	0xc0e9,16			; _sine_table[148] @ 2368
	.field  	0xbe32,16			; _sine_table[149] @ 2384
	.field  	0xbb85,16			; _sine_table[150] @ 2400
	.field  	0xb8e3,16			; _sine_table[151] @ 2416
	.field  	0xb64c,16			; _sine_table[152] @ 2432
	.field  	0xb3c0,16			; _sine_table[153] @ 2448
	.field  	0xb140,16			; _sine_table[154] @ 2464
	.field  	0xaecc,16			; _sine_table[155] @ 2480
	.field  	0xac65,16			; _sine_table[156] @ 2496
	.field  	0xaa0a,16			; _sine_table[157] @ 2512
	.field  	0xa7bd,16			; _sine_table[158] @ 2528
	.field  	0xa57e,16			; _sine_table[159] @ 2544
	.field  	0xa34c,16			; _sine_table[160] @ 2560
	.field  	0xa129,16			; _sine_table[161] @ 2576
	.field  	0x9f14,16			; _sine_table[162] @ 2592
	.field  	0x9d0e,16			; _sine_table[163] @ 2608
	.field  	0x9b17,16			; _sine_table[164] @ 2624
	.field  	0x9930,16			; _sine_table[165] @ 2640
	.field  	0x9759,16			; _sine_table[166] @ 2656
	.field  	0x9592,16			; _sine_table[167] @ 2672
	.field  	0x93dc,16			; _sine_table[168] @ 2688
	.field  	0x9236,16			; _sine_table[169] @ 2704
	.field  	0x90a1,16			; _sine_table[170] @ 2720
	.field  	0x8f1d,16			; _sine_table[171] @ 2736
	.field  	0x8dab,16			; _sine_table[172] @ 2752
	.field  	0x8c4a,16			; _sine_table[173] @ 2768
	.field  	0x8afb,16			; _sine_table[174] @ 2784
	.field  	0x89be,16			; _sine_table[175] @ 2800
	.field  	0x8894,16			; _sine_table[176] @ 2816
	.field  	0x877b,16			; _sine_table[177] @ 2832
	.field  	0x8676,16			; _sine_table[178] @ 2848
	.field  	0x8583,16			; _sine_table[179] @ 2864
	.field  	0x84a3,16			; _sine_table[180] @ 2880
	.field  	0x83d6,16			; _sine_table[181] @ 2896
	.field  	0x831c,16			; _sine_table[182] @ 2912
	.field  	0x8276,16			; _sine_table[183] @ 2928
	.field  	0x81e2,16			; _sine_table[184] @ 2944
	.field  	0x8163,16			; _sine_table[185] @ 2960
	.field  	0x80f6,16			; _sine_table[186] @ 2976
	.field  	0x809e,16			; _sine_table[187] @ 2992
	.field  	0x8059,16			; _sine_table[188] @ 3008
	.field  	0x8027,16			; _sine_table[189] @ 3024
	.field  	0x800a,16			; _sine_table[190] @ 3040
	.field  	0x8000,16			; _sine_table[191] @ 3056
	.field  	0x800a,16			; _sine_table[192] @ 3072
	.field  	0x8027,16			; _sine_table[193] @ 3088
	.field  	0x8059,16			; _sine_table[194] @ 3104
	.field  	0x809e,16			; _sine_table[195] @ 3120
	.field  	0x80f6,16			; _sine_table[196] @ 3136
	.field  	0x8163,16			; _sine_table[197] @ 3152
	.field  	0x81e2,16			; _sine_table[198] @ 3168
	.field  	0x8276,16			; _sine_table[199] @ 3184
	.field  	0x831c,16			; _sine_table[200] @ 3200
	.field  	0x83d6,16			; _sine_table[201] @ 3216
	.field  	0x84a3,16			; _sine_table[202] @ 3232
	.field  	0x8583,16			; _sine_table[203] @ 3248
	.field  	0x8676,16			; _sine_table[204] @ 3264
	.field  	0x877b,16			; _sine_table[205] @ 3280
	.field  	0x8894,16			; _sine_table[206] @ 3296
	.field  	0x89be,16			; _sine_table[207] @ 3312
	.field  	0x8afb,16			; _sine_table[208] @ 3328
	.field  	0x8c4a,16			; _sine_table[209] @ 3344
	.field  	0x8dab,16			; _sine_table[210] @ 3360
	.field  	0x8f1d,16			; _sine_table[211] @ 3376
	.field  	0x90a1,16			; _sine_table[212] @ 3392
	.field  	0x9236,16			; _sine_table[213] @ 3408
	.field  	0x93dc,16			; _sine_table[214] @ 3424
	.field  	0x9592,16			; _sine_table[215] @ 3440
	.field  	0x9759,16			; _sine_table[216] @ 3456
	.field  	0x9930,16			; _sine_table[217] @ 3472
	.field  	0x9b17,16			; _sine_table[218] @ 3488
	.field  	0x9d0e,16			; _sine_table[219] @ 3504
	.field  	0x9f14,16			; _sine_table[220] @ 3520
	.field  	0xa129,16			; _sine_table[221] @ 3536
	.field  	0xa34c,16			; _sine_table[222] @ 3552
	.field  	0xa57e,16			; _sine_table[223] @ 3568
	.field  	0xa7bd,16			; _sine_table[224] @ 3584
	.field  	0xaa0a,16			; _sine_table[225] @ 3600
	.field  	0xac65,16			; _sine_table[226] @ 3616
	.field  	0xaecc,16			; _sine_table[227] @ 3632
	.field  	0xb140,16			; _sine_table[228] @ 3648
	.field  	0xb3c0,16			; _sine_table[229] @ 3664
	.field  	0xb64c,16			; _sine_table[230] @ 3680
	.field  	0xb8e3,16			; _sine_table[231] @ 3696
	.field  	0xbb85,16			; _sine_table[232] @ 3712
	.field  	0xbe32,16			; _sine_table[233] @ 3728
	.field  	0xc0e9,16			; _sine_table[234] @ 3744
	.field  	0xc3a9,16			; _sine_table[235] @ 3760
	.field  	0xc673,16			; _sine_table[236] @ 3776
	.field  	0xc946,16			; _sine_table[237] @ 3792
	.field  	0xcc21,16			; _sine_table[238] @ 3808
	.field  	0xcf04,16			; _sine_table[239] @ 3824
	.field  	0xd1ef,16			; _sine_table[240] @ 3840
	.field  	0xd4e1,16			; _sine_table[241] @ 3856
	.field  	0xd7d9,16			; _sine_table[242] @ 3872
	.field  	0xdad8,16			; _sine_table[243] @ 3888
	.field  	0xdddc,16			; _sine_table[244] @ 3904
	.field  	0xe0e6,16			; _sine_table[245] @ 3920
	.field  	0xe3f4,16			; _sine_table[246] @ 3936
	.field  	0xe707,16			; _sine_table[247] @ 3952
	.field  	0xea1e,16			; _sine_table[248] @ 3968
	.field  	0xed38,16			; _sine_table[249] @ 3984
	.field  	0xf055,16			; _sine_table[250] @ 4000
	.field  	0xf374,16			; _sine_table[251] @ 4016
	.field  	0xf695,16			; _sine_table[252] @ 4032
	.field  	0xf9b8,16			; _sine_table[253] @ 4048
	.field  	0xfcdc,16			; _sine_table[254] @ 4064
	.field  	0,16			; _sine_table[255] @ 4080
IR_1:	.set	512

	.sect	".text"
	.bss	_sine_table,512,4
	.sym	_sine_table,_sine_table, 51, 3, 4096,, 256

	.sect	".cinit"
	.align	8
	.field  	IR_2,32
	.field  	_stepSize+0,32
	.field  	0xb27,16			; _stepSize[0] @ 0
	.field  	0xc52,16			; _stepSize[1] @ 16
	.field  	0xda2,16			; _stepSize[2] @ 32
	.field  	0xf0e,16			; _stepSize[3] @ 48
	.field  	0x1358,16			; _stepSize[4] @ 64
	.field  	0x1560,16			; _stepSize[5] @ 80
	.field  	0x17a2,16			; _stepSize[6] @ 96
	.field  	0x1a21,16			; _stepSize[7] @ 112
IR_2:	.set	16

	.sect	".text"
	.bss	_stepSize,16,4
	.sym	_stepSize,_stepSize, 61, 3, 128,, 8

	.sect	".cinit"
	.align	8
	.field  	IR_3,32
	.field  	_rowTable+0,32
	.field  	0,8			; _rowTable[0] @ 0
	.field  	0,8			; _rowTable[1] @ 8
	.field  	0,8			; _rowTable[2] @ 16
	.field  	0,8			; _rowTable[3] @ 24
	.field  	0x1,8			; _rowTable[4] @ 32
	.field  	0x1,8			; _rowTable[5] @ 40
	.field  	0x1,8			; _rowTable[6] @ 48
	.field  	0x2,8			; _rowTable[7] @ 56
	.field  	0x2,8			; _rowTable[8] @ 64
	.field  	0x2,8			; _rowTable[9] @ 72
	.field  	0x3,8			; _rowTable[10] @ 80
	.field  	0x3,8			; _rowTable[11] @ 88
	.field  	0x3,8			; _rowTable[12] @ 96
	.field  	0,8			; _rowTable[13] @ 104
	.field  	0x1,8			; _rowTable[14] @ 112
	.field  	0x2,8			; _rowTable[15] @ 120
	.field  	0x3,8			; _rowTable[16] @ 128
IR_3:	.set	17

	.sect	".text"
	.bss	_rowTable,17,4
	.sym	_rowTable,_rowTable, 50, 3, 136,, 17

	.sect	".cinit"
	.align	8
	.field  	IR_4,32
	.field  	_colTable+0,32
	.field  	0,8			; _colTable[0] @ 0
	.field  	0x4,8			; _colTable[1] @ 8
	.field  	0x5,8			; _colTable[2] @ 16
	.field  	0x6,8			; _colTable[3] @ 24
	.field  	0x4,8			; _colTable[4] @ 32
	.field  	0x5,8			; _colTable[5] @ 40
	.field  	0x6,8			; _colTable[6] @ 48
	.field  	0x4,8			; _colTable[7] @ 56
	.field  	0x5,8			; _colTable[8] @ 64
	.field  	0x6,8			; _colTable[9] @ 72
	.field  	0x5,8			; _colTable[10] @ 80
	.field  	0x4,8			; _colTable[11] @ 88
	.field  	0x6,8			; _colTable[12] @ 96
	.field  	0x7,8			; _colTable[13] @ 104
	.field  	0x7,8			; _colTable[14] @ 112
	.field  	0x7,8			; _colTable[15] @ 120
	.field  	0x7,8			; _colTable[16] @ 128
IR_4:	.set	17

	.sect	".text"
	.bss	_colTable,17,4
	.sym	_colTable,_colTable, 50, 3, 136,, 17

	.sect	".cinit:c"
	.align	8
	.field  	(CIR - $) - 8, 32
	.field  	_valid+0,32
	.field  	0,32			; _valid @ 0

	.sect	".text"
_valid:	.usect	".bss:c",4,4
	.sym	_valid,_valid, 4, 3, 32
	.file	"C:\ti\c6000\cgtools\include\string.h"
	.file	"dtmf_gen.c"
	.sect	".text"
	.global	_DTMF_sumBuf
	.sym	_DTMF_sumBuf,_DTMF_sumBuf, 32, 2, 0
	.func	203
;----------------------------------------------------------------------
; 203 | DTMF_sumBuf(int16 *buf, int size)                                      
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _DTMF_sumBuf                                                *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,A12,B0,B1,B2,  *
;*                           B4,B5,B6,B7,B8,B9,SP                             *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,A12,B0,B1,B2,  *
;*                           B3,B4,B5,B6,B7,B8,B9,DP,SP                       *
;*   Local Frame Size  : 0 Args + 0 Auto + 12 Save = 12 byte                  *
;******************************************************************************
_DTMF_sumBuf:
;** --------------------------------------------------------------------------*
	.sym	_buf,4, 19, 17, 32
	.sym	_size,20, 4, 17, 32
	.sym	C$1,20, 13, 4, 16
	.sym	V$0,20, 13, 4, 16
	.sym	V$1,8, 13, 4, 16
	.sym	V$2,6, 13, 4, 16
	.sym	_colSamp,0, 3, 4, 16
	.sym	_rowSamp,0, 3, 4, 16
	.sym	_p,11, 19, 4, 32
	.sym	_i,22, 4, 4, 32
	.sym	_buf,0, 19, 4, 32
	.sym	_size,21, 4, 4, 32
	.sym	K$26,0, 14, 4, 32
	.sym	K$32,5, 19, 4, 32
	.sym	U$9,22, 4, 4, 32
           STW     .D2T1   A12,*SP--(16)     ; |203| 
           STW     .D2T1   A10,*+SP(8)       ; |203| 
           STW     .D2T1   A11,*+SP(12)      ; |203| 
	.line	2
;----------------------------------------------------------------------
; 205 | int i;                                                                 
;----------------------------------------------------------------------
           MV      .L2     B4,B5             ; 
	.line	4
;----------------------------------------------------------------------
; 206 | int16 *p = bufHead = buf;                                              
;----------------------------------------------------------------------
           MV      .L1     A4,A11            ; 
           STW     .D2T1   A11,*+DP(_bufHead) ; |206| 
	.line	6
;----------------------------------------------------------------------
; 208 | if (valid == 1 && sampCount > 0) {                                     
;----------------------------------------------------------------------
           LDHU    .D2T2   *+DP(_sampCount),B4 ; |208| 
           NOP             4
           CMPEQ   .L2     B4,0,B6           ; |208| 
           XOR     .L2     1,B6,B6           ; |208| 
           LDW     .D2T2   *+DP(_valid),B7   ; |208| 
           NOP             4
           CMPEQ   .L2     B7,1,B7           ; |208| 
           AND     .L2     B6,B7,B0          ; |208| 
   [!B0]   B       .S1     L4                ; |208| 
           NOP             5
           ; BRANCH OCCURS                   ; |208| 
;** --------------------------------------------------------------------------*
	.line	7
;----------------------------------------------------------------------
; 209 | for (i = 0; i < size && sampCount > 0; i++) {                          
; 210 |     int16 rowSamp, colSamp, sum;                                       
; 212 |     rowSamp = sine_table[Q7_INTEGER_PART(Q7_ROUND(rowPhase))];         
; 213 |     rowPhase += rowDelta;                                              
; 214 |     colSamp = sine_table[Q7_INTEGER_PART(Q7_ROUND(colPhase))];         
; 215 |     colPhase += colDelta;                                              
; 219 |     sum = ((rowSamp >> 1) + (colSamp >>1)) >> 1;                       
; 220 |     *p++ += sum;                                                       
; 221 |     sampCount--;                                                       
;----------------------------------------------------------------------
           CMPGT   .L2     B5,0,B7           ; |209| 
           AND     .L2     B6,B7,B0          ; |209| 
   [!B0]   B       .S1     L4                ; |209| 
           LDHU    .D2T1   *+DP(_colPhase),A8 ; |209| 
           MVK     .S1     (_sine_table-$bss),A0 ; |209| 
           ADD     .L1X    DP,A0,A5          ; 
           LDHU    .D2T1   *+DP(_rowPhase),A6 ; |209| 
           MVK     .S1     0x40,A0           ; |209| 
           ; BRANCH OCCURS                   ; |209| 
;** --------------------------------------------------------------------------*
           LDHU    .D2T2   *+DP(_rowDelta),B9 ; (P) |213| 
           LDHU    .D2T2   *+DP(_colDelta),B6 ; (P) |215| 
           NOP             1
           MV      .L1     A8,A4

           MVK     .S1     0x1,A1
||         MVC     .S2     CSR,B2
||         ADD     .L1     A0,A4,A3          ; (P) |214| 

           AND     .L2     -2,B2,B7
||         EXTU    .S1     A3,17,24,A3       ; (P) |214| 

           ADD     .L1     A0,A6,A3          ; (P) |212| 
||         MVC     .S2     B7,CSR            ; interrupts off
|| [ A1]   LDH     .D1T1   *+A5[A3],A9       ; (P) |214| 
||         ADD     .L2X    B9,A6,B9          ; (P) |213| 

           ZERO    .L2     B0                ; |209| 
||         SUB     .D2     B4,1,B4           ; (P) |222| 
||         EXTU    .S1     A3,17,24,A6       ; (P) |212| 
||         EXTU    .S2     B9,16,16,B9       ; (P) |213| 

;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*
;*      Known Minimum Trip Count         : 1
;*      Known Max Trip Count Factor      : 1
;*      Loop Carried Dependency Bound(^) : 7
;*      Unpartitioned Resource Bound     : 6
;*      Partitioned Resource Bound(*)    : 7
;*      Resource Partition:
;*                                A-side   B-side
;*      .L units                     0        2     
;*      .S units                     6        3     
;*      .D units                     4        2     
;*      .M units                     0        0     
;*      .X cross paths               2        1     
;*      .T address paths             4        2     
;*      Long read paths              1        0     
;*      Long write paths             0        0     
;*      Logical  ops (.LS)           2        3     (.L or .S unit)
;*      Addition ops (.LSD)          7        4     (.L or .S or .D unit)
;*      Bound(.L .S .LS)             4        4     
;*      Bound(.L .S .D .LS .LSD)     7*       5     
;*
;*      Searching for software pipeline schedule at ...
;*         ii = 7  Schedule found with 3 iterations in parallel
;*      done
;*
;*      Collapsed epilog stages     : 2
;*      Prolog not removed
;*      Collapsed prolog stages     : 0
;*
;*      Minimum required memory pad : 0 bytes
;*
;*      For further improvement on this loop, try option -mh28
;*
;*      Minimum safe trip count     : 1
;*----------------------------------------------------------------------------*
L1:    ; PIPED LOOP PROLOG

           ADD     .L1X    B6,A4,A3          ; (P) |215| 
||         ADD     .L2     1,B0,B6           ; (P) |222| 
||         LDHU    .D2T2   *+DP(_rowDelta),B9 ; (P) @|213| 
||         EXTU    .S2     B4,16,16,B4       ; (P) |222| 
|| [ A1]   LDH     .D1T1   *+A5[A6],A10      ; (P) |212| 

   [ A1]   MV      .S2     B9,B8             ; (P) |222| 
||         EXTU    .S1     A3,16,16,A4       ; (P) |215| 
||         LDHU    .D2T2   *+DP(_colDelta),B0 ; (P) @|215| 
||         CMPEQ   .L2     B4,0,B0           ; (P) |222| 

           MV      .L1     A1,A2
||         ADD     .S1     A0,A4,A3          ; (P) @|214| 
|| [ A1]   MV      .D2     B4,B7             ; (P) |222| 
||         XOR     .S2     1,B0,B0           ; (P) |222| 
||         CMPLT   .L2     B6,B5,B1          ; (P) |222| 

   [ A1]   MV      .L1     A4,A8             ; (P) |222| 
||         AND     .L2     B0,B1,B0          ; (P) |222| 
||         SHR     .S1     A9,1,A7           ; (P) |220| 
|| [ A1]   LDH     .D1T1   *A11,A12          ; (P)  ^ |220| 

;** --------------------------------------------------------------------------*
L2:    ; PIPED LOOP KERNEL

           MV      .L1X    B9,A6             ; Define a twin register
|| [!B0]   ZERO    .D1     A1                ; 
||         EXTU    .S1     A3,17,24,A3       ; @|214| 

   [ A1]   B       .S2     L2                ; |222| 
||         SHR     .S1     A10,1,A3          ; |220| 
||         ADD     .L1     A0,A6,A6          ; @|212| 
|| [ A1]   LDH     .D1T1   *+A5[A3],A9       ; @|214| 
||         ADD     .L2X    B9,A6,B9          ; @|213| 

           ADD     .D1     A7,A3,A4          ; |220| 
||         EXTU    .S2     B9,16,16,B9       ; @|213| 
||         SUB     .L2     B4,1,B4           ; @|222| 
||         EXTU    .S1     A6,17,24,A6       ; @|212| 
||         ADD     .L1X    B0,A4,A3          ; @|215| 

           SHR     .S1     A4,1,A4           ; |220| 
||         ADD     .L2     1,B6,B6           ; @|222| 
||         EXTU    .S2     B4,16,16,B4       ; @|222| 
|| [ A1]   LDH     .D1T1   *+A5[A6],A10      ; @|212| 
||         LDHU    .D2T2   *+DP(_rowDelta),B9 ; @@|213| 

           ADD     .L1     A4,A12,A3         ;  ^ |220| 
||         CMPEQ   .L2     B4,0,B0           ; @|222| 
||         EXTU    .S1     A3,16,16,A4       ; @|215| 
|| [ A1]   MV      .S2     B9,B8             ; @|222| 
||         LDHU    .D2T2   *+DP(_colDelta),B0 ; @@|215| 

           MV      .S1     A1,A2             ; Inserted to split a long life
|| [ A2]   STH     .D1T1   A3,*A11++         ;  ^ |220| 
||         CMPLT   .L2     B6,B5,B1          ; @|222| 
|| [ A1]   MV      .D2     B4,B7             ; @|222| 
||         XOR     .S2     1,B0,B0           ; @|222| 
||         ADD     .L1     A0,A4,A3          ; @@|214| 

           AND     .L2     B0,B1,B0          ; @|222| 
|| [ A1]   MV      .L1     A4,A8             ; @|222| 
||         SHR     .S1     A9,1,A7           ; @|220| 
|| [ A1]   LDH     .D1T1   *A11,A12          ; @ ^ |220| 

;** --------------------------------------------------------------------------*
L3:    ; PIPED LOOP EPILOG
;** --------------------------------------------------------------------------*

           STH     .D2T1   A8,*+DP(_colPhase) ; |222| 
||         MV      .L2     B7,B4
||         MV      .L1X    B8,A6

           STH     .D2T1   A6,*+DP(_rowPhase) ; |222| 
           STH     .D2T2   B4,*+DP(_sampCount) ; |222| 
           MVC     .S2     B2,CSR            ; interrupts on
;** --------------------------------------------------------------------------*
L4:    
	.line	22
           LDW     .D2T1   *+SP(8),A10       ; |224| 

           B       .S2     B3                ; |224| 
||         LDW     .D2T1   *+SP(12),A11      ; |224| 

           LDW     .D2T1   *++SP(16),A12     ; |224| 
           NOP             4
           ; BRANCH OCCURS                   ; |224| 
	.endfunc	224,000001c00h,16


	.sect	".text"
	.global	_DTMF_setOutputDigit
	.sym	_DTMF_setOutputDigit,_DTMF_setOutputDigit, 32, 2, 0
	.func	138
;----------------------------------------------------------------------
; 138 | DTMF_setOutputDigit(int digit)                                         
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _DTMF_setOutputDigit                                        *
;*                                                                            *
;*   Regs Modified     : A0,A1,B4,B5,B6                                       *
;*   Regs Used         : A0,A1,A4,B3,B4,B5,B6,DP                              *
;*   Local Frame Size  : 0 Args + 0 Auto + 0 Save = 0 byte                    *
;******************************************************************************
_DTMF_setOutputDigit:
;** --------------------------------------------------------------------------*
	.sym	_digit,4, 4, 17, 32
	.sym	C$1,22, 29, 4, 32
	.sym	_digit,20, 4, 4, 32
	.line	2
           MV      .L2X    A4,B4             ; |139| 
	.line	4
;----------------------------------------------------------------------
; 141 | valid = 0; /* assumes DTMF_fillBuf always higher priority than this fxn
;     | ; */                                                                   
;----------------------------------------------------------------------
           ZERO    .L2     B5                ; |141| 
           STW     .D2T2   B5,*+DP(_valid)   ; |141| 
	.line	6
;----------------------------------------------------------------------
; 143 | if (digit > 0 && digit <= 16) {                                        
;----------------------------------------------------------------------
           MVK     .S2     16,B5             ; |143| 
           CMPGT   .L2     B4,B5,B5          ; |143| 

           XOR     .L2     1,B5,B5           ; |143| 
||         CMPGT   .L1X    B4,0,A0           ; |143| 

           AND     .L1X    B5,A0,A1          ; |143| 
   [!A1]   B       .S1     L5                ; |143| 
           NOP             5
           ; BRANCH OCCURS                   ; |143| 
;** --------------------------------------------------------------------------*
	.line	8
;----------------------------------------------------------------------
; 145 | rowDelta = stepSize[rowTable[digit]];                                  
;----------------------------------------------------------------------
           MVK     .S1     (_stepSize-$bss),A0 ; |145| 
           ADD     .L2X    DP,A0,B6          ; 
           MVK     .S2     (_rowTable-$bss),B5 ; |145| 
           ADD     .L2     DP,B5,B5          ; |145| 
           LDB     .D2T2   *+B4[B5],B5       ; |145| 
           NOP             4
           LDHU    .D2T2   *+B6[B5],B5       ; |145| 
           NOP             4
           STH     .D2T2   B5,*+DP(_rowDelta) ; |145| 
	.line	9
;----------------------------------------------------------------------
; 146 | colDelta = stepSize[colTable[digit]];                                  
;----------------------------------------------------------------------
           MVK     .S2     (_colTable-$bss),B5 ; |146| 
           ADD     .L2     DP,B5,B5          ; |146| 
           LDB     .D2T2   *+B4[B5],B4       ; |146| 
           NOP             4
           LDHU    .D2T2   *+B6[B4],B4       ; |146| 
           NOP             4
           STH     .D2T2   B4,*+DP(_colDelta) ; |146| 
	.line	11
;----------------------------------------------------------------------
; 148 | rowPhase = 0;                                                          
;----------------------------------------------------------------------
           ZERO    .L2     B4                ; |148| 
           STH     .D2T2   B4,*+DP(_rowPhase) ; |148| 
	.line	12
;----------------------------------------------------------------------
; 149 | colPhase = 0;                                                          
;----------------------------------------------------------------------
           STH     .D2T2   B4,*+DP(_colPhase) ; |149| 
	.line	15
;----------------------------------------------------------------------
; 152 | sampCount = NUM_TONE_SAMPS;                                            
;----------------------------------------------------------------------
           MVK     .S2     4000,B4           ; |152| 
           STH     .D2T2   B4,*+DP(_sampCount) ; |152| 
	.line	18
;----------------------------------------------------------------------
; 155 | valid = 1;                                                             
;----------------------------------------------------------------------
           MVK     .S1     1,A0              ; |155| 
           STW     .D2T1   A0,*+DP(_valid)   ; |155| 
;** --------------------------------------------------------------------------*
L5:    
	.line	20
           B       .S2     B3                ; |157| 
           NOP             5
           ; BRANCH OCCURS                   ; |157| 
	.endfunc	157,000000000h,0


	.sect	".text"
	.global	_DTMF_fillBuf
	.sym	_DTMF_fillBuf,_DTMF_fillBuf, 32, 2, 0
	.func	167
;----------------------------------------------------------------------
; 167 | DTMF_fillBuf(int16 *buf, int size)                                     
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _DTMF_fillBuf                                               *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,A12,B0,B1,B2,  *
;*                           B3,B4,B5,B6,B7,B8,B9,B10,SP                      *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,A12,B0,B1,B2,  *
;*                           B3,B4,B5,B6,B7,B8,B9,B10,DP,SP                   *
;*   Local Frame Size  : 0 Args + 0 Auto + 20 Save = 20 byte                  *
;******************************************************************************
_DTMF_fillBuf:
;** --------------------------------------------------------------------------*
	.sym	_buf,4, 19, 17, 32
	.sym	_size,20, 4, 17, 32
	.sym	C$1,3, 14, 4, 32
	.sym	C$2,20, 14, 4, 32
	.sym	U$9,22, 4, 4, 32
	.sym	U$7,21, 13, 4, 16
	.sym	K$48,8, 19, 4, 32
	.sym	K$43,9, 14, 4, 32
	.sym	_size,24, 4, 4, 32
	.sym	_buf,0, 19, 4, 32
	.sym	_i,20, 4, 4, 32
	.sym	_p,10, 19, 4, 32
	.sym	_rowSamp,0, 3, 4, 16
	.sym	_colSamp,0, 3, 4, 16
	.sym	_m,0, 18, 4, 32
	.sym	_n,16, 14, 4, 32
	.sym	_m,0, 18, 4, 32
	.sym	_n,21, 14, 4, 32
	.sym	V$2,7, 13, 4, 16
	.sym	V$1,5, 13, 4, 16
	.sym	V$0,21, 13, 4, 16
	.sym	K$21,3, 4, 4, 32
	.sym	K$21,3, 4, 4, 32
           STW     .D2T2   B10,*SP--(24)     ; |167| 
           STW     .D2T1   A10,*+SP(8)       ; |167| 
           STW     .D2T1   A11,*+SP(12)      ; |167| 
           STW     .D2T1   A12,*+SP(16)      ; |167| 
           STW     .D2T2   B3,*+SP(20)       ; |167| 
	.line	2
;----------------------------------------------------------------------
; 169 | int i;                                                                 
;----------------------------------------------------------------------
           MV      .L2     B4,B8             ; 
	.line	4
;----------------------------------------------------------------------
; 170 | int16 *p = bufHead = buf;                                              
;----------------------------------------------------------------------
           MV      .L1     A4,A10            ; 

           MV      .L1     A4,A0             ; 
||         STW     .D2T1   A10,*+DP(_bufHead) ; |170| 

	.line	6
;----------------------------------------------------------------------
; 172 | if (valid == 1 && sampCount > 0) {                                     
; 173 |     for (i = 0; i < size && sampCount > 0; i++) {                      
; 174 |         int16 rowSamp, colSamp, sum;                                   
; 176 |         rowSamp = sine_table[Q7_INTEGER_PART(Q7_ROUND(rowPhase))];     
; 177 |         rowPhase += rowDelta;                                          
; 178 |         colSamp = sine_table[Q7_INTEGER_PART(Q7_ROUND(colPhase))];     
; 179 |         colPhase += colDelta;                                          
; 183 |         sum = ((rowSamp >> 1) + (colSamp >>1)); // >> 2;               
; 184 |         *p++ = sum;                                                    
; 185 |         sampCount--;                                                   
; 187 |     if (i < size) {                                                    
; 189 |         memset(p, 0, (size - i) * sizeof(int16));                      
; 191 | } else {                                                               
;----------------------------------------------------------------------
           LDHU    .D2T2   *+DP(_sampCount),B5 ; |172| 
           NOP             4
           CMPEQ   .L2     B5,0,B4           ; |172| 
           XOR     .L2     1,B4,B6           ; |172| 
           LDW     .D2T2   *+DP(_valid),B4   ; |172| 
           NOP             4
           CMPEQ   .L2     B4,1,B4           ; |172| 
           AND     .L2     B6,B4,B0          ; |172| 
   [ B0]   B       .S1     L9                ; |172| 
           NOP             5
           ; BRANCH OCCURS                   ; |172| 
;** --------------------------------------------------------------------------*
; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ENTERING memset()
	.line	26
;----------------------------------------------------------------------
; 192 | memset(p, 0, size * sizeof(int16));                                    
;----------------------------------------------------------------------
           SHL     .S2     B8,1,B0           ; |192| 
   [!B0]   B       .S1     L17               ; |192| 
           ZERO    .L1     A3                ; |192| 
   [ B0]   SUB     .L2     B0,2,B0           ; 
           NOP             3
           ; BRANCH OCCURS                   ; |192| 
;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*
;*      Loop Unroll Multiple             : 2x
;*      Known Minimum Trip Count         : 1
;*      Known Maximum Trip Count         : 1073741823
;*      Known Max Trip Count Factor      : 1
;*      Loop Carried Dependency Bound(^) : 0
;*      Unpartitioned Resource Bound     : 1
;*      Partitioned Resource Bound(*)    : 1
;*      Resource Partition:
;*                                A-side   B-side
;*      .L units                     0        0     
;*      .S units                     1*       0     
;*      .D units                     1*       1*    
;*      .M units                     0        0     
;*      .X cross paths               0        0     
;*      .T address paths             1*       1*    
;*      Long read paths              1*       1*    
;*      Long write paths             0        0     
;*      Logical  ops (.LS)           0        0     (.L or .S unit)
;*      Addition ops (.LSD)          0        1     (.L or .S or .D unit)
;*      Bound(.L .S .LS)             1*       0     
;*      Bound(.L .S .D .LS .LSD)     1*       1*    
;*
;*      Searching for software pipeline schedule at ...
;*         ii = 1  Schedule found with 7 iterations in parallel
;*      done
;*
;*      Collapsed epilog stages     : 6
;*      Collapsed prolog stages     : 0
;*      Minimum required memory pad : 0 bytes
;*
;*      Minimum safe trip count     : 2
;*----------------------------------------------------------------------------*
L6:    ; PIPED LOOP PROLOG

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @|192| 
|| [ B0]   B       .S1     L7                ; (P) |192| 

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @@|192| 
|| [ B0]   B       .S1     L7                ; (P) @|192| 

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @@@|192| 
|| [ B0]   B       .S1     L7                ; (P) @@|192| 

           MV      .L2X    A3,B5
||         SUB     .L1     A0,2,A0           ; |192| 
|| [ B0]   SUB     .S2     B0,2,B0           ; (P) @@@@|192| 
|| [ B0]   B       .S1     L7                ; (P) @@@|192| 

           ADD     .L2X    1,A0,B4           ; 
|| [ B0]   SUB     .S2     B0,2,B0           ; (P) @@@@@|192| 
|| [ B0]   B       .S1     L7                ; (P) @@@@|192| 

;** --------------------------------------------------------------------------*
L7:    ; PIPED LOOP KERNEL

           STB     .D1T1   A3,*++A0(2)       ; |192| 
||         STB     .D2T2   B5,*++B4(2)       ; |192| 
|| [ B0]   B       .S1     L7                ; @@@@@|192| 
|| [ B0]   SUB     .L2     B0,2,B0           ; @@@@@@|192| 

;** --------------------------------------------------------------------------*
L8:    ; PIPED LOOP EPILOG
;** --------------------------------------------------------------------------*
           B       .S2     L17               ; |192| 
           NOP             5
           ; BRANCH OCCURS                   ; |192| 
;** --------------------------------------------------------------------------*
L9:    
	.line	7
           ZERO    .L2     B4                ; |173| 
           CMPGT   .L2     B8,0,B7           ; |173| 
           AND     .L2     B6,B7,B0          ; |173| 
   [!B0]   B       .S1     L13               ; |173| 
           LDHU    .D2T1   *+DP(_rowPhase),A7 ; |173| 
           MVK     .S1     (_sine_table-$bss),A0 ; |173| 
           ADD     .L1X    DP,A0,A8          ; 
           LDHU    .D2T1   *+DP(_colPhase),A5 ; |173| 
           MVK     .S1     0x40,A9           ; |173| 
           ; BRANCH OCCURS                   ; |173| 
;** --------------------------------------------------------------------------*
           MVC     .S2     CSR,B10
           AND     .L2     -2,B10,B6

           LDHU    .D2T2   *+DP(_rowDelta),B0 ; (P) |177| 
||         MVC     .S2     B6,CSR            ; interrupts off

           LDHU    .D2T2   *+DP(_colDelta),B2 ; (P) |179| 

           SUB     .L2     B5,1,B5           ; (P) |186| 
||         ADD     .L1     A9,A7,A3          ; (P) |176| 

           EXTU    .S2     B5,16,16,B5       ; (P) |186| 

           ADD     .S2     1,B4,B4           ; (P) |186| 
||         SUB     .D2     B5,1,B1           ; (P) @|186| 
||         EXTU    .S1     A3,17,24,A6       ; (P) |176| 
||         CMPEQ   .L2     B5,0,B9           ; (P) |186| 

           ADD     .S1     A9,A5,A3          ; (P) |178| 
||         XOR     .S2     1,B9,B0           ; (P) |186| 
||         ADD     .L1X    B0,A7,A7          ; (P) |177| 
||         CMPLT   .L2     B4,B8,B9          ; (P) |186| 

           MVK     .S1     0x1,A1
||         AND     .L2     B0,B9,B0          ; (P) |186| 
||         ADD     .S2X    B2,A5,B9          ; (P) |179| 
||         LDHU    .D2T2   *+DP(_rowDelta),B2 ; (P) @|177| 

;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*
;*      Known Minimum Trip Count         : 1
;*      Known Max Trip Count Factor      : 1
;*      Loop Carried Dependency Bound(^) : 4
;*      Unpartitioned Resource Bound     : 6
;*      Partitioned Resource Bound(*)    : 6
;*      Resource Partition:
;*                                A-side   B-side
;*      .L units                     0        2     
;*      .S units                     5        3     
;*      .D units                     3        2     
;*      .M units                     0        0     
;*      .X cross paths               3        1     
;*      .T address paths             3        2     
;*      Long read paths              1        0     
;*      Long write paths             0        0     
;*      Logical  ops (.LS)           3        3     (.L or .S unit)
;*      Addition ops (.LSD)          6        4     (.L or .S or .D unit)
;*      Bound(.L .S .LS)             4        4     
;*      Bound(.L .S .D .LS .LSD)     6*       5     
;*
;*      Searching for software pipeline schedule at ...
;*         ii = 6  Schedule found with 4 iterations in parallel
;*      done
;*
;*      Collapsed epilog stages     : 3
;*      Prolog not removed
;*      Collapsed prolog stages     : 0
;*
;*      Minimum required memory pad : 0 bytes
;*
;*      Minimum safe trip count     : 1
;*----------------------------------------------------------------------------*
L10:    ; PIPED LOOP PROLOG

   [ A1]   MV      .L2     B5,B7             ; (P) |186| 
|| [ A1]   MV      .L1X    B4,A0             ; (P) |186| 
||         LDHU    .D2T2   *+DP(_colDelta),B9 ; (P) @|179| 
||         EXTU    .S1     A7,16,16,A7       ; (P) |177| 
|| [ A1]   LDH     .D1T1   *+A8[A6],A11      ; (P)  ^ |176| 

   [ A1]   MV      .L1     A7,A4             ; (P) |186| 
||         ADD     .D1     A9,A7,A3          ; (P) @|176| 
||         EXTU    .S2     B9,16,16,B9       ; (P) |179| 
||         EXTU    .S1     A3,17,24,A12      ; (P) |178| 

   [ A1]   MV      .L2     B9,B6             ; (P) |186| 
|| [ A1]   LDH     .D1T1   *+A8[A12],A3      ; (P)  ^ |178| 
||         EXTU    .S2     B1,16,16,B5       ; (P) @|186| 

           SUB     .S2     B5,1,B1           ; (P) @@|186| 
||         ADD     .D2     1,B4,B4           ; (P) @|186| 
||         MV      .L1X    B9,A3             ; (P) Define a twin register
||         EXTU    .S1     A3,17,24,A6       ; (P) @|176| 
||         CMPEQ   .L2     B5,0,B9           ; (P) @|186| 

           ADD     .S1     A9,A3,A12         ; (P) @|178| 
||         XOR     .S2     1,B9,B2           ; (P) @|186| 
||         ADD     .L1X    B2,A7,A7          ; (P) @|177| 
||         CMPLT   .L2     B4,B8,B3          ; (P) @|186| 

           MV      .L1     A1,A2
|| [!B0]   ZERO    .D1     A1                ; (P)  ^ 
||         AND     .L2     B2,B3,B0          ; (P) @|186| 
||         ADD     .S2X    B9,A3,B9          ; (P) @|179| 
||         SHR     .S1     A11,1,A5          ; (P)  ^ |184| 
||         LDHU    .D2T2   *+DP(_rowDelta),B9 ; (P) @@|177| 

;** --------------------------------------------------------------------------*
L11:    ; PIPED LOOP KERNEL

   [ A1]   B       .S2     L11               ; |186| 
|| [ A1]   MV      .L1X    B4,A0             ; @|186| 
|| [ A1]   MV      .L2     B5,B7             ; @|186| 
||         EXTU    .S1     A7,16,16,A7       ; @|177| 
|| [ A1]   LDH     .D1T1   *+A8[A6],A11      ; @ ^ |176| 
||         LDHU    .D2T2   *+DP(_colDelta),B9 ; @@|179| 

   [ A1]   MV      .L1     A7,A4             ; @|186| 
||         EXTU    .S1     A12,17,24,A12     ; @|178| 
||         EXTU    .S2     B9,16,16,B9       ; @|179| 
||         ADD     .D1     A9,A7,A6          ; @@|176| 

           SHR     .S1     A3,1,A12          ;  ^ |184| 
|| [ A1]   MV      .L2     B9,B6             ; @|186| 
|| [ A1]   LDH     .D1T1   *+A8[A12],A3      ; @ ^ |178| 
||         EXTU    .S2     B1,16,16,B5       ; @@|186| 

           ADD     .D1     A12,A5,A12        ;  ^ |184| 
||         MV      .L1X    B9,A5             ; @Define a twin register
||         ADD     .D2     1,B4,B4           ; @@|186| 
||         CMPEQ   .L2     B5,0,B2           ; @@|186| 
||         EXTU    .S1     A6,17,24,A6       ; @@|176| 
||         SUB     .S2     B5,1,B1           ; @@@|186| 

   [ A2]   STH     .D1T1   A12,*A10++        ;  ^ |184| 
||         CMPLT   .L2     B4,B8,B3          ; @@|186| 
||         XOR     .S2     1,B2,B2           ; @@|186| 
||         ADD     .S1     A9,A5,A12         ; @@|178| 
||         ADD     .L1X    B9,A7,A7          ; @@|177| 

           MV      .L1     A1,A2             ;  ^ Inserted to split a long life
|| [!B0]   ZERO    .D1     A1                ; @ ^ 
||         SHR     .S1     A11,1,A5          ; @ ^ |184| 
||         AND     .L2     B2,B3,B0          ; @@|186| 
||         ADD     .S2X    B9,A5,B9          ; @@|179| 
||         LDHU    .D2T2   *+DP(_rowDelta),B9 ; @@@|177| 

;** --------------------------------------------------------------------------*
L12:    ; PIPED LOOP EPILOG
;** --------------------------------------------------------------------------*

           MV      .L2X    A0,B4
||         MV      .S1     A4,A7
||         MV      .S2     B7,B5
||         MV      .L1X    B6,A5

           STH     .D2T1   A5,*+DP(_colPhase) ; |186| 
           STH     .D2T2   B5,*+DP(_sampCount) ; |186| 

           STH     .D2T1   A7,*+DP(_rowPhase) ; |186| 
||         MVC     .S2     B10,CSR           ; interrupts on

;** --------------------------------------------------------------------------*
L13:    
	.line	21
           CMPLT   .L2     B4,B8,B0          ; |187| 
   [!B0]   B       .S1     L18               ; |187| 
           NOP             5
           ; BRANCH OCCURS                   ; |187| 
;** --------------------------------------------------------------------------*
; >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> ENTERING memset()
	.line	23
           SHL     .S2     B4,1,B4           ; |189| 
           SHL     .S1X    B8,1,A3           ; |189| 
           SUB     .L2X    A3,B4,B5          ; |189| 
           MV      .L1     A10,A0            ; |189| 
           CMPEQ   .L2X    A3,B4,B0          ; |189| 
   [ B0]   B       .S1     L17               ; |189| 
           ZERO    .L1     A3                ; |189| 
   [!B0]   SUB     .L2     B5,2,B0           ; 
           NOP             3
           ; BRANCH OCCURS                   ; |189| 
;*----------------------------------------------------------------------------*
;*   SOFTWARE PIPELINE INFORMATION
;*
;*      Loop Unroll Multiple             : 2x
;*      Known Minimum Trip Count         : 1
;*      Known Maximum Trip Count         : 1073741823
;*      Known Max Trip Count Factor      : 1
;*      Loop Carried Dependency Bound(^) : 0
;*      Unpartitioned Resource Bound     : 1
;*      Partitioned Resource Bound(*)    : 1
;*      Resource Partition:
;*                                A-side   B-side
;*      .L units                     0        0     
;*      .S units                     1*       0     
;*      .D units                     1*       1*    
;*      .M units                     0        0     
;*      .X cross paths               0        0     
;*      .T address paths             1*       1*    
;*      Long read paths              1*       1*    
;*      Long write paths             0        0     
;*      Logical  ops (.LS)           0        0     (.L or .S unit)
;*      Addition ops (.LSD)          0        1     (.L or .S or .D unit)
;*      Bound(.L .S .LS)             1*       0     
;*      Bound(.L .S .D .LS .LSD)     1*       1*    
;*
;*      Searching for software pipeline schedule at ...
;*         ii = 1  Schedule found with 7 iterations in parallel
;*      done
;*
;*      Collapsed epilog stages     : 6
;*      Collapsed prolog stages     : 0
;*      Minimum required memory pad : 0 bytes
;*
;*      Minimum safe trip count     : 2
;*----------------------------------------------------------------------------*
L14:    ; PIPED LOOP PROLOG

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @|189| 
|| [ B0]   B       .S1     L15               ; (P) |189| 

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @@|189| 
|| [ B0]   B       .S1     L15               ; (P) @|189| 

   [ B0]   SUB     .L2     B0,2,B0           ; (P) @@@|189| 
|| [ B0]   B       .S1     L15               ; (P) @@|189| 

           SUB     .L1     A0,2,A0           ; |189| 
||         MV      .L2X    A3,B5
|| [ B0]   SUB     .S2     B0,2,B0           ; (P) @@@@|189| 
|| [ B0]   B       .S1     L15               ; (P) @@@|189| 

           ADD     .L2X    1,A0,B4           ; 
|| [ B0]   SUB     .S2     B0,2,B0           ; (P) @@@@@|189| 
|| [ B0]   B       .S1     L15               ; (P) @@@@|189| 

;** --------------------------------------------------------------------------*
L15:    ; PIPED LOOP KERNEL

           STB     .D1T1   A3,*++A0(2)       ; |189| 
||         STB     .D2T2   B5,*++B4(2)       ; |189| 
|| [ B0]   B       .S1     L15               ; @@@@@|189| 
|| [ B0]   SUB     .L2     B0,2,B0           ; @@@@@@|189| 

;** --------------------------------------------------------------------------*
L16:    ; PIPED LOOP EPILOG
;** --------------------------------------------------------------------------*
L17:    
; <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< LEAVING memset()
;** --------------------------------------------------------------------------*
L18:    
	.line	28
           LDW     .D2T2   *+SP(20),B3       ; |194| 
           LDW     .D2T1   *+SP(12),A11      ; |194| 
           LDW     .D2T1   *+SP(8),A10       ; |194| 
           LDW     .D2T1   *+SP(16),A12      ; |194| 
           LDW     .D2T2   *++SP(24),B10     ; |194| 
           B       .S2     B3                ; |194| 
           NOP             5
           ; BRANCH OCCURS                   ; |194| 
	.endfunc	194,004081c00h,24


;******************************************************************************
;* MARK THE END OF THE SCALAR INIT RECORD IN CINIT:C                          *
;******************************************************************************
CIR:	.sect	".cinit:c"
