function [bt,at]=trasla3(b,a,w1,w2,teta)
% Trasla in frequenza un filtro numerico del terzo ordine
% b coefficienti del numeratore
% a      "       del denominatore
% w1 frequenza di taglio inferiore
% w2 frequenza di taglio superiore
% teta frequenza di taglio del filtro di partenza (passa-basso)

alfa=cos((w1+w2)/2)/cos((w2-w1)/2);
k=cot((w2-w1)/2)*tan(teta/2);
A=2*alfa*k/(k+1);
B=(k-1)/(k+1);
M=[   -1			 		   B 							     -B^2 							B^3
      3*A 					-(2*A*B+A) 					  A*B^2+2*A*B 				   -3*A*B^2
      -(3*A^2+3*B)		A^2*B+2*A^2+2*B^2+1	     -(B^3+2*A^2*B+A^2+2*B)	3*A^2*B+3*B^2
      A^3+6*A*B			-(A^3+2*A*B^2+2*A*B+2*A)  A^3+2*A*B^2+2*A*B+2*A  	-(A^3+6*A*B)
      -(3*A^2*B+3*B^2)	2*A^2*B+B^3+A^2+2*B  	  -(A^2*B+2*A^2+2*B^2+1)	3*A^2+3*B
      3*A*B^2				-(A*B^2+2*A*B)				  2*A*B+A						-3*A
      -B^3					B^2							  -B								1   ];
at=a*M';
bt=b*M';
m=at(1);
at=at/m;
bt=bt/m;