	.mmregs

; SETTINGS

	.ds     0f00h	; Inizio della memoria dati

TA      .word   9	; Frequenza di campionamento=16kHz
RA      .word   9	
TB      .word   36
RB      .word   36
AIC_CTR .word   08h

a6      .word   614	; Coefficienti del filtro
a5      .word   0
a4      .word   2105
a3      .word   0
a2      .word   2486
a1      .word   0

b6      .word   -114
b5      .word   0
b4      .word   342
b3      .word   0
b2      .word   -342
b1      .word   0
b0      .word   114

XN      .word   0	; x(n)
XN1     .word   0	; x(n-1)
XN2     .word   0	; x(n-2)
XN3     .word   0	; x(n-3)
XN4     .word   0	; x(n-4)
XN5     .word   0	; x(n-5)
XN6     .word   0	; x(n-6)
EM1     .word   0

YN1     .word   0	; y(n-1)
YN2     .word   0	; y(n-2)
YN3     .word   0	; y(n-3)
YN4     .word   0	; y(n-4)
YN5     .word   0	; y(n-5)
YN6     .word   0	; y(n-6)

;INTERRUPT SETTINGS                                  

	.ps     080ah   ; Assembla all'indirizzo indicato 

RINT    b       RX	; Salta a RX quando c' interruzione di ricezione
XINT    b       TX      ; Salta a TX quando c' interruzione di trasmissione 

;PROCESSOR INITIALISATION                                                

	.ps 0a00h       ; Assembla all'indirizzo indicato

	.entry          ; Punto d'ingresso al programma
	.text		; testo

START   setc    INTM        ; Disabilita le interruzioni
        ldp     #0          ; Setta dp a 0
	splk    #0834h,PMST ; Scrive una stringa a 16 bit nel registro PMST
	lacc    #0          ; Carica l'accumulatore con 0

	samm    CWSR        ; Inizializza il registro CWSR
	samm    PDWSR	    ; Inizializza il registro PDWSR
	splk    #022h,IMR   ; Seleziona le interruzioni da mascherare
	call    AIC	    ; Chiama la subroutine AIC
       
	clrc    OVM         ; Overflow mode = 0
	spm     0    	    ; Product Shift mode = 0
	splk    #012h,IMR   ; Maschera le interruzioni
	clrc    INTM        ; Abilita le interruzioni

;MAIN PROGRAM

WAIT    idle 		; Attende un'interruzione
	nop 		; No operation
	nop		; No operation
	b       WAIT	; Salta a WAIT

;RECEIVE INTERRUPT SERVICE ROUTINE

RX      ldp     #0	 ; Carica la pagina 0
	clrc    INTM	 ; Abilita le interruzioni
	lamm    DRR	 ; Legge i dati dal registro di ingresso seriale
	and     #0FFFCh  ; Azzera i 2 bit meno significativi dell'accumulatore
	ldp     #30	 ; Carica la pagina 30
	sacl    XN	 ; memorizza la parola ricevuta in XN
	lar     AR0,#YN6 ; AR0 = y(n-6)
	zap		 ; Azzera ACC e PREG
	mar     *,AR0	 ; AR0  il registro corrente
	rpt     #5	 ; Ripete la successiva linea 6 volte
	macd    #a6,*-   ; Moltiplica e accumula
	apac		 ; Aggiunge l'ultimo prodotto
	neg              ; Nega il contenuto dell'accumulatore
	rpt     #4       ; Divide il contenuto dell'accumulatore per 32
	sfl
	lar     AR0,#XN6 ; AR0 = x(n-6)
	mar     *,AR0	 ; AR0  il registro corrente
	zpr		 ; Azzera PREG
	rpt     #6	 ; Ripete 7 volte l'istruzione successiva
	macd    #b6,*-   ; Moltiplica e accumula
	apac		 ; Aggiunge l'ultimo prodotto
	sach    YN1,1    ; Memorizza il risultato in YN1
	lacc    YN1      ; Carica l'accumulatore con YN1
	and     #0FFFCh  ; Azzera i 2 bit meno significativi di ACC
	ldp     #0       ; Carica la pagina 0
	samm    DXR      ; Copia l'accumulatore nel registro di trasmissione
	clrc    INTM	 ; Abilita le interruzioni
	rete             ; Ritorna al programma principale

;TRANSMIT INTERRUPT SERVICE ROUTINE

TX      rete               ; Ritorna al programma principale

;BOARD INITIALISATION

AIC     splk    #20h,TCR  
	splk    #01h,PRD
	mar     *,AR0 
	lacc    #0008h
	sacl    SPC 
	lacc    #00C8h 
	sacl    SPC
       
	lacc    #080h
	sach    DXR
	sacl    GREG
	lar     AR0,#0FFFFh
	rpt     #10000
	lacc    *,0,AR0
	sach    GREG
	
	ldp     #TA   
	setc    SXM
	lacc    TA,9
	add     RA,2 
	call    AIC2ND  

	ldp     #TB 
	lacc    TB,9  
	add     RB,2  
	add     #02h 
	call    AIC2ND 

	ldp     #AIC_CTR     
	lacc    AIC_CTR,2  
	add     #03h   
	call    AIC2ND 
	ret  

AIC2ND  ldp     #0 
	sach    DXR
	clrc    INTM
	idle 
	add     #6h,15
	sach    DXR 
	idle
	sacl    DXR
	idle
	lacl    #0
	sacl    DXR
	idle
	setc    INTM
	ret

	.end
