Attribute VB_Name = "General"
Public fMainForm As frmMain


Global utente As String
Global logfile As Boolean

Global nome_strumento As String
Global numero_seriale As String
Global inventario As String
Global comando_volt As String
Global comando_ampere As String
Global gpib_primario As String

Global fondo_scala As Integer
Global opzione As Integer
Global campioni As Integer


Sub Main()
    Dim fLogin As New frmLogin
    fLogin.Show vbModal
    If Not fLogin.OK Then
        'L'accesso non  riuscito e pertanto esce dall'applicazione
        End
    End If
    Unload fLogin


    frmSplash.Show
    frmSplash.Refresh
    
    Set fMainForm = New frmMain
    'Unload frmSplash
    Load fMainForm
    Unload frmSplash


    fMainForm.Show
End Sub
Public Function leggiValore(a As Integer) As Double
    
    'La funzione LeggiValore riceve come parametro l'identificatore
    'della scheda ed esegue una lettura completa dallo strumento
    'il cui indirizzo  gpib_primario
    
    Dim comando As String
    Dim BufferDato As String * 20
    Dim count As Long
    
    'La stringa COMANDO contiene la sequenza ASCII per impostare la
    'scheda come parlatore (carattere @) e lo strumento come
    'ascoltatore (ASCII 32+indirizzo strumento)
    'La stringa "?_" serve ad annullare la precedente impostazione
    
    comando = "?_@" & Chr$(32 + gpib_primario)
    
    'La call ibcmd seguente esegue il comando
    
    Call ibcmd(a, comando)
    
    'La call ibwrt fa eseguire allo strumento un particolare comando
    'in questo caso comando_volt permette di eseguire una lettura
    'di tensione e di rendere disponibile il dato sul bus.
    
    Call ibwrt(a, comando_volt)
    
    'La stringa COMANDO contiene la sequenza ASCII per impostare la
    'scheda come ascoltatore (carattere SPACE) e lo strumento come
    'parlatore (ASCII 64+indirizzo strumento)
    'La stringa "?_" serve ad annullare la precedente impostazione
    
    comando = "?_ " & Chr$(64 + gpib_primario)
    
    'La call ibcmd seguente esegue il comando
    
    Call ibcmd(a, comando)
    count = Len(BufferDato)
    
    'L'istruzione ilrd preleva il dato reso disponibile dalla ibwrt
    'e lo memorizza nella stringa
    
    ilrd a, BufferDato, count
        
    leggiValore = Val(BufferDato)
    
End Function

Public Function inizializza() As Integer

    ' Le 3 istruzioni seguenti provvedono ad identificare la scheda
    ' ad inizializzare il bus ed infine a porre in modalit remota
    ' gli strumenti connessi al bus
    
    Call ibfind("GPIB0", a%)
    Call ibsic(a)
    Call ibsre(a, 1)
    
    inizializza = a
        
End Function


