****************************************************************
*   (C) COPYRIGHT TEXAS INSTRUMENTS, INC. 1992                 *
****************************************************************
*  MODULE NAME: reverb.asm                                       *
*                                                              *
*  DESCRIPTION: echo generation
*                                      Texas Instruments Inc   *
****************************************************************
;---------------------MODIFICATIONS------------------------------------------
; 21 march 1997      mehmet akhan univ of herts
; changed starting point of prog, changed buffer point maintanence 
; commented buffer pointer maintanence
; buffers at c00h to 2bffh
; program starts at 0a00h
; loader cannot cope with DARAM load
; do not set ps at fe00h
;-------------------------------------------------------------------------------------
         .mmregs
*
;---------------------------------------------------------------;
; Bit definition of the control register in the AIC             ;
;---------------------------------------------------------------;

      ;+-------------------------+
      ;|LP xx G1 G0 | SY AX LB BP|              G1  G0  gain
      ;+------------+------------+             ---------------
      ; |     GAIN    |  |  |  +-- BP Filter    0   0    4
      ; |     Synch --+  |  +----- Loopback     1   1    4
      ; |     Auxin -----+                      0   1    2
      ; + (sinx)/x filter                       1   0    1


TA       .set     18              ; Fcut = 8 KHz
RA       .set     18              ; Fcut = 8 KHz
TAp      .set     31              ;
RAp      .set     31              ;
TB       .set     36              ; Fs = 2*Fcut
RB       .set     36              ; Fs = 2*Fcut
AIC_CTR  .set     29h        ; band pass filter in, i/p gain=2
TAP      .set     500h            ; Gap between echo


****************************************************************
*   Set up the ISR vector                                      *
****************************************************************
         .ps     080ah
rint:    B       RECEIVE       ;0A; Serial prot receive interrupt RINT.
xint:    B       TRANSMIT      ;0C; Serial port transmit interrupt XINT.
         ;-------------------------------------------------------

*
******************************************************************
* TMS32C05X INITIALIZATION                                       *
******************************************************************
         .ps 0a00h
         .entry
START:   
         SETC    INTM             ; Disable interrupts
         LDP     #0                     ; Set data page pointer
         OPL     #0834h,PMST
         LACC    #0
         SAMM    CWSR             ; Set software wait state to 0
         SAMM    PDWSR           ;
;-------------------------------------------------------------------------
; initialise circular buffers
         LACC    #0C00h         ; set up circular buffer pointers
         SACL    CBSR1           ; buffer1 = 0c00 -> 2bff
         SACL    CBSR2           ; buffer 2 = 0c00 -> 2bff
         LACC    #02bffh          ; 
         SACL    CBER1           ; buffer top 2bff
         SACL    CBER2           ;
         LACC    #98h             ; buf1=AR0, buf2=AR1
         SACL    CBCR
;----------------------------------------------------------------------------
;initialise AIC
         SPLK    #022h,IMR        ; Using XINT syn TX & RX
         CALL    AICINIT          ; initialize AIC and enable interrupts
;-------------------------------------------------------------------------
; initialise circular buffer pointers         
         LAR     AR0,#2BFFh      ; AR0 --> top of CB1
         LAR     AR1,#1980h       ; AR1 -->1980h initial echo spacing
         LAMM    AR1
         SUB     #TAP,0
         SAMM    AR2                 ;AR2--> 1980-TAP
         SUB     #TAP,0
         SAMM    AR3                 ;AR3 -->1980-2xTAP
         SUB     #TAP,0
         SAMM    AR4                 ;AR4 -->1980-3xTAP
;-----------------------------------------------------------------------------
;final processor initialisation
         CLRC    OVM              ; OVM = 0
         SPM     0                ; PM = 0
         SPLK    #012h,IMR
         CLRC    INTM             ; enable
;------------------------------------------------------------------------------
;--------------------main---------------------------------------------------
WAIT:
        NOP                      ; wait for a transmit or receive
         NOP
         B       WAIT
;------- end of main program ----------;

;
; RECIEVER INTERRUPT SERVICE ROUTINE
;
RECEIVE:
;----------------------------------------------------------------------
; core reverb routine
; stores received sample
; adds three echos to delayed sample
; sample delay 2bffh-1980h
; echo delay 500h

         LACL    DRR              ; read data from DRR
         SACL    *+,0,AR1       ; store new sample
; and point to sample to be echoed
         LACC    *+,16,AR2     ; get&move sample to high acc
; start adding echos
         ADD     *+,15,AR3     ; add (first echo/2) to sample 
         ADD     *+,14,AR4     ; add (second echo/4) to sample
         ADD     *+,13,AR0     ; add (third echo/8) to sample
         AND     #0FFFCh,16   ; zero low two bits in high acc
         SACH    DXR              ; xmit
;---------------------------------------------------------------------------
;pointer maintanence AR0 & AR1 maintained auto
; maintain AR2, AR3, AR4 manually
         LAMM    AR2              ;has AR2 reached top of buffer
         SUB     #2C00h,0
         BCND    CHK_3,NEQ
         LAR     AR2,#0C00h     ;set to bottom if it has
         B       GO
CHK_3:   LAMM    AR3        ; Is AR3 at top?
         SUB     #2C00h,0
         BCND    CHK_4,NEQ
         LAR     AR3,#0C00h     ; set to bottom if it has
         B       GO
CHK_4:   LAMM    AR4       ;is AR4 at top?
         SUB     #2C00h,0
         BCND    GO,NEQ
         LAR     AR4,#0C00h
GO:   RETE                            ; go back program
*
;
; TRANSMIT INTERRUPT SERVICE ROUTINE
;
TRANSMIT:
         RETE

*
******************************************************************
*  DESCRIPTION: This routine initializes the TLC320C40 for       *
*               a 8Khz sample rate with a gain setting of 1      *
******************************************************************
* aic initialization data
*
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
         SPLK    #01h,PRD           ; for AIC master clock
         MAR     *,AR0
         LACC    #0008h             ; Non continuous mode
         SACL    SPC                ; FSX as input
         LACC    #00c8h             ; 16 bit words
         SACL    SPC
         LACC    #080h              ; Pulse AIC reset by setting it low
         SACH    DXR
         SACL    GREG               ; Pulse AIC reset by seting BR* low
         LAR     AR0,#0FFFFh        ; and taking it high after 10000 cycles
         RPT     #9999              ; (.5ms at 50ns instruction cycles)
         LACC    *,0,AR0            ;
         SACH    GREG
         SETC    SXM              ;
         LACC    #TA,9             ; Initialized TA and RA register
         ADD     #RA,2             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LACC    #TB,9             ; Initialized TB and RB register
         ADD     #RB,2             ;
         ADD     #02h             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LACC    #AIC_CTR,2        ; Initialized control register
         ADD     #03h              ;
         CALL    AIC_2ND          ;
         RET                      ;

AIC_2ND:
         SACH    DXR              ;
         CLRC    INTM
         IDLE
         ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         SACH    DXR              ;
         IDLE
         SACL    DXR              ;
         IDLE
         LACL    #0               ;
         SACL    DXR              ; make sure the word got sent
         IDLE
         SETC    INTM
         RET                      ;
        .end

