*************************************
* RECORDER PROGRAM
*
* modified mba, uh, march 97
* stopped playback in ISR
*************************************
         .MMREGS
         .ds      0980h
TA       .word    10        ;
RA       .word    10        ;  This set up of AIC registers give
                            ;  a sampling freq of 10,000 Hz
                            ;
TB       .word    50        ;
RB       .word    50        ;
AIC_CTR  .word    28h       ; AIC is in sync mode w/ preamp gain =4
buf_beg  .word    1000h     ; buffer starting point
buf_hlt  .word    2c00h     ; buffer ending point
_word    .word    0h        ; Temp storage
func     .word    0h        ; 0=record, 1= playback
temp     .word    0h
pwidth   .set     15ah      ; for 57600 baud
****************************************************************
*   Set up the ISR vector                                      *
****************************************************************
         .ps      0080ah
rint:    B        RCV
xint:    B        XMIT

         .ps       0a00h
         .entry                  ;
         ;--------------------------------------------------------------
         ;---processor initialisation----------------------------
         SETC    INTM
         LDP     #0
         OPL     #0834h,PMST
         LACC    #0
         SAMM    CWSR
         SAMM    PDWSR
         SETC    SXM           ;  SXM MUST BE SET
         SPLK    #022h,IMR     ; This turns on transmit interrupt only

         CALL    AICINIT       ;
         SPLK    #032h,IMR     ; turn on xmit interrupt
         CLRC    OVM
         SPM     0             ;
         LDP     #buf_beg
         LAR     AR0,buf_beg   ; set up aux pointers
         LACC    buf_hlt
         SAMM    ARCR
         MAR     *,AR0         ;
         CLRC    SXM           ;
         LDP     #buf_beg      ;
         CLRC    INTM
         LACC    func          ; Determine play or record 0=record 1=play
                                        ;PC stops DSK and writes this
         BCND    PLALOOP,NEQ
         LAMM    DRR           ; get junk to receive next int
         LAMM    DRR
         LAMM    DRR
; ---------------- record ------------------------
                                  ; The AIC is sampling at 10KHz
RECLOOP: ZAP
         IDLE                     ; wait for a transmit or receive
         LACC   temp,8            ;
         SACH   _word             ; save it temporarily to 8 LSBs
         IDLE                     ; wait until next sample is reveived
         LACC   temp              ; Load data into ACC to low byte
         AND    #0FF00h           ; Mask out 8 LSBs
         OR     _word             ; Pack low byte(temp) with high byte
         SACL   *+,0              ; Store the packed data to buffer
         CMPR   0                 ; IF at buf_hlt
         LACC   #2                ; Send PC 'recording stopped' indicator
         BCND   stop,TC           ; If at end then stop & send indicator
         BCND PLALOOP, TC
         B      RECLOOP           ; Otherwise pack and record more data

PLALOOP:
         ZAP                      ; Zero the ACC and PREG
         LACC   *+,8              ; Load data so low byte is first word
         SACH   _word             ; store next word temporarily in LSBs
         AND    #0FFFCh
         SAMM   DXR               ; Send AIC low byte (first word)
         IDLE                     ; wait for next interrupt
         LACC   _word,8           ; Load low byte & shft to get same mag
         AND    #0FFFCh
         SAMM   DXR               ; Send the second word to the AIC
         IDLE                     ; Wait until next interrupt
         CMPR   0                 ; IF at buf_hlt
         LACC   #3                ; Send PC 'Playing stopped' indicator
         BCND   stop,TC           ; If at end then stop & send indicator
         B      PLALOOP           ; Otherwise unpack and play more data

; --------------- Send PC the Status Indicator -----------------------
stop:
        SETC   INTM
        SPLK   #02h,IMR     ;DISABLE RINT AND XINT INTERRUPTS
        SACL   temp         ; SAVE INDICATOR
        LACC   #0           ;
        SAMM   DXR          ; SEND ZER0 TO AIC
        LACC   temp         ;
        CLRC   INTM
xfrbyte:
         CLRC    C
         LAR     AR1,#08h
nextbit: BCND    ZERO,NC
ONE:     SETC    XF
         B       send
ZERO:    CLRC    XF
send:    RPT     #pwidth
         MAR     *,AR1
         ROR
         BANZ    nextbit,*-
         SETC    XF
         RPT     #pwidth
         NOP
         RPT     #pwidth
         NOP
         NOP
end      B       end
;------- end of main program ----------;

;
; RECIEVER INTERRUPT SERVICE ROUTINE
;
RCV:
         SETC    SXM
         LAMM    DRR     ; receive data
         SACL    temp,4    ; store it
         LACC    #0          ; clear acc just in case
;         LACC    temp     ; playback not needed
;         AND     #0FFFCh  
;         SAMM    DXR
         CLRC    SXM
         RETE
;
; TRANSMIT INTERRUPT SERVICE ROUTINE
;
XMIT:
         RETE
*
******************************************************************
*  DESCRIPTION: This routine initializes the TLC320C40 for       *
*		a 8Khz sample rate with a gain setting of 1	 *
******************************************************************
* aic initialization data
*
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
         SPLK    #01h,PRD           ; for AIC master clock
         MAR     *,AR0
         LACC    #0008h             ; Non continuous mode
         SACL    SPC                ; FSX as input
         LACC    #00c8h             ; 16 bit words
         SACL    SPC
         LACC    #080h            ; Pulse AIC reset by setting it low
         SACH    DXR
         SACL    GREG
         LAR     AR0,#0FFFFh
         RPT     #10000           ; and taking it high after 10000 cycles
         LACC    *,0,AR0          ; (.5ms at 50ns)
         SACH    GREG
         ;------------------------
         LDP     #TA              ;
         SETC    SXM              ;
         LACC    TA,9             ; Initialize TA and RA register
         ADD     RA,2             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #TB
         LACC    TB,9             ; Initialize TB and RB register
         ADD     RB,2             ;
         ADD     #02h             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #AIC_CTR
         LACC    AIC_CTR,2        ; Initialize control register
         ADD     #03h             ;
         CALL    AIC_2ND          ;
         RET                      ;

AIC_2ND:
         LDP     #0               ; Data page point is 0  (MM regs)
         SACH    DXR              ; send ACChi 00
         CLRC    INTM             ; enable interrupts
         IDLE                     ; wait for interrupt
         ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         SACH    DXR              ; send ACChi to initiate secondary protocol
         IDLE                     ; wait for interrupt
         SACL    DXR              ; send the T register data
         IDLE                     ; wait for interrupt
         LACL    #0               ; clear ACClo
         SACL    DXR              ; send another to make sure 1st word got sent
         IDLE                     ; wait for interrupt
         SETC    INTM
         RET                      ;
        .END

*
******************************************************************
*  DESCRIPTION: This routine initializes the TLC320C40 for       *
*		a 8Khz sample rate with a gain setting of 1	 *
******************************************************************
* aic initialization data
*
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
         SPLK    #01h,PRD           ; for AIC master clock
         MAR     *,AR0
         LACC    #080h            ; Pulse AIC reset by setting it low
         SACH    DXR
         SACL    GREG
         LAR     AR0,#0FFFFh
         RPT     #10000           ; and taking it high after 10000 cycles
         LACC    *,0,AR0          ; (.5ms at 50ns)
         SACH    GREG
         ;------------------------
         LDP     #TA              ;
         SETC    SXM              ;
         LACC    TA,9             ; Initialize TA and RA register
         ADD     RA,2             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #TB
         LACC    TB,9             ; Initialize TB and RB register
         ADD     RB,2             ;
         ADD     #02h             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #AIC_CTR
         LACC    AIC_CTR,2        ; Initialize control register
         ADD     #03h             ;
         CALL    AIC_2ND          ;
         RET                      ;

AIC_2ND:
         LDP     #0               ; Data page point is 0  (MM regs)
         SACH    DXR              ; send ACChi 00
         CLRC    INTM             ; enable interrupts
         IDLE                     ; wait for interrupt
         ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         SACH    DXR              ; send ACChi to initiate secondary protocol
         IDLE                     ; wait for interrupt
         SACL    DXR              ; send the T register data
         IDLE                     ; wait for interrupt
         LACL    #0               ; clear ACClo
         SACL    DXR              ; send another to make sure 1st word got sent
         IDLE                     ; wait for interrupt
         SETC    INTM
         RET                      ;
        .END


