;==========================================================================;
;=INFORMATION           PROGRAM         ; pass through                    =;
;=============          FILE NAME       ; pass.asm                        =;
;=                      INCLUDE FILES   ; no include files                =;
;=                      PROCESSOR       ; TMS320C5x                       =;
;=                      AUTHOR          ; Matt Byatt - Texas Instruments  =;
;=                      DATE/VERSION    ; July 1996 / Ver 1.00            =;
;==========================================================================;
;=DESCRIPTION                                                             =;
;=============                                                            =;
;=                                                                        =;
;= Pass:        A program that initialises the TMS320C50 DSK processor    =;
;=              and AIC codec. At a sampling rate of 8kHz, the board's    =;
;=              serial input port is read to the accumulator.             =;
;=                                                                        =;
;=              Within the same ISR, the contents of the accumulator are  =;
;=              written to the serial output port without modification.   =;
;=                                                                        =;
;=              The constant read and writing continually passes the      =;
;=              input signal to the output.                               =;
;=                                                                        =;
;=                                                                        =;
;=                                                                        =;
;==========================================================================;
;=SPECIFICATION         FREQUENCY       ; 8kHz                            =;
;===============        FILTER          ; not present                     =;
;=                      MISC            ; TLC320C40 initialised           =;
;==========================================================================;
	.mmregs
;==========================================================================;
;=SETTINGS                                                                =;
;==========================================================================;
	.ds     0f00h           ; Assemble to data memory
TA      .word   17              ; TA AIC value - Fcut = 8 KHz
RA      .word   17              ; RA AIC value - Fcut = 8 KHz
TB      .word   37              ; TB AIC value - Fs = 2*Fcut
RB      .word   37              ; RB AIC value - Fs = 2*Fcut
AIC_CTR .word   28h              ; |LP xx G1 G0 | SY AX LB BP|           
				; +------------+------------+            
				;  |     GAIN    |  |  |  +-- BP Filter   
				;  |     Synch --+  |  +----- Loopback     
				;  |     Auxin -----+                    
				;  + (sinx)/x filter                      
;==========================================================================;
;=INTERRUPT SETTINGS                                                      =;
;==========================================================================;
	.ps     080ah           ; Assemble to program memory
RINT    b       RX              ; Branch to RX on receive interrupt
XINT    b       TX              ; Branch to TX on transmit interrupt
;==========================================================================;
;=PROCESSOR INITIALISATION                                                =;
;==========================================================================;
	.ps 0a00h               ; Assemble to program memory
	.entry                  ; Mark program entry point
	.text                   ; Text
START   setc    INTM            ; Disable interrupts
	ldp     #0              ; Set data page pointer to page zero
	splk    #0834h,PMST     ; Write 16 bit pattern to PMST register
	lacc    #0              ; Load accumulator with number zero
	;-----------------------;
	samm    CWSR            ; Set software wait state to zero
	samm    PDWSR           ; Set software wait state to zero
	splk    #022h,IMR       ; Using XINT syn TX & RX
	call    AIC             ; Initialize AIC and enable interrupts
	;-----------------------;
	clrc    OVM             ; Overflow mode is set to zero
	spm     0               ; Product shift mode is set to zero
	splk    #012h,IMR       ; Mask interrupts
	clrc    INTM            ; Enable interrupts
;==========================================================================;
;=MAIN PROGRAM                                                            =;
;==========================================================================;
WAIT    idle                    ; Idle until interrupt
	nop                     ; No operation
	nop                     ; No operation
	b       WAIT            ; Branch to WAIT
;---- end of main program ------; Comment line
;==========================================================================;
;= RECEIVE INTERRUPT SERVICE ROUTINE                                      =;
;==========================================================================;
RX      ldp     #0              ; Set data page pointer to zero
	lamm    DRR             ; Read data from serial input register 
	and     #0FFFCh         ; Clear lower two (status) bit from acc
	samm    DXR             ; Write lower acc to DXR
	rete                    ; Return to main program
;==========================================================================;
;=TRANSMIT INTERRUPT SERVICE ROUTINE                                      =;
;==========================================================================;
TX      rete                    ; Return to main program
;==========================================================================;
;=BOARD INITIALISATION                                                    =;
;==========================================================================;
AIC     splk    #20h,TCR        ; To generate 10 MHz from Tout
	splk    #01h,PRD        ; Load period counter with 1
	mar     *,AR0           ; Modify AR pointer (used with GREG)
	lacc    #0008h          ; Load acc with 08h
	sacl    SPC             ; Store acc in SPC
	lacc    #00C8h          ; Load acc with 0C8h
	sacl    SPC             ; Set and reset SPC register
	;-----------------------;
	lacc    #080h           ; Initialise 8000h to FFFFh as global memory
	sach    DXR             ; Store high acc to DXR
	sacl    GREG            ; Store to global memory register
	lar     AR0,#0FFFFh     ; Set AR0 register
	rpt     #10000          ; Set repeat counter
	lacc    *,0,AR0         ; Access global memory
	sach    GREG            ; Disable global memory
	;-----------------------;
	ldp     #TA             ; Load data page TA
	setc    SXM             ; Set SXM for sign extension mode
	lacc    TA,9            ; Load accumulator with TA data
	add     RA,2            ; Load accumulator with RB data
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #TB             ; Load data page TB
	lacc    TB,9            ; Load accumulator with TB data
	add     RB,2            ; Load accumulator with RB data
	add     #02h            ; Add 10b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	;-----------------------;
	ldp     #AIC_CTR        ; Load data page AIC_CTR
	lacc    AIC_CTR,2       ; Initialized control register
	add     #03h            ; Add 11b to set status bits
	call    AIC2ND          ; Call function AIC2ND
	ret                     ; Return from call
;-------------------------------;
AIC2ND  ldp     #0              ; Load data page zero
	sach    DXR             ; Store upper acc to DXR
	clrc    INTM            ; Enable interrupts
	idle                    ; Idle until interrupt - TINT
	add     #6h,15          ; Set 2 LSBs of upper acc high
	sach    DXR             ; Store upper acc to DXR
	idle                    ; Idle until interrupt - TINT
	sacl    DXR             ; Store lower acc to DXR
	idle                    ; Idle until interrupt - TINT
	lacl    #0              ; Store lower acc to DXR - flushing
	sacl    DXR             ; make sure the word got sent
	idle                    ; Idle until interrupt - TINT                   
	setc    INTM            ; Disable interrupts
	ret                     ; Return from call
;-------------------------------;                      
	.end                    ; End of program






