//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "DisegnaOnda.h"
#include "AbouBox.h"
#include "unit2.h"
#include <stdlib.h>
#include <stdio.h>
#include "unit2.h"
#include "unit3.h"
#include "math.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

const double Tc = 1.0/18000.0;
const double MaxTens = 6.4;
const double T = 1; // 1 sec
const double TickX   = T/(double)600;
const double TickY   = MaxTens/(double)256;

TPoint VetPunti[7200];
TPoint VetPuntiInterp[7200];
int numPunti;
int TX, TY;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
  Image->Canvas->MoveTo(0,0);
  Image->Canvas->Pen->Color = clRed;
  Image->Canvas->Pen->Width = 1;
  Coppie->Clear();
  numPunti = 2;
  DisegnaAsse(clGreen);
  VetPunti[0].y   = 128;
  VetPunti[0].x   = 0;
  VetPunti[1].y = 128;
  VetPunti[1].x = 599;
  TX = 1;
  TY = 1;
}

//---------------------------------------------------------------------
void __fastcall TForm1::FormMouseDown(TObject *Sender, TMouseButton Button,
                                      TShiftState Shift, int X, int Y)
{
bool tuttoBene = true ;

int i =0 ;
while (tuttoBene && (i < numPunti))
{
if (VetPunti [i].x == X)
{
   tuttoBene = false ;
} // end if

i++ ;
}// end while


if (tuttoBene)
  {
  TVarRec valXY[2] = {TickX*X,3.2 - TickY*Y};
  Image->Canvas->Pen->Color = clRed;
  Image->Canvas->Pen->Width = 3;
  Image->Canvas->MoveTo(X, Y);
  TVarRec tempvar[2] = {X, Y};
  StatusBar1->SimpleText = Format("Acquisito: X: %3d, Y: %3d", tempvar, 2);
  VetPunti[numPunti++] = Point(X,Y);
  Coppie->Text = Coppie->Text + Format("(%2.3f, %1.3f)\n",valXY,2);
  NumCampEdit->Text = IntToStr(StrToInt(NumCampEdit->Text)+1);
  Image->Canvas->MoveTo(X, Y);
  Image->Canvas->LineTo(X, Y);
  CongiungiPunti(clBlue);
  }// end if

}

//---------------------------------------------------------------------
void __fastcall TForm1::FormMouseMove(TObject *Sender, TShiftState Shift,
                                      int X, int Y)
{
  TVarRec tempvar[2] = {X, Y};
  TVarRec valX[1] = {TickX*X};
  TVarRec valY[1] = {3.2 - TickY*Y};
  StatusBar1->SimpleText =
     Format("Posizione: ( X: %3d, Y: %3d )", tempvar, 2);
  FreqEdit->Text = Format("%2.4f",valX,1);
  VoltEdit->Text = Format("%1.3f",valY,1);
}

//---------------------------------------------------------------------
void __fastcall TForm1::FormMouseUp(TObject *Sender, TMouseButton Button,
                                    TShiftState Shift, int X, int Y)
{
  /*
  Image->Canvas->MoveTo(X, Y);
  Image->Canvas->LineTo(X, Y);
  CongiungiPunti(clBlue);
  */
}

//---------------------------------------------------------------------
void __fastcall TForm1::CongiungiPunti(TColor color)
{
  int i,j;
  TPoint app;

  Image->Canvas->Pen->Color = clWhite;
  Image->Canvas->Pen->Width = 1;
  Image->Canvas->Pen->Style = psSolid; // psDot;
  Image->Canvas->MoveTo(0,100);

  for (i=0;i<numPunti-1;i++)
  {
    Image->Canvas->MoveTo(VetPunti[i].x, VetPunti[i].y);
    Image->Canvas->LineTo(VetPunti[i+1].x, VetPunti[i+1].y);
  }


  for (i=0;i<numPunti-1;i++)
    for (j=i+1;j<numPunti;j++)
     if (VetPunti[i].x > VetPunti[j].x) {
        app = VetPunti[i];
        VetPunti[i] = VetPunti[j];
        VetPunti[j] = app;
     }



  Coppie->Text = "";
  for (i=0;i<numPunti;i++)
  {
   TVarRec valXY[2] = {TickX*VetPunti[i].x,3.2 - TickY*VetPunti[i].y};
   Coppie->Text = Coppie->Text + Format("(%2.3f, %1.3f)\n",valXY,2);

  }

  Image->Canvas->Pen->Color = color;

  for (i=0;i<numPunti-1;i++)
  {
    Image->Canvas->MoveTo(VetPunti[i].x, VetPunti[i].y);
    Image->Canvas->LineTo(VetPunti[i+1].x, VetPunti[i+1].y);
  }
}

void __fastcall TForm1 :: DisegnaGriglia(TColor color)
{

 const TickVer = 5;
 const TickHor = 4;
 int i;
 int dX,dY;

 Image->Canvas->Pen->Color = color;
 Image->Canvas->Pen->Width = 1;
 Image->Canvas->Pen->Style = psDashDot;

 Image->Canvas->MoveTo(0,128);
 Image->Canvas->LineTo(600,128);

 dY = 128/TickVer;
 for (i=1;i<=TickHor;i++) {
   Image->Canvas->MoveTo(0,dY*i);
   Image->Canvas->LineTo(600,dY*i);
   Image->Canvas->MoveTo(0,128+dY*i);
   Image->Canvas->LineTo(600,128+dY*i);
 }

 dX = 300/TickHor;
 for (i=1;i<=TickVer;i++) {
   Image->Canvas->MoveTo(dX*i,0);
   Image->Canvas->LineTo(dX*i,256);
   Image->Canvas->MoveTo(300+dX*i,0);
   Image->Canvas->LineTo(300+dX*i,256);
 }

};

void __fastcall TForm1 :: DisegnaAsse(TColor color)
{
 Image->Canvas->Pen->Color = color;
 Image->Canvas->Pen->Width = 1;
 Image->Canvas->Pen->Style = psDashDot;

 Image->Canvas->MoveTo(0,128);
 Image->Canvas->LineTo(600,128);
}

void __fastcall TForm1::PulisciDisegno()
{
  Image->Canvas->Pen->Color = clWhite;
  Image->Canvas->Rectangle(0,0,600,256);
  Coppie->Clear();
  GrigliaClick(this);
  numPunti = 0;
  NumCampEdit->Text = '0';
}

void __fastcall TForm1::ClearButClick(TObject *Sender)
{
  PulisciDisegno();
  VetPunti[0].y   = 128;
  VetPunti[0].x   = 0;
  VetPunti[1].y = 128;
  VetPunti[1].x = 599;
    numPunti = 2;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::GrigliaClick(TObject *Sender)
{
  switch (Griglia->ItemIndex)
  {
    case 0: DisegnaGriglia(clGreen); break;
    case 1: {
             DisegnaGriglia(clWhite);
             DisegnaAsse(clGreen);
             break;
            }
  }
  CongiungiPunti(clRed);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TestButClick(TObject *Sender)
{
  system("start autotest.bat");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OffButClick(TObject *Sender)
{
   system("start SPENTO.BAT");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::LoadButClick(TObject *Sender)
{
 system("start/m CARICA.exe");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ResetButClick(TObject *Sender)
{
 system("start RESET");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  AboutBox->Visible = true;
}

double __fastcall TForm1::Pendenza(TPoint P1, TPoint P2, int x)
{
  return (1.0*(P2.y-P1.y)/(P2.x-P1.x)*(x-P1.x)+P1.y);
}


void __fastcall TForm1::CreaPuntiIntermedi()
{
   TPoint P1, P2;
   double vetFinale[7200];
   int i,j;
   int puntiDSP;

   for (i=0;i<numPunti;i++) {VetPunti[i].x = VetPunti[i].x * 12;};  // 7200/600 = 12

   for (i=0;i<numPunti-1;i++)
   { P1 = VetPunti[i];
     P2 = VetPunti[i+1];
     for (j=VetPunti[i].x;j<=VetPunti[i+1].x;j++)
      {
       VetPuntiInterp[j].x = j;
       VetPuntiInterp[j].y = (int)Pendenza(P1,P2,j);
      }
   }

   numPunti=7200;

   puntiDSP= StrToInt(PuntiEdit->Text.c_str());

   for (i=0;i<puntiDSP;i++) VetPunti[i]=VetPuntiInterp[(int)(i*(double)7200.0/puntiDSP)];

   numPunti=puntiDSP;

}


//---------------------------------------------------------------------------
void __fastcall TForm1::GenButClick(TObject *Sender)
{
  FILE *dati;
  int i;


  CreaPuntiIntermedi();

  dati = fopen("dati.dat", "w+");
  for (i=0;i<numPunti;i++)
  {
    fprintf(dati, "%3.3f %1.3f\n",VetPunti[i].x*TickX*StrToInt(PeriodoEdit->Text.c_str()), 3.2 - VetPunti[i].y*TickY);
  }

  fclose(dati);

  LoadBut->Enabled = true;
  ResetBut->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SceltaOndaClick(TObject *Sender)
{
 PulisciDisegno();
 TensioneEdit->Color = clWindow;
 TensioneEdit->Enabled = true;
 switch (SceltaOnda->ItemIndex)
 {
  case 0: TensioneEdit->Color = clScrollBar; break;
  case 1: {
           GeneraOndaSeno(StrToInt(TensioneEdit->Text.c_str()));
           break;
          }
  case 2: {
           GeneraOndaQuadra(StrToInt(TensioneEdit->Text.c_str()));
           break;
           }
  case 3: {
           GeneraOndaTriangolare(StrToInt(TensioneEdit->Text.c_str()));
           break;
           }
  case 4: {
           GeneraOndaRampa(StrToInt(TensioneEdit->Text.c_str()));
           break;
           }
 }
 CongiungiPunti(clRed);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GeneraOndaQuadra(double Vpp)
{
  int i;
  double nt;
  PulisciDisegno();
  numPunti = StrToInt(PuntiEdit->Text.c_str());
  nt = (numPunti)/2;
  Vpp=(Vpp/6.4)*256/1000;

  for (i=0;i<nt;i++)
  {
    VetPunti[i] = Point(300/nt*i,128+Vpp);
    VetPunti[numPunti/2+i] = Point(301+300/nt*i,128-Vpp);
  }

  NumCampEdit->Text = IntToStr(numPunti);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GeneraOndaTriangolare(double Vpp)
{
  int i;
  double nt;
  double nv;
  PulisciDisegno();
  numPunti = StrToInt(PuntiEdit->Text.c_str());

  Vpp=(Vpp/6.4)*256/1000;
  nt = (numPunti)/2;
  nv = 2*(Vpp)/nt;

  for (i=0;i<nt;i++)
  {
    VetPunti[i] = Point(300/nt*i,128-Vpp+nv*i);
    VetPunti[numPunti/2+i] = Point(300+300/nt*i,128+Vpp-nv*i);
  }

  NumCampEdit->Text = IntToStr(numPunti);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GeneraOndaRampa(double Vpp)
{
  int i;
  double nv;
  PulisciDisegno();
  numPunti = StrToInt(PuntiEdit->Text.c_str());

  Vpp=(Vpp/6.4)*256/1000;
  nv = 2*(Vpp)/numPunti;

  for (i=0;i<numPunti;i++)
  {
    VetPunti[i] = Point(600/numPunti*i,128-Vpp+nv*i);
    //VetPunti[numPunti/2+i] = Point(300+300/nt*i,128+Vpp-nv*i);
  }

  NumCampEdit->Text = IntToStr(numPunti);
}
//---------------------------------------------------------------------------

// Qua e' per l'onda sinusoidale
void __fastcall TForm1::GeneraOndaSeno(double Vpp)
{
  int i;
  PulisciDisegno();
  numPunti = StrToInt(PuntiEdit->Text.c_str());

  Vpp=(Vpp/6.4)*256/1000;

  for (i=0;i<numPunti;i++)
  {
  VetPunti [i] =  Point (600/numPunti*i, 128-Vpp*sin (2*3.1415/numPunti*i ))  ;
  }

  NumCampEdit->Text = IntToStr(numPunti);
}

void __fastcall TForm1::Button4Click(TObject *Sender)
{
  Aiuto->Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TensioneEditChange(TObject *Sender)
{
 SceltaOndaClick(this);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::PeriodoEditChange(TObject *Sender)
{
 int app;
 /*
 if (PeriodoEdit->Text=="")
 {
   PeriodoEdit->Text = "10";
 };

 app = ((int)(18000/(StrToInt(PeriodoEdit->Text.c_str()))));
 /*
 if (app > 1000)
    {
      app = 1000;
      PeriodoEdit->Text = "1000"  ;
 };


 if (app < 10) app = 10;
 */
 //PuntiEdit->Text = IntToStr(app);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ApriFormParametri(TObject *Sender)
{
  ParForm->Visible = true;
}
//---------------------------------------------------------------------------

