;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;							;
; SINSUB.ASM		Mike Reddish	22/5/95		;
;							;
; A subroutine that will work out the sine of a number	;
;							;
; Call name: sin					;
;							;
; Input: a word in the location "sinput", where		;
; 8000h == -180    degrees				;
;  :         :						;
; C000h == -90     degrees 				;
;  :    	   :					;
; ffffh == -0.0055 degrees				;
; 0000h == 0       degrees				;
;  :         :						;
; 7fffh == 179.99  degrees 				;
; 							;
; Output: a word in location "soutput", in 1.15 format	;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
sin:	lacc	sinput		; Get input
	sub	#0c000h,0
	bcnd	neg1,eq	; Catch for c000h only
	lacc	sinput
	abs			; convert to +ve number.
	sub	#4000h,0
	bcnd	q1or4,lt	; branch if if quadrant 1 or 4
	lacc	#7fffh
	sub	sinput		; x=3fff-input
	sacl	x,1		; Store 2 times result
	b	tosin		; finished if q2or3
neg1	lacc	#8001h,0	; Fiddle for -1 which over flows.
	sacl	x,0
	b	tosin
q1or4	lacl	sinput
	sacl	x,1		; store 2 times input
;now convert x to sin.
tosin	lt	x	; treg0=x  Get input from memory
	mpy	x	; p=x2
	sph	x2	; save to memory, so can get back in treg0
	lt	x2	; treg0=x2
	mpy	c9	; p=x2*c9
	lacc	c7,16	; load acc high.
	lta	x2	; TREG0=x2, Acc=(x2*c9)+c7
	sach	temp	; save to memory, so can get back multiply
	mpy	temp	; p=x2*(x2*c9+c7)
	lacc	c5,16
	lta	x2	; TREG0=x2, Acc=(x2*((x2*c9)+c7))+c5
	sach	temp	; save to memory, so can get back multiply
	mpy	temp	; p=x2*(x2*(x2*c9+c7)+c5)
	lacc	c3,16
	lta	x2	; TREG0=x2, Acc=(x2*((x2*((x2*c9)+c7)+c5)+c3
	sach	temp	; save to memory, so can get back multiply
	mpy	temp	; p=x2*(x2*(x2*(x**2*c9)+c7)+c5)+c3)
	lacc	c1,16
	lta	x	; TREG0=x, Acc=(x2*(x2*(x2*(x2*c9+c7)+c5)+c3)+c1
	sach	temp	; save to memory, so can get back multiply
	mpy	temp	; p=x2*(x2*((x2*((x**2*c9)+c7)+c5)+c3)+c1
	lacl	#0	; zero accum
	lta	x2	; move p to accum
	sach	soutput,1; Multiply by 2 (coefficents are divided by 2 )
	ret

	
	
	
