;                          TEST MACD INSTRUCTION
;
; This program demystifies MACD instruction that works in a repeat loop
;  A simple 4 coefficient arbitrary filter coefficient table h0-h3 is created.
;  Filter sample locations xn-xnlast are filled with initial sample values. 
;  New samples are supplied by incrementing a stored initial value in location
; SAMPLE.  Result of MACD loop is stored in location OUTPUT.
;  
;  Best way to observe the operation of MACD instruction is to set a breakpoint 
;  just after SACL OUTPUT which stores the final output. Then display the 
;  contents of memory  from location f00h. This will demonstrate
;     * operation of MACD
;     * shifting of samples through the filter
;     * shifting the new sample into the filter
; samples should be shifting through from locations
;  f09h => xn
;  f0ch => xnlast
;  f0eh => sample
;  f0fh => output
; when the loop runs once the o/p should be 20d = 14h
; first sample value is 5
; feel free to modify the program to observe it better.
; All interrupts are masked except INT2 for the debugger
;---------------------------------------------------------------------------
; Author		Mehmet Akhan
; Date		17/3/1997      
; ------------------------------------------------------------------------

	 .MMREGS
	 .ds      0f00h
TA       .word    16         ;
RA       .word    16         ;  This set up of AIC registers give
			     ;  a sampling freq of 10,081 Hz
			     ;
TB       .word    31         ;
RB       .word    31         ;
AIC_CTR	.word    08h

;representative Filter Coefficients
h0      .word         1    ; 
h1      .word         2    ; 
h2      .word         3    ; 
h3      .word         4   ; 

;representative samples already in filter
XN       .word      1
XN1      .word     2
XN2      .word     3   
XNLAST   .word     4
EMPTY	.word	0	; reserve as scratch space for MACD

; new samples arriving
SAMPLE	.word	0
; place output samples here
OUTPUT	.word	0

; no interrupts are used

	.ps       0a00h
	.entry                  ;
;--------------------------------------------------------------

	SETC    INTM		;interrupts are not used in this program
	LDP     #0
	OPL     #0834h,PMST
	LACC    #0
	SAMM    CWSR		; set wait states
	SAMM    PDWSR
	SETC    SXM           	;  SXM MUST BE SET
	SPLK    #02h,IMR	; UNMASK INT2 FOR DSK DEBUGGER
	CLRC    OVM		; let acc overflow
	SPM     0             	; no shift of multiplier output
	CLRC    INTM          	; enable ints


;-------------MAIN PROGRAM ----------------------------------------------------
MAIN:
                         			;prepare for the second loop
	LDP	#XN		;turn to data page XN
	LACC	#4		;load accumulator with an initial sample value
	SACL	SAMPLE	;store initial sample value

;start the loop

AGAIN:	LAR      AR0,#XNLAST  ; load AR0 with address of last delay element
	ZAP                   		; ZERO ACC AND PRODUCT REGISTERS
	MAR      *,AR0        	; AR0 is the current AR register.

	RPT	#3		; repeat 4 times
	MACD   #h0,*-       	; the complete coefficient  table.
	APAC			; do the final sum

	LDP       #XN		; turn to data page XN
	SACL	OUTPUT	; store the final result

	LACL	SAMPLE	; load the new sample value
	ADD	#1		; increment by 1, =>first sample is 5
	SACL	SAMPLE	; store it for next time round
	SACL	XN		; write in into first sample location
;
; set the breakpoint here to see the effect of MACD instruction
;
	B	AGAIN



