;                               BAND-STOP FILTER
;
;  -> FIR FILTER
;     This program uses an 85 tap FIR filter to implement a HIPASS filter.
;     The filter stops frequencies between 1.0KHz and  2.0KHz. 
;     Blackman filter windowing was used 
;     when calculating the filter's coefficients.
;
;  -> AIC
;     AIC set-up parameters. For DSK running at 40 mhz, the sampling
;     frequency is 10,000,000/2/TA/TB for transmit and is
;     10,000,000/2/RA/RB for receive. The max value for TA,TB.RA,RB is 63
;     since the registers are 6 bits.
;
;     RANDOM NOISE GENERATOR
;     This portion of the program can be copied from lopass into this one.
;      Do not forget to comment out  LAMM DRR to stop data coming in.
;      
;      mba  uh  21 april 1997 
; ------------------------------------------------------------------------

	 .mmregs
	 .ds     0f00h
;
;
TA      .word 16 ;
RA      .word 16 ;
TAp     .word 1 ; not used
RAp     .word 1 ; " "
TB      .word 31; 
RB      .word 31; 
AIC_CTR .word 08h ;
Output  .word 0
Temp    .word 0;

 .include "bandstop.flt"

;***************************************************************
;   Set up the ISR vector                                      *
;***************************************************************
	 .ps     080ah         ;
rint:    B       RECEIVE       ;0A; Serial port receive interrupt RINT.
xint:    B       TRANSMIT      ;0C; Serial port transmit interrupt XINT.

;
;*****************************************************************
; TMS32C05X INITIALIZATION                                       *
;                                                                *
;*****************************************************************
	 .ps     0a00h
	 .entry
	 SETC    INTM             ; Disable interrupts
	 LDP     #0               ; Set data page pointer
	 OPL     #0834h,PMST      ; OR the status register
	 LACC    #0
	 SAMM    CWSR             ; Set software wait state to 0
	 SAMM    PDWSR            ;
	 SETC    SXM
	 SPLK    #022h,IMR        ; Using XINT syn TX & RX
	 CALL    AICINIT          ; initialize AIC and enable interrupts
	 SPLK    #12h,IMR ; Select serial port receive interrupt
	 CLRC    OVM
	 SPM 0
	 CLRC    INTM             ; Enable interrupts

forever  IDLE
	 B       forever

;------- end of main program ----------;


;--------------------------  RECIEVER ISR  --------------------------
RECEIVE:
    LDP #XN
    CLRC INTM
    LAMM DRR ; get input in ACC
    SACL XN
; start FIR
    LAR  ar0,#XNLAST     ; FIR data value in data memory - work down memory.
    ZAP
    MAR  *,ar0           ; Make AR1 current.
    RPT  #taps-1
    MACD #coefftab,*-     ; Coefficients stored in program memory.
    APAC
    SACH Output,1
    LACC Output
    SFL
    AND  #0fffch ; and ls 2 bits of top 16 bits, for DAC.
    SAMM DXR
    RETE
;--------------------------  Transmit ISR  --------------------------
;
TRANSMIT:
    RETE

******************************************************************
* DESCRIPTION: This routine initializes the TLC32040 for *
* your sample rate and command word *
******************************************************************
* aic initialization data

AICINIT:
	SPLK #01h,PRD
	SPLK #20h,TCR ; make a 10 mhz clock signal
	MAR *,AR0
	LACC #0008h ; Non continuous mode
	SACL SPC ; FSX as input
	LACC #00c8h ; 16 bit words
	SACL SPC
	LACC #080h ; Pulse AIC reset by setting it low
	SACH DXR
	SACL GREG
	LAR AR0,#0FFFFh
	RPT #10000 ; and taking it high after 10000 cycles
	LACC *,0,AR0 ; (.5ms at 50ns)
	SACH GREG
	LDP #TA ;
	SETC SXM ;
	LACC TA,9 ; Initialized TA and RA register
	ADD RA,2 ;
	CALL AIC_2ND ;
	;------------------------
	LDP #TB
	LACC TB,9 ; Initialized TB and RB register
	ADD RB,2 ;
	ADD #02h ;
	CALL AIC_2ND ;
	;------------------------
	LDP #AIC_CTR
	LACC AIC_CTR,2 ; Initialized control register
	ADD #03h ;
	;LACC #11100000b
	CALL AIC_2ND ;
	RET ;

AIC_2ND:
	LDP #0
	SACH DXR ;
	CLRC INTM
	IDLE
	ADD #6h,15 ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
	SACH DXR ;
	IDLE
	SACL DXR ;
	IDLE
	LACL #0 ;
	SACL DXR ; make sure the word got sent
	IDLE
	SETC INTM
	RET ;


	.end

