   ;---------------------------------------------;
   ; Table listing twiddles used in ANALYZER.ASM ;
   ; (C) Texas Instruments Inc.                  ;
   ;     load FFT_Size twiddle coefficients      ;
   ;---------------------------------------------;
   ;-----------------------------------------------;
   ;      Complex FFT Data array allocation        ;
   ;-----------------------------------------------;
_D_base:    .space  00010h
_D_base+1   .space  00010h
   ;-----------------------------------------------;
   ;      Bit reversed Twiddle lookup Table        ;
   ;-----------------------------------------------;
            .ds     01800h
_T_base:
   .word    32767 ;Normaly 0! Used for raised   
_T_base+1:
   .word   -32768 ;cosine window from this table
   .word   -32768 ; -90.00                        -1.000000 
   .word        0 ;      1  000000010  000000000  -0.000000 
   .word   -23170 ;-135.00                        -0.707107 
   .word   -23170 ;      2  000000100  100000000  -0.707107 
   .word   -23170 ; -45.00                        -0.707107 
   .word    23170 ;      3  000000110  100000000  +0.707107 
   .word   -12539 ;-157.50                        -0.382683 
   .word   -30273 ;      4  000001000  010000000  -0.923880 
   .word   -30273 ; -67.50                        -0.923880 
   .word    12539 ;      5  000001010  010000000  +0.382683 
   .word   -30273 ;-112.50                        -0.923880 
   .word   -12539 ;      6  000001100  110000000  -0.382683 
   .word   -12539 ; -22.50                        -0.382683 
   .word    30273 ;      7  000001110  110000000  +0.923880 
   .word    -6392 ;-168.75                        -0.195090 
   .word   -32138 ;      8  000010000  001000000  -0.980785 
   .word   -32138 ; -78.75                        -0.980785 
   .word     6392 ;      9  000010010  001000000  +0.195090 
   .word   -27245 ;-123.75                        -0.831470 
   .word   -18204 ;     10  000010100  101000000  -0.555570 
   .word   -18204 ; -33.75                        -0.555570 
   .word    27245 ;     11  000010110  101000000  +0.831470 
   .word   -18204 ;-146.25                        -0.555570 
   .word   -27245 ;     12  000011000  011000000  -0.831470 
   .word   -27245 ; -56.25                        -0.831470 
   .word    18204 ;     13  000011010  011000000  +0.555570 
   .word   -32138 ;-101.25                        -0.980785 
   .word    -6392 ;     14  000011100  111000000  -0.195090 
   .word    -6392 ; -11.25                        -0.195090 
   .word    32138 ;     15  000011110  111000000  +0.980785 
   .word    -3211 ;-174.38                        -0.098017 
   .word   -32610 ;     16  000100000  000100000  -0.995185 
   .word   -32610 ; -84.38                        -0.995185 
   .word     3211 ;     17  000100010  000100000  +0.098017 
   .word   -25330 ;-129.38                        -0.773010 
   .word   -20787 ;     18  000100100  100100000  -0.634393 
   .word   -20787 ; -39.38                        -0.634393 
   .word    25330 ;     19  000100110  100100000  +0.773010 
   .word   -15446 ;-151.88                        -0.471397 
   .word   -28898 ;     20  000101000  010100000  -0.881921 
   .word   -28898 ; -61.88                        -0.881921 
   .word    15446 ;     21  000101010  010100000  +0.471397 
   .word   -31357 ;-106.88                        -0.956940 
   .word    -9512 ;     22  000101100  110100000  -0.290285 
   .word    -9512 ; -16.88                        -0.290285 
   .word    31357 ;     23  000101110  110100000  +0.956940 
   .word    -9512 ;-163.13                        -0.290285 
   .word   -31357 ;     24  000110000  001100000  -0.956940 
   .word   -31357 ; -73.13                        -0.956940 
   .word     9512 ;     25  000110010  001100000  +0.290285 
   .word   -28898 ;-118.13                        -0.881921 
   .word   -15446 ;     26  000110100  101100000  -0.471397 
   .word   -15446 ; -28.13                        -0.471397 
   .word    28898 ;     27  000110110  101100000  +0.881921 
   .word   -20787 ;-140.63                        -0.634393 
   .word   -25330 ;     28  000111000  011100000  -0.773010 
   .word   -25330 ; -50.63                        -0.773010 
   .word    20787 ;     29  000111010  011100000  +0.634393 
   .word   -32610 ; -95.63                        -0.995185 
   .word    -3211 ;     30  000111100  111100000  -0.098017 
   .word    -3211 ;  -5.63                        -0.098017 
   .word    32610 ;     31  000111110  111100000  +0.995185 
   .word    -1607 ;-177.19                        -0.049068 
   .word   -32728 ;     32  001000000  000010000  -0.998795 
   .word   -32728 ; -87.19                        -0.998795 
   .word     1607 ;     33  001000010  000010000  +0.049068 
   .word   -24279 ;-132.19                        -0.740951 
   .word   -22005 ;     34  001000100  100010000  -0.671559 
   .word   -22005 ; -42.19                        -0.671559 
   .word    24279 ;     35  001000110  100010000  +0.740951 
   .word   -14010 ;-154.69                        -0.427555 
   .word   -29621 ;     36  001001000  010010000  -0.903989 
   .word   -29621 ; -64.69                        -0.903989 
   .word    14010 ;     37  001001010  010010000  +0.427555 
   .word   -30852 ;-109.69                        -0.941544 
   .word   -11039 ;     38  001001100  110010000  -0.336890 
   .word   -11039 ; -19.69                        -0.336890 
   .word    30852 ;     39  001001110  110010000  +0.941544 
   .word    -7961 ;-165.94                        -0.242980 
   .word   -31785 ;     40  001010000  001010000  -0.970031 
   .word   -31785 ; -75.94                        -0.970031 
   .word     7961 ;     41  001010010  001010000  +0.242980 
   .word   -28106 ;-120.94                        -0.857729 
   .word   -16846 ;     42  001010100  101010000  -0.514103 
   .word   -16846 ; -30.94                        -0.514103 
   .word    28106 ;     43  001010110  101010000  +0.857729 
   .word   -19519 ;-143.44                        -0.595699 
   .word   -26319 ;     44  001011000  011010000  -0.803208 
   .word   -26319 ; -53.44                        -0.803208 
   .word    19519 ;     45  001011010  011010000  +0.595699 
   .word   -32413 ; -98.44                        -0.989177 
   .word    -4808 ;     46  001011100  111010000  -0.146730 
   .word    -4808 ;  -8.44                        -0.146730 
   .word    32413 ;     47  001011110  111010000  +0.989177 
   .word    -4808 ;-171.56                        -0.146730 
   .word   -32413 ;     48  001100000  000110000  -0.989177 
   .word   -32413 ; -81.56                        -0.989177 
   .word     4808 ;     49  001100010  000110000  +0.146730 
   .word   -26319 ;-126.56                        -0.803208 
   .word   -19519 ;     50  001100100  100110000  -0.595699 
   .word   -19519 ; -36.56                        -0.595699 
   .word    26319 ;     51  001100110  100110000  +0.803208 
   .word   -16846 ;-149.06                        -0.514103 
   .word   -28106 ;     52  001101000  010110000  -0.857729 
   .word   -28106 ; -59.06                        -0.857729 
   .word    16846 ;     53  001101010  010110000  +0.514103 
   .word   -31785 ;-104.06                        -0.970031 
   .word    -7961 ;     54  001101100  110110000  -0.242980 
   .word    -7961 ; -14.06                        -0.242980 
   .word    31785 ;     55  001101110  110110000  +0.970031 
   .word   -11039 ;-160.31                        -0.336890 
   .word   -30852 ;     56  001110000  001110000  -0.941544 
   .word   -30852 ; -70.31                        -0.941544 
   .word    11039 ;     57  001110010  001110000  +0.336890 
   .word   -29621 ;-115.31                        -0.903989 
   .word   -14010 ;     58  001110100  101110000  -0.427555 
   .word   -14010 ; -25.31                        -0.427555 
   .word    29621 ;     59  001110110  101110000  +0.903989 
   .word   -22005 ;-137.81                        -0.671559 
   .word   -24279 ;     60  001111000  011110000  -0.740951 
   .word   -24279 ; -47.81                        -0.740951 
   .word    22005 ;     61  001111010  011110000  +0.671559 
   .word   -32728 ; -92.81                        -0.998795 
   .word    -1607 ;     62  001111100  111110000  -0.049068 
   .word    -1607 ;  -2.81                        -0.049068 
   .word    32728 ;     63  001111110  111110000  +0.998795 
   .word     -804 ;-178.59                        -0.024541 
   .word   -32758 ;     64  010000000  000001000  -0.999699 
   .word   -32758 ; -88.59                        -0.999699 
   .word      804 ;     65  010000010  000001000  +0.024541 
   .word   -23732 ;-133.59                        -0.724247 
   .word   -22594 ;     66  010000100  100001000  -0.689541 
   .word   -22594 ; -43.59                        -0.689541 
   .word    23732 ;     67  010000110  100001000  +0.724247 
   .word   -13278 ;-156.09                        -0.405241 
   .word   -29956 ;     68  010001000  010001000  -0.914210 
   .word   -29956 ; -66.09                        -0.914210 
   .word    13278 ;     69  010001010  010001000  +0.405241 
   .word   -30572 ;-111.09                        -0.932993 
   .word   -11793 ;     70  010001100  110001000  -0.359895 
   .word   -11793 ; -21.09                        -0.359895 
   .word    30572 ;     71  010001110  110001000  +0.932993 
   .word    -7179 ;-167.34                        -0.219101 
   .word   -31971 ;     72  010010000  001001000  -0.975702 
   .word   -31971 ; -77.34                        -0.975702 
   .word     7179 ;     73  010010010  001001000  +0.219101 
   .word   -27684 ;-122.34                        -0.844854 
   .word   -17530 ;     74  010010100  101001000  -0.534998 
   .word   -17530 ; -32.34                        -0.534998 
   .word    27684 ;     75  010010110  101001000  +0.844854 
   .word   -18868 ;-144.84                        -0.575808 
   .word   -26790 ;     76  010011000  011001000  -0.817585 
   .word   -26790 ; -54.84                        -0.817585 
   .word    18868 ;     77  010011010  011001000  +0.575808 
   .word   -32285 ; -99.84                        -0.985278 
   .word    -5602 ;     78  010011100  111001000  -0.170962 
   .word    -5602 ;  -9.84                        -0.170962 
   .word    32285 ;     79  010011110  111001000  +0.985278 
   .word    -4011 ;-172.97                        -0.122411 
   .word   -32521 ;     80  010100000  000101000  -0.992480 
   .word   -32521 ; -82.97                        -0.992480 
   .word     4011 ;     81  010100010  000101000  +0.122411 
   .word   -25832 ;-127.97                        -0.788346 
   .word   -20159 ;     82  010100100  100101000  -0.615232 
   .word   -20159 ; -37.97                        -0.615232 
   .word    25832 ;     83  010100110  100101000  +0.788346 
   .word   -16151 ;-150.47                        -0.492898 
   .word   -28511 ;     84  010101000  010101000  -0.870087 
   .word   -28511 ; -60.47                        -0.870087 
   .word    16151 ;     85  010101010  010101000  +0.492898 
   .word   -31581 ;-105.47                        -0.963776 
   .word    -8739 ;     86  010101100  110101000  -0.266713 
   .word    -8739 ; -15.47                        -0.266713 
   .word    31581 ;     87  010101110  110101000  +0.963776 
   .word   -10278 ;-161.72                        -0.313682 
   .word   -31114 ;     88  010110000  001101000  -0.949528 
   .word   -31114 ; -71.72                        -0.949528 
   .word    10278 ;     89  010110010  001101000  +0.313682 
   .word   -29269 ;-116.72                        -0.893224 
   .word   -14732 ;     90  010110100  101101000  -0.449611 
   .word   -14732 ; -26.72                        -0.449611 
   .word    29269 ;     91  010110110  101101000  +0.893224 
   .word   -21403 ;-139.22                        -0.653173 
   .word   -24812 ;     92  010111000  011101000  -0.757209 
   .word   -24812 ; -49.22                        -0.757209 
   .word    21403 ;     93  010111010  011101000  +0.653173 
   .word   -32679 ; -94.22                        -0.997290 
   .word    -2410 ;     94  010111100  111101000  -0.073565 
   .word    -2410 ;  -4.22                        -0.073565 
   .word    32679 ;     95  010111110  111101000  +0.997290 
   .word    -2410 ;-175.78                        -0.073565 
   .word   -32679 ;     96  011000000  000011000  -0.997290 
   .word   -32679 ; -85.78                        -0.997290 
   .word     2410 ;     97  011000010  000011000  +0.073565 
   .word   -24812 ;-130.78                        -0.757209 
   .word   -21403 ;     98  011000100  100011000  -0.653173 
   .word   -21403 ; -40.78                        -0.653173 
   .word    24812 ;     99  011000110  100011000  +0.757209 
   .word   -14732 ;-153.28                        -0.449611 
   .word   -29269 ;    100  011001000  010011000  -0.893224 
   .word   -29269 ; -63.28                        -0.893224 
   .word    14732 ;    101  011001010  010011000  +0.449611 
   .word   -31114 ;-108.28                        -0.949528 
   .word   -10278 ;    102  011001100  110011000  -0.313682 
   .word   -10278 ; -18.28                        -0.313682 
   .word    31114 ;    103  011001110  110011000  +0.949528 
   .word    -8739 ;-164.53                        -0.266713 
   .word   -31581 ;    104  011010000  001011000  -0.963776 
   .word   -31581 ; -74.53                        -0.963776 
   .word     8739 ;    105  011010010  001011000  +0.266713 
   .word   -28511 ;-119.53                        -0.870087 
   .word   -16151 ;    106  011010100  101011000  -0.492898 
   .word   -16151 ; -29.53                        -0.492898 
   .word    28511 ;    107  011010110  101011000  +0.870087 
   .word   -20159 ;-142.03                        -0.615232 
   .word   -25832 ;    108  011011000  011011000  -0.788346 
   .word   -25832 ; -52.03                        -0.788346 
   .word    20159 ;    109  011011010  011011000  +0.615232 
   .word   -32521 ; -97.03                        -0.992480 
   .word    -4011 ;    110  011011100  111011000  -0.122411 
   .word    -4011 ;  -7.03                        -0.122411 
   .word    32521 ;    111  011011110  111011000  +0.992480 
   .word    -5602 ;-170.16                        -0.170962 
   .word   -32285 ;    112  011100000  000111000  -0.985278 
   .word   -32285 ; -80.16                        -0.985278 
   .word     5602 ;    113  011100010  000111000  +0.170962 
   .word   -26790 ;-125.16                        -0.817585 
   .word   -18868 ;    114  011100100  100111000  -0.575808 
   .word   -18868 ; -35.16                        -0.575808 
   .word    26790 ;    115  011100110  100111000  +0.817585 
   .word   -17530 ;-147.66                        -0.534998 
   .word   -27684 ;    116  011101000  010111000  -0.844854 
   .word   -27684 ; -57.66                        -0.844854 
   .word    17530 ;    117  011101010  010111000  +0.534998 
   .word   -31971 ;-102.66                        -0.975702 
   .word    -7179 ;    118  011101100  110111000  -0.219101 
   .word    -7179 ; -12.66                        -0.219101 
   .word    31971 ;    119  011101110  110111000  +0.975702 
   .word   -11793 ;-158.91                        -0.359895 
   .word   -30572 ;    120  011110000  001111000  -0.932993 
   .word   -30572 ; -68.91                        -0.932993 
   .word    11793 ;    121  011110010  001111000  +0.359895 
   .word   -29956 ;-113.91                        -0.914210 
   .word   -13278 ;    122  011110100  101111000  -0.405241 
   .word   -13278 ; -23.91                        -0.405241 
   .word    29956 ;    123  011110110  101111000  +0.914210 
   .word   -22594 ;-136.41                        -0.689541 
   .word   -23732 ;    124  011111000  011111000  -0.724247 
   .word   -23732 ; -46.41                        -0.724247 
   .word    22594 ;    125  011111010  011111000  +0.689541 
   .word   -32758 ; -91.41                        -0.999699 
   .word     -804 ;    126  011111100  111111000  -0.024541 
   .word     -804 ;  -1.41                        -0.024541 
   .word    32758 ;    127  011111110  111111000  +0.999699 
   .word     -402 ;-179.30                        -0.012272 
   .word   -32765 ;    128  100000000  000000100  -0.999925 
   .word   -32765 ; -89.30                        -0.999925 
   .word      402 ;    129  100000010  000000100  +0.012272 
   .word   -23453 ;-134.30                        -0.715731 
   .word   -22884 ;    130  100000100  100000100  -0.698376 
   .word   -22884 ; -44.30                        -0.698376 
   .word    23453 ;    131  100000110  100000100  +0.715731 
   .word   -12910 ;-156.80                        -0.393992 
   .word   -30117 ;    132  100001000  010000100  -0.919114 
   .word   -30117 ; -66.80                        -0.919114 
   .word    12910 ;    133  100001010  010000100  +0.393992 
   .word   -30425 ;-111.80                        -0.928506 
   .word   -12167 ;    134  100001100  110000100  -0.371317 
   .word   -12167 ; -21.80                        -0.371317 
   .word    30425 ;    135  100001110  110000100  +0.928506 
   .word    -6786 ;-168.05                        -0.207111 
   .word   -32057 ;    136  100010000  001000100  -0.978317 
   .word   -32057 ; -78.05                        -0.978317 
   .word     6786 ;    137  100010010  001000100  +0.207111 
   .word   -27466 ;-123.05                        -0.838225 
   .word   -17869 ;    138  100010100  101000100  -0.545325 
   .word   -17869 ; -33.05                        -0.545325 
   .word    27466 ;    139  100010110  101000100  +0.838225 
   .word   -18537 ;-145.55                        -0.565732 
   .word   -27020 ;    140  100011000  011000100  -0.824589 
   .word   -27020 ; -55.55                        -0.824589 
   .word    18537 ;    141  100011010  011000100  +0.565732 
   .word   -32214 ;-100.55                        -0.983105 
   .word    -5997 ;    142  100011100  111000100  -0.183040 
   .word    -5997 ; -10.55                        -0.183040 
   .word    32214 ;    143  100011110  111000100  +0.983105 
   .word    -3611 ;-173.67                        -0.110222 
   .word   -32568 ;    144  100100000  000100100  -0.993907 
   .word   -32568 ; -83.67                        -0.993907 
   .word     3611 ;    145  100100010  000100100  +0.110222 
   .word   -25583 ;-128.67                        -0.780737 
   .word   -20475 ;    146  100100100  100100100  -0.624859 
   .word   -20475 ; -38.67                        -0.624859 
   .word    25583 ;    147  100100110  100100100  +0.780737 
   .word   -15800 ;-151.17                        -0.482184 
   .word   -28707 ;    148  100101000  010100100  -0.876070 
   .word   -28707 ; -61.17                        -0.876070 
   .word    15800 ;    149  100101010  010100100  +0.482184 
   .word   -31471 ;-106.17                        -0.960431 
   .word    -9126 ;    150  100101100  110100100  -0.278520 
   .word    -9126 ; -16.17                        -0.278520 
   .word    31471 ;    151  100101110  110100100  +0.960431 
   .word    -9896 ;-162.42                        -0.302006 
   .word   -31237 ;    152  100110000  001100100  -0.953306 
   .word   -31237 ; -72.42                        -0.953306 
   .word     9896 ;    153  100110010  001100100  +0.302006 
   .word   -29086 ;-117.42                        -0.887640 
   .word   -15090 ;    154  100110100  101100100  -0.460539 
   .word   -15090 ; -27.42                        -0.460539 
   .word    29086 ;    155  100110110  101100100  +0.887640 
   .word   -21097 ;-139.92                        -0.643832 
   .word   -25073 ;    156  100111000  011100100  -0.765167 
   .word   -25073 ; -49.92                        -0.765167 
   .word    21097 ;    157  100111010  011100100  +0.643832 
   .word   -32647 ; -94.92                        -0.996313 
   .word    -2811 ;    158  100111100  111100100  -0.085797 
   .word    -2811 ;  -4.92                        -0.085797 
   .word    32647 ;    159  100111110  111100100  +0.996313 
   .word    -2009 ;-176.48                        -0.061321 
   .word   -32706 ;    160  101000000  000010100  -0.998118 
   .word   -32706 ; -86.48                        -0.998118 
   .word     2009 ;    161  101000010  000010100  +0.061321 
   .word   -24547 ;-131.48                        -0.749136 
   .word   -21706 ;    162  101000100  100010100  -0.662416 
   .word   -21706 ; -41.48                        -0.662416 
   .word    24547 ;    163  101000110  100010100  +0.749136 
   .word   -14372 ;-153.98                        -0.438616 
   .word   -29447 ;    164  101001000  010010100  -0.898674 
   .word   -29447 ; -63.98                        -0.898674 
   .word    14372 ;    165  101001010  010010100  +0.438616 
   .word   -30985 ;-108.98                        -0.945607 
   .word   -10659 ;    166  101001100  110010100  -0.325310 
   .word   -10659 ; -18.98                        -0.325310 
   .word    30985 ;    167  101001110  110010100  +0.945607 
   .word    -8351 ;-165.23                        -0.254866 
   .word   -31685 ;    168  101010000  001010100  -0.966976 
   .word   -31685 ; -75.23                        -0.966976 
   .word     8351 ;    169  101010010  001010100  +0.254866 
   .word   -28310 ;-120.23                        -0.863973 
   .word   -16499 ;    170  101010100  101010100  -0.503538 
   .word   -16499 ; -30.23                        -0.503538 
   .word    28310 ;    171  101010110  101010100  +0.863973 
   .word   -19841 ;-142.73                        -0.605511 
   .word   -26077 ;    172  101011000  011010100  -0.795837 
   .word   -26077 ; -52.73                        -0.795837 
   .word    19841 ;    173  101011010  011010100  +0.605511 
   .word   -32469 ; -97.73                        -0.990903 
   .word    -4409 ;    174  101011100  111010100  -0.134581 
   .word    -4409 ;  -7.73                        -0.134581 
   .word    32469 ;    175  101011110  111010100  +0.990903 
   .word    -5205 ;-170.86                        -0.158858 
   .word   -32351 ;    176  101100000  000110100  -0.987301 
   .word   -32351 ; -80.86                        -0.987301 
   .word     5205 ;    177  101100010  000110100  +0.158858 
   .word   -26557 ;-125.86                        -0.810457 
   .word   -19195 ;    178  101100100  100110100  -0.585798 
   .word   -19195 ; -35.86                        -0.585798 
   .word    26557 ;    179  101100110  100110100  +0.810457 
   .word   -17189 ;-148.36                        -0.524590 
   .word   -27897 ;    180  101101000  010110100  -0.851355 
   .word   -27897 ; -58.36                        -0.851355 
   .word    17189 ;    181  101101010  010110100  +0.524590 
   .word   -31881 ;-103.36                        -0.972940 
   .word    -7571 ;    182  101101100  110110100  -0.231058 
   .word    -7571 ; -13.36                        -0.231058 
   .word    31881 ;    183  101101110  110110100  +0.972940 
   .word   -11416 ;-159.61                        -0.348419 
   .word   -30714 ;    184  101110000  001110100  -0.937339 
   .word   -30714 ; -69.61                        -0.937339 
   .word    11416 ;    185  101110010  001110100  +0.348419 
   .word   -29791 ;-114.61                        -0.909168 
   .word   -13645 ;    186  101110100  101110100  -0.416430 
   .word   -13645 ; -24.61                        -0.416430 
   .word    29791 ;    187  101110110  101110100  +0.909168 
   .word   -22301 ;-137.11                        -0.680601 
   .word   -24007 ;    188  101111000  011110100  -0.732654 
   .word   -24007 ; -47.11                        -0.732654 
   .word    22301 ;    189  101111010  011110100  +0.680601 
   .word   -32745 ; -92.11                        -0.999322 
   .word    -1206 ;    190  101111100  111110100  -0.036807 
   .word    -1206 ;  -2.11                        -0.036807 
   .word    32745 ;    191  101111110  111110100  +0.999322 
   .word    -1206 ;-177.89                        -0.036807 
   .word   -32745 ;    192  110000000  000001100  -0.999322 
   .word   -32745 ; -87.89                        -0.999322 
   .word     1206 ;    193  110000010  000001100  +0.036807 
   .word   -24007 ;-132.89                        -0.732654 
   .word   -22301 ;    194  110000100  100001100  -0.680601 
   .word   -22301 ; -42.89                        -0.680601 
   .word    24007 ;    195  110000110  100001100  +0.732654 
   .word   -13645 ;-155.39                        -0.416430 
   .word   -29791 ;    196  110001000  010001100  -0.909168 
   .word   -29791 ; -65.39                        -0.909168 
   .word    13645 ;    197  110001010  010001100  +0.416430 
   .word   -30714 ;-110.39                        -0.937339 
   .word   -11416 ;    198  110001100  110001100  -0.348419 
   .word   -11416 ; -20.39                        -0.348419 
   .word    30714 ;    199  110001110  110001100  +0.937339 
   .word    -7571 ;-166.64                        -0.231058 
   .word   -31881 ;    200  110010000  001001100  -0.972940 
   .word   -31881 ; -76.64                        -0.972940 
   .word     7571 ;    201  110010010  001001100  +0.231058 
   .word   -27897 ;-121.64                        -0.851355 
   .word   -17189 ;    202  110010100  101001100  -0.524590 
   .word   -17189 ; -31.64                        -0.524590 
   .word    27897 ;    203  110010110  101001100  +0.851355 
   .word   -19195 ;-144.14                        -0.585798 
   .word   -26557 ;    204  110011000  011001100  -0.810457 
   .word   -26557 ; -54.14                        -0.810457 
   .word    19195 ;    205  110011010  011001100  +0.585798 
   .word   -32351 ; -99.14                        -0.987301 
   .word    -5205 ;    206  110011100  111001100  -0.158858 
   .word    -5205 ;  -9.14                        -0.158858 
   .word    32351 ;    207  110011110  111001100  +0.987301 
   .word    -4409 ;-172.27                        -0.134581 
   .word   -32469 ;    208  110100000  000101100  -0.990903 
   .word   -32469 ; -82.27                        -0.990903 
   .word     4409 ;    209  110100010  000101100  +0.134581 
   .word   -26077 ;-127.27                        -0.795837 
   .word   -19841 ;    210  110100100  100101100  -0.605511 
   .word   -19841 ; -37.27                        -0.605511 
   .word    26077 ;    211  110100110  100101100  +0.795837 
   .word   -16499 ;-149.77                        -0.503538 
   .word   -28310 ;    212  110101000  010101100  -0.863973 
   .word   -28310 ; -59.77                        -0.863973 
   .word    16499 ;    213  110101010  010101100  +0.503538 
   .word   -31685 ;-104.77                        -0.966976 
   .word    -8351 ;    214  110101100  110101100  -0.254866 
   .word    -8351 ; -14.77                        -0.254866 
   .word    31685 ;    215  110101110  110101100  +0.966976 
   .word   -10659 ;-161.02                        -0.325310 
   .word   -30985 ;    216  110110000  001101100  -0.945607 
   .word   -30985 ; -71.02                        -0.945607 
   .word    10659 ;    217  110110010  001101100  +0.325310 
   .word   -29447 ;-116.02                        -0.898674 
   .word   -14372 ;    218  110110100  101101100  -0.438616 
   .word   -14372 ; -26.02                        -0.438616 
   .word    29447 ;    219  110110110  101101100  +0.898674 
   .word   -21706 ;-138.52                        -0.662416 
   .word   -24547 ;    220  110111000  011101100  -0.749136 
   .word   -24547 ; -48.52                        -0.749136 
   .word    21706 ;    221  110111010  011101100  +0.662416 
   .word   -32706 ; -93.52                        -0.998118 
   .word    -2009 ;    222  110111100  111101100  -0.061321 
   .word    -2009 ;  -3.52                        -0.061321 
   .word    32706 ;    223  110111110  111101100  +0.998118 
   .word    -2811 ;-175.08                        -0.085797 
   .word   -32647 ;    224  111000000  000011100  -0.996313 
   .word   -32647 ; -85.08                        -0.996313 
   .word     2811 ;    225  111000010  000011100  +0.085797 
   .word   -25073 ;-130.08                        -0.765167 
   .word   -21097 ;    226  111000100  100011100  -0.643832 
   .word   -21097 ; -40.08                        -0.643832 
   .word    25073 ;    227  111000110  100011100  +0.765167 
   .word   -15090 ;-152.58                        -0.460539 
   .word   -29086 ;    228  111001000  010011100  -0.887640 
   .word   -29086 ; -62.58                        -0.887640 
   .word    15090 ;    229  111001010  010011100  +0.460539 
   .word   -31237 ;-107.58                        -0.953306 
   .word    -9896 ;    230  111001100  110011100  -0.302006 
   .word    -9896 ; -17.58                        -0.302006 
   .word    31237 ;    231  111001110  110011100  +0.953306 
   .word    -9126 ;-163.83                        -0.278520 
   .word   -31471 ;    232  111010000  001011100  -0.960431 
   .word   -31471 ; -73.83                        -0.960431 
   .word     9126 ;    233  111010010  001011100  +0.278520 
   .word   -28707 ;-118.83                        -0.876070 
   .word   -15800 ;    234  111010100  101011100  -0.482184 
   .word   -15800 ; -28.83                        -0.482184 
   .word    28707 ;    235  111010110  101011100  +0.876070 
   .word   -20475 ;-141.33                        -0.624859 
   .word   -25583 ;    236  111011000  011011100  -0.780737 
   .word   -25583 ; -51.33                        -0.780737 
   .word    20475 ;    237  111011010  011011100  +0.624859 
   .word   -32568 ; -96.33                        -0.993907 
   .word    -3611 ;    238  111011100  111011100  -0.110222 
   .word    -3611 ;  -6.33                        -0.110222 
   .word    32568 ;    239  111011110  111011100  +0.993907 
   .word    -5997 ;-169.45                        -0.183040 
   .word   -32214 ;    240  111100000  000111100  -0.983105 
   .word   -32214 ; -79.45                        -0.983105 
   .word     5997 ;    241  111100010  000111100  +0.183040 
   .word   -27020 ;-124.45                        -0.824589 
   .word   -18537 ;    242  111100100  100111100  -0.565732 
   .word   -18537 ; -34.45                        -0.565732 
   .word    27020 ;    243  111100110  100111100  +0.824589 
   .word   -17869 ;-146.95                        -0.545325 
   .word   -27466 ;    244  111101000  010111100  -0.838225 
   .word   -27466 ; -56.95                        -0.838225 
   .word    17869 ;    245  111101010  010111100  +0.545325 
   .word   -32057 ;-101.95                        -0.978317 
   .word    -6786 ;    246  111101100  110111100  -0.207111 
   .word    -6786 ; -11.95                        -0.207111 
   .word    32057 ;    247  111101110  110111100  +0.978317 
   .word   -12167 ;-158.20                        -0.371317 
   .word   -30425 ;    248  111110000  001111100  -0.928506 
   .word   -30425 ; -68.20                        -0.928506 
   .word    12167 ;    249  111110010  001111100  +0.371317 
   .word   -30117 ;-113.20                        -0.919114 
   .word   -12910 ;    250  111110100  101111100  -0.393992 
   .word   -12910 ; -23.20                        -0.393992 
   .word    30117 ;    251  111110110  101111100  +0.919114 
   .word   -22884 ;-135.70                        -0.698376 
   .word   -23453 ;    252  111111000  011111100  -0.715731 
   .word   -23453 ; -45.70                        -0.715731 
   .word    22884 ;    253  111111010  011111100  +0.698376 
   .word   -32765 ; -90.70                        -0.999925 
   .word     -402 ;    254  111111100  111111100  -0.012272 
   .word     -402 ;  -0.70                        -0.012272 
   .word    32765 ;    255  111111110  111111100  +0.999925 
   .word     -201 ;-179.65                        -0.006136 
   .word   -32767 ;    256  000000000  000000010  -0.999981 
   .word   -32767 ; -89.65                        -0.999981 
   .word      201 ;    257  000000010  000000010  +0.006136 
   .word   -23312 ;-134.65                        -0.711432 
   .word   -23027 ;    258  000000100  100000010  -0.702755 
   .word   -23027 ; -44.65                        -0.702755 
   .word    23312 ;    259  000000110  100000010  +0.711432 
   .word   -12725 ;-157.15                        -0.388345 
   .word   -30196 ;    260  000001000  010000010  -0.921514 
   .word   -30196 ; -67.15                        -0.921514 
   .word    12725 ;    261  000001010  010000010  +0.388345 
   .word   -30350 ;-112.15                        -0.926210 
   .word   -12353 ;    262  000001100  110000010  -0.377007 
   .word   -12353 ; -22.15                        -0.377007 
   .word    30350 ;    263  000001110  110000010  +0.926210 
   .word    -6589 ;-168.40                        -0.201105 
   .word   -32098 ;    264  000010000  001000010  -0.979570 
   .word   -32098 ; -78.40                        -0.979570 
   .word     6589 ;    265  000010010  001000010  +0.201105 
   .word   -27356 ;-123.40                        -0.834863 
   .word   -18037 ;    266  000010100  101000010  -0.550458 
   .word   -18037 ; -33.40                        -0.550458 
   .word    27356 ;    267  000010110  101000010  +0.834863 
   .word   -18371 ;-145.90                        -0.560662 
   .word   -27133 ;    268  000011000  011000010  -0.828045 
   .word   -27133 ; -55.90                        -0.828045 
   .word    18371 ;    269  000011010  011000010  +0.560662 
   .word   -32176 ;-100.90                        -0.981964 
   .word    -6195 ;    270  000011100  111000010  -0.189069 
   .word    -6195 ; -10.90                        -0.189069 
   .word    32176 ;    271  000011110  111000010  +0.981964 
   .word    -3411 ;-174.02                        -0.104122 
   .word   -32589 ;    272  000100000  000100010  -0.994565 
   .word   -32589 ; -84.02                        -0.994565 
   .word     3411 ;    273  000100010  000100010  +0.104122 
   .word   -25457 ;-129.02                        -0.776888 
   .word   -20631 ;    274  000100100  100100010  -0.629638 
   .word   -20631 ; -39.02                        -0.629638 
   .word    25457 ;    275  000100110  100100010  +0.776888 
   .word   -15623 ;-151.52                        -0.476799 
   .word   -28803 ;    276  000101000  010100010  -0.879012 
   .word   -28803 ; -61.52                        -0.879012 
   .word    15623 ;    277  000101010  010100010  +0.476799 
   .word   -31414 ;-106.52                        -0.958703 
   .word    -9319 ;    278  000101100  110100010  -0.284408 
   .word    -9319 ; -16.52                        -0.284408 
   .word    31414 ;    279  000101110  110100010  +0.958703 
   .word    -9704 ;-162.77                        -0.296151 
   .word   -31298 ;    280  000110000  001100010  -0.955141 
   .word   -31298 ; -72.77                        -0.955141 
   .word     9704 ;    281  000110010  001100010  +0.296151 
   .word   -28993 ;-117.77                        -0.884797 
   .word   -15269 ;    282  000110100  101100010  -0.465976 
   .word   -15269 ; -27.77                        -0.465976 
   .word    28993 ;    283  000110110  101100010  +0.884797 
   .word   -20942 ;-140.27                        -0.639124 
   .word   -25201 ;    284  000111000  011100010  -0.769103 
   .word   -25201 ; -50.27                        -0.769103 
   .word    20942 ;    285  000111010  011100010  +0.639124 
   .word   -32629 ; -95.27                        -0.995767 
   .word    -3011 ;    286  000111100  111100010  -0.091909 
   .word    -3011 ;  -5.27                        -0.091909 
   .word    32629 ;    287  000111110  111100010  +0.995767 
   .word    -1808 ;-176.84                        -0.055195 
   .word   -32718 ;    288  001000000  000010010  -0.998476 
   .word   -32718 ; -86.84                        -0.998476 
   .word     1808 ;    289  001000010  000010010  +0.055195 
   .word   -24414 ;-131.84                        -0.745058 
   .word   -21856 ;    290  001000100  100010010  -0.667000 
   .word   -21856 ; -41.84                        -0.667000 
   .word    24414 ;    291  001000110  100010010  +0.745058 
   .word   -14191 ;-154.34                        -0.433094 
   .word   -29535 ;    292  001001000  010010010  -0.901349 
   .word   -29535 ; -64.34                        -0.901349 
   .word    14191 ;    293  001001010  010010010  +0.433094 
   .word   -30919 ;-109.34                        -0.943593 
   .word   -10849 ;    294  001001100  110010010  -0.331106 
   .word   -10849 ; -19.34                        -0.331106 
   .word    30919 ;    295  001001110  110010010  +0.943593 
   .word    -8156 ;-165.59                        -0.248928 
   .word   -31736 ;    296  001010000  001010010  -0.968522 
   .word   -31736 ; -75.59                        -0.968522 
   .word     8156 ;    297  001010010  001010010  +0.248928 
   .word   -28208 ;-120.59                        -0.860867 
   .word   -16673 ;    298  001010100  101010010  -0.508830 
   .word   -16673 ; -30.59                        -0.508830 
   .word    28208 ;    299  001010110  101010010  +0.860867 
   .word   -19681 ;-143.09                        -0.600616 
   .word   -26199 ;    300  001011000  011010010  -0.799537 
   .word   -26199 ; -53.09                        -0.799537 
   .word    19681 ;    301  001011010  011010010  +0.600616 
   .word   -32442 ; -98.09                        -0.990058 
   .word    -4609 ;    302  001011100  111010010  -0.140658 
   .word    -4609 ;  -8.09                        -0.140658 
   .word    32442 ;    303  001011110  111010010  +0.990058 
   .word    -5006 ;-171.21                        -0.152797 
   .word   -32383 ;    304  001100000  000110010  -0.988258 
   .word   -32383 ; -81.21                        -0.988258 
   .word     5006 ;    305  001100010  000110010  +0.152797 
   .word   -26438 ;-126.21                        -0.806848 
   .word   -19358 ;    306  001100100  100110010  -0.590760 
   .word   -19358 ; -36.21                        -0.590760 
   .word    26438 ;    307  001100110  100110010  +0.806848 
   .word   -17018 ;-148.71                        -0.519356 
   .word   -28002 ;    308  001101000  010110010  -0.854558 
   .word   -28002 ; -58.71                        -0.854558 
   .word    17018 ;    309  001101010  010110010  +0.519356 
   .word   -31834 ;-103.71                        -0.971504 
   .word    -7766 ;    310  001101100  110110010  -0.237024 
   .word    -7766 ; -13.71                        -0.237024 
   .word    31834 ;    311  001101110  110110010  +0.971504 
   .word   -11228 ;-159.96                        -0.342661 
   .word   -30784 ;    312  001110000  001110010  -0.939459 
   .word   -30784 ; -69.96                        -0.939459 
   .word    11228 ;    313  001110010  001110010  +0.342661 
   .word   -29707 ;-114.96                        -0.906596 
   .word   -13828 ;    314  001110100  101110010  -0.422000 
   .word   -13828 ; -24.96                        -0.422000 
   .word    29707 ;    315  001110110  101110010  +0.906596 
   .word   -22154 ;-137.46                        -0.676093 
   .word   -24144 ;    316  001111000  011110010  -0.736817 
   .word   -24144 ; -47.46                        -0.736817 
   .word    22154 ;    317  001111010  011110010  +0.676093 
   .word   -32737 ; -92.46                        -0.999078 
   .word    -1407 ;    318  001111100  111110010  -0.042938 
   .word    -1407 ;  -2.46                        -0.042938 
   .word    32737 ;    319  001111110  111110010  +0.999078 
   .word    -1005 ;-178.24                        -0.030675 
   .word   -32752 ;    320  010000000  000001010  -0.999529 
   .word   -32752 ; -88.24                        -0.999529 
   .word     1005 ;    321  010000010  000001010  +0.030675 
   .word   -23870 ;-133.24                        -0.728464 
   .word   -22448 ;    322  010000100  100001010  -0.685084 
   .word   -22448 ; -43.24                        -0.685084 
   .word    23870 ;    323  010000110  100001010  +0.728464 
   .word   -13462 ;-155.74                        -0.410843 
   .word   -29874 ;    324  010001000  010001010  -0.911706 
   .word   -29874 ; -65.74                        -0.911706 
   .word    13462 ;    325  010001010  010001010  +0.410843 
   .word   -30644 ;-110.74                        -0.935184 
   .word   -11605 ;    326  010001100  110001010  -0.354164 
   .word   -11605 ; -20.74                        -0.354164 
   .word    30644 ;    327  010001110  110001010  +0.935184 
   .word    -7375 ;-166.99                        -0.225084 
   .word   -31927 ;    328  010010000  001001010  -0.974339 
   .word   -31927 ; -76.99                        -0.974339 
   .word     7375 ;    329  010010010  001001010  +0.225084 
   .word   -27791 ;-121.99                        -0.848120 
   .word   -17360 ;    330  010010100  101001010  -0.529804 
   .word   -17360 ; -31.99                        -0.529804 
   .word    27791 ;    331  010010110  101001010  +0.848120 
   .word   -19032 ;-144.49                        -0.580814 
   .word   -26674 ;    332  010011000  011001010  -0.814036 
   .word   -26674 ; -54.49                        -0.814036 
   .word    19032 ;    333  010011010  011001010  +0.580814 
   .word   -32319 ; -99.49                        -0.986308 
   .word    -5403 ;    334  010011100  111001010  -0.164913 
   .word    -5403 ;  -9.49                        -0.164913 
   .word    32319 ;    335  010011110  111001010  +0.986308 
   .word    -4210 ;-172.62                        -0.128498 
   .word   -32496 ;    336  010100000  000101010  -0.991710 
   .word   -32496 ; -82.62                        -0.991710 
   .word     4210 ;    337  010100010  000101010  +0.128498 
   .word   -25955 ;-127.62                        -0.792107 
   .word   -20001 ;    338  010100100  100101010  -0.610383 
   .word   -20001 ; -37.62                        -0.610383 
   .word    25955 ;    339  010100110  100101010  +0.792107 
   .word   -16325 ;-150.12                        -0.498228 
   .word   -28411 ;    340  010101000  010101010  -0.867046 
   .word   -28411 ; -60.12                        -0.867046 
   .word    16325 ;    341  010101010  010101010  +0.498228 
   .word   -31634 ;-105.12                        -0.965394 
   .word    -8545 ;    342  010101100  110101010  -0.260794 
   .word    -8545 ; -15.12                        -0.260794 
   .word    31634 ;    343  010101110  110101010  +0.965394 
   .word   -10469 ;-161.37                        -0.319502 
   .word   -31050 ;    344  010110000  001101010  -0.947586 
   .word   -31050 ; -71.37                        -0.947586 
   .word    10469 ;    345  010110010  001101010  +0.319502 
   .word   -29359 ;-116.37                        -0.895966 
   .word   -14552 ;    346  010110100  101101010  -0.444122 
   .word   -14552 ; -26.37                        -0.444122 
   .word    29359 ;    347  010110110  101101010  +0.895966 
   .word   -21555 ;-138.87                        -0.657807 
   .word   -24680 ;    348  010111000  011101010  -0.753187 
   .word   -24680 ; -48.87                        -0.753187 
   .word    21555 ;    349  010111010  011101010  +0.657807 
   .word   -32693 ; -93.87                        -0.997723 
   .word    -2210 ;    350  010111100  111101010  -0.067444 
   .word    -2210 ;  -3.87                        -0.067444 
   .word    32693 ;    351  010111110  111101010  +0.997723 
   .word    -2611 ;-175.43                        -0.079682 
   .word   -32663 ;    352  011000000  000011010  -0.996820 
   .word   -32663 ; -85.43                        -0.996820 
   .word     2611 ;    353  011000010  000011010  +0.079682 
   .word   -24943 ;-130.43                        -0.761202 
   .word   -21250 ;    354  011000100  100011010  -0.648514 
   .word   -21250 ; -40.43                        -0.648514 
   .word    24943 ;    355  011000110  100011010  +0.761202 
   .word   -14912 ;-152.93                        -0.455084 
   .word   -29178 ;    356  011001000  010011010  -0.890449 
   .word   -29178 ; -62.93                        -0.890449 
   .word    14912 ;    357  011001010  010011010  +0.455084 
   .word   -31176 ;-107.93                        -0.951435 
   .word   -10087 ;    358  011001100  110011010  -0.307850 
   .word   -10087 ; -17.93                        -0.307850 
   .word    31176 ;    359  011001110  110011010  +0.951435 
   .word    -8933 ;-164.18                        -0.272621 
   .word   -31526 ;    360  011010000  001011010  -0.962121 
   .word   -31526 ; -74.18                        -0.962121 
   .word     8933 ;    361  011010010  001011010  +0.272621 
   .word   -28609 ;-119.18                        -0.873095 
   .word   -15976 ;    362  011010100  101011010  -0.487550 
   .word   -15976 ; -29.18                        -0.487550 
   .word    28609 ;    363  011010110  101011010  +0.873095 
   .word   -20318 ;-141.68                        -0.620057 
   .word   -25708 ;    364  011011000  011011010  -0.784557 
   .word   -25708 ; -51.68                        -0.784557 
   .word    20318 ;    365  011011010  011011010  +0.620057 
   .word   -32545 ; -96.68                        -0.993212 
   .word    -3811 ;    366  011011100  111011010  -0.116319 
   .word    -3811 ;  -6.68                        -0.116319 
   .word    32545 ;    367  011011110  111011010  +0.993212 
   .word    -5800 ;-169.80                        -0.177004 
   .word   -32250 ;    368  011100000  000111010  -0.984210 
   .word   -32250 ; -79.80                        -0.984210 
   .word     5800 ;    369  011100010  000111010  +0.177004 
   .word   -26905 ;-124.80                        -0.821103 
   .word   -18703 ;    370  011100100  100111010  -0.570781 
   .word   -18703 ; -34.80                        -0.570781 
   .word    26905 ;    371  011100110  100111010  +0.821103 
   .word   -17700 ;-147.30                        -0.540171 
   .word   -27576 ;    372  011101000  010111010  -0.841555 
   .word   -27576 ; -57.30                        -0.841555 
   .word    17700 ;    373  011101010  010111010  +0.540171 
   .word   -32015 ;-102.30                        -0.977028 
   .word    -6983 ;    374  011101100  110111010  -0.213110 
   .word    -6983 ; -12.30                        -0.213110 
   .word    32015 ;    375  011101110  110111010  +0.977028 
   .word   -11980 ;-158.55                        -0.365613 
   .word   -30499 ;    376  011110000  001111010  -0.930767 
   .word   -30499 ; -68.55                        -0.930767 
   .word    11980 ;    377  011110010  001111010  +0.365613 
   .word   -30037 ;-113.55                        -0.916679 
   .word   -13094 ;    378  011110100  101111010  -0.399624 
   .word   -13094 ; -23.55                        -0.399624 
   .word    30037 ;    379  011110110  101111010  +0.916679 
   .word   -22740 ;-136.05                        -0.693971 
   .word   -23593 ;    380  011111000  011111010  -0.720003 
   .word   -23593 ; -46.05                        -0.720003 
   .word    22740 ;    381  011111010  011111010  +0.693971 
   .word   -32762 ; -91.05                        -0.999831 
   .word     -603 ;    382  011111100  111111010  -0.018407 
   .word     -603 ;  -1.05                        -0.018407 
   .word    32762 ;    383  011111110  111111010  +0.999831 
   .word     -603 ;-178.95                        -0.018407 
   .word   -32762 ;    384  100000000  000000110  -0.999831 
   .word   -32762 ; -88.95                        -0.999831 
   .word      603 ;    385  100000010  000000110  +0.018407 
   .word   -23593 ;-133.95                        -0.720003 
   .word   -22740 ;    386  100000100  100000110  -0.693971 
   .word   -22740 ; -43.95                        -0.693971 
   .word    23593 ;    387  100000110  100000110  +0.720003 
   .word   -13094 ;-156.45                        -0.399624 
   .word   -30037 ;    388  100001000  010000110  -0.916679 
   .word   -30037 ; -66.45                        -0.916679 
   .word    13094 ;    389  100001010  010000110  +0.399624 
   .word   -30499 ;-111.45                        -0.930767 
   .word   -11980 ;    390  100001100  110000110  -0.365613 
   .word   -11980 ; -21.45                        -0.365613 
   .word    30499 ;    391  100001110  110000110  +0.930767 
   .word    -6983 ;-167.70                        -0.213110 
   .word   -32015 ;    392  100010000  001000110  -0.977028 
   .word   -32015 ; -77.70                        -0.977028 
   .word     6983 ;    393  100010010  001000110  +0.213110 
   .word   -27576 ;-122.70                        -0.841555 
   .word   -17700 ;    394  100010100  101000110  -0.540171 
   .word   -17700 ; -32.70                        -0.540171 
   .word    27576 ;    395  100010110  101000110  +0.841555 
   .word   -18703 ;-145.20                        -0.570781 
   .word   -26905 ;    396  100011000  011000110  -0.821103 
   .word   -26905 ; -55.20                        -0.821103 
   .word    18703 ;    397  100011010  011000110  +0.570781 
   .word   -32250 ;-100.20                        -0.984210 
   .word    -5800 ;    398  100011100  111000110  -0.177004 
   .word    -5800 ; -10.20                        -0.177004 
   .word    32250 ;    399  100011110  111000110  +0.984210 
   .word    -3811 ;-173.32                        -0.116319 
   .word   -32545 ;    400  100100000  000100110  -0.993212 
   .word   -32545 ; -83.32                        -0.993212 
   .word     3811 ;    401  100100010  000100110  +0.116319 
   .word   -25708 ;-128.32                        -0.784557 
   .word   -20318 ;    402  100100100  100100110  -0.620057 
   .word   -20318 ; -38.32                        -0.620057 
   .word    25708 ;    403  100100110  100100110  +0.784557 
   .word   -15976 ;-150.82                        -0.487550 
   .word   -28609 ;    404  100101000  010100110  -0.873095 
   .word   -28609 ; -60.82                        -0.873095 
   .word    15976 ;    405  100101010  010100110  +0.487550 
   .word   -31526 ;-105.82                        -0.962121 
   .word    -8933 ;    406  100101100  110100110  -0.272621 
   .word    -8933 ; -15.82                        -0.272621 
   .word    31526 ;    407  100101110  110100110  +0.962121 
   .word   -10087 ;-162.07                        -0.307850 
   .word   -31176 ;    408  100110000  001100110  -0.951435 
   .word   -31176 ; -72.07                        -0.951435 
   .word    10087 ;    409  100110010  001100110  +0.307850 
   .word   -29178 ;-117.07                        -0.890449 
   .word   -14912 ;    410  100110100  101100110  -0.455084 
   .word   -14912 ; -27.07                        -0.455084 
   .word    29178 ;    411  100110110  101100110  +0.890449 
   .word   -21250 ;-139.57                        -0.648514 
   .word   -24943 ;    412  100111000  011100110  -0.761202 
   .word   -24943 ; -49.57                        -0.761202 
   .word    21250 ;    413  100111010  011100110  +0.648514 
   .word   -32663 ; -94.57                        -0.996820 
   .word    -2611 ;    414  100111100  111100110  -0.079682 
   .word    -2611 ;  -4.57                        -0.079682 
   .word    32663 ;    415  100111110  111100110  +0.996820 
   .word    -2210 ;-176.13                        -0.067444 
   .word   -32693 ;    416  101000000  000010110  -0.997723 
   .word   -32693 ; -86.13                        -0.997723 
   .word     2210 ;    417  101000010  000010110  +0.067444 
   .word   -24680 ;-131.13                        -0.753187 
   .word   -21555 ;    418  101000100  100010110  -0.657807 
   .word   -21555 ; -41.13                        -0.657807 
   .word    24680 ;    419  101000110  100010110  +0.753187 
   .word   -14552 ;-153.63                        -0.444122 
   .word   -29359 ;    420  101001000  010010110  -0.895966 
   .word   -29359 ; -63.63                        -0.895966 
   .word    14552 ;    421  101001010  010010110  +0.444122 
   .word   -31050 ;-108.63                        -0.947586 
   .word   -10469 ;    422  101001100  110010110  -0.319502 
   .word   -10469 ; -18.63                        -0.319502 
   .word    31050 ;    423  101001110  110010110  +0.947586 
   .word    -8545 ;-164.88                        -0.260794 
   .word   -31634 ;    424  101010000  001010110  -0.965394 
   .word   -31634 ; -74.88                        -0.965394 
   .word     8545 ;    425  101010010  001010110  +0.260794 
   .word   -28411 ;-119.88                        -0.867046 
   .word   -16325 ;    426  101010100  101010110  -0.498228 
   .word   -16325 ; -29.88                        -0.498228 
   .word    28411 ;    427  101010110  101010110  +0.867046 
   .word   -20001 ;-142.38                        -0.610383 
   .word   -25955 ;    428  101011000  011010110  -0.792107 
   .word   -25955 ; -52.38                        -0.792107 
   .word    20001 ;    429  101011010  011010110  +0.610383 
   .word   -32496 ; -97.38                        -0.991710 
   .word    -4210 ;    430  101011100  111010110  -0.128498 
   .word    -4210 ;  -7.38                        -0.128498 
   .word    32496 ;    431  101011110  111010110  +0.991710 
   .word    -5403 ;-170.51                        -0.164913 
   .word   -32319 ;    432  101100000  000110110  -0.986308 
   .word   -32319 ; -80.51                        -0.986308 
   .word     5403 ;    433  101100010  000110110  +0.164913 
   .word   -26674 ;-125.51                        -0.814036 
   .word   -19032 ;    434  101100100  100110110  -0.580814 
   .word   -19032 ; -35.51                        -0.580814 
   .word    26674 ;    435  101100110  100110110  +0.814036 
   .word   -17360 ;-148.01                        -0.529804 
   .word   -27791 ;    436  101101000  010110110  -0.848120 
   .word   -27791 ; -58.01                        -0.848120 
   .word    17360 ;    437  101101010  010110110  +0.529804 
   .word   -31927 ;-103.01                        -0.974339 
   .word    -7375 ;    438  101101100  110110110  -0.225084 
   .word    -7375 ; -13.01                        -0.225084 
   .word    31927 ;    439  101101110  110110110  +0.974339 
   .word   -11605 ;-159.26                        -0.354164 
   .word   -30644 ;    440  101110000  001110110  -0.935184 
   .word   -30644 ; -69.26                        -0.935184 
   .word    11605 ;    441  101110010  001110110  +0.354164 
   .word   -29874 ;-114.26                        -0.911706 
   .word   -13462 ;    442  101110100  101110110  -0.410843 
   .word   -13462 ; -24.26                        -0.410843 
   .word    29874 ;    443  101110110  101110110  +0.911706 
   .word   -22448 ;-136.76                        -0.685084 
   .word   -23870 ;    444  101111000  011110110  -0.728464 
   .word   -23870 ; -46.76                        -0.728464 
   .word    22448 ;    445  101111010  011110110  +0.685084 
   .word   -32752 ; -91.76                        -0.999529 
   .word    -1005 ;    446  101111100  111110110  -0.030675 
   .word    -1005 ;  -1.76                        -0.030675 
   .word    32752 ;    447  101111110  111110110  +0.999529 
   .word    -1407 ;-177.54                        -0.042938 
   .word   -32737 ;    448  110000000  000001110  -0.999078 
   .word   -32737 ; -87.54                        -0.999078 
   .word     1407 ;    449  110000010  000001110  +0.042938 
   .word   -24144 ;-132.54                        -0.736817 
   .word   -22154 ;    450  110000100  100001110  -0.676093 
   .word   -22154 ; -42.54                        -0.676093 
   .word    24144 ;    451  110000110  100001110  +0.736817 
   .word   -13828 ;-155.04                        -0.422000 
   .word   -29707 ;    452  110001000  010001110  -0.906596 
   .word   -29707 ; -65.04                        -0.906596 
   .word    13828 ;    453  110001010  010001110  +0.422000 
   .word   -30784 ;-110.04                        -0.939459 
   .word   -11228 ;    454  110001100  110001110  -0.342661 
   .word   -11228 ; -20.04                        -0.342661 
   .word    30784 ;    455  110001110  110001110  +0.939459 
   .word    -7766 ;-166.29                        -0.237024 
   .word   -31834 ;    456  110010000  001001110  -0.971504 
   .word   -31834 ; -76.29                        -0.971504 
   .word     7766 ;    457  110010010  001001110  +0.237024 
   .word   -28002 ;-121.29                        -0.854558 
   .word   -17018 ;    458  110010100  101001110  -0.519356 
   .word   -17018 ; -31.29                        -0.519356 
   .word    28002 ;    459  110010110  101001110  +0.854558 
   .word   -19358 ;-143.79                        -0.590760 
   .word   -26438 ;    460  110011000  011001110  -0.806848 
   .word   -26438 ; -53.79                        -0.806848 
   .word    19358 ;    461  110011010  011001110  +0.590760 
   .word   -32383 ; -98.79                        -0.988258 
   .word    -5006 ;    462  110011100  111001110  -0.152797 
   .word    -5006 ;  -8.79                        -0.152797 
   .word    32383 ;    463  110011110  111001110  +0.988258 
   .word    -4609 ;-171.91                        -0.140658 
   .word   -32442 ;    464  110100000  000101110  -0.990058 
   .word   -32442 ; -81.91                        -0.990058 
   .word     4609 ;    465  110100010  000101110  +0.140658 
   .word   -26199 ;-126.91                        -0.799537 
   .word   -19681 ;    466  110100100  100101110  -0.600616 
   .word   -19681 ; -36.91                        -0.600616 
   .word    26199 ;    467  110100110  100101110  +0.799537 
   .word   -16673 ;-149.41                        -0.508830 
   .word   -28208 ;    468  110101000  010101110  -0.860867 
   .word   -28208 ; -59.41                        -0.860867 
   .word    16673 ;    469  110101010  010101110  +0.508830 
   .word   -31736 ;-104.41                        -0.968522 
   .word    -8156 ;    470  110101100  110101110  -0.248928 
   .word    -8156 ; -14.41                        -0.248928 
   .word    31736 ;    471  110101110  110101110  +0.968522 
   .word   -10849 ;-160.66                        -0.331106 
   .word   -30919 ;    472  110110000  001101110  -0.943593 
   .word   -30919 ; -70.66                        -0.943593 
   .word    10849 ;    473  110110010  001101110  +0.331106 
   .word   -29535 ;-115.66                        -0.901349 
   .word   -14191 ;    474  110110100  101101110  -0.433094 
   .word   -14191 ; -25.66                        -0.433094 
   .word    29535 ;    475  110110110  101101110  +0.901349 
   .word   -21856 ;-138.16                        -0.667000 
   .word   -24414 ;    476  110111000  011101110  -0.745058 
   .word   -24414 ; -48.16                        -0.745058 
   .word    21856 ;    477  110111010  011101110  +0.667000 
   .word   -32718 ; -93.16                        -0.998476 
   .word    -1808 ;    478  110111100  111101110  -0.055195 
   .word    -1808 ;  -3.16                        -0.055195 
   .word    32718 ;    479  110111110  111101110  +0.998476 
   .word    -3011 ;-174.73                        -0.091909 
   .word   -32629 ;    480  111000000  000011110  -0.995767 
   .word   -32629 ; -84.73                        -0.995767 
   .word     3011 ;    481  111000010  000011110  +0.091909 
   .word   -25201 ;-129.73                        -0.769103 
   .word   -20942 ;    482  111000100  100011110  -0.639124 
   .word   -20942 ; -39.73                        -0.639124 
   .word    25201 ;    483  111000110  100011110  +0.769103 
   .word   -15269 ;-152.23                        -0.465976 
   .word   -28993 ;    484  111001000  010011110  -0.884797 
   .word   -28993 ; -62.23                        -0.884797 
   .word    15269 ;    485  111001010  010011110  +0.465976 
   .word   -31298 ;-107.23                        -0.955141 
   .word    -9704 ;    486  111001100  110011110  -0.296151 
   .word    -9704 ; -17.23                        -0.296151 
   .word    31298 ;    487  111001110  110011110  +0.955141 
   .word    -9319 ;-163.48                        -0.284408 
   .word   -31414 ;    488  111010000  001011110  -0.958703 
   .word   -31414 ; -73.48                        -0.958703 
   .word     9319 ;    489  111010010  001011110  +0.284408 
   .word   -28803 ;-118.48                        -0.879012 
   .word   -15623 ;    490  111010100  101011110  -0.476799 
   .word   -15623 ; -28.48                        -0.476799 
   .word    28803 ;    491  111010110  101011110  +0.879012 
   .word   -20631 ;-140.98                        -0.629638 
   .word   -25457 ;    492  111011000  011011110  -0.776888 
   .word   -25457 ; -50.98                        -0.776888 
   .word    20631 ;    493  111011010  011011110  +0.629638 
   .word   -32589 ; -95.98                        -0.994565 
   .word    -3411 ;    494  111011100  111011110  -0.104122 
   .word    -3411 ;  -5.98                        -0.104122 
   .word    32589 ;    495  111011110  111011110  +0.994565 
   .word    -6195 ;-169.10                        -0.189069 
   .word   -32176 ;    496  111100000  000111110  -0.981964 
   .word   -32176 ; -79.10                        -0.981964 
   .word     6195 ;    497  111100010  000111110  +0.189069 
   .word   -27133 ;-124.10                        -0.828045 
   .word   -18371 ;    498  111100100  100111110  -0.560662 
   .word   -18371 ; -34.10                        -0.560662 
   .word    27133 ;    499  111100110  100111110  +0.828045 
   .word   -18037 ;-146.60                        -0.550458 
   .word   -27356 ;    500  111101000  010111110  -0.834863 
   .word   -27356 ; -56.60                        -0.834863 
   .word    18037 ;    501  111101010  010111110  +0.550458 
   .word   -32098 ;-101.60                        -0.979570 
   .word    -6589 ;    502  111101100  110111110  -0.201105 
   .word    -6589 ; -11.60                        -0.201105 
   .word    32098 ;    503  111101110  110111110  +0.979570 
   .word   -12353 ;-157.85                        -0.377007 
   .word   -30350 ;    504  111110000  001111110  -0.926210 
   .word   -30350 ; -67.85                        -0.926210 
   .word    12353 ;    505  111110010  001111110  +0.377007 
   .word   -30196 ;-112.85                        -0.921514 
   .word   -12725 ;    506  111110100  101111110  -0.388345 
   .word   -12725 ; -22.85                        -0.388345 
   .word    30196 ;    507  111110110  101111110  +0.921514 
   .word   -23027 ;-135.35                        -0.702755 
   .word   -23312 ;    508  111111000  011111110  -0.711432 
   .word   -23312 ; -45.35                        -0.711432 
   .word    23027 ;    509  111111010  011111110  +0.702755 
   .word   -32767 ; -90.35                        -0.999981 
   .word     -201 ;    510  111111100  111111110  -0.006136 
   .word     -201 ;  -0.35                        -0.006136 
   .word    32767 ;    511  111111110  111111110  +0.999981 
   ;-----------------------------------------------;
   ;  Input Buffer allocation and initialization   ;
   ;-----------------------------------------------;
             .ds     01c00h
_B_base:     .space  00010h
   ;-----------------------------------------------;
   ;  Hanning (raised cosine) from twiddle table   ;
   ;  No window table is initialized !!            ;
   ;-----------------------------------------------;
