// Questo serve per utilizzare la libreria HI5, quella che serve per l'uso
// della scheda tramite programma C
#include "HI5_LIB.H"

// Questo serv per usare le stringhe di caratteri
#include <string.h>

// Questi sono i moduli nostri
#include <func.h>
#include <prove.h>


// variabili che fanno parte della libreria HI5
// NON modificare la imr!!!
STRUCT_IMR imr;

// vari parametri come : numero della porta COM, baud rate.....
PARAMETER prm;

// Posizione nello schermo a cui compariranno i messaggi di sistema
extern MSGRx, MSGRy;

extern pcom;                // Numero della porta COM.

// Nome del file di programma da caricare nella scheda ;
// Lo inizializzo soltanto
extern  char appfile[] = "12345678.dsk";


void main(void)
{
  // Indirizzo della memoria del DSP dove scrivere il valore di vdc
  const int vdcDsp = 0x0f05 ;

  // Indirizzo della memoria del DSP dove scrivere il valore di zeroVolt
  const int zeroVoltDsp =  0x0f05 ;

  // Indirizzo di partenza del programma assembly del DSP
  const int indirizzoPartenza = 0x0a00;

  // La scelta eseguita dall'utente.
  int scelta = 0 ;

  // valore della tensione continua
  double vdc = 0 ;

  // Valore numerico da mandare alla scheda affinche' mandi in uscita
  // tensione nulla.
  // Il valore iniziale abbastanza buono e' 104.
  int zeroVolt = 104 ;

  // Numero di campioni da caricare sulla scheda
  int numCamp = 8 ;

  // Indirizzo finale del buffer circolare
  int fineMem = 0xf10;

  // Frequenza del segnale a forma arbitraria
  float freqSegnale = 0;

  // Indica se bisogna uscire dal programma
  int finito = 0 ;

  // Indica in quale punto dello schermo devono comparire i messaggi
  // di sistema
  MSGRy=5;

  // cancello lo schermo
  clrscr();

  // Imposto la porta seriale su cui e' copllegata la scheda ;
  // 0 indica la COM1, e cosi' via.
  prm.com = 0;

  // Imposto il baud rate sulla porta seriale.
  // Se siamo sotto Windows, vedere se questa impostazione fa effetto
  // gia' cosi', oppure bisogna impostare la stessa velocita' tramite
  // pennello di controllo.
  prm.speed = 19200;

  // Imposta la logica di un certo piedino della porta seriale.
  // Pure qui vedere se sotto Windows va tutto bene.
  prm.INVERSE = YES;

  // Legge i parametri dalla riga di comando (se ce ne sono)
  // e imposta di conseguenza certe variabili.
  // Non usarla se siamo sotto Windows (non servirebbe).
  GetArguments();


   while(!finito) {
    printf("\n\n");

    printf("0. Spegne il DSP ed esce dal programma\n");
    printf("1. Genera tensione zero\n");
    printf("2. Genera tensione costante\n");
    printf("3. Genera una forma d'onda arbitraria\n") ;
    printf("4. Esegue l'auto-test della scheda\n") ;
    printf("5. Spegne il DSP.\n") ;

    scanf("%d",&scelta);

    clrscr();
    switch(scelta) {

      // Questo e' il pezzo di codice per fermare il DSP
      // e uscire dal programma
      case 0:
	// Indico che il programma deve terminare
	finito=1;
      // Indico quale e' il programma assembly da eseguire
      strcpy (appfile,"spento.dsk") ;
      // Inizializzo la scheda e carico il programma
      initScheda () ;
      // Faccio partire il programma appena caricato
      FreeRun(indirizzoPartenza);
      printf("\nIl DSP  stato fermato.\n\n");

      break;

      // Questo e' il pezzo di codice per generare tensione zero
      case 1:
      // Indico quale e' il programma assembly da eseguire
      strcpy (appfile,"zero.dsk") ;
      // Inizializzo la scheda e carico il programma
      initScheda () ;

      // Invio alla scheda il valore da mandare in uscita
	sendcommand(LD,zeroVoltDsp,1);
	sendword(zeroVolt);

      // Faccio partire il programma appena caricato
      FreeRun(indirizzoPartenza);
      printf("\nIl DSP  stato avviato e genera tensione nulla\n\n");

      break;

      // Questo e' il pezzo di codice per generare tensione costante
      case 2:
      // Indico quale e' il programma assembly da eseguire
      strcpy (appfile,"vdc.dsk") ;
      // Inizializzo la scheda e carico il programma
      initScheda () ;

      // Qua invio il valore di tensione da generare
	printf ("\nQuanti volt costanti (da -3.20 a 3.20) ?\n") ;
	scanf ("%lf",&vdc) ;

	// Scrivo nella memoria della scheda il valore dei volts
	// da generare
	sendcommand(LD,vdcDsp,1);
	sendword(toNumDac(vdc));

      // Faccio partire il programma appena caricato
      FreeRun(indirizzoPartenza);
      printf("\nIl DSP  stato avviato e genera tensione costante\n\n");

      break;


      // Questo e' il pezzo di codice per generare la
      // forma d'onda arbitraria
      case 3:
      // Indico quale e' il programma assembly da eseguire
      strcpy (appfile,"arb.dsk") ;

	printf ("\nQuanti campioni (da 8 a 7400)?\n") ;
	scanf ("%d",&numCamp) ;

	freqSegnale = Fc / numCamp ;
	// Inizializzo la scheda e carico il programma
	initScheda () ;

      // Calcolo la fine del buffer circolare del DSP
	fineMem = inizioMem + numCamp -1 ;

	// E lo invio alla scheda.
	sendcommand(LD,CBER1,1);
	sendword (fineMem) ;

	printf ("\nAttendere il caricamento dei campioni nella memoria del DSP.\n") ;

       // Riempio la memoria del DSP coi campioni voluti.
       // Per ora carico i campioni di un dente di sega.
	sendcommand(LD,inizioMem,numCamp);
	for (int i=0; i<numCamp; i++)
	{
	   sendword(toNumDac(i*Vmax/numCamp ));
	}// end for
	printf ("\nCaricamento terminato.\n") ;
	printf ("\nLa frequenza del segnale vale : %.0f Hertz\n",freqSegnale) ;

      // Faccio partire il programma appena caricato
      FreeRun(indirizzoPartenza);
      printf("\nIl DSP  stato avviato e genera la forma d'onda voluta \n\n");
      break;

      // Questo e' il pezzo di codice per eseguire l'auto-test della scheda
      case 4:
	testScheda () ;
      break;

      // Questo e' il pezzo di codice per fermare il DSP
      case 5:
      // Indico quale e' il programma assembly da eseguire
      strcpy (appfile,"spento.dsk") ;
      // Inizializzo la scheda e carico il programma
      initScheda () ;
      // Faccio partire il programma appena caricato
      FreeRun(indirizzoPartenza);

      printf("\nIl DSP  stato fermato.\n\n");
      break;

    } // end switch

  }// end while

}// end main

// Funzione da chiamare tutte le volte che si deve caricare un nuovo
// programma nel DSP.
void initScheda ()
{
      // Inizializza il contatore di programma del DSP al primo
      // indirizzo disponibile della memoria di programma
      prm.PGM_CNT = 0x980;

      // Inizializza il sopftware per la comunicazione tra PC e scheda
      InitializeMonitor();

      // Carica sulla scheda il programma voluto
      LoadDsk();

      // Inizializza tutti i registri interni del DSP
      InitRegister(YES);
}// end initScheda
