/* --------------------------------------------------------------------- */
/*  File 'HI5_LIB.H' Include file for the 'C5x DSK HI5 Library  Ver 1.00 */
/* --------------------------------------------------------------------- */
typedef unsigned int   UINT;
typedef unsigned char  UCHAR;
typedef          char* STRING;
typedef unsigned long  ULONG;

# include <alloc.h>
# include <conio.h>
# include <ctype.h>
//# include <dos.h>
# include <fcntl.h>
//# include <graphics.h>
# include <io.h>
# include <math.h>
# include <setjmp.h>
# include <stdio.h>
# include <stdarg.h>
# include <stdlib.h>
# include <string.h>
# include <time.h>

# define KB_ESC  0x01b

/*---UART definitions: register etc.   -------------------------------  */

# define THR      0    /* Transmitter holding register                  */
# define DHR      0    /* Receiver data       register                  */
# define BRDL     0    /* Baud rate devisor, low byte                   */
# define BRDH     1    /* Baud rate devisor, high byte                  */
# define LCR      3    /* Line control register                         */
# define MSR      4    /* Modem status register                         */
# define LSR      5    /* Line status register                          */
# define DATA_READY    1  /*  defined in the LCR register               */
# define XMT_BUF_EMPTY 0x20

const int MAXLEN = 0x100,
	  MAXLINE = 100;

			  /* Addresses of 'C50 registers                */
const int ACCU =0x60,     /* Address of the Accumulator                 */
	  ACCB =0x62,     /* Address of Accumulator B                   */
	  PREG =0x64,     /* Address of Product Register                */
	  ST0 =0x66,      /* Address of ST0                             */
	  ST1 =0x67,      /* Address of ST1                             */
	  TREG =0x68,     /* Address of the T register                  */
	  STACK =0x69,    /* Address of the hardware stack              */
	  ARX =0x71,      /* Address of the Auxillary ergisters         */
	  TIMER =0x74;    /* address of Timer register                  */


/* -------------enumarations -----------------------------------------  */

enum BOOLE {NO, YES};

enum c50COMMANDS { /* commands for comm between PC and monitor kernel   */
		 DD=0,DP,LD,LP,/* these 4 are also defined in c50       */
		 XCH_PGM,XG};  /* these 2 are also defined in c50       */
			       /* XCH_PGM is supported on debugger only */


		 /* These are used for status reporting                 */
enum INITMONITOR {GOOD,TESTERROR,NOESCAPE,NORESPONSE};


/* -------------structures -----------------------------------------  */
struct STRUCT_IMR {
		UINT add, user, debug;
		BOOLE modified;
};

struct PARAMETER {
	   UINT  CONFMODE;       /* Set the CNF bit in the 'C50         */
	   UINT  INIT_ST0;       /* Value to init ST0                   */
	   UINT  INIT_ST1;       /* Value to init ST1                   */
	   UINT  INIT_PMST;      /* Value to init PMST                  */
	   UINT  PGM_CNT;        /* Value to init the program counter   */

	   /*       the next 3 parameter define the comport             */
	   BOOLE INVERSE;     /* Inversion of the DTR line No/Yes       */
	   UINT  com;         /* Communication Port number (1 or 2)     */
	   ULONG speed;       /* Baudrate up to 115K baud               */
};

/* -------------------------------------------------------------------- */

extern struct STRUCT_IMR imr;
extern struct PARAMETER  prm;
/* -------------------------------------------------------------------- */
void        BaudRateDetect(void);
UINT	      getwordcom(void);
void	      GetArguments(void);
UINT        GetDskAdd(STRING pbuf);
UINT        GetDskData(STRING pbuf,UINT data[]);
BOOLE	       FreeRun(UINT address);
void        InitPort(void);
void        InitializeMonitor(void);
INITMONITOR InitMonitor(void);
void        InitRegister(BOOLE all);
double      LoadDsk(void);
void        reset50(void);
/* The following are extra functions added to hi5_lib */
void        comout(UINT send); /* sends byte without checking for return */
UINT        newchar(void); /* checks to see if a new character has arrived */
UCHAR       comin(void); /* gets a pending input character */
/* ===================================================*/
void        sendbyte(UINT);
UINT        sendword(UINT);
void        WaitFor(UINT);
UCHAR	      rcvdata(int);
void        MSGR(char msg_string[50]);


/* ------------------------------------------------------------------- */
inline void sendcommand(const c50COMMANDS cmd,UINT startaddress,UINT length)
{
 sendbyte(cmd); sendword(startaddress); sendword(length-1);
}
/* ------------------------------------------------------------------- */
inline void SendDataWord(UINT address,UINT word)
{
 sendcommand(LD,address,1);
 sendword(word);
}
/* ------------------------------------------------------------------- */
inline UINT GetPgmWord(UINT address)
{
 sendcommand((c50COMMANDS) DP, address, 1);
 return getwordcom();
}
/* ------------------------------------------------------------------- */

