

// Le costanti :
// Tensione massima in uscita del DAC
const double Vmax = 3.20 ;

// Tensione minima in uscita del DAC
const double Vmin = -3.20 ;

// Frequenza di campionamento (in Hz) ;
const double Fc = 17921 ;

// Numero minimo e massimo dei campioni usabili :
const int numCampMin = 8 ;
const int numCampMax = 7400 ;

// Indirizzo di inizio del buffer circolare
const int inizioMem = 0xf10 ;

// registro di fine del buffer circolare
const int CBER1 = 0x001b ;


// Prototipi delle funzioni

// Questa funzione prende un valore frazionario, compreso tra le tensioni
// minima e massima del DAC del DSP, e restituisce il corretto intero che lo
// rappresenta nel DSP. Se il valore esce dal campo ammesso, il risultato
// e' "cimato".
int toNumDac (double valore) ;


// Esegue l'autotest della scheda.
void testScheda () ;
