

#ifndef InterfacciaH
#define InterfacciaH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>


/*******************************************************************************
  Classe Interfaccia 488:
  Contiene i metodi relativi alle operazioni di base realizzabili sulla scheda
  IEEE-488. Tali medodi sono:
    * GpibError(...)  - Gestisce gli eventuali errori rilevati
    * Init(...)       - Inizializza un dispositivo collegato all'interfaccia
    * ReadStatus(...) - Legge lo stato del dispositivo
    * EseguiCMD(...)  - Esegue l'opportuno comando passato come parametro
    * EseguiRead(...) - Legge l'output del dispositivo selezionato
*******************************************************************************/
class Interfaccia488
{
  private:
  public:
    void __fastcall GpibError(char *msg,int Device, int BoardIndex);
    int  __fastcall Init(int PrimaryAddr, int SecondaryAddr, int BoardIndex);
    void __fastcall ReadStatus(char *Buffer, int Device, int BoardIndex);
    void __fastcall EseguiCMD(int Device, char S[]);
    void __fastcall EseguiRead(int Device, char Buffer[]);

};

/*******************************************************************************
  Classe TOscilloscopio:
  Contiene i metodi relativi alle operazioni di base realizzabili su un generico
  oscilloscopio collegato al PC mediante interfaccia IEEE-488. Tali medodi sono:
    * Identificativo()-
    * Indirizzi()     -
    * Reset()         - Porta il dispositivo nelle condizioni di default
    * AutoSet()       - Effettua l'autorange delle scale verticali e orizzontali
    * Lock()          - Blocca il pannello frontale del dispositivo
    * UnLock()        - Sblocca il pannello frontale del dispositivo
    * CH(...)         - On/Off della visualizzazione del segnale sul canale 1/2
    * ScalaV(...)     - Cambia la scala verticale del canale prescelto
    * PosizV(...)     - Sposta verticalmente il segnale visualizzato
    * CHscalaH(...)   - Cambia la scala orizzontale
    * Run()           - Blocca la visualizzazione sul dispositivo
    * Stop()          - Sblocca la visualizzazione sul dispositivo
    * AttenuazSonda() - Imposta il tipo di attenuazione della sonda
    * Acquisisci()    - Effettua l'acquisizione dal dispositivo di 2500 campioni
    * Contrasto(...)  - Imposta il contrasto sul display dell'Oscilloscopio
*******************************************************************************/

class TOscilloscopio
{
  private:
    struct Info {
      int PrimaryAddr;
      int SecondaryAddr;
      int BoardIndex;
    };
  public:
     char* __fastcall Identificativo();
     Info __fastcall Indirizzi();
     void __fastcall Reset();
     void __fastcall AutoSet();
     void __fastcall Lock();
     void __fastcall UnLock();
     void __fastcall CH(int ch, bool stato);
     void __fastcall ScalaV(int CH,int pos);
     void __fastcall PosizV(int CH,int pos);
     void __fastcall CHscalaH(int pos);
     void __fastcall AttenuazSonda(int tipo);
     void __fastcall Run();
     void __fastcall Stop();
     void __fastcall Contrasto(int val);
     void __fastcall Acquisisci();
};

/*******************************************************************************
  Classe TGeneratore:
  Contiene i metodi relativi alle operazioni di base realizzabili su un generico
  generatore di segnale collegato al PC mediante IEEE-488. Tali medodi sono:
    * Identificativo()-
    * Indirizzi()     -
    * Reset()         - Porta il dispositivo nelle condizioni di default
    * Shape(...)      - Consente la scelta della forma d'onda da generare
    * ApplicaParametri() - Applica i parametri di: Frequenza, Ampiezza ed Offset
    Metodi che realizzano modulazioni ed effetti sui segnali generati:
    * FreqSweep()     -  Sweep di frequenza
    * BurstMod()      -  Modulazione Burst
    * FSK()           -  Modulazione FSK
    * AmplMod()       -  Modulazione di ampiezza
    * FreqMod()       -  Modulazione di frequenza
    * StopModulazione() - Interrompe una eventuale modulazione precedente
*******************************************************************************/
class TGeneratore
{
  private:
    struct Info {
      int PrimaryAddr;
      int SecondaryAddr;
      int BoardIndex;
    };
  public:
     char* __fastcall Identificativo();
     Info __fastcall Indirizzi();
     void __fastcall Reset();
     void __fastcall Shape(char Tipo[]);
     void __fastcall ApplicaParametri();
     void __fastcall StopModulazione(int tipo);
     void __fastcall FreqSweep();
     void __fastcall BurstMod();
     void __fastcall FSK();
     void __fastcall AmplMod();
     void __fastcall FreqMod();
};

/*******************************************************************************
  Classe TForm:
  Realizza i componenti IDE relativi al pannello principale
*******************************************************************************/
class TForm1 : public TForm
{
__published:	// IDE-managed Components
        TButton *BottoneRileva;
        TEdit *Edit1;
        TEdit *Edit2;
        TEdit *Edit3;
        TEdit *Edit4;
        TSpeedButton *SpeedButton1;
        TSpeedButton *SpeedButton2;
        TLabel *Label1;
        TLabel *Label2;
        TButton *BottoneClear;
        TLabel *Label3;
        TButton *BottoneSalva;
        TEdit *Edit5;
        TEdit *Edit6;
        TEdit *Edit7;
        TEdit *Edit8;
        TEdit *Edit9;
        TEdit *Edit10;
        TLabel *Label4;
        TLabel *Label5;
        TLabel *Label6;
        TButton *Acquisizione;
        TRichEdit *REdit;
        TButton *About;

        void __fastcall BottoneRilevaClick(TObject *Sender);
        void __fastcall SpeedButton1Click(TObject *Sender);
        void __fastcall SpeedButton2Click(TObject *Sender);
        void __fastcall BottoneClearClick(TObject *Sender);
        void __fastcall AcquisizioneClick(TObject *Sender);
        void __fastcall AboutClick(TObject *Sender);

private:	// User declarations
public:		// User declarations

        __fastcall TForm1(TComponent* Owner);
};

//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
