/*******************************************************************************
 TESINA n5 per esame di: ELABORAZIONI dei SEGNALI ed INFORMAZIONI di MISURA:

 NOMEFILE: Unit2.cpp (Generatore di segnale)

 NOTE: Nel file  riportata l'istanza dell'oggetto Generatore e gli eventi
       relativi ai Click sui bottoni del pannello.
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "Unit2.h"              // Header del file e di quello contenente
#include "interfaccia.h"        // i prototipi delle classi necessarie.

#pragma package(smart_init)
#pragma resource "*.dfm"

TForm2 *Form2;                  // Istanza dell'oggetto Pannello Generatore
TGeneratore *Generatore;        // Istanza dell'oggetto Generatore

int PrecMod = 0;                // Variabile usata per memorizzare il tipo di
                                // modulazione precedente.

//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner) : TForm(Owner) { }
//---------------------------------------------------------------------------

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata del form relativo alla
  Frequency Sweep. Sul form verranno richiesti i parametri necessari.
*******************************************************************************/
void __fastcall TForm2::Button5Click(TObject *Sender)
{
   Generatore->FreqSweep();
}

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata del form relativo alla
  modulazione a Burst. Sul form verranno richiesti i parametri necessari.
*******************************************************************************/
void __fastcall TForm2::Button6Click(TObject *Sender)
{
  Generatore->BurstMod();
}

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata del form relativo alla
  modulazione FSK. Sul form verranno richiesti i parametri necessari.
*******************************************************************************/
void __fastcall TForm2::Button7Click(TObject *Sender)
{
  Generatore->FSK();
}

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata del form relativo alla
  modulazione di Ampiezza. Sul form verranno richiesti i parametri necessari.
*******************************************************************************/
void __fastcall TForm2::Button8Click(TObject *Sender)
{
  Generatore->AmplMod();
}

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata del form relativo alla
  modulazione di Frequenza. Sul form verranno richiesti i parametri necessari.
*******************************************************************************/
void __fastcall TForm2::Button9Click(TObject *Sender)
{
  Generatore->FreqMod();
}

/*******************************************************************************
  All'evento Click del tasto vengono imposti alla forma d'onda, prodotta dal
  generatore di segnale, i parametri relativi alla Frequenza, Tensione picco
  picco e Tensione di Offset. I controlli su tali parametri verranno effettuati
  all'interno della funzione stessa.
*******************************************************************************/
void __fastcall TForm2::Button10Click(TObject *Sender)
{
   Generatore->ApplicaParametri();
}

/*******************************************************************************
 All'evento Click del tasto  associata la chiamata della funzione relativa al
 RESET dello strumento, che porter lo stesso a generare un'onda sinusoidale
 con frequenza pari a 1KHz, Tensione di picco pari ad 1V ed Offset nullo.
*******************************************************************************/
void __fastcall TForm2::Button11Click(TObject *Sender)
{
   Generatore->Reset();
}

/*******************************************************************************
 All'evento Click su una delle possibili scelte del RadioGroupBox viene chiamata
 la funzione Shape(...) con il tipo di segnale da generare. I tipi di segnale
 possibili per questa implementazione sono:
 - SIN    - onda sinusoidale
 - SQUARE - onda quadra
 - TRI    - onda triangolare
 - RAMP   - onda a dente di sega
*******************************************************************************/
void __fastcall TForm2::SceltaOndaClick(TObject *Sender)
{
  switch (SceltaOnda->ItemIndex)
  {
    case 0: Generatore->Shape("SIN");    break;
    case 1: Generatore->Shape("SQUARE"); break;
    case 2: Generatore->Shape("TRI");    break;
    case 3: Generatore->Shape("RAMP");   break;
  }
}

/*******************************************************************************
 All'evento Click sul RadioGroupBox SceltaMod viene lanciata la modulazione
 scelta ed eventualmente ci fossero delle modulazioni in esecuzioni atto esse
 vengono interrotte.
*******************************************************************************/
void __fastcall TForm2::SceltaModClick(TObject *Sender)
{
  Generatore->StopModulazione(PrecMod);
  PrecMod = SceltaMod->ItemIndex;
  switch (SceltaMod->ItemIndex)
  {
    case 0: Generatore->Reset()     ;break;
    case 1: Generatore->AmplMod()   ;break;
    case 2: Generatore->FreqMod()   ;break;
    case 3: Generatore->FSK()       ;break;
    case 4: Generatore->BurstMod()  ;break;
    case 5: Generatore->FreqSweep() ;break;
  }
}

