function []=compare(fc, N)
%
% compare(fc,N)
%
% fc  la freq di campionamento
% N  il numero di punti
%
% Questa funzione campiona un SEGNALE PREDEFINITO (vd function segnale()) alla frequenza di campionamento prescelta
% e ne effettua la FFT su N punti; la FFT viene calcolata utilizzando:
% 1) la fft() di MATLAB
% 2) la nostra FFT_radix4_dt()
% 3) la nostra FFT_radix4_df()
%
% i risultati (previo calcolo del modulo) vengono plottati per confronto visivo
%
% ATTENZIONE: scegliere un numero di punti N=2^p, dove p sia pari, per rendere possibile il calcolo della FFT radix4!!!!


s = campionaSegnale(fc,N);

% calcolo delle 3 fft
x2 = FFT_radix2(s);
x4dt = FFT_radix4_dt(s);
x4df = FFT_radix4_df(s);

% visualizzazione dei risultati
figure
subplot(3,1,1);
plotSpec(s,fc,x2);
title('Grafico dello Spettro del segnale S ricavato dalla FFT di MATLAB');

subplot(3,1,2);
plotSpec(s,fc,x4dt);
title('Grafico dello Spettro del segnale S ricavato dalla FFT radix4 dt');

subplot(3,1,3);
plotSpec(s,fc,x4df);
title('Grafico dello Spettro del segnale S ricavato dalla FFT radix4 df');
