function res = FFT_radix4_df(x)
% res = FFT_radix4_df(x)    
% Dove x  il vettore dei campioni (DEVE ESSERE DI DIMENSIONE N=4^P)

% calcolo della potenza P
[row, column] = size(x);
p=0;
while column > (4^p)
    p = p+1;
end;

% inizilizzazione vettore X e twiddle factor W
for k = 1 : (4^p)
   X(k,1) = x(k);
   X(k,2) = 0;
   
   W(k,1) =  cos(2*pi*(k-1)/(4^p));
   W(k,2) = -sin(2*pi*(k-1)/(4^p));
end;

% calcolo della fft
for s = 0 : (p-1)    
    for i = 0 : ((4^(p-(p-1-s)-1))-1)
        for j = 0 : ((4^(p-1-s))-1)
             % calcolo degli indici su X interessati dalla 2B corrente
            x0 = j + (4^(p-1-s))*0 + (4^((p-1-s)+1))*i + 1;
            x1 = j + (4^(p-1-s))*1 + (4^((p-1-s)+1))*i + 1;
            x2 = j + (4^(p-1-s))*2 + (4^((p-1-s)+1))*i + 1;
            x3 = j + (4^(p-1-s))*3 + (4^((p-1-s)+1))*i + 1;
            
            % calcolo degli indici su W interessati dalla 2B corrente
            w0 = 0*j*(4^(p-(p-1-s)-1)) + 1;
            w1 = 1*j*(4^(p-(p-1-s)-1)) + 1;
            w2 = 2*j*(4^(p-(p-1-s)-1)) + 1;
            w3 = 3*j*(4^(p-(p-1-s)-1)) + 1;
            
            % caolcolo della 2B                        
            Xt(1,1) = X(x0,1) + X(x1,1) + X(x2,1) + X(x3,1);
            Xt(1,2) = X(x0,2) + X(x1,2) + X(x2,2) + X(x3,2);

            Xt(2,1) = X(x0,1) + X(x1,2) - X(x2,1) - X(x3,2);
            Xt(2,2) = X(x0,2) - X(x1,1) - X(x2,2) + X(x3,1);

            Xt(3,1) = X(x0,1) - X(x1,1) + X(x2,1) - X(x3,1);
            Xt(3,2) = X(x0,2) - X(x1,2) + X(x2,2) - X(x3,2);

            Xt(4,1) = X(x0,1) - X(x1,2) - X(x2,1) + X(x3,2);
            Xt(4,2) = X(x0,2) + X(x1,1) - X(x2,2) - X(x3,1);

            X(x0,1) = Xt(1,1);
            X(x0,2) = Xt(1,2);

            X(x1,1) = Xt(2,1);
            X(x1,2) = Xt(2,2);

            X(x2,1) = Xt(3,1);
            X(x2,2) = Xt(3,2);

            X(x3,1) = Xt(4,1);
            X(x3,2) = Xt(4,2);            
                                  
            % moltiplicazione per i twiddle factor
            Xt(1,1) = X(x0,1)*W(w0,1) - X(x0,2)*W(w0,2);  
            Xt(1,2) = X(x0,1)*W(w0,2) + X(x0,2)*W(w0,1);  
 
            Xt(2,1) = X(x1,1)*W(w1,1) - X(x1,2)*W(w1,2);  
            Xt(2,2) = X(x1,1)*W(w1,2) + X(x1,2)*W(w1,1);  
 
            Xt(3,1) = X(x2,1)*W(w2,1) - X(x2,2)*W(w2,2);  
            Xt(3,2) = X(x2,1)*W(w2,2) + X(x2,2)*W(w2,1);  
 
            Xt(4,1) = X(x3,1)*W(w3,1) - X(x3,2)*W(w3,2);  
            Xt(4,2) = X(x3,1)*W(w3,2) + X(x3,2)*W(w3,1);  
            
            X(x0,1) = Xt(1,1);
            X(x0,2) = Xt(1,2);

            X(x1,1) = Xt(2,1);
            X(x1,2) = Xt(2,2);

            X(x2,1) = Xt(3,1);
            X(x2,2) = Xt(3,2);

            X(x3,1) = Xt(4,1);
            X(x3,2) = Xt(4,2);        
        end;
    end;
end;

% calcolo dei moduli 
for k = 1 : (4^p)
   X(k,1) = ((X(k,1)^2) + (X(k,2)^2))^.5; 
end;

% riordino dei risultati
for k = 0 : ((4^p)-1)
   res(k+1) = X(reorder(k,p)+1,1);      
end;
