/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl_dip.h
* DATE CREATED.. Thu 06/15/2001 
* LAST MODIFIED. Thu 06/15/2001 
*
\******************************************************************************/
#ifndef _BSL_DIP_H_
#define _BSL_DIP_H_

#include <csl_emif.h>
#include "bsl_board.h"

#if (DIP_SUPPORT)
/****************************************\
* DIP scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _DIP_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* DIP global macro declarations
\****************************************/

#if (BOARD_6711DSK | BOARD_6211DSK)
  /* DIP mask */
  #define	DIP_1		1
  #define	DIP_2		2
  #define	DIP_3		4
#endif

#if (BOARD_6201EVM)
  /* DIP mask */
  #define	DIP_0		1
  #define	DIP_1		2
  #define	DIP_2		4
#endif


/****************************************\
* DIP global typedef declarations
\****************************************/

/****************************************\
* DIP global variable declarations
\****************************************/

/****************************************\
* DIP global function declarations
\****************************************/

BSLAPI void _DIP_init();
BSLAPI Uint32 DIP_get(Uint32 dipNum);

/****************************************\
* DIP inline function declarations
\****************************************/

/****************************************\
* DIP inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* DIP_SUPPORT */
#endif /* _BSL_DIP_H_ */
/******************************************************************************\
* End of bsl_dip.h
\******************************************************************************/

