/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl_ad535.h
* DATE CREATED.. Thu 06/15/2000 
* LAST MODIFIED. Thu 06/15/2000 
*
\******************************************************************************/
#ifndef _BSL_AD535_H_
#define _BSL_AD535_H_

#include <csl_mcbsp.h>
#include "bsl_board.h"

#if (AD535_SUPPORT)
/****************************************\
* AD535 scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _AD535_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* AD535 global macro declarations
\****************************************/

#define AD535_GAIN_MUTE                 34.5
#define AD535_GAIN_0DB                  0.0

/* AD535_Id structure macros - pointer referencing*/
#define _AD535_ALLOCATED(x)            ((x)->Obj.allocated)
#define _AD535_HMCBSP(x)               ((x)->Obj.hMcbsp)
#define _AD535_MCBSP_NO(x)             ((x)->Id.mcbsp_no)

#define _AD535_ASSERT_HANDLE(hAD535)   if (hAD535 == INV) return 

/****************************************\
* AD535 global typedef declarations
\****************************************/

typedef struct {
  struct {
    int mcbsp_no;
  } Id;
  struct {
    Uint32 allocated;
    MCBSP_Handle hMcbsp;
  } Obj;
} AD535_Id, *AD535_Handle; 


typedef enum {
  AD535_LOOPBACK_DISABLE = 0x00,
  AD535_LOOPBACK_ANALOG = 0x10,
  AD535_LOOPBACK_DIGITAL = 0x20
} AD535_Loopback;

typedef enum {
  AD535_MICGAIN_OFF = 0x00,
  AD535_MICGAIN_ON = 0x40
} AD535_MicGain;

typedef struct {
  AD535_Loopback lb_mode;
  AD535_MicGain  mic_gain;
  float          in_gain;
  float          out_gain;
} AD535_Config;

typedef enum {
  AD535_REG_CTRL0 = 0x00,
  AD535_REG_CTRL1 = 0x01,
  AD535_REG_CTRL2 = 0x02,
  AD535_REG_CTRL3 = 0x03,
  AD535_REG_CTRL4 = 0x04,
  AD535_REG_CTRL5 = 0x05
} AD535_Reg; 

/****************************************\
* AD535 global variable declarations
\****************************************/
extern far AD535_Id *AD535_localId;
/****************************************\
* AD535 global function declarations
\****************************************/

  BSLAPI void _AD535_init();
  BSLAPI void AD535_close(AD535_Handle hAD535);
  BSLAPI void AD535_config(AD535_Handle hAD535, AD535_Config *config);
  BSLAPI void AD535_inGain(AD535_Handle hAD535, float inGain);
  BSLAPI void AD535_micGain(AD535_Handle hAD535, AD535_MicGain micGain);
  BSLAPI void AD535_modifyReg(AD535_Handle hAD535, AD535_Reg ad535Register, Uint32 val, Uint32 mask);
  BSLAPI AD535_Handle AD535_open(AD535_Id *myId);
  BSLAPI void AD535_outGain(AD535_Handle hAD535, float outGain);
  BSLAPI void AD535_powerDown(AD535_Handle hAD535);
  BSLAPI Uint32 AD535_readReg(AD535_Handle hAD535, AD535_Reg ad535Register);
  BSLAPI void AD535_reset(AD535_Handle hAD535);
  BSLAPI void AD535_writeReg(AD535_Handle hAD535,AD535_Reg ad535Register, Uint32 Val);

/****************************************\
* AD535 inline function declarations
\****************************************/

IDECL int AD535_read(AD535_Handle hAD535);
IDECL void AD535_write(AD535_Handle hAD535, int val);
IDECL MCBSP_Handle AD535_getMcbspHandle(AD535_Handle hAD535);

/****************************************\
* AD535 inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/

IDEF int AD535_read(AD535_Handle hAD535){
  while(!MCBSP_rrdy(_AD535_HMCBSP(hAD535))); 
  return((int) MCBSP_read(_AD535_HMCBSP(hAD535)) );
}
/*----------------------------------------------------------------------------*/

IDEF void AD535_write(AD535_Handle hAD535, int val){
  MCBSP_write(_AD535_HMCBSP(hAD535),(val&0xfffe));
  while(!MCBSP_xrdy(_AD535_HMCBSP(hAD535))); 
  MCBSP_write(_AD535_HMCBSP(hAD535),0);
  
}
/*----------------------------------------------------------------------------*/

IDEF MCBSP_Handle AD535_getMcbspHandle(AD535_Handle hAD535){
  return((hAD535->Obj.hMcbsp));
}
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* AD535_SUPPORT */
#endif /* _BSL_AD535_H_ */
/******************************************************************************\
* End of bsl_ad535.h
\******************************************************************************/

