*****************************************************************
* Application: 	DTMF codec
* File:		scaleq15.asm
* Description:	Scaling a frame of data for normalization
*		
* History:
* Date		Who		Comment
* 07-30-97	Gunter Schmer	creation
*
*****************************************************************

*************************************************************************
* Function: 	short scale_q15(short data[],	--> A4 arg1
*				short scalar  	--> B4 arg2
*				int N        )	--> A6 arg3
*					    	    B3 retaddr
*
* Description:	This function scales a frame of data with a
*		scalar. Data values and scalar are in Q15 format.
*		The resulting data frame is also in Q15 format.
*		Frame length N needs to be even and N > 8.
*
* Pseudo C-code:
*
*	short scale_q15(short 	data[],
*			short 	scalar 
*			int	N      )
*	{
*		int n;
*
*		for(n=0;n<N;n++)
*			data[n] = ((int)scalar * (int)data[n]) >> 15;
*	}
*
* Regs used:	A2,A3,A4,A5,A6,A7,A8,A9
*		B0,B3,B4
*
* Regs modified:A1,A2,A3,A4,A5,A6,A7,A8
*		B0,B4,B5,B6
*
* Execution:	N+16 cycles
*
*************************************************************************
		.global	_scale_q15
		.text
_scale_q15:

;
;------ Register Allocation for scale loop ------------------------
;	A0 : 		A4 : data[]	A8 : x01	
;	A1 : 		A5 : x0		A9 : y01
;	A2 : scalar	A6 : y0		A10: 
;	A3 : odata[]	A7 : yh1	A11: 
;
;	B0 : count	B4 : scalar	B8 : 
;	B1 : 		B5 : x1		B9 : 
;	B2 : 		B6 : y1		B10:
;	B3 : ret addr	B7 : 		B11:
;
;	B14: DP
;	B15: SP
;

	LDW	.D1	*A4++,A8	;load x01
||	MV	.L1	A4,A3		;odata=data

	SUB	.L2x	A6,6,B0		;count=N-6

	LDW	.D1	*A4++,A8	;load x01

	MV	.L1x	B4,A2		;copy scalar to A-file

	LDW	.D1	*A4++,A8	;load x01

	MPY	.M1	A8,A2,A5	;x0=scalar*x01[15:0]
||	MPYHL	.M2x	A8,B4,B5	;x1=scalar*x01[31:16]

	LDW	.D1	*A4++,A8	;load x01
|| [B0]	B	.S2	LOOP		;branch to loop

	MPY	.M1	A8,A2,A5	;x0=scalar*x01[15:0]
||	MPYHL	.M2x	A8,B4,B5	;x1=scalar*x01[31:16]
||	EXTU	.S1	A5,1,16,A6	;y0=Q15(x0)
||	EXTU	.S2	B5,1,16,B6	;y1=Q15(x1)

	SHL	.S1x	B6,16,A7	;yh1=y1<<16
||	LDW	.D1	*A4++,A8	;load x01
|| [B0]	B	.S2	LOOP		;branch to loop

	MPY	.M1	A8,A2,A5	;x0=scalar*x01[15:0]
||	MPYHL	.M2x	A8,B4,B5	;x1=scalar*x01[31:16]
||	EXTU	.S1	A5,1,16,A6	;y0=Q15(x0)
||	EXTU	.S2	B5,1,16,B6	;y1=Q15(x1)
||	OR	.L1	A6,A7,A9	;y01=yh1^y0

LOOP:
	SHL	.S1x	B6,16,A7	;yh1=y1<<16
||	LDW	.D1	*A4++,A8	;load x01
|| [B0]	B	.S2	LOOP		;branch to loop

	MPY	.M1	A8,A2,A5	;x0=scalar*x01[15:0]
||	MPYHL	.M2x	A8,B4,B5	;x1=scalar*x01[31:16]
||	EXTU	.S1	A5,1,16,A6	;y0=Q15(x0)
||	EXTU	.S2	B5,1,16,B6	;y1=Q15(x1)
||	OR	.L1	A6,A7,A9	;y01=yh1^y0
||	STW	.D1	A9,*A3++	;store y01
|| [B0]	SUB	.L2	B0,2,B0		;decrement loop count

	B	.S2	B3		;return
	NOP		5
