/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... bsl_led.h
* DATE CREATED.. Thu 06/15/2001 
* LAST MODIFIED. Thu 06/15/2001 
*
\******************************************************************************/
#ifndef _BSL_LED_H_
#define _BSL_LED_H_

#include <csl_emif.h>
#include "bsl_board.h"

#if (LED_SUPPORT)
/****************************************\
* LED scope and inline control macros
\****************************************/
#ifdef __cplusplus
#define BSLAPI extern "C" far 
#else
#define BSLAPI extern far 
#endif

#undef  USEDEFS
#undef  IDECL
#undef  IDEF

#ifdef  _LED_MOD_
  #define IDECL BSLAPI
  #define USEDEFS
  #define IDEF
#else
  #ifdef  _INLINE
    #define IDECL static inline
    #define USEDEFS
    #define IDEF  static inline
  #else
    #define IDECL BSLAPI
  #endif
#endif

/****************************************\
* LED global macro declarations
\****************************************/

#if (BOARD_6711DSK | BOARD_6211DSK)
  /* LED mask */
  #define LED_1         1
  #define LED_2         2
  #define LED_3         4
  #define LED_ALL       7
#endif

#if (BOARD_6201EVM)
  /* LED mask */
  #define LED_0         1
  #define LED_1         2
  #define LED_ALL       3
#endif

/****************************************\
* LED global typedef declarations
\****************************************/

/****************************************\
* LED global variable declarations
\****************************************/

/****************************************\
* LED global function declarations
\****************************************/

BSLAPI void _LED_init();
BSLAPI void LED_off(Uint32 ledNum);
BSLAPI void LED_on(Uint32 ledNum);
BSLAPI void LED_toggle(Uint32 ledNum);

/****************************************\
* LED inline function declarations
\****************************************/

/****************************************\
* LED inline function definitions
\****************************************/
#ifdef USEDEFS
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#endif /* USEDEFS */

#endif /* LED_SUPPORT */
#endif /* _BSL_LED_H_ */
/******************************************************************************\
* End of bsl_led.h
\******************************************************************************/

