*****************************************************************
* Application: 	DTMF codec
* File:		dtmf_rel.asm
* Description:	Check relative peaks
*		
* History:
* Date		Who		Comment
* 05-05-98	Gunter Schmer	creation
*
*****************************************************************

*************************************************************************
* Function: 	unsigned char dtmfCheckRelPeak( short rowMaxIndex,    --> A4
*						short colMaxIndex,    --> B4
*						unsigned char flags ) --> A6
*
*					    	    B3 retaddr
*
* Description:	This function checks neighboring peaks in row and col
*		frequency band
*
*
* Regs used:	A0,A1,A2,A3,A4,A5,A6,A7,
*		B0,B1,B2,B3,B4,B5,B6,B7,B8
*
* Regs modified:A0,A1,A2,A3,A4,A5,A6,A7
*		B0,B1,B2,B4,B5,B6,B7,B8
*
* Execution:	17 cycles
*
*************************************************************************
		.global	_dtmfCheckRelPeak
		.global	_energy
		.global	_thresRelativePeak
		.text
_dtmfCheckRelPeak:

;
;------ Register Allocation  ------------------------
;	A0 : 		A4 : rowMaxIndex	A8 : tmp flags 
;	A1 : 		A5 : rowRelMax 		A9 : 
;	A2 : 		A6 : rowMax		A10: 
;	A3 : 		A7 : rowVal		A11: 
;
;	B0 : 		B4 : colMaxIndex 	B8 : 
;	B1 : 		B5 : colRelMax		B9 :
;	B2 : 		B6 : colMax		B10:
;	B3 : ret addr	B7 : colVal		B11:
;
;	B14: DP
;	B15: SP
;

	MVKL	.S1	_energy,A2		;
||	MVKL	.S2	_energy+8,B2		;

	MVKH	.S1	_energy,A2		;A2 = &energy[0]
||	MVKH	.S2	_energy+8,B2		;B2 = &energy[4]
||	SUB	.L2	B4,4,B4			;		

	MVK	.S1	0,A5			;
||	MVK	.S2	0,B5			;
||	LDH	.D1	*+A2[A4],A6		;save rowMax
||	LDH	.D2	*+B2[B4],B6		;save colMax

	STH	.D1	A5,*+A2[A4]		;energy[rowMaxIndex] = 0
||	STH	.D2	B5,*+B2[B4]		;energy[colMaxIndex] = 0

	LDH	.D1	*A2++,A7		;rowVal = energy[0]
||	LDH	.D2	*B2++,B7		;colVal = energy[4]
||	MV	.L1	A6,A8			;A8 = flags

	MVK	.S1	0,A5			;init rowRelMax = 0
||	MVK	.S2	0,B5			;init colRelMax = 0	

	LDH	.D1	*A2++,A7		;rowVal = energy[1]
||	LDH	.D2	*B2++,B7		;colVal = energy[5]

	NOP

	LDH	.D1	*A2++,A7		;rowVal = energy[2]
||	LDH	.D2	*B2++,B7		;colVal = energy[6]

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowRelMax<energy[0])
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colRelMax<energy[4])

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowRelMax = energy[0]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colRelMax = energy[4]
||	LDH	.D1	*A2--[3],A7		;rowVal = energy[3]
||	LDH	.D2	*B2--[3],B7		;colVal = energy[7]

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowRelMax<energy[1])
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colRelMax<energy[4])
||	STH	.D1	A6,*A2[A4]		;restore energy[rowMaxIndex]
||	STH	.D2	B6,*B2[B4]		;restore energy[colMaxIndex]

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowRelMax = energy[1]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colRelMax = energy[5]

	CMPLT	.L1	A5,A7,A1		;A1 = if(rowRelMax<energy[2])
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colRelMax<energy[6])

  [A1]	MV	.S1	A7,A5			;if(A1==1) rowRelMax = energy[2]
||[B1]	MV	.S2	B7,B5			;if(B1==1) colRelMax = energy[6]
	
	CMPLT	.L1	A5,A7,A1		;A1 = if(rowRelMax<energy[3])
||	CMPLT	.L2	B5,B7,B1		;B1 = if(colRelMax<energy[7])

  [A1]	MV	.L1	A7,A5			;if(A1==1) rowRelMax = energy[3]
||[B1]	MV	.L2	B7,B5			;if(B1==1) colRelMax = energy[7]
||	SHL	.S1	A6,15,A6		;init rowRelDen = rowMax<<15
||	SHL	.S2	B6,15,B6		;init colRelDen = colMax<<15

	SHL	.S1	A5,16,A5		;init rowRelRatio = rowRelMax<<16
||	SHL	.S2	B5,16,B5		;init colRelRatio = colRelMax<<16

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter1
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter1

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter2
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter2

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter3
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter3

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter4
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter4

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter5
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter5

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter6
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter6

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter7
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter7

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter8
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter8

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter9
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter9

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter10
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter10
||	MVKL	.S1	_thresRelativePeak,A2	;

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter11
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter11
||	MVKH	.S1	_thresRelativePeak,A2	;

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter12
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter12
||	LDH	.D1	*A2,A7			;A7 = thresRelativePeak

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter13
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter13
||	MVKL	.S2	0FFFFh,B7		;

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter14
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter14
||	B	.S2	B3			;return

	SUBC	.L1	A5,A6,A5		;rowRelRatio iter15
||	SUBC	.L2	B5,B6,B5		;colRelRatio iter15
||	MVKH	.S2	0,B7			;mask = 0000FFFFh

  	AND	.L1x	A5,B7,A5		;row2ndRatio = row2ndRatio & 0000FFFFh
||	AND	.L2	B5,B7,B5		;col2ndRatio = col2ndRatio & 0000FFFFh

	CMPGT	.L1	A5,A7,A1		;A1 = if(row2ndRatio>thres2ndHarmonics)
||	CMPGT	.L2x	B5,A7,B1		;B1 = if(col2ndRatio>thres2ndHarmonics)
||	MVK	.S1	20h,A7			;A7 = 20h

  [A1]	OR	.S1	A8,A7,A4		;if(A1==1) flags = flags | 20h

  [B1]	OR	.S1	A8,A7,A4		;if(B1==1) flags = flags | 20h



