;******************************************************************************
;* TMS320C6x ANSI C Codegen                               Version 4.00.beta 1 *
;* Date/Time created: Thu Feb 24 18:00:50 2000                                *
;******************************************************************************

;******************************************************************************
;* GLOBAL FILE PARAMETERS                                                     *
;*                                                                            *
;*   Architecture      : TMS320C620x                                          *
;*   Optimization      : Enabled at level 3                                   *
;*   Optimizing for    : Speed                                                *
;*                       Based on options: -o3, no -ms                        *
;*   Endian            : Little                                               *
;*   Interrupt Thrshld : Disabled                                             *
;*   Memory Model      : Small                                                *
;*   Calls to RTS      : Near                                                 *
;*   Pipelining        : Enabled                                              *
;*   Speculative Load  : Disabled                                             *
;*   Memory Aliases    : Presume not aliases (optimistic)                     *
;*   Debug Info        : Debug                                                *
;*                                                                            *
;******************************************************************************

FP	.set	A15
DP	.set	B14
SP	.set	B15
	.global	$bss

;	opt6x -h2 -t -n2 -O3 C:\TEMP\TI224_2 C:\TEMP\TI224_4 
	.file	"dtmf_dec.c"
	.file	"C:\ti\c6000\bios\include\std.h"
	.file	"C:\ti\c6000\bios\include\log.h"
	.file	"dtmf.h"
	.file	"C:\ti\c6000\bios\include\log.h"
	.stag	_LOG_Obj, 192
	.member	_bufend, 0, 14, 8, 32
	.member	_flag, 32, 14, 8, 32
	.member	_seqnum, 64, 14, 8, 32
	.member	_curptr, 96, 14, 8, 32
	.member	_lenmask, 128, 14, 8, 32
	.member	_bufbeg, 160, 14, 8, 32
	.eos
	.sym	_Uns, 0, 14, 13, 32
	.sym	_LOG_Obj, 0, 8, 13, 192,_LOG_Obj
	.sym	_String, 0, 18, 13, 32
	.file	"dtmf_dec.c"
	.stag	_T0, 16
	.member	_state, 0, 12, 8, 8
	.member	_flags, 8, 12, 8, 8
	.eos
	.sym	_DTMF_DecObj, 0, 8, 13, 16,_T0
	.file	"dtmf.h"
	.file	"dtmf_dec.c"

	.sect	".cinit"
	.align	8
	.field  	IR_1,32
	.field  	_energy+0,32
	.field  	0,16			; _energy[0] @ 0
	.field  	0,16			; _energy[1] @ 16
	.field  	0,16			; _energy[2] @ 32
	.field  	0,16			; _energy[3] @ 48
	.field  	0,16			; _energy[4] @ 64
	.field  	0,16			; _energy[5] @ 80
	.field  	0,16			; _energy[6] @ 96
	.field  	0,16			; _energy[7] @ 112
	.field  	0,16			; _energy[8] @ 128
	.field  	0,16			; _energy[9] @ 144
	.field  	0,16			; _energy[10] @ 160
	.field  	0,16			; _energy[11] @ 176
IR_1:	.set	24

	.sect	".text"
	.global	_energy
	.bss	_energy,24,4
	.sym	_energy,_energy, 51, 2, 192,, 12

	.sect	".cinit:c"
	.align	8
	.field  	(CIR - $) - 8, 32
	.field  	_coef10+0,32
	.field  	0x694c6d4c,32			; _coef10 @ 0

	.sect	".text"
	.global	_coef10
_coef10:	.usect	".bss:c",4,4
	.sym	_coef10,_coef10, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x5e9b6465,32			; _coef32 @ 0

	.sect	".text"
	.global	_coef32
_coef32:	.usect	".bss:c",4,4
	.sym	_coef32,_coef32, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x3fc54a81,32			; _coef54 @ 0

	.sect	".text"
	.global	_coef54
_coef54:	.usect	".bss:c",4,4
	.sym	_coef54,_coef54, 4, 2, 32

	.sect	".cinit:c"
	.align	4
	.field  	0x2463331d,32			; _coef76 @ 0

	.sect	".text"
	.global	_coef76
_coef76:	.usect	".bss:c",4,4
	.sym	_coef76,_coef76, 4, 2, 32

	.sect	".cinit"
	.align	8
	.field  	IR_2,32
	.field  	_coef1st+0,32
	.field  	0x6d4c,16			; _coef1st[0] @ 0
	.field  	0x694c,16			; _coef1st[1] @ 16
	.field  	0x6465,16			; _coef1st[2] @ 32
	.field  	0x5e9b,16			; _coef1st[3] @ 48
	.field  	0x4a81,16			; _coef1st[4] @ 64
	.field  	0x3fc5,16			; _coef1st[5] @ 80
	.field  	0x331d,16			; _coef1st[6] @ 96
	.field  	0x2463,16			; _coef1st[7] @ 112
IR_2:	.set	16

	.sect	".text"
	.global	_coef1st
	.bss	_coef1st,16,4
	.sym	_coef1st,_coef1st, 51, 2, 128,, 8

	.sect	".cinit"
	.align	8
	.field  	IR_3,32
	.field  	_coef2nd+0,32
	.field  	0x3993,16			; _coef2nd[0] @ 0
	.field  	0x2c96,16			; _coef2nd[1] @ 16
	.field  	0x1d7d,16			; _coef2nd[2] @ 32
	.field  	0xbd8,16			; _coef2nd[3] @ 48
	.field  	0xd6bb,16			; _coef2nd[4] @ 64
	.field  	0xbf89,16			; _coef2nd[5] @ 80
	.field  	0xa8d2,16			; _coef2nd[6] @ 96
	.field  	0x94b0,16			; _coef2nd[7] @ 112
IR_3:	.set	16

	.sect	".text"
	.global	_coef2nd
	.bss	_coef2nd,16,4
	.sym	_coef2nd,_coef2nd, 51, 2, 128,, 8

	.sect	".cinit"
	.align	8
	.field  	IR_4,32
	.field  	_keys+0,32
	.field  	0x1,8			; _keys[0] @ 0
	.field  	0x2,8			; _keys[1] @ 8
	.field  	0x3,8			; _keys[2] @ 16
	.field  	0xa,8			; _keys[3] @ 24
	.field  	0x4,8			; _keys[4] @ 32
	.field  	0x5,8			; _keys[5] @ 40
	.field  	0x6,8			; _keys[6] @ 48
	.field  	0xb,8			; _keys[7] @ 56
	.field  	0x7,8			; _keys[8] @ 64
	.field  	0x8,8			; _keys[9] @ 72
	.field  	0x9,8			; _keys[10] @ 80
	.field  	0xc,8			; _keys[11] @ 88
	.field  	0xe,8			; _keys[12] @ 96
	.field  	0,8			; _keys[13] @ 104
	.field  	0xf,8			; _keys[14] @ 112
	.field  	0xd,8			; _keys[15] @ 120
IR_4:	.set	16

	.sect	".text"
	.global	_keys
	.bss	_keys,16,4
	.sym	_keys,_keys, 60, 2, 128,, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1b85,16			; _thresSignalStrength @ 0

	.sect	".text"
	.global	_thresSignalStrength
_thresSignalStrength:	.usect	".bss:c",2,2
	.sym	_thresSignalStrength,_thresSignalStrength, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x5dc,16			; _thresPauseStrength @ 0

	.sect	".text"
	.global	_thresPauseStrength
_thresPauseStrength:	.usect	".bss:c",2,2
	.sym	_thresPauseStrength,_thresPauseStrength, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x101d,16			; _thresReverseTwist @ 0

	.sect	".text"
	.global	_thresReverseTwist
_thresReverseTwist:	.usect	".bss:c",2,2
	.sym	_thresReverseTwist,_thresReverseTwist, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x2027,16			; _thresStandardTwist @ 0

	.sect	".text"
	.global	_thresStandardTwist
_thresStandardTwist:	.usect	".bss:c",2,2
	.sym	_thresStandardTwist,_thresStandardTwist, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1999,16			; _thresRelativePeak @ 0

	.sect	".text"
	.global	_thresRelativePeak
_thresRelativePeak:	.usect	".bss:c",2,2
	.sym	_thresRelativePeak,_thresRelativePeak, 3, 2, 16

	.sect	".cinit:c"
	.align	2
	.field  	0x1999,16			; _thres2ndHarmonics @ 0

	.sect	".text"
	.global	_thres2ndHarmonics
_thres2ndHarmonics:	.usect	".bss:c",2,2
	.sym	_thres2ndHarmonics,_thres2ndHarmonics, 3, 2, 16
	.sect	".text"
	.sym	_dtmfNormalize,_dtmfNormalize, 32, 3, 0
	.func	198
;----------------------------------------------------------------------
; 198 | static void dtmfNormalize(short N, short *buffer)                      
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _dtmfNormalize                                              *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,SP                                   *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,SP                                   *
;*   Local Frame Size  : 0 Args + 0 Auto + 8 Save = 8 byte                    *
;******************************************************************************
_dtmfNormalize:
;** --------------------------------------------------------------------------*
	.sym	_buffer,4, 19, 17, 32
;**	Parameter deleted: N == 164;
	.sym	_normScale,20, 3, 4, 16
	.sym	_normAmplitude,0, 3, 4, 16
	.sym	_normPower,4, 4, 4, 32
	.sym	_buffer,10, 19, 4, 32
           STW     .D2T1   A10,*SP--(8)      ; |198| 
           STW     .D2T2   B3,*+SP(4)        ; |198| 
	.line	2
;----------------------------------------------------------------------
; 200 | int     normPower;              /* (Q30)                        */     
; 201 | int     normLimit=0x00018F9C;   /* = 1/(64*164) 0x00018F9C      (Q30)
;     |  */                                                                    
; 202 | short   normConstant=0x4FF6;    /* = sqrt(64/164) 0x4FF6        (Q15)
;     |  */                                                                    
; 203 | short   normLevel=0x008D;       /* = 0.5*sqrt(2)/164 0x008D     (Q15)
;     |  */                                                                    
; 204 | short   normAmplitude;                                                 
; 205 | short   normScale;                                                     
;----------------------------------------------------------------------
	.line	10
;----------------------------------------------------------------------
; 207 | normPower = (int)(dotprod40(buffer,buffer,N) >> 6);                    
; 209 | if(normPower>normLimit)         {                                      
;----------------------------------------------------------------------
           B       .S1     _dotprod40        ; |207| 
           MVKL    .S2     RL0,B3            ; |207| 
           MVKH    .S2     RL0,B3            ; |207| 
           MV      .L1     A4,A10            ; 
           MV      .L2X    A4,B4             ; 
           MVK     .S1     0xa4,A6           ; |207| 
RL0:       ; CALL OCCURS                     ; |207| 
           MVKL    .S2     0x18f9c,B4        ; |207| 

           SHR     .S1     A5:A4,6,A5:A4     ; |207| 
||         MVKH    .S2     0x18f9c,B4        ; |207| 

           CMPGT   .L2X    A4,B4,B0          ; 
   [!B0]   B       .S1     L1                ; |207| 
           NOP             5
           ; BRANCH OCCURS                   ; |207| 
;** --------------------------------------------------------------------------*
	.line	13
;----------------------------------------------------------------------
; 210 | normAmplitude = sqrt(normPower);                                       
;----------------------------------------------------------------------
           B       .S1     _sqrt             ; |210| 
           MVKL    .S2     RL2,B3            ; |210| 
           MVKH    .S2     RL2,B3            ; |210| 
           NOP             3
RL2:       ; CALL OCCURS                     ; |210| 
           MV      .L1     A4,A0             ; 
	.line	14
;----------------------------------------------------------------------
; 211 | normAmplitude = ((int)normAmplitude * (int)normConstant) >> 15;        
;----------------------------------------------------------------------
           MVK     .S1     10235,A3          ; |211| 
           MPY     .M1     A0,A3,A0          ; |211| 
           NOP             1
           EXT     .S1     A0,2,16,A0        ; 
	.line	15
;----------------------------------------------------------------------
; 212 | normScale = div_q15(normLevel,normAmplitude);                          
;----------------------------------------------------------------------
           B       .S1     _div_q15          ; |212| 
           MVKL    .S2     RL4,B3            ; |212| 
           MV      .L2X    A0,B4             ; |212| 
           MVK     .S1     0x8d,A4           ; |212| 
           MVKH    .S2     RL4,B3            ; |212| 
           NOP             1
RL4:       ; CALL OCCURS                     ; |212| 
           MV      .L2X    A4,B4             ; 
	.line	16
;----------------------------------------------------------------------
; 213 | scale_q15(buffer,normScale,N);                                         
;----------------------------------------------------------------------
           B       .S1     _scale_q15        ; |213| 
           MVKL    .S2     RL6,B3            ; |213| 
           MV      .L1     A10,A4            ; |213| 
           MVKH    .S2     RL6,B3            ; |213| 
           MVK     .S1     0xa4,A6           ; |213| 
           NOP             1
RL6:       ; CALL OCCURS                     ; |213| 
;** --------------------------------------------------------------------------*
L1:    
	.line	18
           LDW     .D2T2   *+SP(4),B3        ; |215| 
           LDW     .D2T1   *++SP(8),A10      ; |215| 
           NOP             3
           B       .S2     B3                ; |215| 
           NOP             5
           ; BRANCH OCCURS                   ; |215| 
	.endfunc	215,000080400h,8


	.sect	".text"
	.sym	_dtmfDigitDetect,_dtmfDigitDetect, 36, 3, 0
	.func	107
;----------------------------------------------------------------------
; 107 | static int dtmfDigitDetect(DTMF_DecObj *chxDecObjPtr, short *buffer)   
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _dtmfDigitDetect                                            *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,SP                    *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,A11,B0,B1,B2,B3,B4,*
;*                           B5,B6,B7,B8,B9,B10,B11,B12,DP,SP                 *
;*   Local Frame Size  : 8 Args + 4 Auto + 24 Save = 36 byte                  *
;******************************************************************************
_dtmfDigitDetect:
;** --------------------------------------------------------------------------*
	.sym	_chxDecObjPtr,4, 24, 17, 32, _T0
	.sym	_buffer,20, 19, 17, 32
	.sym	C$1,0, 19, 4, 32
	.sym	C$2,20, 19, 4, 32
	.sym	C$3,28, 19, 4, 32
	.sym	_flags,26, 12, 4, 8
	.sym	_digit,10, 4, 4, 32
	.sym	_colMaxIndex,12, 3, 1, 16
	.sym	_rowMaxIndex,14, 3, 1, 16
	.sym	_chxDecObjPtr,27, 24, 4, 32, _T0
	.sym	_buffer,11, 19, 4, 32
	.sym	U$48,16, 4, 4, 32
	.sym	U$21,16, 12, 4, 8
	.sym	K$8,28, 19, 4, 32
           STW     .D2T2   B12,*SP--(40)     ; |107| 
           STW     .D2T1   A10,*+SP(20)      ; |107| 
           STW     .D2T1   A11,*+SP(24)      ; |107| 
           STW     .D2T2   B3,*+SP(28)       ; |107| 
           STW     .D2T2   B10,*+SP(32)      ; |107| 
           STW     .D2T2   B11,*+SP(36)      ; |107| 
	.line	2
;----------------------------------------------------------------------
; 109 | short rowMaxIndex, colMaxIndex;                                        
; 110 | int   coef1, coef2;                                                    
; 111 | int digit = -1;                                                        
; 112 | int keysTableIndex;                                                    
; 113 | unsigned char flags;                                                   
;----------------------------------------------------------------------

           MV      .L2X    A4,B11            ; 
||         MV      .L1X    B4,A11            ; 

	.line	9
;----------------------------------------------------------------------
; 115 | flags     = chxDecObjPtr->flags;                                       
;----------------------------------------------------------------------
           LDBU    .D2T2   *+B11(1),B10      ; |115| 
	.line	12
;----------------------------------------------------------------------
; 118 | goertzel(buffer,&energy[0],coef10,coef32,82);                          
;----------------------------------------------------------------------
           MVK     .S2     (_energy-$bss),B4 ; |118| 
           ADD     .L2     DP,B4,B12         ; 

           B       .S1     _goertzel         ; |118| 
||         LDW     .D2T2   *+DP(_coef32),B6  ; |118| 

           LDW     .D2T1   *+DP(_coef10),A6  ; |118| 
           MVKL    .S2     RL8,B3            ; |118| 
           MV      .L2     B12,B4            ; |118| 
           MV      .L1     A11,A4            ; |118| 

           MVKH    .S2     RL8,B3            ; |118| 
||         MVK     .S1     0x52,A8           ; |118| 

RL8:       ; CALL OCCURS                     ; |118| 
	.line	13
;----------------------------------------------------------------------
; 119 | goertzel(buffer,&energy[4],coef54,coef76,82);                          
;----------------------------------------------------------------------

           B       .S1     _goertzel         ; |119| 
||         LDW     .D2T2   *+DP(_coef76),B6  ; |119| 

           LDW     .D2T1   *+DP(_coef54),A6  ; |119| 
           MVKL    .S2     RL10,B3           ; |119| 
           ADD     .L2     8,B12,B4          ; 
           MV      .L1     A11,A4            ; |119| 

           MVKH    .S2     RL10,B3           ; |119| 
||         MVK     .S1     0x52,A8           ; |119| 

RL10:      ; CALL OCCURS                     ; |119| 
	.line	16
;----------------------------------------------------------------------
; 122 | dtmfMaxSearch(      &rowMaxIndex,                                      
; 123 |                     &colMaxIndex    );                                 
;----------------------------------------------------------------------
           B       .S1     _dtmfMaxSearch    ; |122| 
           MVKL    .S2     RL12,B3           ; |122| 
           ADD     .L2     12,SP,B4          ; |122| 
           ADD     .L1X    14,SP,A4          ; 
           MVKH    .S2     RL12,B3           ; |122| 
           NOP             1
RL12:      ; CALL OCCURS                     ; |122| 
	.line	19
;----------------------------------------------------------------------
; 125 | flags = flags & 0x83;                       /* clear all error flags */
;----------------------------------------------------------------------
           MVK     .S2     131,B4            ; |125| 
           AND     .L2     B4,B10,B4         ; |125| 
           EXTU    .S2     B4,24,24,B10      ; |125| 
	.line	5
           MVK     .S1     0xffffffff,A10    ; |111| 
	.line	13
	.line	24
;----------------------------------------------------------------------
; 130 | if (chxDecObjPtr->state == DTMF_SIG_WAIT)   {                          
; 131 |     VERBOSE_LOG_printf(&trace, "Detector in SIG_WAIT ...");            
;----------------------------------------------------------------------
           LDBU    .D2T2   *B11,B0           ; |130| 
           NOP             4
   [ B0]   B       .S1     L2                ; |130| 
           NOP             5
           ; BRANCH OCCURS                   ; |130| 
;** --------------------------------------------------------------------------*
	.line	27
;----------------------------------------------------------------------
; 133 | if((energy[rowMaxIndex]+energy[colMaxIndex])                           
; 134 |    > thresPauseStrength) {                                             
;----------------------------------------------------------------------
           LDH     .D2T2   *+SP(14),B4       ; |133| 
           LDH     .D2T2   *+SP(12),B5       ; |133| 
           LDH     .D2T2   *+DP(_thresPauseStrength),B6 ; |133| 
           NOP             2
           LDH     .D2T2   *+B12[B4],B4      ; |133| 
           LDH     .D2T2   *+B12[B5],B5      ; |133| 
           NOP             4
           ADD     .L2     B5,B4,B4          ; |133| 
           CMPGT   .L2     B4,B6,B0          ; |133| 
   [!B0]   B       .S1     L6                ; |133| 
           NOP             5
           ; BRANCH OCCURS                   ; |133| 
;** --------------------------------------------------------------------------*
	.line	29
;----------------------------------------------------------------------
; 135 | chxDecObjPtr->state = DTMF_DIGIT_STATE; /* enable digit mode */        
;----------------------------------------------------------------------
           MVK     .S1     1,A0              ; |135| 
           STB     .D2T1   A0,*B11           ; |135| 
	.line	30
;----------------------------------------------------------------------
; 136 | LOG_printf(&trace,                                                     
; 137 |            "... strength is adequate, going to DTMF_DIGIT_STATE");     
;----------------------------------------------------------------------
           B       .S1     _LOG_printf       ; |136| 
           MVKL    .S2     SL1+0,B4          ; |136| 
           MVKL    .S2     RL14,B3           ; |136| 
           MVKH    .S2     SL1+0,B4          ; |136| 
           MVKL    .S1     _trace,A4         ; |136| 

           STW     .D2T2   B4,*+SP(4)        ; |136| 
||         MVKH    .S2     RL14,B3           ; |136| 
||         MVKH    .S1     _trace,A4         ; |136| 

RL14:      ; CALL OCCURS                     ; |136| 
           B       .S1     L6                ; |136| 
           NOP             5
           ; BRANCH OCCURS                   ; |136| 
;** --------------------------------------------------------------------------*
L2:    
	.line	33
;----------------------------------------------------------------------
; 139 | } else  if (chxDecObjPtr->state == DTMF_PAUSE_WAIT) {                  
; 140 |     if((energy[rowMaxIndex]+energy[colMaxIndex])                       
; 141 |        < thresPauseStrength) {                                         
; 142 |         chxDecObjPtr->state = DTMF_SIG_WAIT; /* Wait for next digit */ 
; 143 |         LOG_printf(&trace,                                             
; 144 |                    "... strength below threshold, going to DTMF_SIG_WAI
;     | T");                                                                   
; 151 | else        {                                                          
; 152 |     VERBOSE_LOG_printf(&trace, "Detector in digit mode ...");          
;----------------------------------------------------------------------
           CMPEQ   .L2     B0,2,B0           ; |139| 
   [ B0]   B       .S1     L5                ; |139| 
           NOP             5
           ; BRANCH OCCURS                   ; |139| 
;** --------------------------------------------------------------------------*
	.line	47
;----------------------------------------------------------------------
; 153 | if(!(flags & 0xFC))                                                    
;----------------------------------------------------------------------
           EXTU    .S2     B10,24,26,B4      ; |153| 
           SHL     .S2     B4,2,B0           ; |153| 
   [ B0]   B       .S1     L3                ; |153| 
           NOP             5
           ; BRANCH OCCURS                   ; |153| 
;** --------------------------------------------------------------------------*
	.line	48
;----------------------------------------------------------------------
; 154 | flags = dtmfCheckRelPeak(rowMaxIndex,colMaxIndex,flags);               
;----------------------------------------------------------------------

           B       .S1     _dtmfCheckRelPeak ; |154| 
||         LDH     .D2T2   *+SP(12),B4       ; |154| 

           LDH     .D2T1   *+SP(14),A4       ; |154| 
           MVKL    .S2     RL16,B3           ; |154| 
           MVKH    .S2     RL16,B3           ; |154| 
           MV      .L1X    B10,A6            ; |154| 
           NOP             1
RL16:      ; CALL OCCURS                     ; |154| 
           MV      .L2X    A4,B10            ; 
           EXTU    .S2     B10,24,26,B4      ; |154| 
           SHL     .S2     B4,2,B0           ; |154| 
;** --------------------------------------------------------------------------*
L3:    
	.line	49
;----------------------------------------------------------------------
; 155 | if(!(flags & 0xFC))     {                                              
; 156 |     coef1 = (coef1st[colMaxIndex] << 16) + coef1st[rowMaxIndex];       
; 157 |     coef2 = (coef2nd[colMaxIndex] << 16) + coef2nd[rowMaxIndex];       
;----------------------------------------------------------------------
   [ B0]   B       .S1     L4                ; |155| 
           NOP             5
           ; BRANCH OCCURS                   ; |155| 
;** --------------------------------------------------------------------------*
	.line	52
;----------------------------------------------------------------------
; 158 | goertzel(&buffer[0],&energy[8],coef1,coef2,164);                       
; 160 | if(!(flags & 0xFC))                                                    
; 161 | flags = dtmfCheck(flags);                                              
;----------------------------------------------------------------------
           MVK     .S2     (_coef2nd-$bss),B4 ; |158| 
           ADD     .L2     DP,B4,B4          ; 
           MVK     .S1     (_coef1st-$bss),A0 ; |158| 
           ADD     .L1X    DP,A0,A0          ; 
           LDH     .D2T1   *+SP(12),A4       ; |158| 
           LDH     .D2T2   *+SP(12),B6       ; |158| 
           LDH     .D2T1   *+SP(14),A3       ; |158| 
           LDH     .D2T2   *+SP(14),B5       ; |158| 
           MVKL    .S2     RL18,B3           ; |158| 
           MVKH    .S2     RL18,B3           ; |158| 
           MVK     .S1     0xa4,A8           ; |158| 

           LDH     .D2T2   *+B4[B6],B6       ; |158| 
||         LDH     .D1T1   *+A0[A4],A4       ; |158| 

           B       .S1     _goertzel         ; |158| 
||         LDH     .D2T2   *+B4[B5],B5       ; |158| 
||         LDH     .D1T1   *+A0[A3],A3       ; |158| 

           ADD     .D2     B12,16,B4         ; |158| 
           NOP             2

           SHL     .S1     A4,16,A0          ; |158| 
||         SHL     .S2     B6,16,B6          ; |158| 

           ADD     .L1     A3,A0,A6          ; 
||         MV      .D1     A11,A4            ; |158| 
||         ADD     .L2     B5,B6,B6          ; 

RL18:      ; CALL OCCURS                     ; |158| 
           B       .S1     _dtmfCheck        ; |158| 
           MVKL    .S2     RL20,B3           ; |158| 
           MV      .L1X    B10,A4            ; |158| 
           MVKH    .S2     RL20,B3           ; |158| 
           NOP             2
RL20:      ; CALL OCCURS                     ; |158| 
           MV      .L2X    A4,B10            ; 
           EXTU    .S2     B10,24,26,B4      ; |158| 
           SHL     .S2     B4,2,B0           ; |158| 
;** --------------------------------------------------------------------------*
L4:    
	.line	56
;----------------------------------------------------------------------
; 162 | if(!(flags & 0xFC))     {                                              
; 163 |     keysTableIndex = (rowMaxIndex<<2) + (colMaxIndex-4);               
;----------------------------------------------------------------------
	.line	58
;----------------------------------------------------------------------
; 164 | digit = keys[keysTableIndex]; /* decoded digit      */                 
;----------------------------------------------------------------------
   [!B0]   LDH     .D2T2   *+SP(12),B6       ; |164| 
   [!B0]   LDH     .D2T2   *+SP(14),B5       ; |164| 
   [!B0]   MVK     .S2     (_keys-4-$bss),B4 ; |164| 
   [!B0]   ADD     .L2     DP,B4,B4          ; |164| 
           NOP             2
   [!B0]   ADDAW   .D2     B6,B5,B5          ; |164| 
   [!B0]   LDBU    .D2T1   *+B5[B4],A10      ; |164| 
           NOP             2
	.line	59
;----------------------------------------------------------------------
; 165 | chxDecObjPtr->state = DTMF_PAUSE_WAIT; /* wait for digit to end */     
;----------------------------------------------------------------------
   [!B0]   MVK     .S1     2,A0              ; |165| 
   [!B0]   STB     .D2T1   A0,*B11           ; |165| 
	.line	63
;----------------------------------------------------------------------
; 169 | if (digit != -1) {                                                     
;----------------------------------------------------------------------
           CMPEQ   .L1     A10,-1,A1         ; |169| 
   [ A1]   B       .S1     L6                ; |169| 
           NOP             5
           ; BRANCH OCCURS                   ; |169| 
;** --------------------------------------------------------------------------*
	.line	64
;----------------------------------------------------------------------
; 170 | LOG_printf(&trace, "... digit %x detected", digit);                    
;----------------------------------------------------------------------
           B       .S1     _LOG_printf       ; |170| 
           MVKL    .S2     SL2+0,B4          ; |170| 
           MVKL    .S2     RL22,B3           ; |170| 
           MVKH    .S2     SL2+0,B4          ; |170| 

           STW     .D2T1   A10,*+SP(8)       ; |170| 
||         MVKL    .S1     _trace,A4         ; |170| 

           STW     .D2T2   B4,*+SP(4)        ; |170| 
||         MVKH    .S2     RL22,B3           ; |170| 
||         MVKH    .S1     _trace,A4         ; |170| 

RL22:      ; CALL OCCURS                     ; |170| 
	.line	65
;----------------------------------------------------------------------
; 171 | } else {                                                               
; 173 |     if (flags & DTMF_SIGSTRENGTH) {                                    
; 174 |         VERBOSE_LOG_printf(&trace, "... error, signal strength");      
; 176 |     if (flags & DTMF_REVERSETWIST) {                                   
; 177 |         VERBOSE_LOG_printf(&trace, "... error, reverse twist");        
; 179 |     if (flags & DTMF_TWIST) {                                          
; 180 |         VERBOSE_LOG_printf(&trace, "... error, standard twist");       
; 182 |     if (flags & DTMF_RELPEAK) {                                        
; 183 |         VERBOSE_LOG_printf(&trace, "... error, relative peak");        
; 185 |     if (flags & DTMF_2NDHARM) {                                        
; 186 |         VERBOSE_LOG_printf(&trace, "... error, 2nd harmonic");         
;----------------------------------------------------------------------
           B       .S1     L6                ; |171| 
           NOP             5
           ; BRANCH OCCURS                   ; |171| 
;** --------------------------------------------------------------------------*
L5:    
	.line	34
           LDH     .D2T2   *+SP(14),B4       ; |140| 
           LDH     .D2T2   *+SP(12),B5       ; |140| 
           LDH     .D2T2   *+DP(_thresPauseStrength),B6 ; |140| 
           NOP             2
           LDH     .D2T2   *+B12[B4],B4      ; |140| 
           LDH     .D2T2   *+B12[B5],B5      ; |140| 
           NOP             4
           ADD     .L2     B5,B4,B4          ; |140| 
           CMPLT   .L2     B4,B6,B0          ; |140| 
   [!B0]   B       .S1     L6                ; |140| 
           NOP             5
           ; BRANCH OCCURS                   ; |140| 
;** --------------------------------------------------------------------------*
	.line	36
           ZERO    .L2     B4                ; |142| 
           STB     .D2T2   B4,*B11           ; |142| 
	.line	37
           B       .S1     _LOG_printf       ; |143| 
           MVKL    .S2     RL24,B3           ; |143| 
           MVKL    .S2     SL3+0,B4          ; |143| 
           MVKH    .S2     SL3+0,B4          ; |143| 
           MVKL    .S1     _trace,A4         ; |143| 

           STW     .D2T2   B4,*+SP(4)        ; |143| 
||         MVKH    .S2     RL24,B3           ; |143| 
||         MVKH    .S1     _trace,A4         ; |143| 

RL24:      ; CALL OCCURS                     ; |143| 
;** --------------------------------------------------------------------------*
L6:    
	.line	85
;----------------------------------------------------------------------
; 191 | chxDecObjPtr->flags = flags;                                           
;----------------------------------------------------------------------
           STB     .D2T2   B10,*+B11(1)      ; |191| 
	.line	87
;----------------------------------------------------------------------
; 193 | return digit;                                                          
;----------------------------------------------------------------------
           MV      .L1     A10,A4            ; |193| 
	.line	88
           LDW     .D2T2   *+SP(28),B3       ; |194| 
           LDW     .D2T1   *+SP(24),A11      ; |194| 
           LDW     .D2T2   *+SP(32),B10      ; |194| 
           LDW     .D2T1   *+SP(20),A10      ; |194| 
           LDW     .D2T2   *+SP(36),B11      ; |194| 
           B       .S2     B3                ; |194| 
           LDW     .D2T2   *++SP(40),B12     ; |194| 
           NOP             4
           ; BRANCH OCCURS                   ; |194| 
	.endfunc	194,01c080c00h,40


	.sect	".text"
	.global	_DTMF_decode
	.sym	_DTMF_decode,_DTMF_decode, 36, 2, 0
	.func	92
;----------------------------------------------------------------------
;  92 | int DTMF_decode(DTMF_DecObj *chxDecObjPtr, short *buffer)              
;----------------------------------------------------------------------

;******************************************************************************
;* FUNCTION NAME: _DTMF_decode                                                *
;*                                                                            *
;*   Regs Modified     : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,B10,SP                               *
;*   Regs Used         : A0,A1,A2,A3,A4,A5,A6,A7,A8,A9,A10,B0,B1,B2,B3,B4,B5, *
;*                           B6,B7,B8,B9,B10,SP                               *
;*   Local Frame Size  : 0 Args + 0 Auto + 12 Save = 12 byte                  *
;******************************************************************************
_DTMF_decode:
;** --------------------------------------------------------------------------*
	.sym	_chxDecObjPtr,4, 24, 17, 32, _T0
	.sym	_buffer,20, 19, 17, 32
	.sym	_chxDecObjPtr,10, 24, 4, 32, _T0
	.sym	_buffer,26, 19, 4, 32
           STW     .D2T2   B10,*SP--(16)     ; |92| 
           STW     .D2T1   A10,*+SP(8)       ; |92| 
           STW     .D2T2   B3,*+SP(12)       ; |92| 
	.line	2

           MV      .L2     B4,B10            ; 
||         MV      .L1     A4,A10            ; 

	.line	3
;----------------------------------------------------------------------
;  94 | if (*buffer != 0) {                                                    
;----------------------------------------------------------------------
           LDH     .D2T2   *B10,B0           ; |94| 
           NOP             4
   [!B0]   B       .S1     L7                ; |94| 
           NOP             5
           ; BRANCH OCCURS                   ; |94| 
;** --------------------------------------------------------------------------*
	.line	4
;----------------------------------------------------------------------
;  95 | foo();                                                                 
;----------------------------------------------------------------------
           B       .S1     _foo              ; |95| 
           MVKL    .S2     RL26,B3           ; |95| 
           MVKH    .S2     RL26,B3           ; |95| 
           NOP             3
RL26:      ; CALL OCCURS                     ; |95| 
;** --------------------------------------------------------------------------*
L7:    
	.line	8
;----------------------------------------------------------------------
;  99 | dtmfNormalize(164, buffer);                                            
;----------------------------------------------------------------------
           B       .S1     _dtmfNormalize    ; |99| 
           MVKL    .S2     RL28,B3           ; |99| 
           MVKH    .S2     RL28,B3           ; |99| 
           MV      .L1X    B10,A4            ; |99| 
           NOP             2
RL28:      ; CALL OCCURS                     ; |99| 
	.line	11
;----------------------------------------------------------------------
; 102 | return dtmfDigitDetect(chxDecObjPtr, buffer);                          
;----------------------------------------------------------------------
           B       .S1     _dtmfDigitDetect  ; |102| 
           MVKL    .S2     RL30,B3           ; |102| 
           MV      .L1     A10,A4            ; |102| 
           MVKH    .S2     RL30,B3           ; |102| 
           MV      .L2     B10,B4            ; |102| 
           NOP             1
RL30:      ; CALL OCCURS                     ; |102| 
	.line	12
           LDW     .D2T2   *+SP(12),B3       ; |103| 
           LDW     .D2T1   *+SP(8),A10       ; |103| 
           LDW     .D2T2   *++SP(16),B10     ; |103| 
           NOP             2
           B       .S2     B3                ; |103| 
           NOP             5
           ; BRANCH OCCURS                   ; |103| 
	.endfunc	103,004080400h,16


;******************************************************************************
;* MARK THE END OF THE SCALAR INIT RECORD IN CINIT:C                          *
;******************************************************************************
CIR:	.sect	".cinit:c"
;******************************************************************************
;* STRINGS                                                                    *
;******************************************************************************
	.sect	".const"
SL1:	.string	"... strength is adequate, going to DTMF_DIGIT_STATE",0
SL2:	.string	"... digit %x detected",0
SL3:	.string	"... strength below threshold, going to DTMF_SIG_WAIT",0
;******************************************************************************
;* UNDEFINED EXTERNAL REFERENCES                                              *
;******************************************************************************
	.global	_LOG_printf
	.global	_dtmfCheck
	.global	_dtmfMaxSearch
	.global	_dtmfCheckRelPeak
	.global	_sqrt
	.global	_div_q15
	.global	_dotprod40
	.global	_scale_q15
	.global	_goertzel
	.global	_trace
	.global	_foo
