*****************************************************************
* Application: 	DTMF codec
* File:		divq15.asm
* Description:	Fractional Q15 division for normalization
*		
* History:
* Date		Who		Comment
* 07-28-97	Gunter Schmer	creation
*
*****************************************************************

*************************************************************************
* Function: 	short div_q15(	short num,	--> A4 arg1
*				short den )	--> B4 arg2
*					    	    B3 retaddr
*
* Description:	This function computes the quotient of two positive
*		fractional Q15 numbers. The result is in Q15 and the
*		entry condition is num < den.
*
* Pseudo C-code:
*
*	short div_q15(	short num,
*			short den )
*	{
*		int quotient, temp, den32;
*
*		result=num<<16;
*		den32=den<<15;
*		for(i=0;i<15;i++)	{
*			temp = result - den32;
*			if(temp>=0)	result = (temp<<1)+1;
*			else		result = result<<1;
*		}
*		return ((result)&&(0x0000FFFF));
*	}
*
* Regs used:	A4,A5
*		B3,B4,B5
*
* Regs modified:A4,A5
*		B4,B5
*
* Execution:	23 cycles
*
*************************************************************************
		.global	_div_q15
		.text
_div_q15:

;
;------ Register Allocation  ------------------------
;	A0 : 		A4 : num	A8 : 
;	A1 : 		A5 : den32	A9 : 
;	A2 : 		A6 : 		A10: 
;	A3 : 		A7 : 		A11: 
;
;	B0 : 		B4 : den	B8 : 
;	B1 : 		B5 : mask	B9 : 
;	B2 : 		B6 : 		B10:
;	B3 : ret addr	B7 : 		B11:
;
;	B14: DP
;	B15: SP
;

	SHL	.S1	A4,16,A4		;initialize result=num<<16
||	MVKL	.S2	0FFFFh,B5		;initialize LSB of mask
	SHL	.S1x	B4,15,A5		;initialize den32=den<<15
||	MVKH	.S2	0,B5			;initialize MSB of mask
	
	SUBC	.L1	A4,A5,A4		;15 iterations of SUBC
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4
	SUBC	.L1	A4,A5,A4

	B	.S2	B3			;return
	AND	.L1x	A4,B5,A4		;return value
	NOP		4
