*****************************************************************
* Application: 	DTMF codec
* File:		dtmf_chk.asm
* Description:	Check 2nd harmonics
*		
* History:
* Date		Who		Comment
* 05-04-98	Gunter Schmer	creation
*
*****************************************************************

*************************************************************************
* Function: 	unsigned char dtmfCheck2ndHarmonics( unsigned char flags )
*						--> A4 arg0
*					    	    B3 retaddr
*
* Description:	This function checks
*		- signal strength
*		- 2nd harmonic content
*		- reverse/standard twists
*
*
* Regs used:	A4,A5
*		B3,B4,B5
*
* Regs modified:A4,A5
*		B4,B5
*
* Execution:	55 cycles
*
*************************************************************************
		.global	_dtmfCheck
		.text
_dtmfCheck:

;
;------ Register Allocation  ------------------------
;	A0 : 		A4 : flags	A8 : 
;	A1 : 		A5 : row2nd 	A9 : 
;	A2 : 		A6 : rowMax 	A10: 
;	A3 : thres2nd	A7 :  		A11: 
;
;	B0 : 		B4 : mask 	B8 : 
;	B1 : 		B5 : col2nd	B9 : 
;	B2 : 		B6 : colMax	B10:
;	B3 : ret addr	B7 : 		B11:
;
;	B14: DP
;	B15: SP
;
	MVK	.S1	_energy+8,A2		;
||	MVK	.S2	_energy+9,B2		;

	MVKH	.S1	_energy+8,A2		;A2 = &energy[8]
||	MVKH	.S2	_energy+9,B2		;B2 = &energy[10]

	LDH	.D1	*A2++[2],A6		;A6 = rowMax
||	LDH	.D2	*B2++[2],B6		;B6 = colMax
||	MVK	.S1	_thresSignal,A1		;

	LDH	.D1	*A2,A5			;A5 = row2nd
||	LDH	.D2	*B2,B5			;B5 = col2nd
||	MVKH	.S1	_thresSignal,A1		;

	MVK	.S1	40h,A8			;A8 = 40h
||	MVK	.S2	_thres2ndHarmonics,B2	;
||	LDH	.D1	*A1,B7			;B7 = thresSignal

	MVKH	.S2	_thres2ndHarmonics,B2	;

	LDH	.D2	*B2,A7			;A7 = thres2ndHarm

	CMPGT	.L2x	A6,B6,B2		;B2 = if(rowMax>colMax)
||	ADD	.L1x	A6,B6,A9		;A9 = rowMax+colMax
||	MVK	.S1	04h,A0			;A0 = 04h

	CMPLT	.L1	A5,A6,A1		;A1 = if(row2nd<rowMax)
||	CMPLT	.L2	B5,B6,B1		;B1 = if(col2nd<colMax)
||	SHL	.S1	A6,15,A6		;init row2ndDen = rowMax<<15
||	SHL	.S2	B6,15,B6		;init col2ndDen = colMax<<15

	SHL	.S1	A5,16,A5		;init row2ndRatio = row2nd<<16
||	SHL	.S2	B5,16,B5		;init col2ndRatio = col2nd<<16
||[!A1]	OR	.L1	A4,A8,A4		;if(A1==0) flags=flags|40h
||	CMPLT	.L2x	A9,B7,B0		;B0 = if(rowMax+colMax < thresSignal)

  [!B1]	OR	.L1	A4,A8,A4		;if(B1==0) flags=flags|40h
||[B2]	SHL	.S1x	B6,1,A2			;init revTwiRatio = colMax<<16
||[B2]	MV	.S2x	A6,B7			;init revTwiDen = rowMax<<15

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter1
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter1
||[B0]	OR	.S1	A4,A0,A4		;if(B0==1) flags=flags|04h ***end of signal check***

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter2
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter2
||[!B2]	MV	.S1	A6,A2			;init stdTwiRatio = rowMax<<15
||[!B2]	SHL	.S2	B6,1,B7			;init stdTwiDen = colMax<<16


  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter3
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter3

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter4
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter4

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter5
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter5

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter6
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter6

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter7
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter7

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter8
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter8

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter9
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter9

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter10
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter10

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter11
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter11

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter12
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter12

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter13
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter13

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter14
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter14
||	MVKL	.S2	0FFFFh,B4		;

  [A1]	SUBC	.L1	A5,A6,A5		;row2ndRatio iter15
||[B1]	SUBC	.L2	B5,B6,B5		;col2ndRatio iter15
||	MVKH	.S2	0,B4			;mask = 0000FFFFh

  [A1]	AND	.L1x	A5,B4,A5		;row2ndRatio = row2ndRatio & 0000FFFFh
||[B1]	AND	.L2	B5,B4,B5		;col2ndRatio = col2ndRatio & 0000FFFFh

	CMPGT	.L1	A5,A7,A1		;A1 = if(row2ndRatio>thres2ndHarmonics)
||	CMPGT	.L2x	B5,A7,B1		;B1 = if(col2ndRatio>thres2ndHarmonics)

  [A1]	OR	.S1	A4,A8,A4		;if(A1==1) flags=flags|40h ***end of row 2nd harm check ***
||[B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter1
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter1

  [B1]	OR	.S1	A4,A8,A4		;if(B1==1) flags=flags|40h ***end of col 2nd harm check ***
||[B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter2
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter2

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter3
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter3

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter4
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter4

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter5
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter5

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter6
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter6

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter7
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter7

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter8
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter8

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter9
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter9

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter10
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter10
||[B2]	MVK	.S1	_thresReverseTwist,A6	;
||[!B2]	MVK	.S2	_thresStandardTwist,B6	;

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter11
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter11
||[B2]	MVKH	.S1	_thresReverseTwist,A6	;
||[!B2]	MVKH	.S2	_thresStandardTwist,B6	;

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter12
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter12
||[B2]	LDH	.D1	*A6,A5			;A5 = thresReverseTwist
||[!B2]	LDH	.D2	*B6,B5			;B5 = thresStandardTwist

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter13
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter13

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter14
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter14

  [B2]	SUBC	.L1x	A2,B7,A2		;revTwiRatio iter15
||[!B2]	SUBC	.L2x	B7,A2,B7		;stdTwiRatio iter15

  [B2]	AND	.L1x	A2,B4,A2		;revTwiRatio = revTwiRatio & 0000FFFFh
||[!B2]	AND	.L2	B7,B4,B7		;stdTwiRatio = stdTwiRatio & 0000FFFFh

  [B2]	CMPLT	.L1	A2,A5,A1		;A1 = if(revTwiRatio<thresReverseTwist)
||[!B2]	CMPLT	.L2	B7,B5,B1		;B1 = if(stdTwiRatio<thresStandardTwist)
||	MVK	.S1	08h,A8			;A8 = 08h

  [A1]	OR	.S1	A4,A8,A4		;if(A1==1) flags = flags|08h

  [B1]	OR	.S1	A4,A8,A4		;if(B1==1) flags = flags|08h	

	B	.S2	B3			;return
	NOP		5
