#include "chorus.h"	// costanti che servono per l'effetto

/*********************************************************
 * Il coefficiente A ed i tre valori iniziali generano
 * un LFO (Low Frequency Oscillator) a 3Hz quando si
 * lavora ad una frequenza di campionamento di 8KHz.
 *********************************************************/
// y[1] = sin((2*pi*f)/fc)
// A = 2*cos((2*pi*f)/fc)

float y[3] = {0,0.002356192,0};
float A = 1.999994448;
 
// restituisce il ritardo variabile generato
// dall'LFO espresso in numero di campioni
short sineDelayGen(void) {
  y[0] = y[1] * A - y[2];
  y[2] = y[1];
  y[1] = y[0];

  return((short)( ( MAX_SWEEP_DEPTH_SAMPLES/2 )*y[0]) ) + (MAX_SWEEP_DEPTH_SAMPLES/2) + MIN_DELAY_SAMPLES;
}
