/**************************************************************\
 *  Prototypes
\**************************************************************/
short codec_in(void);
void codec_out(int value);
void codec_init(void);
void init_HWI(void);
void emif_init(void);

/**************************************************************\
 *  Include files
\**************************************************************/
#include <c6x.h>           // C6000 compiler definitions

#include <csl.h>           // CSL headers
#include <csl_irq.h>
#include <csl_mcbsp.h>

#include <bsl.h>           // BSL headers
#include <bsl_ad535.h>     // -i build option allows CCS to find these headers
#include <bsl_suggestions.h>
#include <std.h>
#include <log.h>

#define MIN_CICLI 10


/**************************************************************\
 *  Global Variables
\**************************************************************/
    /**********************************************************\
     *  The following AD535 Handle and Config structure were   
     *  entered verbatim from the BSL documentation. The config
     *  values are common to many applications; if nothing 
     *  else, they make a good starting point.               
    \**********************************************************/
    AD535_Handle hAD535;                                       
    AD535_Config my_AD535_Config = {                           
        AD535_LOOPBACK_DISABLE,                                
        AD535_MICGAIN_OFF,                                     
        AD535_GAIN_0DB,                                        
        AD535_GAIN_0DB                                         
    };                
    extern far LOG_Obj myLog;                                   
	short rumore=0;//usato per determinare il rumore
    unsigned int count=0;//usato per il conteggio del tempo
    int iniz=1;//inizializzazione del dispositivo
    int i=0;
    short in[2000];
    short in2[2000];
   
  
/**************************************************************\
 *  Main Routine
\**************************************************************/
void main()
{
for(i=0;i<2000;i++){
    	in[i]=0;
    	in2[i]=0;
    }
    i=0;
    CSL_init();              // Initialize CSL library
    BSL_init();              // Initialize BSL library
    emif_init();             // Dummy function - see note below
    codec_init();
    init_HWI();
    
 
    AD535_read(hAD535);  /* Read anything to cause mcbsp
    //                            to start transmit interrupts */

    /**************************************************\
     *  Rather than creating an infinite loop in main,
     *  DSP/BIOS provides an infinite idle (IDL) loop.
     *  All you need to do is return from main. 
    \**************************************************/                  
    
    return;
}

/**************************************************************\
 *	Configure External Memory Interface (EMIF)
 *
 *  We have a dummy function here to setup the EMIF. In a "real"
 *  system you would be required to setup the EMIF but in our
 *  development system CCS sets up the memory for us (refer to 
 *  the DSK6211_6711.gel file for the CCS script that 
 *  accomplishes this task.
\**************************************************************/
void emif_init(void){
}

/*************************************************************\
 *	Initialize hardware interrupts. 
 **************************************************************
 *  The AD535 codec is hardwired to McBSP0. Therefore,
 *	our system uses the McBSP0 transmit interrupt 
 *  (XINT0) to signal when to write the next output sample.
 *	
 *	Enabling the CPU to recognize the RINT0 interrupt requires:
 *
 *	1. Map McBSP0 receive interrupt (RINT0) to interrupt 11 (HWI11)
 *     using the Config Tool
 *	2. Enable interrupts globally
 *	3. Enable McBSP receive interrupt
\*************************************************************/
void init_HWI(void)
{
	IRQ_globalEnable();             // Enable ints globally
	IRQ_enable(IRQ_EVT_RINT0);     // Enable McBSP0 interrupt
}

// Interrupt service routine you need to reference in HWI module of CDB file
void RINT0_HWI(void)
{
	volatile short input;
	volatile short inband, inbass;
	input=codec_in();             

	inband=passabanda(input);

	if(inband<0)
		inband= -inband;

	inbass=passabasso(inband);
	
				
		//determinazione del rumore di fondo
if(i<2000 && iniz==1){//mi serve iniz per via dell'overflow di i;
	rumore+=inbass;
	i++;
}
else if(i==2000 && iniz==1){
	rumore=rumore/i;//media del rumore acquisito nei primi i cicli
	i++;
	//rumore=0;
}
	
//acquisizione segnale
else if(iniz==0 || i>2000){//all'inizio entro per i>0; poi valutazione abbreviata
	iniz=0;
	if(inbass>rumore){//presenza di segnale vocale
		count++;
	}
	else{//assenza di segnale vocale
		if(count>MIN_CICLI){//valuto la durata del segnale vocale appena terminato
			LOG_printf(&myLog,"Durata in secondi del segnale: %f\n", ((float) count)/8000);
			
			count=0;	
		}
		count=0;
	}
	in[i%2000]=inbass;
		in2[i%2000]=input;
	i=(i+1)%2000;
	

}
//	codec_out(input);

}

/**********************************************************\
 *	Codec Functions
\**********************************************************/
void codec_init()
{
	/* Use the BSL routines to:  Open, reset, & config the AD535               *\
	 * Part of the AD535_open() routine opens and configures the McBSP0, since *
	\*  all communications with the AD535 codec are handled via the McBSP0.    */
	hAD535 = AD535_open(AD535_localId);      // Open AD535 and set hAD535 handle
	AD535_reset(hAD535);                     // Reset AD535                     
	AD535_config(hAD535, &my_AD535_Config);   // Configure AD535                 
	
	/**************************************************\
	 *	This sets a bit in a McBSP register thus
	 *	allowing it to continue running even when the
	 *	debugger is halted. This keeps the codec from
	 *	being corrupted.
	 *
	 *  We've put this function in the "bsl_suggestions"
	\**************************************************/
	MCBSP_setfree(0);
}

/******************************************************\
 *	Output a sample to the AD535 codec.
\******************************************************/
short codec_in(void) 
{ 
	return AD535_HWI_read(hAD535);
}

/******************************************************\
 *	Read a sample from the AD535 codec.
\******************************************************/
void codec_out(int value)
{
	AD535_HWI_write(hAD535,value);
}
