/*********************************************************
 * The coefficient A and the three initial values
 * generate a 3KHz tone (sine wave) when running
 * at a sample rate of 8KHz.
 *
 * Even though the calculations are done in floating
 * point, this function returns a short value since
 * this is what's needed by a 16-bit codec (DAC).
 *********************************************************/
float z[3] = {0,0.7071,0};
float A = 1.0;

float sineGen(void) {
	z[0] = z[1] * A - z[2];  
	z[2] = z[1];
	z[1] = z[0];

	return(z[0]);
}



 float h[8]={0,0,0,0,0,0,0,0};
 float X[8]={0,0,0,0,0,0,0,0};
 float Y=0;
 float E=0;




// algoritmo lms: prende il segnale in ingresso (segnale+rumore) e cerca di approssimare l'uscita ad una sinusoide   
// a 3Khz (segnale desiderato) 

float lms(float input)
{
	int N=8;
 	int i;
	float er,D;
	float beta = 0.1;
		
	X[0] = input/32768; 
	D = sineGen();
	Y=0;
	
	for(i=0;i<N;i++)
		Y +=(h[i] * X[i]);
	
	E = D-Y;	

	er =beta * E; 	

	for(i=N-1;i>=0;i--)
	{	h[i] = h[i] + (er * X[i]) ;
		X[i]=X[i-1];	}
	   
	return Y;
}





