#include "HI5_LIB.H"
#include <values.h>

#define TETA  0.2*M_PI
#define Fc 16

STRUCT_IMR imr;             /* You need to include external structures, */
PARAMETER prm;              /* variables, constants, etc HERE if you    */
extern MSGRx, MSGRy;        /* plan to use them in MAIN                 */
extern pcom;                /* (commport address)                       */
extern  char appfile[] = "iir.dsk";

float butterAI[]={1, -1.76, 1.1829, -0.2781};
float butterBJ[]={0.0181, 0.0543, 0.0543, 0.0181};

float chebyAI[]={1, -1.7848, 1.3253, -0.3637};
float chebyBJ[]={0.022091, 0.066273, 0.066273, 0.022091};

float ellipAI[]={1, -1.7887, 1.3473, -0.3673};
float ellipBJ[]={0.055, 0.0407, 0.0407, 0.055};

void moltiplica(float m[7][4], float v[4], float res[7]);

int main(void)             /* See HI5_LIB.H for data types             */
{
  MSGRy=5;

 /*---------------------------------------------------------------------*/
 /* It is suggested you use the following code to properly initialize   */
 /* the DSK and load your application file to the DSK                   */
  clrscr();
  prm.com = 0;              /* Set commport (1)                         */
  prm.speed = 19200;        /* Set baudrate                             */
  prm.PGM_CNT = 0x980;      /* Set DSP program counter                  */
  prm.INVERSE = YES;        /* Set inverse pin for most common          */
  GetArguments();           /* Get any command line agruments           */
  InitializeMonitor();      /* Init communication with DSK              */
  LoadDsk();                /* Load the application file to the DSK     */
  InitRegister(YES);        /* Init DSP internal registers (optional)   */
  FreeRun(0x0a00);

  float F0, Bw, w1, w2, alfa,k,A,B;
  float mat[7][4];
  float at[7];
  float bt[7];
  int i,j;
  int ans;
  int finito=0;
  float mx;
  int atsend[7];
  int btsend[7];
  float AI[4];
  float BJ[4];

  printf("\n\nIl DSP  stato avviato con un filtro di Chebyshev con F0=4 kHz e Bw=0.8 kHz\n");
  F0=4.0;
  Bw=0.8;
  while(!finito) {
    printf("\n1. Cambia il tipo di filtro.\n");
    printf("2. Modifica F0.\n");
    printf("3. Modifica Bw.\n");
    printf("4. Avvia l'esecuzione.\n");
    printf("5. Esci\n");
    scanf("%d",&ans);

    switch(ans) {
      case 1:
	int filt;
	printf("Seleziona il tipo:\n");
	printf("1. Butterworth.\n");
	printf("2. Chebyshev.\n");
	printf("3. Elliptic.\n");
	scanf("%d",&filt);
	switch(filt) {
	  case 1:
	    for(i=0;i<4;i++) {
	      AI[i]=butterAI[i];
	      BJ[i]=butterBJ[i];
	    }
	    break;
	  case 2:
	    for(i=0;i<4;i++) {
	      AI[i]=chebyAI[i];
	      BJ[i]=chebyBJ[i];
	    }
	    break;
	  case 3:
	    for(i=0;i<4;i++) {
	      AI[i]=ellipAI[i];
	      BJ[i]=ellipBJ[i];
	    }
	    break;
	}
	break;
      case 2:
	printf("Immetti il nuovo valore di F0 (kHz): ");
	scanf("%f",&F0);
	break;
      case 3:
	printf("Immetti il nuovo valore di Bw (kHz): ");
	scanf("%f",&Bw);
	break;
      case 4:
	clrscr();

	w1=2*M_PI*(F0-Bw/2)/Fc;
	w2=2*M_PI*(F0+Bw/2)/Fc;

	alfa=cos((w1+w2)/2)/cos((w2-w1)/2);
	k=tan(TETA/2)/tan((w2-w1)/2);
	A=2*alfa*k/(k+1);
	B=(k-1)/(k+1);

	mat[0][0]=-1;
	mat[1][0]=3*A;
	mat[2][0]=-(3*pow(A,2)+3*B);
	mat[3][0]=pow(A,3)+6*A*B;
	mat[4][0]=-(3*pow(A,2)*B+3*pow(B,2));
	mat[5][0]=3*A*pow(B,2);
	mat[6][0]=-pow(B,3);

	mat[0][1]=B;
	mat[1][1]=-(2*A*B+A);
	mat[2][1]=pow(A,2)*B+2*pow(A,2)+2*pow(B,2)+1;
	mat[3][1]=-(pow(A,3)+2*A*pow(B,2)+2*A*B+2*A);
	mat[4][1]=2*pow(A,2)*B+pow(B,3)+pow(A,2)+2*B;
	mat[5][1]=-(A*pow(B,2)+2*A*B);
	mat[6][1]=pow(B,2);

	for (i=0;i<7;i++) {
	  for (j=2;j<4;j++) {
	    mat[i][j]=-mat[6-i][3-j];
	  }
	}

	moltiplica(mat,AI,at);
	moltiplica(mat,BJ,bt);

	mx=at[0];
	for (i=0;i<7;i++) {
	  at[i]=at[i]/mx;
	  bt[i]=bt[i]/mx;
	}


	for (i=0;i<7;i++) {
	  atsend[i]=at[i]*32768/32;
	  btsend[i]=bt[i]*32768;
	}

	InitializeMonitor();      /* Init communication with DSK              */
	LoadDsk();                /* Load the application file to the DSK     */
	InitRegister(YES);        /* Init DSP internal registers (optional)   */

	// Invio i parametri del filtro al DSK

	sendcommand(LD,0x0f05,13);
	for (i=6;i>=1;i--)
	  sendword(atsend[i]);
	for (i=6;i>=0;i--)
	  sendword(btsend[i]);

	// Avvio l'esecuzione
	FreeRun(0x0a00);
	printf("\n\nIl DSP  stato avviato con i parametri immessi.\n");
	break;
      case 5:
	finito=1;
	reset50();
	break;
    }

  }
  return 0;
}

void moltiplica(float m[7][4], float v[4], float res[7]) {
  int i,j;
  for (i=0;i<7;i++) {
    res[i]=0;
    for(j=0;j<4;j++)
      res[i] = res[i] + m[i][j] * v[j];
  }
}


