/* -------------------------------------------------------------------- */
/* File: HI_5LIB.CPP -> Host Interface Library Source Code   Ver 1.00   */
/* -------------------------------------------------------------------- */

#include "HI5_LIB.H"

FILE    *stream;
extern char appfile[];          /* app filename with .DSK extension      */

extern int  MSGRx=2,MSGRy=21;   /* x&y coordinates of messenger window  */
extern UINT pcom=0;            /* commport address                      */
extern PARAMETER prm;          /* you can use these in main             */
extern STRUCT_IMR imr;         /*                                       */
/* -------------------------------------------------------------------- */

void InitializeMonitor(void)
{
      InitPort();
      BaudRateDetect();
		delay(2);
      switch(InitMonitor()){
	case NORESPONSE: MSGR("Didn't get response from DSP"); break;
	case TESTERROR:  MSGR("Didn't return right value"); break;
	case NOESCAPE:   MSGR("Didn't receive ESC from DSP"); break;
	case GOOD:       MSGR("DSK is functioning properly!");
			 return;
		}
		delay(1000);
		exit(0);

}

void comout(UINT send)
{
  WaitFor(XMT_BUF_EMPTY);        /* wait for buff empty                 */
  outportb(pcom,send);           /* send a byte                         */
}

UINT newchar(void) /* checks to see if a new character has arrived */
{
  if (inportb(pcom+LSR) & DATA_READY)
	 return 1;
  return 0;
}

UCHAR comin(void) /* gets a pending input character */
{
  delay(1);
  return  inportb(pcom);

}

/* --------------------------------------------------------------------  */


void sendbyte(UINT send)
{
  WaitFor(XMT_BUF_EMPTY);        /* wait for buff empty                 */
  outportb(pcom,send);           /* send a byte                         */
  WaitFor(DATA_READY);           /* wait for data received              */
  delay(1);
  UINT receive=inportb(pcom);
  if (receive != send)
	  MSGR("DSK did not receive correct data.  ");

}
/* -------------------------------------------------------------------   */


UINT sendword(UINT send)
{
  WaitFor(XMT_BUF_EMPTY);      /* wait for empty                 */
  UINT s1 = (send>>8)&0xff;
  outportb(pcom,s1);           /* send high byte of end address  */

  WaitFor(DATA_READY);         /* wait for data received         */
  delay(1);
  UINT receive=inportb(pcom);

  WaitFor(XMT_BUF_EMPTY);
  s1 = send&0xff;
  outportb(pcom,s1);        /* send low  byte of end address     */

  WaitFor(DATA_READY);      /* wait for data received            */
  delay(1);
  if((receive=(receive<<8)+inportb(pcom))!=send)
     MSGR("DSK did not receive correct word.   ");

  return receive; /* return sent word for check if necessary     */
}
/* -------------------------------------------------------------------  */


BOOLE FreeRun(UINT address)
{
  sendbyte(XG); sendword(address);    /* execute         */
  outportb(pcom,NULL);                /* Startpulse      */


  return NO;
}
/* -------------------------------------------------------------------  */


void WaitFor(UINT what)
{
  int j=5000,i=j;

  while(!(inportb(pcom+LSR) & what) && i--);
  if(i<1)
    MSGR("Wait loop finished in WaitFor()    ");

}
/* -------------------------------------------------------------------  */


void InitPort(void)
{
  UINT  COMADD[]={0x3f8, 0x2f8, 0x3e8, 0x2e8};
  int   BRD=115200l/prm.speed;
  pcom = COMADD[prm.com];
  UINT port_no=pcom;

  asm  mov  DX,word ptr port_no
  asm  add  DX,3
  asm  mov  AL,0x87              /* SET BAUD access             */
  asm  out  DX,AL
  asm  sub  DX,3
  asm  mov  AX,word ptr BRD      /* LO   Set 19200 baud         */
  asm  out  DX,AL
  asm  add  DX,1
  asm  mov  AL,byte ptr BRD      /* HI                          */
  asm  xchg AL,AH
  asm  out  DX,AL
  asm  sub  DX,1
  asm  add  DX,3
  asm  mov  AL,0x7               /* CLR BAUD access...  N-8-2           */
  asm  out  DX,AL
  asm  out  DX,AL                /* N-8-2                               */
  asm  mov  DX,port_no           /* 0x3FC 0x2FC  modem control register */
  asm  add  DX,5                 /* check LINE_STATUS  0x2FD  0x3FD (+5)*/
xempty0:
  asm  in   AL,DX
  asm  and  AL,0x60              /* wait for DXR&TXR to empty before RST*/
  asm  cmp  AL,0x60
  asm  jne  xempty0

}
/* -------------------------------------------------------------------  */


INITMONITOR InitMonitor(void)
{
  int  i=10000;
  int  ans=inportb(pcom+LSR);

  while(!(ans & DATA_READY) && i){  /* data received?           */
	ans = inportb(pcom+LSR);
	i--;
  }


	if(i<1)
      return  NORESPONSE;
   if( inportb(pcom)!=KB_ESC)
       return NOESCAPE;

   UINT send=0x55;               /* test for reponse with random pattern */
   WaitFor(XMT_BUF_EMPTY);       /* wait for buff empty                  */
   outportb(pcom,send);          /* send a byte                          */
   WaitFor(DATA_READY);          /* wait for data received               */
   delay(1);
   if (inportb(pcom)!=send)
       return TESTERROR;
   WaitFor(XMT_BUF_EMPTY);       /* wait for buff empty         */
	outportb(pcom,(send=KB_ESC)); /* send a byte                 */
   WaitFor(DATA_READY);          /* wait for data received      */
   delay(1);
   if (inportb(pcom)==send){
       return GOOD;                /* all tests are successful!   */
   }
   return TESTERROR;               /* Failed test                 */
}
/* -------------------------------------------------------------------  */


void reset50()
{
  UINT  port_no=pcom;
  if(prm.INVERSE) {                /* do inverse DTR for reset of c50    */
     asm  mov  DX,word ptr port_no /*modem control register  02FC 03FC   */
     asm  add  DX,4                /*                                    */
     asm  mov  AL,0xB              /* RTS=1, DTR=0                       */
     asm  out  DX,AL
     delay(1);
     asm  mov  DX,word ptr port_no /* modem control register    */
     asm  add  DX,4
     asm  mov  AL,0xA              /* RTS=1, DTR=0               */
     asm  out  DX,AL
     delay(1);
	  asm  mov  DX,word ptr port_no /* modem control register     */
     asm  add  DX,4
     asm  mov  AL,0xB             /* RTS=1, DTR=0               */
     asm  out  DX,AL
     delay(1);
  }
  else  {        /* else we have hardware negate function from PC to c50*/
     asm  mov  DX,word ptr port_no /* modem control register            */
     asm  add  DX,4
     asm  mov  AL,0xA              /* RTS=1, DTR=0       */
     asm  out  DX,AL
     delay(1);
	  asm  mov  DX,word ptr port_no /* modem control register    */
     asm  add  DX,4
     asm  mov  AL,0xB              /* RTS=1, DTR=0       */
     asm  out  DX,AL
     delay(1);
     asm  mov  DX,word ptr port_no /* modem control register    */
     asm  add  DX,4
     asm  mov  AL,0xA              /* RTS=1, DTR=0               */
     asm  out  DX,AL
     delay(1);
  }
}
/* -------------------------------------------------------------------  */


void BaudRateDetect()
{
 reset50();
 delay(12);
 if(prm.speed<57600){
    while(!(inportb(pcom+LSR) & XMT_BUF_EMPTY));
    outportb(pcom,0x80);    /* write a byte to the com port (320c50) */
 }

 else
	 outportb(pcom,0x80);    /* write a byte to the com port (320c50) */
}
/* -------------------------------------------------------------------  */


UINT getwordcom(void)
{
 WaitFor(XMT_BUF_EMPTY);
 outportb(pcom,NULL);  /* write a NULL to the com port (320c50) */
 WaitFor(DATA_READY);
 delay(1);
 UINT high=inportb(pcom)<<8;
 outportb(pcom,NULL);  /* write a NULL to the com port (320c50) */
 WaitFor(DATA_READY);
 delay(1);
 high+=inportb(pcom);
 return high;
}
/* -------------------------------------------------------------------- */


void InitRegister(BOOLE all)
{
  imr.add=4;
  imr.user=imr.debug=2;
  imr.modified=NO;
  SendDataWord(imr.add,imr.debug);
  SendDataWord(STACK,prm.PGM_CNT);
  if(!all)
    return;

  sendcommand(LD,ACCU,8);
  sendword(0);    /* Accu        */
  sendword(0);
  sendword(0);    /* Accb        */
  sendword(0);
  sendword(0);    /* Preg        */
  sendword(0);
  sendword(prm.INIT_ST0);
  sendword(prm.INIT_ST1);
  SendDataWord(TIMER,0xffff);  /* TIMER  */
  SendDataWord(TREG,0);        /* TREG   */
  int i=10;
  sendcommand(LD,STACK+1,i);
  for(;i;i--){
      sendword(0);}
}
/* -------------------------------------------------------------------- */


double LoadDsk(void)
{
  char    linebuf[MAXLINE], *pbuf=linebuf;
  UINT    data[MAXLINE]; /* max 100. words to download */
  UINT    numdata=0;     /* num of words to download   */
  ULONG   sumdata=0;     /* sum of all downloaded words */
  UINT    address;       /* address for     download     */
  BOOLE   program;       /* type: if program 'yes' , no if data 'no' */
  if ((stream = fopen(appfile, "r")) == NULL)
  {
	MSGR("Cannot open Application file.");
	fcloseall();
	return 0;
  }
 while(1)
   {
     pbuf=fgets(linebuf,MAXLINE,stream);

     switch(*pbuf)
     {
	case  ':':
	case NULL: fclose(stream);
		   MSGR("Loading complete             ");
		   fcloseall();
		   return 0;
	case  'K': numdata=0;break;
	case  '9': address=GetDskAdd(pbuf+1); /* DSK for an address      */
		   switch(*(pbuf+5))
		     {
		      case '7': break;
		      case 'M': program=NO; break;
		      case 'B': program=YES; break;
		      default : MSGR("Error 1: Corrupted Tag in DSK file");
				return 0;
		     }
		   numdata=GetDskData(pbuf+5,data);
		   sumdata +=numdata;
		   break;
	case  '1': address=GetDskAdd(pbuf+1);          /* Entry address */
		   if(address==0 || prm.PGM_CNT>0)
		     break; /* dska generates addr=0 if no entry defined*/
		   else
		      prm.PGM_CNT=address;
		   break;
	default  : MSGR("Error: 'Corrupted tag value in DSK file");
		   return 0;
     }

     if(numdata)                                    /* download line   */
     {
		 UINT i,cmd=(program==YES) ? LP:LD;

       sendcommand((c50COMMANDS) cmd,address,numdata);
       for(i=0;i<numdata;i++)
	   sendword(data[i]);

      }
   }
}
/* -------------------------------------------------------------------- */


UINT GetDskAdd(STRING pbuf)
{
 UINT x=0,i=4;
 char c=*pbuf++;
 for(;i;i--,c=*pbuf++)
   {
    x =(x<<4) + c;
    if(isdigit(c))
      x -= '0';
    else
      x -= 'A'-10;
   }
 return x;
}
/* -------------------------------------------------------------------  */


UINT GetDskData(STRING pbuf,UINT *data)
{
  UINT x,num=0,i;
  UCHAR c;

  while(*(pbuf++)!='7')
   {
    for(*data=0,i=4;i;i--)
      {
		 c = *pbuf++;
       *data<<=4;
       if(isdigit(c))
	 *data +=c-'0';
       else
	 *data +=c-'A'+10;
      }
     data++;
     num++;
   }

  return num;
}
/* -------------------------------------------------------------------  */


void GetArguments(void)
{
 int i=0, c=0, k=0;
 extern char **_argv;
 extern int   _argc;
 char   *ptr, *endptr;
 long sp=0;
 for(i = 1; i < _argc; k=0, i++){
     while((c=_argv[i][k])!=0){ /* loop the entire argument      */
	  if((c=='-') || (c=='\\')){
	       k++;
	       c = _argv[i][k];
	    }
	    else{ return;}
	    strupr(_argv[i]);
	    switch(toupper(c)){
			case 'B':
			while(isdigit(c=_argv[i][++k]))
			      sp=sp*10+c-'0';
			if( (115200L % sp) == 0l )
				 prm.speed=sp;
			else
			    MSGR("ERROR: Invalid baudrate\n");
			break;
			case 'C': while(!isdigit(_argv[i][k])) k++;
			c = _argv[i][k++];
			switch(c){
			  case '1':
			  case '2': prm.com=c-'1';break;
			  case '3': case '4': /* illegal in this version*/
			  default : MSGR("ERROR: Invalid comport\n");
			}
			break;
	      case 'I': prm.INVERSE=NO;k++;break;
		 }
     }
 }
}
/* -------------------------------------------------------------------- */


void MSGR(char *message)
{
	movetext(MSGRx,MSGRy+1,MSGRx+35,MSGRy+1,MSGRx,MSGRy);
	/* move text up one line */
	movetext(MSGRx,MSGRy+2,MSGRx+35,MSGRy+2,MSGRx,MSGRy+1);
	gotoxy(MSGRx,MSGRy+2);
	cprintf("      			           ");
	gotoxy(MSGRx,MSGRy+2);cprintf("%s",message);
}
/* -------------------------------------------------------------------- */

unsigned char rcvdata(int port_no)
{
  unsigned char c;
  asm  mov  DX,word ptr port_no // RECV a character
  asm  add  DX,5                // check LINE_STATUS  0x2FD  0x3FD (+5)
  asm  mov  BX,4000             //
chkst:                          //
  asm  sub  bx,1                //
  asm  jz   timerr              //
  asm  in   AL,DX               //
  asm  and  AL,061h             //
  asm  cmp  AL,061h             //
  asm  jne  chkst               // wait for DRR & RSR to fill
  asm  sub  DX,5                //
  asm  in   AL,DX               //
  asm  mov  byte ptr c,AL       //
  return(c);                    //
timerr:                         //
    return(-1);                 //
}
