Attribute VB_Name = "VBIB32"
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   This module contains the subroutine declarations,
'   function declarations and constants required to use
'   the National Instruments GPIB Dynamic Link Library
'   (DLL) for controlling IEEE-488 instrumentation.  This
'   file must be 'added' to your Visual Basic project
'   (by choosing Add File from the File menu or pressing
'   CTRL+F12) so that you can access the NI-488.2
'   subroutines and functions.
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   NI-488 DLL entry function declarations

Declare Function ibask32 Lib "Gpib-32.dll" Alias "ibask" (ByVal ud&, ByVal opt&, sstr As Any) As Long
Declare Function ibbna32 Lib "Gpib-32.dll" Alias "ibbnaA" (ByVal ud&, sstr As Any) As Long
Declare Function ibcac32 Lib "Gpib-32.dll" Alias "ibcac" (ByVal ud&, ByVal v%) As Long
Declare Function ibclr32 Lib "Gpib-32.dll" Alias "ibclr" (ByVal ud&) As Long
Declare Function ibcmd32 Lib "Gpib-32.dll" Alias "ibcmd" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibcmda32 Lib "Gpib-32.dll" Alias "ibcmda" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibconfig32 Lib "Gpib-32.dll" Alias "ibconfig" (ByVal ud&, ByVal opt&, ByVal v&) As Long
Declare Function ibdev32 Lib "Gpib-32.dll" Alias "ibdev" (ByVal bdid&, ByVal pad&, ByVal sad&, ByVal tmo&, ByVal eot&, ByVal eos&) As Long
Declare Function ibdiag32 Lib "Gpib-32.dll" Alias "ibdiag" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibdma32 Lib "Gpib-32.dll" Alias "ibdma" (ByVal ud&, ByVal v&) As Long
Declare Function ibeos32 Lib "Gpib-32.dll" Alias "ibeos" (ByVal ud&, ByVal v&) As Long
Declare Function ibeot32 Lib "Gpib-32.dll" Alias "ibeot" (ByVal ud&, ByVal v&) As Long
Declare Function ibevent32 Lib "Gpib-32.dll" Alias "ibevent" (ByVal ud&, eevent&) As Long
Declare Function ibfind32 Lib "Gpib-32.dll" Alias "ibfindA" (sstr As Any) As Long
Declare Function ibgts32 Lib "Gpib-32.dll" Alias "ibgts" (ByVal ud&, ByVal v&) As Long
Declare Function ibist32 Lib "Gpib-32.dll" Alias "ibist" (ByVal ud&, ByVal v&) As Long
Declare Function iblines32 Lib "Gpib-32.dll" Alias "iblines" (ByVal ud&, v&) As Long
Declare Function ibln32 Lib "Gpib-32.dll" Alias "ibln" (ByVal ud&, ByVal pad&, ByVal sad&, ln&) As Long
Declare Function ibloc32 Lib "Gpib-32.dll" Alias "ibloc" (ByVal ud&) As Long
Declare Function ibonl32 Lib "Gpib-32.dll" Alias "ibonl" (ByVal ud&, ByVal v&) As Long
Declare Function ibpad32 Lib "Gpib-32.dll" Alias "ibpad" (ByVal ud&, ByVal v&) As Long
Declare Function ibpct32 Lib "Gpib-32.dll" Alias "ibpct" (ByVal ud&) As Long
Declare Function ibpoke32 Lib "Gpib-32.dll" Alias "ibpoke" (ByVal ud&, ByVal opt&, ByVal v&) As Long
Declare Function ibppc32 Lib "Gpib-32.dll" Alias "ibppc" (ByVal ud&, ByVal v&) As Long
Declare Function ibrd32 Lib "Gpib-32.dll" Alias "ibrd" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibrda32 Lib "Gpib-32.dll" Alias "ibrda" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibrdf32 Lib "Gpib-32.dll" Alias "ibrdfA" (ByVal ud&, sstr As Any) As Long
Declare Function ibrdi32 Lib "Gpib-32.dll" Alias "ibrd" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibrdia32 Lib "Gpib-32.dll" Alias "ibrda" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibrdkey32 Lib "Gpib-32.dll" Alias "ibrdkey" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibrpp32 Lib "Gpib-32.dll" Alias "ibrpp" (ByVal ud&, sstr As Any) As Long
Declare Function ibrsc32 Lib "Gpib-32.dll" Alias "ibrsc" (ByVal ud&, ByVal v&) As Long
Declare Function ibrsp32 Lib "Gpib-32.dll" Alias "ibrsp" (ByVal ud&, sstr As Any) As Long
Declare Function ibrsv32 Lib "Gpib-32.dll" Alias "ibrsv" (ByVal ud&, ByVal v&) As Long
Declare Function ibsad32 Lib "Gpib-32.dll" Alias "ibsad" (ByVal ud&, ByVal v&) As Long
Declare Function ibsic32 Lib "Gpib-32.dll" Alias "ibsic" (ByVal ud&) As Long
Declare Function ibsre32 Lib "Gpib-32.dll" Alias "ibsre" (ByVal ud&, ByVal v&) As Long
Declare Function ibstop32 Lib "Gpib-32.dll" Alias "ibstop" (ByVal ud&) As Long
Declare Function ibtmo32 Lib "Gpib-32.dll" Alias "ibtmo" (ByVal ud&, ByVal v&) As Long
Declare Function ibtrg32 Lib "Gpib-32.dll" Alias "ibtrg" (ByVal ud&) As Long
Declare Function ibwait32 Lib "Gpib-32.dll" Alias "ibwait" (ByVal tmpUD&, ByVal tmpmask&) As Long
Declare Function ibwrt32 Lib "Gpib-32.dll" Alias "ibwrt" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibwrta32 Lib "Gpib-32.dll" Alias "ibwrta" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibwrtf32 Lib "Gpib-32.dll" Alias "ibwrtfA" (ByVal ud&, sstr As Any) As Long
Declare Function ibwrti32 Lib "Gpib-32.dll" Alias "ibwrti" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibwrtia32 Lib "Gpib-32.dll" Alias "ibwrtia" (ByVal ud&, sstr As Any, ByVal cnt&) As Long
Declare Function ibwrtkey32 Lib "Gpib-32.dll" Alias "ibwrtkey" (ByVal ud&, sstr As Any, ByVal cnt&) As Long

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   NI-488.2 DLL entry function declarations

Declare Sub AllSpoll32 Lib "Gpib-32.dll" Alias "AllSpoll" (ByVal ud&, arg1 As Any, arg2 As Any)
Declare Sub DevClear32 Lib "Gpib-32.dll" Alias "DevClear" (ByVal ud&, ByVal v&)
Declare Sub DevClearList32 Lib "Gpib-32.dll" Alias "DevClearList" (ByVal ud&, arg1 As Any)
Declare Sub EnableLocal32 Lib "Gpib-32.dll" Alias "EnableLocal" (ByVal ud&, arg1 As Any)
Declare Sub EnableRemote32 Lib "Gpib-32.dll" Alias "EnableRemote" (ByVal ud&, arg1 As Any)
Declare Sub FindLstn32 Lib "Gpib-32.dll" Alias "FindLstn" (ByVal ud&, arg1 As Any, arg2 As Any, arg3 As Any)
Declare Sub FindRQS32 Lib "Gpib-32.dll" Alias "FindRQS" (ByVal ud&, arg1 As Any, result&)
Declare Sub PassControl32 Lib "Gpib-32.dll" Alias "PassControl" (ByVal ud&, ByVal addr&)
Declare Sub PPoll32 Lib "Gpib-32.dll" Alias "PPoll" (ByVal ud&, sstr As Any)
Declare Sub PPollConfig32 Lib "Gpib-32.dll" Alias "PPollConfig" (ByVal ud&, ByVal addr&, ByVal line&, ByVal sense&)
Declare Sub PPollUnconfig32 Lib "Gpib-32.dll" Alias "PPollUnconfig" (ByVal ud&, arg1 As Any)
Declare Sub RcvRespMsg32 Lib "Gpib-32.dll" Alias "RcvRespMsg" (ByVal ud&, arg1 As Any, ByVal cnt&, ByVal term&)
Declare Sub ReadStatusByte32 Lib "Gpib-32.dll" Alias "ReadStatusByte" (ByVal ud&, ByVal addr&, arg1 As Any)
Declare Sub Receive32 Lib "Gpib-32.dll" Alias "Receive" (ByVal ud&, ByVal addr&, arg1 As Any, ByVal cnt&, ByVal term&)
Declare Sub ReceiveSetup32 Lib "Gpib-32.dll" Alias "ReceiveSetup" (ByVal ud&, ByVal addr&)
Declare Sub ResetSys32 Lib "Gpib-32.dll" Alias "ResetSys" (ByVal ud&, arg1 As Any)
Declare Sub Send32 Lib "Gpib-32.dll" Alias "Send" (ByVal ud&, ByVal addr&, sstr As Any, ByVal cnt&, ByVal term&)
Declare Sub SendCmds32 Lib "Gpib-32.dll" Alias "SendCmds" (ByVal ud&, sstr As Any, ByVal cnt&)
Declare Sub SendDataBytes32 Lib "Gpib-32.dll" Alias "SendDataBytes" (ByVal ud&, sstr As Any, ByVal cnt&, ByVal term&)
Declare Sub SendIFC32 Lib "Gpib-32.dll" Alias "SendIFC" (ByVal ud&)
Declare Sub SendList32 Lib "Gpib-32.dll" Alias "SendList" (ByVal ud&, arg1 As Any, arg2 As Any, ByVal cnt&, ByVal term&)
Declare Sub SendLLO32 Lib "Gpib-32.dll" Alias "SendLLO" (ByVal ud&)
Declare Sub SendSetup32 Lib "Gpib-32.dll" Alias "SendSetup" (ByVal ud&, arg1 As Any)
Declare Sub SetRWLS32 Lib "Gpib-32.dll" Alias "SetRWLS" (ByVal ud&, arg1 As Any)
Declare Sub TestSys32 Lib "Gpib-32.dll" Alias "TestSys" (ByVal ud&, arg1 As Any, arg2 As Any)
Declare Sub Trigger32 Lib "Gpib-32.dll" Alias "Trigger" (ByVal ud&, ByVal addr&)
Declare Sub TriggerList32 Lib "Gpib-32.dll" Alias "TriggerList" (ByVal ud&, arg1 As Any)

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'   DLL entry function declarations needed for GPIB global variables

Declare Function RegisterGpibGlobalsForThread Lib "Gpib-32.dll" (Longibsta&, Longiberr&, Longibcnt&, ibcntl&) As Long
Declare Function UnregisterGpibGlobalsForThread Lib "Gpib-32.dll" () As Long


Sub AllSpoll(ud%, addrs%(), results%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
 
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    
' Call the 32-bit DLL.
    Call AllSpoll32(ByVal tmpUD&, addrs%(0), results%(0))
    
    Call copy_ibvars
End Sub

Sub copy_ibvars()
    ibsta% = ConvertLongToInt(Longibsta&)
    iberr% = CInt(Longiberr&)
    ibcnt% = ConvertLongToInt(ibcntl&)
End Sub

Sub DevClear(ud%, addr%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)

' Call the 32-bit DLL.
    Call DevClear32(ByVal tmpUD&, ByVal tmpaddr&)
    
    Call copy_ibvars
End Sub

Sub DevClearList(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call DevClearList32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub EnableLocal(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call EnableLocal32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub EnableRemote(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call EnableRemote32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub FindLstn(ud%, addrs%(), results%(), limit%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
  
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmplimit& = CLng(limit%)

' Call the 32-bit DLL.
    Call FindLstn32(ByVal tmpUD&, addrs%(0), results%(0), ByVal tmplimit&)
    
    Call copy_ibvars

End Sub

Sub FindRQS(ud%, addrs%(), result%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call FindRQS32(ByVal tmpUD&, addrs%(0), tmpresult&)

    result% = ConvertLongToInt(tmpresult&)
    
    Call copy_ibvars
End Sub

Sub ibask(ud%, opt%, rval%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters to Longs.
    tmpUD& = CLng(ud%)
    tmpopt& = CLng(opt%)

' Call the 32-bit DLL.
    rc& = ibask32(ByVal tmpUD&, ByVal tmpopt&, tmprval&)

    rval% = ConvertLongToInt(tmprval&)

    Call copy_ibvars
End Sub

Sub ibbna(ud%, udname$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibbna32(ByVal tmpUD&, ByVal udname$)

    Call copy_ibvars
End Sub

Sub ibcac(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters to Longs.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibcac32(ByVal tmpUD&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub ibclr(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    
'  Call the 32-bit DLL.
    tmp& = ibclr32(ByVal tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibcmd(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

    cnt& = CLng(Len(buf$))
    
'  Call the 32-bit DLL.
    rc& = ibcmd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibcmda(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    
'  Call the 32-bit DLL.
    rc& = ibcmd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

' When Visual Basic remapping buffer problem solved, then use:
'    rc& = ibcmda32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibconfig(bdid%, opt%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(bdid%)
    tmpopt& = CLng(opt%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibconfig32(ByVal tmpUD&, ByVal tmpopt&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibdev(bdid%, pad%, sad%, tmo%, eot%, eos%, ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpID& = CLng(bdid%)
    tmppad& = CLng(pad%)
    tmpsad& = CLng(sad%)
    tmptmo& = CLng(tmo%)
    tmpeot& = CLng(eot%)
    tmpeos& = CLng(eos%)
    
' Call the 32-bit DLL.
    tmpUD& = ibdev32(ByVal tmpID&, ByVal tmppad&, ByVal tmpsad&, ByVal tmptmo&, ByVal tmpeot&, ByVal tmpeos&)

    ud% = ConvertLongToInt(tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibdiag(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

    cnt& = CLng(Len(buf$))
    
'  Call the 32-bit DLL.
    rc& = ibdiag32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibdma(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibdma32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibeos(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibeos32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibeot(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibeot32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibevent(ud%, eevent%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibevent32(ByVal tmpUD&, tmpv&)

    eevent% = ConvertLongToInt(tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibfind(udname$, ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Call the 32-bit DLL.
    rc& = ibfind32(ByVal udname$)

    ud% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Sub

Sub ibgts(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibgts32(ByVal tmpUD&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub ibist(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibist32(ByVal tmpUD&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub iblines(ud%, lines%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = iblines32(ByVal tmpUD&, tmplines&)

    lines% = ConvertLongToInt(tmplines&)

    Call copy_ibvars
End Sub

Sub ibln(ud%, pad%, sad%, ln%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmppad& = CLng(pad%)
    tmpsad& = CLng(sad%)

'  Call the 32-bit DLL.
    rc& = ibln32(ByVal tmpUD&, ByVal tmppad&, ByVal tmpsad&, tmpln&)

    ln% = ConvertLongToInt(tmpln&)

    Call copy_ibvars
End Sub

Sub ibloc(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibloc32(ByVal tmpUD&)

    Call copy_ibvars
End Sub

Sub ibonl(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)
    
' Call the 32-bit DLL.
    rc& = ibonl32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibpad(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibpad32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibpct(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibpct32(ByVal tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibpoke(bdid%, opt%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(bdid%)
    tmpopt& = CLng(opt%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibpoke32(ByVal tmpUD&, ByVal tmpopt&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub ibppc(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibppc32(ByVal tmpUD&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub ibrd(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    
' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibrda(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

    cnt& = CLng(Len(buf$))
    
' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
   
' When Visual Basic remapping buffer problem solved, use this:
'    rc& = ibrda32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibrdf(ud%, filename$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrdf32(ByVal tmpUD&, ByVal filename$)
    
    Call copy_ibvars
End Sub

Sub ibrdi(ud%, ibuf%(), cnt&)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibrdia(ud%, ibuf%(), cnt&)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, then use:
'    rc& = ibrda32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibrdkey(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

    cnt& = CLng(Len(buf$))
    
' Call the 32-bit DLL.
    rc& = ibrdkey32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibrpp(ud%, ppr%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    Static tmp_str As String * 2

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrpp32(tmpUD&, ByVal tmp_str$)

    ppr% = Asc(tmp_str$)
    
    Call copy_ibvars
End Sub

Sub ibrsc(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibrsc32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibrsp(ud%, rsp%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    Static tmp_str As String * 2

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL
    rc& = ibrsp32(ByVal tmpUD&, ByVal tmp_str$)
    
    rsp% = Asc(tmp_str$)
    
    Call copy_ibvars
End Sub

Sub ibrsv(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibrsv32(ByVal tmpUD&, ByVal tmpv&)

    Call copy_ibvars
End Sub

Sub ibsad(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibsad32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibsic(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibsic32(ByVal tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibsre(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibsre32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibstop(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibstop32(ByVal tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibtmo(ud%, v%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibtmo32(ByVal tmpUD&, ByVal tmpv&)
    
    Call copy_ibvars
End Sub

Sub ibtrg(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call 32-bit DLL.
    rc& = ibtrg32(ByVal tmpUD&)
    
    Call copy_ibvars
End Sub

Sub ibwait(ud%, mask%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    tmpmask& = CLng(mask%)

' Call the 32-bit DLL.
    rc& = ibwait32(ByVal tmpUD&, ByVal tmpmask&)

    Call copy_ibvars
End Sub

Sub ibwrt(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    
' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    Call copy_ibvars
End Sub

Sub ibwrta(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

    cnt& = CLng(Len(buf$))
    
' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, use this:
'    rc& = ibwrta32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibwrtf(ud%, filename$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrtf32(ByVal tmpUD&, ByVal filename$)

    Call copy_ibvars
End Sub

Sub ibwrti(ud%, ibuf%(), cnt&)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibwrtia(ud%, ibuf%(), cnt&)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, use this:
'    rc& = ibwrta32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    Call copy_ibvars
End Sub

Sub ibwrtkey(ud%, buf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrtkey32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    Call copy_ibvars
End Sub

Function ilask(ud%, opt%, rval%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters to Longs.
    tmpUD& = CLng(ud%)
    tmpopt& = CLng(opt%)
    
' Call the 32-bit DLL.
    rc& = ibask32(ByVal tmpUD&, ByVal tmpopt&, tmprval&)
    
    ilask% = ConvertLongToInt(rc&)
    rval% = ConvertLongToInt(tmprval&)
    
    Call copy_ibvars
End Function

Function ilbna(ud%, udname$) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    
' Call the 32-bit DLL.
    rc& = ibbna32(ByVal tmpUD&, ByVal udname$)
    
    ilbna% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilcac(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters to Longs.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)
    
'  Call the 32-bit DLL.
    rc& = ibcac32(ByVal tmpUD&, ByVal tmpv&)

    ilcac% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilclr(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibclr32(ByVal tmpUD&)
    
' Convert Long into Integer.
    ilclr% = ConvertLongToInt(rc&)
 
    Call copy_ibvars
End Function

Function ilcmd(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    
'  Call the 32-bit DLL.
    rc& = ibcmd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilcmd% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilcmda(ud%, laddr&, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
'Function ilcmda(ud%, buf$, cnt&) As Integer
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibcmd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, use this:
'    rc& = ibcmda32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilcmda% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilconfig(bdid%, opt%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(bdid%)
    tmpopt& = CLng(opt%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibconfig32(ByVal tmpUD&, ByVal tmpopt&, ByVal tmpv&)

    ilconfig% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ildev(bdid%, pad%, sad%, tmo%, eot%, eos%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameters into Longs.
    tmpID& = CLng(bdid%)
    tmppad& = CLng(pad%)
    tmpsad& = CLng(sad%)
    tmptmo& = CLng(tmo%)
    tmpeot& = CLng(eot%)
    tmpeos& = CLng(eos%)

' Call the 32-bit DLL.
    tmpUD& = ibdev32(ByVal tmpID&, ByVal tmppad&, ByVal tmpsad&, ByVal tmptmo&, ByVal tmpeot&, ByVal tmpeos&)

    ildev% = ConvertLongToInt(tmpUD&)
    
    Call copy_ibvars
End Function

Function ildiag(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibdiag32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ildiag% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ildma(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibdma32(ByVal tmpUD&, ByVal tmpv&)

    ildma% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ileos(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibeos32(ByVal tmpUD&, ByVal tmpv&)

    ileos% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ileot(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibeot32(ByVal tmpUD&, ByVal tmpv&)

    ileot% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilevent(ud%, eevent%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
 
'  Call the 32-bit DLL.
    rc& = ibevent32(ByVal tmpUD&, tmpv&)
    
    ilevent% = ConvertLongToInt(rc&)
    eevent% = ConvertLongToInt(tmpv&)

    Call copy_ibvars
End Function

Function ilfind(udname$) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Call the 32-bit DLL.
    rc& = ibfind32(ByVal udname$)
    
    ilfind% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilgts(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibgts32(ByVal tmpUD&, ByVal tmpv&)

    ilgts% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilist(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibist32(ByVal tmpUD&, ByVal tmpv&)

    ilist% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function illines(ud%, lines%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = iblines32(ByVal tmpUD&, tmplines&)

    illines% = ConvertLongToInt(rc&)
    lines% = ConvertLongToInt(tmplines&)
    
    Call copy_ibvars
End Function

Function illn(ud%, pad%, sad%, ln%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmppad& = CLng(pad%)
    tmpsad& = CLng(sad%)

'  Call the 32-bit DLL.
    rc& = ibln32(ByVal tmpUD&, ByVal tmppad&, ByVal tmpsad&, tmpln&)

    illn% = ConvertLongToInt(rc&)
    ln% = ConvertLongToInt(tmpln&)

    Call copy_ibvars
End Function

Function illoc(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibloc32(ByVal tmpUD&)

    illoc% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilonl(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

' Call the 32-bit DLL.
    rc& = ibonl32(ByVal tmpUD&, ByVal tmpv&)

    ilonl% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilpad(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibpad32(ByVal tmpUD&, ByVal tmpv&)

    ilpad% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilpct(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibpct32(ByVal tmpUD&)

    ilpct% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilpoke(bdid%, opt%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(bdid%)
    tmpopt& = CLng(opt%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibpoke32(ByVal tmpUD&, ByVal tmpopt&, ByVal tmpv&)

    ilpoke% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilppc(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibppc32(ByVal tmpUD&, ByVal tmpv&)

' Convert Long into Integer.
    ilppc% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilrd(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    
' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilrd% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilrda(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, use this:
'    rc& = ibrda32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    ilrda% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilrdf(ud%, filename$) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrdf32(ByVal tmpUD&, ByVal filename$)

    ilrdf% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilrdi(ud%, ibuf%(), cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    ilrdi% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilrdia(ud%, ibuf%(), cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrd32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

' When Visual Basic remapping buffer problem is solved, use this:
'    rc& = ibrda32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    ilrdia% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilrdkey(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrdkey32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilrdkey% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilrpp(ud%, ppr%) As Integer
    Static tmp_str As String * 2
    
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibrpp32(tmpUD&, ByVal tmp_str$)

    ilrpp% = ConvertLongToInt(rc&)
    ppr% = Asc(tmp_str$)
    
    Call copy_ibvars
End Function

Function ilrsc(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibrsc32(ByVal tmpUD&, ByVal tmpv&)

    ilrsc% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilrsp(ud%, spr%) As Integer
    Static tmp_str As String * 2
    
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    
' Call the 32-bit DLL
    rc& = ibrsp32(ByVal tmpUD&, ByVal tmp_str$)
    
    ilrsp% = ConvertLongToInt(rc&)
    spr% = Asc(tmp_str$)
    
    Call copy_ibvars
End Function

Function ilrsv(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibrsv32(ByVal tmpUD&, ByVal tmpv&)

    ilrsv% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilsad(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibsad32(ByVal tmpUD&, ByVal tmpv&)

    ilsad% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilsic(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibsic32(ByVal tmpUD&)

    ilsic% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilsre(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibsre32(ByVal tmpUD&, ByVal tmpv&)

    ilsre% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilstop(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

'  Call the 32-bit DLL.
    rc& = ibstop32(ByVal tmpUD&)

    ilstop% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function iltmo(ud%, v%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpv& = CLng(v%)

'  Call the 32-bit DLL.
    rc& = ibtmo32(ByVal tmpUD&, ByVal tmpv&)

    iltmo% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function iltrg(ud%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)
    
' Call 32-bit DLL.
    rc& = ibtrg32(ByVal tmpUD&)
    
    iltrg% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilwait(ud%, mask%) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)
    tmpmask& = CLng(mask%)
    
' Call the 32-bit DLL.
    rc& = ibwait32(ByVal tmpUD&, ByVal tmpmask&)
    
    ilwait% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilwrt(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)
    
    ilwrt% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilwrta(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

' When Visual Basic remapping buffer problem solved, use this:
'    rc& = ibwrta32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilwrta% = ConvertLongToInt(rc&)
    
    Call copy_ibvars
End Function

Function ilwrtf(ud%, filename$) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrtf32(ByVal tmpUD&, ByVal filename$)

    ilwrtf% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilwrti(ud%, ibuf%(), cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    ilwrti% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilwrtia(ud%, ibuf%(), cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameters into Longs.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrt32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

' When Visual Basic remapping buffer problem solved, use this:
'    rc& = ibwrta32(ByVal tmpUD&, ibuf%(0), ByVal cnt&)

    ilwrtia% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Function ilwrtkey(ud%, buf$, cnt&) As Integer
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter into Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    rc& = ibwrtkey32(ByVal tmpUD&, ByVal buf$, ByVal cnt&)

    ilwrtkey% = ConvertLongToInt(rc&)

    Call copy_ibvars
End Function

Sub PassControl(ud%, addr%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)

' Call the 32-bit DLL.
    Call PassControl32(ByVal tmpUD&, ByVal tmpaddr&)

    Call copy_ibvars
End Sub

Sub Ppoll(ud%, result%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call PPoll32(ByVal tmpUD&, tmpresult&)

    result% = ConvertLongToInt(tmpresult&)
    
    Call copy_ibvars
End Sub

Sub PpollConfig(ud%, addr%, lline%, sense%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)
    tmpline& = CLng(lline%)
    tmpsense& = CLng(sense%)
    
' Call the 32-bit DLL.
    Call PPollConfig32(ByVal tmpUD&, ByVal tmpaddr&, ByVal tmpline&, ByVal tmpsense&)

    Call copy_ibvars
End Sub

Sub PpollUnconfig(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call PPollUnconfig32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub RcvRespMsg(ud%, buf$, term%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    tmpterm& = CLng(term%)

' Call the 32-bit DLL.
    Call RcvRespMsg32(ByVal tmpUD&, ByVal buf$, ByVal cnt&, ByVal tmpterm&)
    
    Call copy_ibvars
End Sub

Sub ReadStatusByte(ud%, addr%, result%)
    Static addr_list%(2)
    
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)
    
' Call the 32-bit DLL.
    Call ReadStatusByte32(ByVal tmpUD&, ByVal tmpaddr&, tmpresult&)

    result% = ConvertLongToInt(tmpresult&)
    
    Call copy_ibvars
End Sub

Sub Receive(ud%, addr%, buf$, term%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)
    cnt& = CLng(Len(buf$))
    tmpterm& = CLng(term%)

' Call the 32-bit DLL.
    Call Receive32(ByVal tmpUD&, ByVal tmpaddr&, ByVal buf$, ByVal cnt&, ByVal tmpterm&)

    Call copy_ibvars
End Sub

Sub ReceiveSetup(ud%, addr%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)

' Call the 32-bit DLL.
    Call ReceiveSetup32(ByVal tmpUD&, ByVal tmpaddr&)

    Call copy_ibvars
End Sub

Sub ResetSys(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
 
' Call the 32-bit DLL.
    Call ResetSys32(ByVal tmpUD&, addrs%(0))
    
    Call copy_ibvars
End Sub

Sub Send(ud%, addr%, buf$, term%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)
    cnt& = CLng(Len(buf$))
    tmpterm& = CLng(term%)

' Call the 32-bit DLL.
    Call Send32(ByVal tmpUD&, ByVal tmpaddr&, ByVal buf$, ByVal cnt&, ByVal tmpterm&)
    
    Call copy_ibvars
End Sub

Sub SendCmds(ud%, cmdbuf$)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(cmdbuf$))

' Call the 32-bit DLL.
    Call SendCmds32(ByVal tmpUD&, ByVal cmdbuf$, ByVal cnt&)

    Call copy_ibvars
End Sub

Sub SendDataBytes(ud%, buf$, term%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    tmpterm& = CLng(term%)

' Call the 32-bit DLL.
    Call SendDataBytes32(ByVal tmpUD&, ByVal buf$, ByVal cnt&, ByVal tmpterm&)

    Call copy_ibvars
End Sub

Sub SendIFC(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call SendIFC32(ByVal tmpUD&)

    Call copy_ibvars
End Sub

Sub SendList(ud%, addr%(), buf$, term%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameters to Longs.
    tmpUD& = CLng(ud%)
    cnt& = CLng(Len(buf$))
    tmpterm& = CLng(term%)

' Call the 32-bit DLL.
    Call SendList32(ByVal tmpUD&, addr%(0), ByVal buf$, ByVal cnt&, ByVal tmpterm&)

    Call copy_ibvars
End Sub

Sub SendLLO(ud%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call SendLLO32(ByVal tmpUD&)

    Call copy_ibvars
End Sub

Sub SendSetup(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call SendSetup32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub SetRWLS(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call SetRWLS32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub TestSRQ(ud%, result%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
    Call ibwait(ud%, 0)
    
    Call copy_ibvars
    
    If ibsta% And &H1000 Then
        result% = 1
    Else
        result% = 0
    End If
    
End Sub

Sub TestSys(ud%, addrs%(), results%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
 
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call TestSys32(ByVal tmpUD&, addrs%(0), results%(0))
    
    Call copy_ibvars
End Sub

Sub Trigger(ud%, addr%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If
    
' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)
    tmpaddr& = CLng(addr%)

' Call the 32-bit DLL.
    Call Trigger32(ByVal tmpUD&, ByVal tmpaddr&)

    Call copy_ibvars
End Sub

Sub TriggerList(ud%, addrs%())
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

' Convert Integer parameter to Long.
    tmpUD& = CLng(ud%)

' Call the 32-bit DLL.
    Call TriggerList32(ByVal tmpUD&, addrs%(0))

    Call copy_ibvars
End Sub

Sub WaitSRQ(ud%, result%)
' Check to see if GPIB Global variables are registered
    If (GPIBglobalsRegistered = 0) Then
      Call RegisterGPIBGlobals
    End If

    Call ibwait(ud%, &H5000)

    Call copy_ibvars

    If ibsta% And &H1000 Then
        result% = 1
    Else
        result% = 0
    End If
End Sub


Private Function ConvertLongToInt(LongNumb&) As Integer

  If (LongNumb& > 32767) Then
  ' Make Long "Unsigned" Int into Short Signed Int.
    tmpnumb& = LongNumb& - 32768
    ConvertLongToInt% = tmpnumb& + &H8000
  ElseIf (LongNumb& < 0) Then
    If (LongNumb& = -1) Then
    ' If Long Int = -1, then Short Int = -1.
      ConvertLongToInt% = -1
    Else
    ' If Long Int is a HUGE "negative" number. then
    ' "truncate" upper word, then convert Long to Short.
      tmpnumb& = LongNumb& And &H7FFF
      ConvertLongToInt% = CInt(tmpnumb&)
    End If
  Else
  ' Perform normal conversion.
    ConvertLongToInt% = CInt(LongNumb&)
  End If
    
End Function

Public Sub RegisterGPIBGlobals()
    rc& = RegisterGpibGlobalsForThread(Longibsta, Longiberr, Longibcnt, ibcntl)
    If (rc& = 0) Then
      GPIBglobalsRegistered = 1
    ElseIf (rc& = 1) Then
      rc& = UnregisterGpibGlobalsForThread
      rc& = RegisterGpibGlobalsForThread(Longibsta, Longiberr, Longibcnt, ibcntl)
      GPIBglobalsRegistered = 1
    ElseIf (rc& = 2) Then
      MsgBox "Operating System is not multi-threaded. Quitting the Program!", 16
      rc& = UnregisterGpibGlobalsForThread
      End
    ElseIf (rc& = 3) Then
      MsgBox "Unable to register GPIB thread globals. Quitting the Program!", 16
      rc& = UnregisterGpibGlobalsForThread
      End
    Else
      MsgBox "Unknown Error for Registering GPIB Globals!!! Quitting the Program!", 16
      End
    End If
End Sub

Public Sub UnregisterGPIBGlobals()
    rc& = UnregisterGpibGlobalsForThread
    If (rc& = 0) Then
      GlobalsRegistered = 0
    ElseIf (rc& = 1) Then
      GlobalsRegistered = 0
    ElseIf (rc& = 2) Then
      MsgBox "Operating System is not multi-threaded. Quitting the Program!", 16
      rc& = UnregisterGpibGlobalsForThread
      End
    ElseIf (rc& = 3) Then
      MsgBox "Unable to unregister GPIB thread globals. Quitting the Program!", 16
      rc& = UnregisterGpibGlobalsForThread
      End
    Else
      MsgBox "Unknown Error for Unregistering GPIB Globals!!! Quitting the Program!", 16
      End
    End If
End Sub


