Attribute VB_Name = "modExcel"
Global e As Excel.Application
Global cartella As Workbook

'Le variabili SFONDO e GRIGIO servono per scegliere
'il colore di sfondo e il fonmato di alcune celle
Dim sfondo
Dim grigio

' Le due variabili "significativita" e "gradoLiberta" servono per il
' calcolo del valore tabellato del test del chi quadro
Dim significativita As Double
Dim gradoLiberta As Integer

'La variabile CAMPIONI contiene il numero di campioni per deviazione
'Dim campioni



Public Function CreaLavoroExcel(num_deviazioni As Integer) As Boolean

'Questa funzione crea tanti fogli di lavoro,
'quante sono le deviazioni

    Dim j As Integer
    Set e = New Excel.Application
    Set cartella = e.Workbooks.Add
    'Servono per settare il tipo di sfondo e il suo colore
    sfondo = xlNone
    grigio = RGB(185, 186, 184)
    
    'Servono per settare i valori per il test del chi^2
    significativita = 0.05
    gradoLiberta = 2
    
    For j = 1 To num_deviazioni
        cartella.Worksheets(j).Activate
        cartella.ActiveSheet.Name = "Deviazione" & j
        
        'Solo per Tensione
        
        cartella.Application.Cells(2, 1) = "Num. Misure"
        cartella.Application.Cells(2, 2) = "Salita/Discesa"
        cartella.Application.Cells(2, 3) = "dx"
        cartella.Application.Cells(2, 4) = "Vx"
        cartella.Application.Cells(2, 5) = "Vc"
        cartella.Application.Cells(2, 6) = "E=Vx-Vc"
        cartella.Application.Cells(2, 7) = "er E/Vx"
        cartella.Application.Cells(2, 8) = "er%"
        cartella.Application.Cells(3, 3) = "[dev]"
        cartella.Application.Cells(3, 4) = "[V]"
        cartella.Application.Cells(3, 5) = "[V]"
        cartella.Application.Cells(3, 6) = "[V]"
        cartella.Application.Cells(3, 8) = "[%]"
        
         'Larghezza delle colonne
        
        cartella.Application.Columns(1).ColumnWidth = 11.57
        cartella.Application.Columns(2).ColumnWidth = 13
        cartella.Application.Columns(3).ColumnWidth = 8.43
        cartella.Application.Columns(4).ColumnWidth = 8.43
        cartella.Application.Columns(5).ColumnWidth = 8.43
        cartella.Application.Columns(6).ColumnWidth = 10.86
        cartella.Application.Columns(7).ColumnWidth = 8.43
        cartella.Application.Columns(8).ColumnWidth = 8.43
        
        
        'Testo allineato al centro
        
        cartella.Application.Columns(1).HorizontalAlignment = xlCenter
        cartella.Application.Columns(2).HorizontalAlignment = xlCenter
        cartella.Application.Columns(3).HorizontalAlignment = xlCenter
        cartella.Application.Columns(4).HorizontalAlignment = xlCenter
        cartella.Application.Columns(5).HorizontalAlignment = xlCenter
        cartella.Application.Columns(6).HorizontalAlignment = xlCenter
        cartella.Application.Columns(7).HorizontalAlignment = xlCenter
        cartella.Application.Columns(8).HorizontalAlignment = xlCenter
        
        'Testo in Grassetto per la seconda e terza riga
        
        cartella.Application.Range("A2:H2").Font.Bold = True
        cartella.Application.Range("A3:H3").Font.Bold = True
        
        ' Sfondo in colore
        cartella.Application.Range("A2:H2").Interior.Pattern = sfondo
        cartella.Application.Range("A2:H2").Interior.Color = grigio
        
        cartella.Application.Range("A3:H3").Interior.Pattern = sfondo
        cartella.Application.Range("A3:H3").Interior.Color = grigio
        
        'Inserimento della griglia
        
        With cartella.Application.Range("A2:H" & (campioni + 3)).Borders
            .LineStyle = xlBorderLineStyleContinuous
            .Weight = xlThin
            .ColorIndex = 1
        End With
        
    Next
    
End Function
Public Sub inserTabella(ByVal num_misura As Integer, ByVal sd As String, ByVal dx As String, ByVal Vx As Double, ByVal Vc As Double)
    Dim offsetRiga As Integer
    offsetRiga = 3 + num_misura
    cartella.Application.Cells(offsetRiga, 1) = num_misura
    cartella.Application.Cells(offsetRiga, 2) = sd
    cartella.Application.Cells(offsetRiga, 3) = dx
    cartella.Application.Cells(offsetRiga, 4) = Vx
    cartella.Application.Cells(offsetRiga, 5) = Vc
    cartella.Application.Cells(offsetRiga, 6) = Vx - Vc
    cartella.Application.Cells(offsetRiga, 7) = (Vx - Vc) / Vx
    cartella.Application.Cells(offsetRiga, 8) = ((Vx - Vc) / Vx) * 100
End Sub
Public Function ChiudiLavoroExcel() As Boolean
    Set e = Nothing
End Function

Public Function formato_celle(a As Double) As Double
    '******************************************
    '* Definisce il formato delle Celle
    '* costituito da due cifre decimali
    '* dopo la virgola
    '******************************************
    
    formato_celle = Format(a, "00.00")
    
End Function
Public Function frequenza_Errore(a As Double, b As Double) As Integer
    '****************************************************
    '* Conta quanti valori ci sono nell'intervallo [a,b)
    '* includendo "a" ed escludendo "b"
    '****************************************************
    Dim contati
    contati = 0
    For i = 1 To campioni
        If ((cartella.Application.Cells(i + 3, 6).Value >= a) And (cartella.Application.Cells(i + 3, 6).Value < b)) Then
            contati = contati + 1
        End If
    Next
    frequenza_Errore = contati
End Function
Public Function CreaformuleClassi() As Boolean
        '******************************************
        '* La funzione crea le classi
        '* per la frequenze osservate
        '******************************************

        '******************************************
        '* numeroClassi indica il numero di classi
        '* per la frequenze osservate
        '******************************************
        Dim numeroClassi As Integer
                        
        cartella.Application.Cells(2, 10) = "Max E"
        cartella.Application.Cells(3, 10) = "Min E"
        cartella.Application.Cells(4, 10) = "N. Classi"
        cartella.Application.Cells(5, 10) = "Intervallo"
        cartella.Application.Cells(6, 10) = "Media"
        cartella.Application.Cells(7, 10) = "Mediana"
        cartella.Application.Cells(8, 10) = "Moda"
        cartella.Application.Cells(9, 10) = "Range"
        cartella.Application.Cells(10, 10) = "Dev. st."
        cartella.Application.Cells(11, 10) = "Asimmet"
        cartella.Application.Cells(12, 10) = "Kurtosi"
        
        'Larghezza delle colonne
        
        cartella.Application.Columns(10).ColumnWidth = 8.43
        cartella.Application.Columns(11).ColumnWidth = 8.43
        
        'Testo allineato al centro
        
        cartella.Application.Columns(10).HorizontalAlignment = xlCenter
        cartella.Application.Columns(11).HorizontalAlignment = xlCenter
        
        'Testo in Grassetto per la colonna
        
        cartella.Application.Range("J2:J12").Font.Bold = True
        
        ' Sfondo in colore
        cartella.Application.Range("J2:J12").Interior.Pattern = sfondo
        cartella.Application.Range("J2:J12").Interior.Color = grigio
        
        'Inserimento della griglia
        With cartella.Application.Range("J2:K12").Borders
            .LineStyle = xlBorderLineStyleContinuous
            .Weight = xlThin
            .ColorIndex = 1
        End With
        
        'Inserire le formule per la tabella di prima
        'minimo,massimo,kurtosi,media mediana ...
        
        
        '****************************************************
        '                DA QUESTO PUNTO IN POI
        '              VENGONO INSERITE LE FORMULE
        '****************************************************
        
        
    
        cartella.Application.Cells(2, 11).Value = formato_celle(Application.WorksheetFunction.Max(Range("F4:F" & (campioni + 3))))
        cartella.Application.Cells(3, 11).Value = Application.WorksheetFunction.Min(Range("F4:F" & (campioni + 3)))
        
        numeroClassi = Int(1 + 3.3 * Application.WorksheetFunction.Log10(campioni))
        cartella.Application.Cells(4, 11).Value = numeroClassi
        
        cartella.Application.Cells(9, 11).Value = formato_celle(cartella.Application.Cells(2, 11).Value - cartella.Application.Cells(3, 11).Value)
        
        cartella.Application.Cells(5, 11).Value = formato_celle((cartella.Application.Cells(9, 11).Value) / (cartella.Application.Cells(4, 11).Value))
        
        'Nella cella(6,11) deve andare la MEDIA
        cartella.Application.Cells(6, 11).Value = (Application.WorksheetFunction.Sum(Range("F4:F" & (campioni + 3))) / campioni)
        
        cartella.Application.Cells(7, 11).Value = formato_celle(Application.WorksheetFunction.Median(Range("F4:F" & (campioni + 3))))
        
        'Nella cella(8,11) va la MODA
        
        'cartella.Application.Cells(8, 11).Value = Application.WorksheetFunction.Mode(Range("F4:F" & (campioni + 3)))
        
        cartella.Application.Cells(10, 11).Value = Format((Application.WorksheetFunction.Stdev(Range("F4:F" & (campioni + 3)))), "0.000")
        
        'Nella cella(11,11) va l'ASIMMETRIA
        'cartella.Application.Cells(11, 11).Value = Application.WorksheetFunction
        
        cartella.Application.Cells(12, 11).Value = formato_celle(Application.WorksheetFunction.Kurt(Range("F4:F" & (campioni + 3))))
        
        'Fine dell'inserimento delle formule
        
        
        'Inserimento del testo per le tabelle delle classi
        
        cartella.Application.Cells(2, 13) = "Classe"
        cartella.Application.Cells(2, 17) = "f"
        cartella.Application.Cells(2, 18) = "fr"
        cartella.Application.Cells(2, 19) = "F"
        
        'Larghezza delle colonne
        
        cartella.Application.Columns(13).ColumnWidth = 6
        cartella.Application.Columns(14).ColumnWidth = 5 '3.86
        cartella.Application.Columns(15).ColumnWidth = 8.43
        cartella.Application.Columns(16).ColumnWidth = 5 '3.86
        cartella.Application.Columns(17).ColumnWidth = 3.43
        cartella.Application.Columns(18).ColumnWidth = 4.29
        cartella.Application.Columns(19).ColumnWidth = 3.43
        
        'Testo allineato al centro
        
        cartella.Application.Columns(13).HorizontalAlignment = xlCenter
        cartella.Application.Columns(14).HorizontalAlignment = xlCenter
        cartella.Application.Columns(15).HorizontalAlignment = xlCenter
        cartella.Application.Columns(16).HorizontalAlignment = xlCenter
        cartella.Application.Columns(17).HorizontalAlignment = xlCenter
        cartella.Application.Columns(18).HorizontalAlignment = xlCenter
        cartella.Application.Columns(19).HorizontalAlignment = xlCenter
        
        'Testo in Grassetto per la colonna
        
        cartella.Application.Cells(2, 10).Font.Bold = True
        cartella.Application.Cells(2, 13).Font.Bold = True
        cartella.Application.Range("Q2:S2").Font.Bold = True
        
        ' Sfondo in colore
        cartella.Application.Cells(2, 13).Interior.Pattern = sfondo
        cartella.Application.Cells(2, 13).Interior.Color = grigio
        
        cartella.Application.Range("Q2:S2").Interior.Pattern = sfondo
        cartella.Application.Range("Q2:S2").Interior.Color = grigio
        
        'Inserimento della griglia
        With cartella.Application.Cells(2, 13).Borders
            .LineStyle = xlBorderLineStyleContinuous
            .Weight = xlThin
            .ColorIndex = 1
        End With
        
        With cartella.Application.Range("Q2:S2").Borders
            .LineStyle = xlBorderLineStyleContinuous
            .Weight = xlThin
            .ColorIndex = 1
        End With
        
        
        '****************************************************
        '                DA QUESTO PUNTO IN POI
        '              VENGONO INSERITE LE FORMULE
        '                  RELATIVE ALLE CLASSI
        '****************************************************
        
        
        For i = 1 To numeroClassi
            cartella.Application.Cells(i + 2, 13) = i
            cartella.Application.Cells(i + 2, 15) = "<= E <"
            If i = 1 Then
                cartella.Application.Cells(i + 2, 14) = cartella.Application.Cells(3, 11)
                cartella.Application.Cells(i + 2, 16) = cartella.Application.Cells(i + 2, 14) + cartella.Application.Cells(5, 11)
            Else
                cartella.Application.Cells(i + 2, 14) = cartella.Application.Cells(i + 2 - 1, 16)
                cartella.Application.Cells(i + 2, 16) = cartella.Application.Cells(i + 2, 14) + cartella.Application.Cells(5, 11)
            End If
            
            cartella.Application.Cells(i + 2, 17) = frequenza_Errore(cartella.Application.Cells(i + 2, 14), cartella.Application.Cells(i + 2, 16))
            cartella.Application.Cells(i + 2, 18) = formato_celle(cartella.Application.Cells(i + 2, 17) / campioni)
            If i = 1 Then
                cartella.Application.Cells(i + 2, 19) = cartella.Application.Cells(i + 2, 17)
            Else
                cartella.Application.Cells(i + 2, 19) = cartella.Application.Cells(i + 2, 17) + cartella.Application.Cells(i + 2 - 1, 19)
            End If
            
                      
            'Inserimento della griglia
            With cartella.Application.Range("M" & i + 2 & ":S" & i + 2).Borders
                .LineStyle = xlBorderLineStyleContinuous
                .Weight = xlThin
                .ColorIndex = 1
            End With
        
        Next
        
                        
        '******************************************
        '* Effettua il grafico della Frequenze
        '* osservate
        '******************************************
        graficodemo (numeroClassi)
End Function
Private Sub calcolaChi(class As Integer)
    '******************************************
    '* Effettua il calcolo di
    '* X Z Area ft (f0-ft)^2 ((f0-ft)^2)/ft
    '* nel test del CHI
    '******************************************
    
    'Calcolo di X
    If Cells(class + 2, 25) = "inf" Then
        Cells(class + 2, 29) = ""
    Else
        Cells(class + 2, 29) = Cells(class + 2, 25)
    End If
    
    'Calcolo di Z
    If Cells(class + 2, 25) = "inf" Then
        Cells(class + 2, 30) = ""
    Else
        Cells(class + 2, 30) = formato_celle(((Cells(class + 2, 29) - Cells(6, 11)) / Cells(10, 11)))
    End If
    
    'Calcolo di Area
    
    If class = 1 Then
        Cells(class + 2, 31) = Application.WorksheetFunction.NormSDist(Cells(class + 2, 30))
    ElseIf Cells(class + 2, 25) = "inf" Then
        Cells(class + 2, 31) = (1 - Application.WorksheetFunction.NormSDist(Cells(class + 2 - 1, 30)))
    Else
        Cells(class + 2, 31) = Application.WorksheetFunction.NormSDist(Cells(class + 2, 30)) - Application.WorksheetFunction.NormSDist(Cells(class + 2 - 1, 30))
    End If
    
      
    'Calcolo di ft
    Cells(class + 2, 32) = Cells(class + 2, 31) * campioni
    
    'Calcolo di (f0-ft)^2
    Cells(class + 2, 34) = (Cells(class + 2, 33) - Cells(class + 2, 32)) ^ 2
        
    'Calcolo di ((f0-ft)^2)/ft
    
    '*****************************************
    '*****************************************
    '*****************************************
    '*****************************************
    Cells(class + 2, 35) = (Cells(class + 2, 34) / Cells(class + 2, 32))
    If (Cells(class + 2, 32) <> 0) Then
        Cells(class + 2, 35) = (Cells(class + 2, 34) / Cells(class + 2, 32))
    Else
    
    End If
End Sub
Private Sub inserisci(classi As Integer, minimo As String, massimo As String)
    '******************************************
    '* Effettua l'inserimento dei limiti
    '* della Frequenze nel test del CHI
    '* per accorpare le classi
    '******************************************
    
    If minimo = "inf" Then
        Cells(2 + classi, 22) = classi
        Cells(2 + classi, 23) = "inf"
        Cells(2 + classi, 24) = "<= E <"
        Cells(2 + classi, 25) = CDbl(massimo)
        
    ElseIf massimo = "inf" Then
        Cells(2 + classi, 22) = classi
        Cells(2 + classi, 23) = CDbl(minimo)
        Cells(2 + classi, 24) = "<= E <"
        Cells(2 + classi, 25) = "inf"
    Else
        Cells(2 + classi, 22) = classi
        Cells(2 + classi, 23) = CDbl(minimo)
        Cells(2 + classi, 24) = "<= E <"
        Cells(2 + classi, 25) = CDbl(massimo)
    End If

End Sub
Public Sub test_chi()
    '******************************************
    '* Esegue il test del chi^2
    '******************************************
    
    '******************************************
    '* numeroClassi indica il numero di classi
    '* per il test del chi^2
    '******************************************
    Dim ChiClassi As Integer
    
    'Inserimento del testo per la tabella del chi
        
    cartella.Application.Cells(2, 22) = "Classe"
    cartella.Application.Cells(2, 26) = "f"
    cartella.Application.Cells(2, 27) = "fr"
    cartella.Application.Cells(2, 28) = "F"
    cartella.Application.Cells(2, 29) = "X"
    cartella.Application.Cells(2, 30) = "Z"
    cartella.Application.Cells(2, 31) = "Area"
    cartella.Application.Cells(2, 32) = "ft"
    cartella.Application.Cells(2, 33) = "f0"
    cartella.Application.Cells(2, 34) = "(f0-ft)^2"
    cartella.Application.Cells(2, 35) = "((f0-ft)^2)/ft"
    
    'Larghezza delle colonne
    
    cartella.Application.Columns(20).ColumnWidth = 2
    cartella.Application.Columns(21).ColumnWidth = 2
    cartella.Application.Columns(22).ColumnWidth = 6
    cartella.Application.Columns(23).ColumnWidth = 5 '3.86
    cartella.Application.Columns(24).ColumnWidth = 6.86
    cartella.Application.Columns(25).ColumnWidth = 5 '3.86
    cartella.Application.Columns(26).ColumnWidth = 3.43
    cartella.Application.Columns(27).ColumnWidth = 4.29
    cartella.Application.Columns(28).ColumnWidth = 3.43
    cartella.Application.Columns(29).ColumnWidth = 5
    cartella.Application.Columns(30).ColumnWidth = 5
    cartella.Application.Columns(31).ColumnWidth = 6
    cartella.Application.Columns(32).ColumnWidth = 5
    cartella.Application.Columns(33).ColumnWidth = 5
    cartella.Application.Columns(34).ColumnWidth = 6
    cartella.Application.Columns(35).ColumnWidth = 9.86
    
    'Testo allineato al centro
    
    cartella.Application.Columns(22).HorizontalAlignment = xlCenter
    cartella.Application.Columns(23).HorizontalAlignment = xlCenter
    cartella.Application.Columns(24).HorizontalAlignment = xlCenter
    cartella.Application.Columns(25).HorizontalAlignment = xlCenter
    cartella.Application.Columns(26).HorizontalAlignment = xlCenter
    cartella.Application.Columns(27).HorizontalAlignment = xlCenter
    cartella.Application.Columns(28).HorizontalAlignment = xlCenter
    cartella.Application.Range("AC:AI").HorizontalAlignment = xlCenter
    'Testo in Grassetto per la colonna
    
    cartella.Application.Cells(2, 22).Font.Bold = True
    cartella.Application.Range("Z2:AI2").Font.Bold = True
    
    ' Sfondo in colore
    cartella.Application.Cells(2, 22).Interior.Pattern = sfondo
    cartella.Application.Cells(2, 22).Interior.Color = grigio
    
    cartella.Application.Range("Z2:AI2").Interior.Pattern = sfondo
    cartella.Application.Range("Z2:AI2").Interior.Color = grigio
    
    'Inserimento della griglia
    With cartella.Application.Cells(2, 22).Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
        
    With cartella.Application.Range("Z2:AI2").Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    
    '****************************************************
    '                DA QUESTO PUNTO IN POI
    '              VENGONO INSERITE I LIMITI
    '                  RELATIVE ALLE CLASSI
    '                       DEL CHI
    '****************************************************
    Dim Somma As Integer
    Dim limiteSup As String
    Dim limiteInf As String
    
    ChiClassi = 1
    limiteSup = Cells(3, 14)
    limiteInf = "inf"
    Call inserisci(ChiClassi, limiteInf, limiteSup)
    'Call calcolaChi(ChiClassi)
    ChiClassi = ChiClassi + 1
    limiteInf = Cells(3, 14)
    For i = 1 To Cells(4, 11)
        If (Somma + Cells(i + 2, 17)) >= 5 Then
            limiteSup = Cells(i + 2, 16)
            Call inserisci(ChiClassi, limiteInf, limiteSup)
            'Call calcolaChi(ChiClassi)
            Somma = 0
            ChiClassi = ChiClassi + 1
            vecchiolimiteInf = limiteInf
            limiteInf = limiteSup
        Else
            Somma = Somma + Cells(i + 2, 17)
        End If
    Next
    If Somma <> 0 Then
        ChiClassi = ChiClassi - 1
        limiteInf = vecchiolimiteInf
        limiteSup = Cells(Cells(4, 11) + 2, 16)
    End If
    If (limiteInf <> limiteSup) Then
        Call inserisci(ChiClassi, limiteInf, limiteSup)
    Else
        ChiClassi = ChiClassi - 1
    End If
    'Call calcolaChi(ChiClassi)
    limiteInf = limiteSup
    limiteSup = "inf"
    ChiClassi = ChiClassi + 1
    Call inserisci(ChiClassi, limiteInf, limiteSup)
    'Call calcolaChi(ChiClassi)
    
    '****************************************************
    '                ADESSO I LIMITI DEL TEST SONO
    '               INSERITI RELATIVE ALLE CLASSI
    '                       DEL CHI
    '
    '
    '               ADESSO DOBBIAMO VEDERE LE
    '                 FREQUENZE OSSERVABILI
    '****************************************************
    
    ' PRIMA RIGA
    Cells(3, 26) = 0
    Cells(3, 27) = 0
    Cells(3, 28) = 0
    Cells(3, 33) = Cells(3, 26)
    Call calcolaChi(1)
    
    'Inserimento Griglia
    With cartella.Application.Range("V3:AI3").Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    'FINE PRIMA RIGA
    
    For i = 1 To ChiClassi - 2
        Cells(i + 3, 26) = frequenza_Errore(Cells(i + 3, 23), Cells(i + 3, 25))
        Cells(i + 3, 27) = formato_celle(Cells(i + 3, 26) / campioni)
        Cells(i + 3, 28) = Cells(i + 3, 26) + Cells(i + 3 - 1, 28)
        Cells(i + 3, 33) = Cells(i + 3, 26)
        Call calcolaChi(i + 1)
        
        'Inserimento Griglia
        With cartella.Application.Range("V" & i + 3 & ":AI" & i + 3).Borders
            .LineStyle = xlBorderLineStyleContinuous
            .Weight = xlThin
            .ColorIndex = 1
        End With
        
    Next
    
    ' ULTIMA RIGA
    Cells(ChiClassi + 2, 26) = 0
    Cells(ChiClassi + 2, 27) = 0
    Cells(ChiClassi + 2, 28) = Cells(ChiClassi + 2 - 1, 28)
    Cells(ChiClassi + 2, 33) = Cells(ChiClassi + 2, 26)
    Call calcolaChi(ChiClassi)
    
    'Inserimento Griglia ChiClassi+2
    With cartella.Application.Range("V" & ChiClassi + 2 & ":AI" & ChiClassi + 2).Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    'FINE ULTIMA RIGA
    
    ' Inserimento delle sommatori finali
    Cells(ChiClassi + 2 + 1, 31) = Application.WorksheetFunction.Sum(Range("AE3:AE" & (ChiClassi + 2)))
    Cells(ChiClassi + 2 + 1, 32) = Application.WorksheetFunction.Sum(Range("AF3:AF" & (ChiClassi + 2)))
    Cells(ChiClassi + 2 + 1, 35) = Application.WorksheetFunction.Sum(Range("AI3:AI" & (ChiClassi + 2)))
    
    'Inserimento Griglia
    With cartella.Application.Cells((ChiClassi + 2 + 1), 31).Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    With cartella.Application.Cells((ChiClassi + 2 + 1), 32).Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    With cartella.Application.Cells((ChiClassi + 2 + 1), 35).Borders
        .LineStyle = xlBorderLineStyleContinuous
        .Weight = xlThin
        .ColorIndex = 1
    End With
    
    '******************************************
    '* QUI INSERIRE IL TEST DEL CHI
    '* CIOE IL VALORE TROVATO IN TABELLA
    '* CON LA FUNZIONE Application.WorksheetFunction.ChiInv(Significativit,gradi di libert)
    '******************************************
    
    
    Dim test
    Cells((ChiClassi + 2 + 4), 22) = "Grado di libert : " & gradoLiberta
    Cells((ChiClassi + 2 + 5), 22) = "Grado di Significativit : " & significativita
    test = formato_celle(Application.WorksheetFunction.ChiInv(significativita, gradoLiberta))
    Cells((ChiClassi + 2 + 6), 22) = "Valore in tabella : " & test
    If (Cells(ChiClassi + 2 + 1, 35) < test) Then
        Cells((ChiClassi + 2 + 5), 30) = "Test Superato"
    Else
        Cells((ChiClassi + 2 + 5), 30) = "Test Non Superato"
    End If
    Cells((ChiClassi + 2 + 5), 30).Font.Color = RGB(255, 0, 0)
    
    cartella.Application.Cells((ChiClassi + 2 + 4), 22).HorizontalAlignment = xlLeft
    cartella.Application.Cells((ChiClassi + 2 + 5), 22).HorizontalAlignment = xlLeft
    cartella.Application.Cells((ChiClassi + 2 + 6), 22).HorizontalAlignment = xlLeft
    cartella.Application.Cells((ChiClassi + 2 + 5), 30).HorizontalAlignment = xlLeft
    
End Sub
Public Sub graficodemo(classi As Integer)
    Dim intervallograficoY As Object
    Dim nuovografico As Object
    
    ' La variabile di dopo serve a riattivari
    ' il foglio corrente dopo aver inserito il grafico
    Dim foglioattivo As String
    
    Set intervallograficoY = e.Application.Range("Q3:Q" & (classi + 2))
    
    intervallograficoY.Select
    foglioattivo = e.Application.ActiveSheet.Name
    
    
   
    Set nuovografico = Charts.Add
    
    
    'A questo punto il grafico  gi fatto
    
    nuovografico.Select
    With nuovografico
        .ChartType = xlColumnStacked
        '.SubType = xlNormal
    End With
    
    ActiveSheet.Name = "Grafico " & foglioattivo
    Worksheets(foglioattivo).Activate

End Sub


Public Sub ImpostaCellAtt()

' possibile utilizzare il metodo Activate per impostare
'la cella attiva. Questa routine attiva ad esempio la
'cella B5 e le applica il formato grassetto.

    Worksheets("misure").Activate
    Worksheets("misure").Range("F1").Activate
    ActiveCell.Font.Bold = True
    
'Nota   Per selezionare un intervallo di celle, utilizzare
'il metodo Select. Per attivare una singola cella,
'utilizzare il metodo Activate.

End Sub


