;-----------------------------------------------------------;
; Written By: Keith Larson                                  ;
;             TMS320Cxx DSP Applications Engineer           ;
;             Texas Instruments                             ;
;-----------------------------------------------------------;
ONEPASS .set    0               ;1= no avg  0=Average on
YES     .set    1               ;
NO      .set    0               ;
;-----------------------------------------------------------;
BITLEN2         .set    54h     ;0078h   ;JUMP CMD
BITLEN          .set    0a8h    ;079h   ;JUMP XMIT
SENDC           .set    08f0h
;===============================
     .ds 0x60                   ; AIC/FFT Setup data in upper 1/2 B2
;==================================================================
; Sampling Rate Selection Table
; -----------------------------
; To change the AIC sampling rate and filter cutoff deselect the
; old configuration by placing a '0' next it and a '1' next to the
; new selection.  An .if/.endif table then sets the TA and TB value.
;
; Useful AIC Equations
; --------------------
;   Fclk = 10 MHz             Master clock input to the AIC
;   Fbit = Fclk/4             Serial port bit rate
;
; ADC Rates (Synchronous mode - DEFAULT)
;   Fscf = Fclk/(2*TA)        Internal switched cap filter rate
;   Fs   = Fclk/(2*TA*TB)     ADC sampling rate
;
; ADC Rates (Asynchronous mode)
;   Fscf = Fclk/(2*RA)        Internal switched cap filter rate
;   Fs   = Fclk/(2*RA*RB)     ADC sampling rate
;
; DAC Rates
;   Fscf = Fclk/(2*TA)        Internal switched cap filter rate
;   Fs   = Fclk/(2*TA*TB)     DAC sampling rate
;
; Note: 1) The TA/TB ratios effect the ADC/DAC SNR
;       2) TA/RA sets the switched capacitor filter (SCF) clock
;       3) TA effects the DAC output BW
;
;
; ADC & DAC upper limit filter characteristics are set by the TA/RA
;   registers when the AIC is run in Synchronous mode (default).
;   This application also deselects the ADC bandpass filter making
;   this table only relevent for the DAC section.
;
; TA/RA  SCF            Fadc/Fdac(upper limit)
;   1    5000.000 kHz   60.764 kHz  Not Usable
;   2    2500.000 kHz   30.382 kHz  Not Usable
;   3    1666.667 kHz   20.255 kHz  Very noisy, often unstable
;   4    1250.000 kHz   15.191 kHz  noisy, sometimes unstable
;   5    1000.000 kHz   12.153 kHz  noisy, good stability
;   6     833.333 kHz   10.127 kHz  some noise
;   7     714.286 kHz    8.681 kHz  noisy at high Fs
;   8     625.000 kHz    7.595 kHz  OK
;   9     555.556 kHz    6.752 kHz  OK
;  10     500.000 kHz    6.076 kHz  OK
;  11     454.545 kHz    5.524 kHz  OK
;  12     416.667 kHz    5.064 kHz  OK
;  13     384.615 kHz    4.674 kHz  OK
;  14     357.143 kHz    4.340 kHz  OK
;  15     333.333 kHz    4.051 kHz  OK
;  16     312.500 kHz    3.798 kHz  OK
;  17     294.118 kHz    3.574 kHz  OK
;  18     277.778 kHz    3.376 kHz  OK
;  19     263.158 kHz    3.198 kHz  OK
;  20     250.000 kHz    3.038 kHz  OK
;  21     238.095 kHz    2.894 kHz  OK
;  22     227.273 kHz    2.762 kHz  OK
;  23     217.391 kHz    2.642 kHz  OK
;  24     208.333 kHz    2.532 kHz  OK
;  25     200.000 kHz    2.431 kHz  OK
;  26     192.308 kHz    2.337 kHz  OK
;  27     185.185 kHz    2.251 kHz  OK
;  28     178.571 kHz    2.170 kHz  OK
;  29     172.414 kHz    2.095 kHz  OK
;  30     166.667 kHz    2.025 kHz  OK
;  31     161.290 kHz    1.960 kHz  OK
;=======================================================;
;ADC & DAC Frequency selection table                    ;
;                                                       ;
;Fselect  Select        TA/TB  Comments                 ;
;=======================================================;
_2560    .set  0      ; 31/63 80 dB SNR

_5000a   .set  0      ; 25/40 80 dB SNR
_5000b   .set  0      ; 22/45 80 dB SNR
_5000c   .set  0      ; 20/50 80 dB SNR
_5000d   .set  0      ; 18/56 80 dB SNR
_5000e   .set  0      ; 16/63 80 dB SNR

_10000a  .set  1      ; 12/42 80 dB SNR
_10000b  .set  0      ; 11/45 80 dB SNR
_10000c  .set  0      ; 10/50 80 dB SNR
_10000d  .set  0      ;  9/56 80 dB SNR
_10000e  .set  0      ;  8/63 80 dB SNR

_20000a  .set  0      ;  8/31 78 dB SNR
_20000b  .set  0      ;  7/36 72 dB SNR
_20000c  .set  0      ;  6/42 70 dB SNR
_20000d  .set  0      ;  5/50 67 dB SNR
_20000e  .set  0      ;  4/63 62 dB SNR

_38000a  .set  0      ;  9/15 80 dB SNR
_38000b  .set  0      ;  8/16 78 dB SNR
_38000c  .set  0      ;  7/19 78 dB SNR
_38000d  .set  0      ;  6/22 72 dB SNR

_44000a  .set  0      ;  9/13 78 dB SNR
_44000b  .set  0      ;  8/14 80 dB SNR
_44000c  .set  0      ;  7/16 75 dB SNR
_44000d  .set  0      ;  6/19 70 dB SNR
_44000e  .set  0      ;  5/23 68 dB SNR
_44000f  .set  0      ;  4/28 65 dB SNR
_44000g  .set  0      ;  3/38 50 dB SNR

_48000a  .set  0      ; 10/10 Nyq alias, 70 dB SNR (low Vpp in)
_48000b  .set  0      ;  9/12 80 dB SNR
_48000c  .set  0      ;  8/13 80 dB SNR
_48000d  .set  0      ;  7/15 75 dB SNR
_48000e  .set  0      ;  6/17 72 dB SNR
_48000f  .set  0      ;  5/22 70 dB SNR
_48000g  .set  0      ;  4/26 60 dB SNR
_48000h  .set  0      ;  3/35 Nyq alias, 50 dB SNR (low Vpp in)

_78000a  .set  0      ;  8/ 8 All noise
_78000b  .set  0      ;  7/ 9 All noise
_78000c  .set  0      ;  6/11 Dead
_78000d  .set  0      ;  5/13 62 dB SNR
_78000e  .set  0      ;  4/16 60 dB SNR
_78000f  .set  0      ;  3/21 Nyq Alias, 45 dB SNR
_78000g  .set  0      ;  2/32 Ext noise - Unc gain

_100000a .set  0      ;  6/ 8 All noise
_100000b .set  0      ;  5/10 Nyq Alias, 45 dB SNR
_100000c .set  0      ;  4/12 60
_100000d .set  0      ;  3/16 50
_100000e .set  0      ;  2/24 Very noisy

_125000a .set  0      ;  4/10 Nyq Alias,    dB SNR
_125000b .set  0      ;  3/13 Nyq Alias,    dB SNR
_125000c .set  0      ;  2/20 Extremely noisy - Unc gain
;=======================================================;
;ADC & DAC TA/TB (RA/RB) switch table                   ;
;=======================================================;
     .if  _2560                 ; Fs=2.560 kHz (minimum)
TA              .word   31      ;
TB              .word   63      ;
     .endif                     ;
;*******************************
     .if  _5000a                ; Fs=5.000 kHz
TA              .word   25      ;
TB              .word   40      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _5000b                ; Fs=5.051 kHz
TA              .word   22      ;
TB              .word   45      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _5000c                ; Fs=5.000 kHz
TA              .word   20      ;
TB              .word   50      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _5000d                ; Fs=4.960 kHz
TA              .word   18      ;
TB              .word   56      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _5000e                ; Fs=4.960 kHz
TA              .word   16      ;
TB              .word   63      ;
     .endif                     ;
;*******************************
     .if  _10000a               ; Fs=9.921 kHz
TA              .word   12      ;
TB              .word   42      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _10000b               ; Fs=10.101 kHz
TA              .word   11      ;
TB              .word   45      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _10000c               ; Fs=10.000 kHz
TA              .word   10      ;
TB              .word   50      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _10000d               ; Fs=9.921 kHz
TA              .word    9      ;
TB              .word   56      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _10000e               ; Fs=9.921 kHz
TA              .word    8      ;
TB              .word   63      ;
     .endif                     ;
;*******************************
     .if  _20000a               ; Fs=20.161 kHz
TA              .word    8      ;
TB              .word   31      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _20000b               ; Fs=19.841 kHz
TA              .word    7      ;
TB              .word   36      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _20000c               ; Fs=19.841 kHz
TA              .word    6      ;
TB              .word   42      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _20000d               ; Fs=20.000 kHz
TA              .word    5      ;
TB              .word   50      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _20000e               ; Fs=19.841 kHz
TA              .word    4      ;
TB              .word   63      ;
     .endif                     ;
;*******************************
     .if  _38000a               ; Fs=37.037 khz
TA              .word    9      ;
TB              .word   15      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _38000b               ; Fs=39.063 khz
TA              .word    8      ;
TB              .word   16      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _38000c               ; Fs=37.593 khz
TA              .word    7      ;
TB              .word   19      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _38000d               ; Fs=37.879 khz
TA              .word    6      ;
TB              .word   22      ;
     .endif                     ;
;*******************************
     .if  _44000a               ; Fs=42.735 khz
TA              .word    9      ;
TB              .word   13      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000b               ; Fs=44.643 khz
TA              .word    8      ;
TB              .word   14      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000c               ; Fs=44.643 khz
TA              .word    7      ;
TB              .word   16      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000d               ; Fs=43.860 khz
TA              .word    6      ;
TB              .word   19      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000e               ; Fs=43.478 khz
TA              .word    5      ;
TB              .word   23      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000f               ; Fs=44.643 khz
TA              .word    4      ;
TB              .word   28      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _44000g               ; Fs=43.860 khz
TA              .word    3      ;
TB              .word   38      ;
     .endif                     ;
;*******************************
     .if  _48000a               ; Fs=50.000 khz
TA              .word   10      ;
TB              .word   10      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000b               ; Fs=46.296 khz
TA              .word    9      ;
TB              .word   12      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000c               ; Fs=48.077 khz
TA              .word    8      ;
TB              .word   13      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000d               ; Fs=47.619 khz
TA              .word    7      ;
TB              .word   15      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000e               ; Fs=49.019 khz
TA              .word    6      ;
TB              .word   17      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000f               ; Fs=45.455 khz
TA              .word    5      ;
TB              .word   22      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000g               ; Fs=48.077 khz
TA              .word    4      ;
TB              .word   26      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _48000h               ; Fs=47.619 khz
TA              .word    3      ;
TB              .word   35      ;
     .endif                     ;
;*******************************
     .if  _78000a               ; Fs=78.125 kHz
TA              .word    8      ; All noise
TB              .word    8      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000b               ; Fs=79.365 kHz
TA              .word    7      ; All noise
TB              .word    9      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000c               ; Fs=75.758 kHz
TA              .word    6      ; DEAD
TB              .word   11      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000d               ; Fs=76.923 kHz
TA              .word    5      ; 62 dB SNR
TB              .word   13      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000e               ; Fs=78.125 kHz
TA              .word    4      ; 65 dB SNR
TB              .word   16      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000f               ; Fs=79.365 kHz
TA              .word    3      ; Nyquist aliased image
TB              .word   21      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _78000g               ; Fs=78.125 kHz
TA              .word    2      ; Extreme noise - Uncontrolled gain
TB              .word   32      ;
     .endif                     ;
;*******************************
     .if  _100000a              ; 104 kHz
TA              .word    6      ; All noise - No signal is apparant
TB              .word    8      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _100000b              ; 100 kHz Very odd behaviour.
TA              .word    5      ; Fdisp = Fin(1+Fnyq)/2
TB              .word   10      ;   Original 0-50 kHz input
     .endif                     ;   has 50-0 kHz image added to it
;- - - - - - - - - - - - - - - -
     .if  _100000c              ; 104 kHz
TA              .word    4      ; 60 dB SNR - Seems to work OK otherwise
TB              .word   12      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _100000d              ; 104 kHz
TA              .word    3      ; 50 dB SNR - Seems to work OK otherwise
TB              .word   16      ;
     .endif                     ;
;- - - - - - - - - - - - - - - -
     .if  _100000e              ; 104 kHz
TA              .word    2      ; Very noisy
TB              .word   24      ;
     .endif                     ;
;*******************************
     .if  _125000a              ; 125 kHz  -  Good SNR, except for image
TA              .word    4      ; Fdisp = Fin(1+Fnyq)/2
TB              .word   10      ;   Original 0-64 kHz input
     .endif                     ;   has 64-0 kHz image added to it
;- - - - - - - - - - - - - - - -
     .if  _125000b              ; 128 kHz
TA              .word    3      ; Fdisp = Fin(1+Fnyq)/2
TB              .word   13      ;   Original 0-64 kHz input
     .endif                     ;   has 64-0 kHz image added to it
;- - - - - - - - - - - - - - - -
     .if  _125000c              ; 125 kHz
TA              .word    2      ; Extremely noisy - Gain is uncontrolled
TB              .word   20      ;
     .endif                     ;
;*******************************
AIC_CMD         .word   0x0003  ; 0x72  0000 0000 0000 0011=0x0003
SIG_DEL         .word   0x0000  ; 0x73
STAT1           .word   0x0000  ; 0x74
ACCU_lo         .word   0x0000  ; 0x75
ACCU_hi         .word   0x0000  ; 0x76
REAL            .word   0x0000  ; 0x77
IMAG            .word   0x0000  ; 0x78
AUX0            .word   0x0000  ; 0x79
AUX1            .word   0x0000  ; 0x7A
FFT_S           .word   256     ;
FFT_S-1         .word   255     ;
FFT_S/2         .word   128     ;
FFT_S/2-1       .word   127     ;
scratch         .word   0
;----------------------------------------------------------------
;    SECONDARY VECTOR TABLE LOCATED IN B0 PROGRAM RAM
;----------------------------------------------------------------
        .mmregs                 ;
        .ps     080ah           ;
        B       RINT            ;RINT  Branch to receive interrupt routine
        B       XINT            ;XINT  XINT is only for timing, so just return
                                ;
;----------------------------------------------------------------
;    APPLICATION CODE IS LOCATED ABOVE DSKD KERNAL
;----------------------------------------------------------------
        .ps     0x0a00          ;
        .entry                  ;
start:                          ;
        SETC    INTM
        SETC    SXM
        SETC    OVM             ; catch accumulator overflows
        LDP     #0              ; All direct addressing is to MMRs and B2
        SPLK    #0830h,PMST
        LACC    #0
        SAMM    CWSR            ; Setsoftware wait stat eto 0
        SAMM    PDWSR           ;
        SPLK    #020h,IMR       ; Using XINT syn TX & RX
                                ; initialize AIC and enable interrupts
AIC_RS  SPLK    #01h,PRD        ; To generate  10MHz from Tout
        SPLK    #20h,TCR        ; for AIC maste rclock
        MAR     *,AR0
        LACC    #0008h          ; Non continuous mode
        SACL    SPC             ; FSX as input
        LACC    #00c8h          ; 16 bit words
        SACL    SPC
        LACC    #080h           ;
        SACH    DXR
        SACL    GREG
        LAR     AR0,#0FFFFh     ; Reset AIC by pulsing BR\pin
        RPT     #500            ; and taking it high after 500 cycles
        LACC    *,0,AR0         ; (.25ms at 50ns )
        SACH    GREG
        SETC    SXM             ;
;-------------------------------
        LACC    AIC_CMD         ; AIC control
        CALL    AIC_2nd         ; call loader
        ;------------------------
        LACC    TB,2            ; AIC timing B regs
        ADD     TB,9            ;
        ADD     #2              ;
        CALL    AIC_2nd         ; call loader
        ;-----------------------
        LACC    TA,2            ; AIC timing A regs
        ADD     TA,9            ;
        CALL    AIC_2nd         ; call loader
        ;-----------------------
        LDP     #0
        LACC    #010h           ; AIC RINT
        SACL    IMR             ; where INT0 indicates EOC (End Of Conv)
;************************************************************************
MAIN:   CALL    Init_S          ; Load 512 alternating data points
        LAR     AR0,FFT_S       ; Sigma FFT
        CALL    FFT             ;

      .if ONEPASS
        CALL    TO_HOST         ;
        B       MAIN
        ;-----------------------
      .else
        CALL    Init_D          ;
        LAR     AR0,FFT_S       ; Delta FFT
        CALL    FFT             ;
      .endif
;************************************************************************
AVG2:   LAR     AR5,#_B_base
        LAR     AR6,#_D_base
        LAR     AR7,#255
        MAR     *,AR5
AVGX:   LACC    *+,0,AR6
        ADD     *
        SFR
        SACL    *+
        MAR     *+,AR7
        BANZ    AVGX,*-,AR5
        CALL    TO_HOST         ;
        ;-----------------------
        B       MAIN            ;

;************************************************************************
Init_S: LAR     AR6,#_D_base     ; _D_base = A1[n],A2[n],A1[n+1],A2[n+1],...
        LAR     AR7,#511        ;
        MAR     *,AR7             ; enable buffer fill
        CLRC    INTM            ; Fill FFT array with 512 samples
FILL    BANZ    FILL,*,AR7      ;
        SETC    INTM            ;
        LAR     AR5,#_B_base     ;
        LAR     AR6,#_D_base     ;
        LAR     AR7,#255         ;
        MAR     *,AR6             ;
FILLX   LACC    *+,0,AR5        ; Load first 256 into buffer array
        SACL    *+,0,AR7        ;
        BANZ    FILLX,*-,AR6    ;
        ;-----------------------
        LAR     AR7,#255        ;
        LAR     AR5,#_D_base     ;
        MAR     *,AR6             ;
FILLY   LACC    *+,16,AR5       ; Then backfill last 256 into FFT array
        SACH    *+              ; REAL=X[n]
        SACL    *+,0,AR7        ; IMAG=0
        BANZ    FILLY,*-,AR6    ;
        RET                     ;
;************************************************************************
Init_D: LAR     AR6,#_D_base     ;
        LAR     AR5,#_B_base     ; Flip Flop data buffer and FFT array
        LAR     AR7,#255        ;
        MAR     *,AR5             ;
FILLD   LACL    *,AR6           ; get x[n+256]
        LAR     AR0,*           ; get X[n]
        SACL    *+              ; REAL=X[n]
        SACH    *+,0,AR5        ; IMAG=0
        SAR     AR0,*+,AR7      ; save X[n] in data buffer
        BANZ    FILLD,*-,AR5    ;
        RET                     ;
*************************************************************************
TO_HOST LACC    #80h
        CALL    BCXMIT          ; Send frame synch (START)
        CALL    BRECV           ; Wait for host start word (01Bh)
        SUB     #01Bh
        NOP                     ; Insert NOPs to ensure condition was ready
        NOP                     ; while execute BCND
        BCND    TO_HOST,NEQ
        LAR     AR3,#_D_base    ;AR3= FFT data array
        LAR     AR5,FFT_S/2-1   ;AR5= loop counter
        MAR     *,AR3           ;
more2   LACC    *+              ;scale log magnitude for host
        MAR     *+              ;skipping imaginary
        RPT     #7              ;
        SFR                     ;
        CALL    XMIT            ;
        MAR     *,AR5           ;
        BANZ    more2,*-,AR3    ;
        RET
;***********************************************************************
FFT:    MAR     *,AR0             ; Calculate FFT parameters from AR0 = Size
        SAR     AR0,FFT_S       ;
        MAR     *-              ;
        SAR     AR0,FFT_S-1     ;
        MAR     *+              ;
        MAR     *BR0+           ; AR0 = AR0 >> 1;
        SAR     AR0,FFT_S/2     ;
        MAR     *-
        SAR     AR0,FFT_S/2-1   ;
        ;-----------------------
        LAR     AR0,FFT_S/2     ;
new_stg LAR    AR1,#_D_base     ; AR1 is the TOP BFLY address
        LAR    AR2,#_D_base     ; AR2 is the BOT BFLY address
        LAR    AR3,#_T_base+1   ; AR3 is the TWiddle pointer
        LAR     AR4,FFT_S/2     ; AR4 counts DFT blocks
        B       n_DFT2,*,AR1    ;
DFT:    MAR     *BR0+,AR5       ; complete circular buffer for TW's
        LAR     AR5,#1           ; set up DFT loop with *BR0+/BANZ
        MAR     *BR0+,AR1       ; using 1 cuts *BR0+ loop in half!
        ;----------------------------------------
        ; AR1=Top AR2=Bottom AR3=Twiddle
        ;----------------------------------------
BFLY:   LACC    *,14,AR2        ;(imag1+imag2)/4
        ADD     *,14,AR1        ;
        SACH    *+,1,AR2        ;store TOP imag
        SUB     *,15            ;(imag1-imag2)/2
        SACH    *+,1,AR1        ;store BOT imag
        LACC    *,14,AR2        ;(real1+real2)/4
        ADD     *,14,AR1        ;
        SACH    *+,1,AR2        ;store TOP real
        SUB     *,15            ;(real1-real2)/2
        SACH    *,1,AR5         ;store BOT real
        BANZ    OK,*BR0+,AR3    ;If at DFT end quit early
        ;-----------------------
        MAR     *+,AR2          ;clean up TW base (xxx0000+1)
        MAR     *+              ;modify BOTom DATA pointer
        MAR     *0+             ;
        MAR     *0+,AR1         ;
n_DFT2: MAR     *0+             ;modify the TOP pointer
        MAR     *0+,AR4         ;
        BANZ    DFT,*0-,AR3     ;dec DFT block count AR4 by OFFset
        MAR     *,AR0             ;
        MAR     *BR0+           ;
        BANZ    new_stg,*       ;if OFFset was 1, now cleared
        B       endFFT          ;
        ;-----------------------
OK      LT      *-,AR2          ;TREG=TWR     *NOTE* Twiddles are Q15
        MPY     *-              ;PREG=REAL*TWR
        LTP     *+,AR3          ;TREG=IMAG     ACCU=REAL*TWR
        MPY     *               ;PREG=IMAG*TWI                AR2=R AR3=I
        LTS     *+,AR2          ;TREG=TWI      ACCU=REAL*TWR-IMAG*TWI
        MPY     *               ;PREG=REAL*TWI
        SACH    *-,1,AR2     ;<<;
        LTP     *,AR3           ;TREG=IMAG     ACCU=REAL*TWI
        MPY     *BR0+,AR2       ;PREG=IMAG*TWR
        APAC                    ;              ACCU=IMAG*TWR+REAL*TWI
        SACH    *+,1,AR2     ;<<;
        B       BFLY,*+,AR1     ;
        ;------------------------------------------------------------
endFFT: MAR     *,AR2           ;Transform REAL & IMAG to log magnitude
        LAR     AR2,#_D_base    ;AR3=FFT data pointer
        LAR     AR3,FFT_S-1     ;AR5=FFT loop counter
        LAR     AR0,FFT_S
        ;-----------------------------------------------------------;
        ; WINDOW: Performs post FFT raised cosine windowing!        ;
        ; This is done by using the frequency coefficients of the   ;
        ; window in a convolution filter of the spectrum.           ;
        ;-----------------------------------------------------------;
       ;mar      *BR0+          ; don't start at DC
more_MAG
        MAR      *BR0-          ;  -IMAG[-1]  1-COS(nwt/N)       + 1
        LACC     *BR0+,15       ;   IMAG[-0]  filter by post     |
        SUB      *BR0+,16       ;  +IMAG[+1]  convolution    <--+++-->
        ADD      *BR0-,15       ;   IMAG                        + + -.5
        SACH     IMAG           ;
        MAR      *+             ;   REAL
        MAR      *BR0-          ;  -REAL[-1]
        LACC     *BR0+,15       ;   REAL[-0]  X[-1] -2*X[0] + X[1]
        SUB      *BR0+,16       ;  +REAL[+1]
        ADD      *BR0-,15,AR1   ;   REAL
        SACH     REAL           ;
        SQRA    IMAG            ;IMAG & REAL can be at most 0x7fff Q15
        LTP     REAL            ;MPY will result (at most) in max positive
        MPY     REAL            ;
        APAC                    ;output is positive Q30
        ADD     #0x1            ;Set up a floor value; log(0) not legal!
        LAR     AR1,#17          ;pre-scaling exponent shifts Y axis
        RPT     #31             ;
        NORM    *-              ;
        NOP
        NOP
        MAR     *,AR2           ;
        MAR     *BR0-           ;-REAL;dump log(f) into oldest REAL (odd addr)
        SACH    *,2             ;clr explicit 1.0 and sign bit from mant
        LACL    *               ;load into ACCU_lo
        SAR     AR1,*           ;then append exponent (AR1)
        ADD     *,16            ;
        RPT     #10             ;jam result into ACCU_hi
        SFL                     ;If needed, Use ADDH to saturate overflow
     ;  sach    *               ;
     ;  addh    *               ;
        SACH    *               ;
        LACC    *               ;
        AND     #0xfffc,0       ;
        SACL    *BR0+           ; REAL
        MAR     *-              ; IMAG
        MAR     *BR0+,AR3       ;+IMAG
        BANZ    more_MAG,*-,AR2 ;keep going until all done
        ;--------------------------------------------------------
BITREV: LAR     AR0,FFT_S       ;Now perform Output bit reversal
        LAR    AR1,#_D_base     ;by moving the magnitude, which
        LAR    AR2,#_D_base+1   ;is in the REAL slots, into the
        LAR     AR3,FFT_S-1     ;IMAG slots of the FFT data array
more_BR LACC    *+              ;load the magnitude
        MAR     *+,AR1          ;
        SACL    *BR0+,0,AR3     ;move it to an open IMAG slot
        BANZ    more_BR,*-,AR2  ;more data to move?
        ;-----------------------
        RET                     ; FFT is finished!!
******************************************************************
AIC_2nd SACH    DXR
        CLRC    INTM
        IDLE
        ADD     #6,15           ;set ACCU_hi = 3 for secondary XMIT
        SACH    DXR             ;
        IDLE                    ;ACCU_hi requests 2nd XMIT
        SACL    DXR             ;
        IDLE                    ;ACCU_lo sets up registers
        SACL    DXR,2           ;close command with LSB = 00
        IDLE
        RET                     ;
*******************************************************************
; Transmitt a character
*******************************************************************
;============================================================================
; Trasmit word routine
;============================================================================
xmtwrd  SACL    scratch
        RPT     #7
        SFR
        CALL    XMIT            ; send highbyte
        LACC    scratch         ;
BCXMIT  BCND    $+4,bio         ; expect a sync (0) signal from PC
        B       $-2
;-----------------------------------------------------------------------------
; xmtbyte follows now           ; send lowbyte and return to calling pgm
;
;  'xmtbyte' requires ARP->AR0 and sets ACCU='mask for byte'
;  send startbit (0) +  databyte + stopbits (2)
;-----------------------------------------------------------------------------
XMIT    CLRC    c               ; startbit=0
        LAR     ar1,#8          ; counter: 1 startbit+ 8 databits (+ 2 stopbits)
nextbit1 BCND   snd0,nc         ; if c=1 send 1 else send 0
snd1    SETC    xf              ; send one
        B       snd
snd0    CLRC    xf
snd     RPT     #BITLEN         ; send one bit
        MAR     *,ar1
        ROR                     ; lsb(accu) -> carrybit
        BANZ    nextbit1,*-     ; repeat for entire word (10 bits)
        SETC    xf
        RPT     #BITLEN
        NOP
        RPT     #BITLEN
        NOP
        RET
;============================================================================
; Read Routine
;============================================================================
BRECV:
wait    BCNDD   STOK,bio        ;wait for start bit
        LAR     AR1,#7
        LACL    #0
        B       wait            ;
STOK    RPT     #BITLEN2        ;BITLEN is scaled and
        NOP
        MAR     *,AR1           ;number of bits - 1
WTBIT   SFR
        RPT     #BITLEN         ;decremented by 8/3 for
        NOP                     ;BITLEN/2 wait
        BCND    ZEROBT,bio
        ADD     #80h
ZEROBT  BANZ    WTBIT,*-        ;last bit ?
        RET                     ;ACC = read value

****************************************************************************
****************************************************************************
****************************************************************************
;******************************************************************
; NOTE: This code is NOT written with context restore!
;************************************************************************
RINT:   SST     #1,STAT1        ;Recover ARP from ARB by LST1
        MAR     *,AR7           ;
        BANZ    more_buf,*-,AR6 ;if buffer is full RET w/o EINT
        LAR     AR7,#0          ;
        LST     #1,STAT1        ;
        RET                     ;
more_buf                        ;
        LACC    DRR             ;
        SACL    *+              ;<<< store Ax[n], point to next
        ;-----------------------
FASTRET LST     #1,STAT1        ;
        RETE                    ;
XINT:   RETE
;====================================================================
        .listoff                ;
        .ds     01000h          ;NOTE: Twiddles are relocated to
        .include "dsk_twid.asm" ;      0x400 (B2) using CONF 1
        .liston
        .end
