;       Output a tune made up of tones to DAC.
;
; Note: 1. Master clock = 10.000 MHz
;       2. The transmit and receive sections are in synchronous mode.
;          Tone generation is synced on the transmit interrupt.
;
;       Mike Reddish 31/5/95
; mba 4/97 define hex as h not H

	 .mmregs
	 .ds     0f00h
;
;
TA       .word    18
RA       .word    18
;
TB       .word    18       ; Conversion freq = 15.432Hz
RB       .word    18
AIC_CTR  .word    08h      ; xmit & RCV are synchronous
TIME     .word    0d60h           ; pulse duration
TIMER    .word    00000h
DIGIT    .word    00000h
;ramp     .word    0000h
; Coeffifients required for the sine generation
c1      .word   25736   ;(6488h) 1.570796327
c3      .word   -10583  ;(d6a9h) -0.6459640968
c5      .word   1306    ;(051Ah) 0.07969260
c7      .word   -77     ;(ffb4h) -0.004681666
c9      .word   3       ;(0003h) 0.00016
sinput  .word   0
soutput .word   0
temp    .word   0       ; temp space
x2      .word   0       ; store for x2 (read as x squared)
x       .word    0       ; store for x
st1val  .word   07fdh
sintime .word   1096h; Value to give 1kHz frequency.
tonesum .word   0       ; sum of treble and base.
tonlen  .word   0       ; remaining length of tone (in samples).
valbase .word   0       ; current value of base.
valtreb .word   0       ; current value of treb.
ar1str  .word   0       ; Stroe fro Ar1
	.word   0       ; 1 blank value to seporate tones.

;
cro     .set    15432   ;crochet=1sec.
qua     .set    7716    ;quaver=.5sec.
sem     .set    3858    ;semiquaver=.25sec.
CC      .set    555     ;Values for notes
DD      .set    623
EE      .set    699
FF      .set    741
GG      .set    832
A       .set    934
B       .set    1048
C       .set    1111
D       .set    1247
E       .set    1400
F       .set    1483
G       .set    1664
a       .set    1868
b       .set    2097
c       .set    2222
	

;tonetab .word   15432,1111,555;cro,C,CC;
;	.word   15432,1247,623;cro,D,DD
;	.int    15432,1400,699;cro,E,EE,03
;	.word   15432,1483,741;cro,F,FF
;	.word   7716,1664,832;qua,G,GG
;	.word   7716,1868,934;qua,a,A
;	.word   3858,2097,1048;sem,b,B
;	.word   3858,2222,1111;sem,c,C
;toneend .word   0
;tonetab .word   15432,1111,1111;cro,C,CC;
;	.word   15432,1247,1048;cro,D,DD
;	.int    15432,1400,934;cro,E,EE,03
;	.word   15432,1483,832;cro,F,FF
;	.word   7716,1664,741;qua,G,GG
;	.word   7716,1868,699;qua,a,A
;	.word   3858,2097,623;sem,b,B
;	.word   3858,2222,555;sem,c,C
tonetab
	.include	minuet.txt
toneend .word   0

;***************************************************************
;   Set up the ISR vector                                      *
;***************************************************************
	 .ps     080ah         ;
rint:    B       RECEIVE       ;0A; Serial port receive interrupt RINT.
xint:    B       TRANSMIT      ;0C; Serial port transmit interrupt XINT.

;
;*****************************************************************
; TMS32C05X INITIALIZATION                                       *
;                                                                *
;*****************************************************************
	 .ps     0a00h
	 .entry
	 SETC    INTM             ; Disable interrupts
	 LDP     #0               ; Set data page pointer
	 OPL     #0834h,PMST      ; OR the status register
         LACC    #0
	 SAMM    CWSR             ; Set software wait state to 0
	 SAMM    PDWSR            ;
;         LACC    #3	          ; Set index register to THREE
;
	 CLRC    OVM              ; OVM = 0 normal accumulator overflow
	 SPM     0                ; PM = 0  no shift when transferring to ALU
;	 LACC    #0
;	lar	ar2,#tonetab
	ldp	#0
	splk	#03,INDX	; Set index register to 3.
	splk	#02,IMR		; disable tx int.
	ldp     #c1
	lst     #1,st1val       ; Set PM status bits to get correct shift
	zap                     ; zero accum.
	sacl    valbase
	lar     ar2,#tonetab    ;point to start of tone table.
	nop
	nop
	mar	*,ar2		; Make Ar4 current
	lacc    *+              ;load in first tone length.
	nop
	nop
	sar     ar2,ar1str      ;Save pointer.
	sacl    tonlen          ; and save it
; Reset AIC by writing to PA2 (address >52) to DSK

	ldp	#0
	 SPLK    #022h,IMR        ; Using XINT syn TX & RX
	 CALL    AICINIT          ; initialize AIC and enable interrupts
	 CLRC    INTM             ; Enable interrupts

forever  IDLE
	 B       forever 
	 
;------- end of main program ----------;

;
;--------------------------  RECIEVER ISR  --------------------------
; Not used
RECEIVE:        
		RETE
;--------------------------  Transmit ISR  --------------------------
;
TRANSMIT:
;Entry AR1 point to current treble value.
;      AR1 is the current AR pointer.
;	setc	XF
	mar	*,ar2		; make ar2 current
	ldp     #tonlen
	lacl	tonesum
	samm	DXR		; send out last sample.
;	lst     #1,st1val       ; Set PM status bits to get correct shift, make Ar1 current
	lacl    tonlen          ; See if need to change to next tone.
	lar     ar2,ar1str
	sub     #1              ; decrement counter.
	bcnd    lenok,NEQ       
		adrk    #2      ; point to next tone length
		lacl    *+      ; get tone length point to next treble value.
		bcnd    lenok,NEQ       ; if zero, then hit end of table.
			lar     ar2,#tonetab     ;point back to start of table
			lacl    *+      ; reload  tone length
lenok   sacl    tonlen          ;Save new tone length.
; Work out next sample for treble.
	lacl    valtreb         ; Get current treble value
	add     *+              ; add on treble from table, point to base.
	sacl    valtreb         ; save for next time
	sacl    sinput          
	call    sin             ; work out sin of value.
	lacc    soutput,0	; Get back result, and sign extend.
	sfr                     ; shift right (divide by 2).
	sacl    tonesum         ; save while work out base.
; Work out next sample for base.
       lacl    valbase         ; Get current base value
       add     *-              ; add on base from table, point to treble.
       sacl    valbase         ; save for next time
       sacl    sinput          
       call    sin             ; work out sin of value.
       lacc    soutput	       ; Get back result, and sign extend.
       sfr                     ; shift right (divide by 2).
; Add treble to base, and output.
       add     tonesum
       and     #0FFFCh,0       ; bits 0 & 1 have to be zero for AIC.
              sacl	tonesum
;	samm    DXR             ; send sample to AIC
	sar     ar2,ar1str
;	clrc	xf
	rete
	


;---------------------------- end of ISR ------------------------

;
;*****************************************************************
;  DESCRIPTION: This routine initializes the 'C50 serial port    *
;               and the TLC320C40's (AIC) TA,RA,TB,RB and        *
;               control registers                                *
;*****************************************************************
;
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
	 SPLK    #01h,PRD           ; for AIC master clock
	 MAR     *,AR0
	 LACC    #0008h             ; Non continuous mode
	 SACL    SPC                ; FSX as input
	 LACC    #00c8h             ; 16 bit words
	 SACL    SPC
	 LACC    #080h            ; Pulse AIC reset by setting it low
	 SACH    DXR
	 SACL    GREG
	 LAR     AR0,#0FFFFh
	 RPT     #10000           ; and taking it high after 10000 cycles
	 LACC    *,0,AR0          ; (.5ms at 50ns)
	 SACH    GREG
	 ;------------------------
	 LDP     #TA              ;
	 SETC    SXM              ;
	 LACC    TA,9             ; Initialize TA and RA register
	 ADD     RA,2             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #TB
	 LACC    TB,9             ; Initialize TB and RB register
	 ADD     RB,2             ;
	 ADD     #02h             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #AIC_CTR
	 LACC    AIC_CTR,2        ; Initialize control register
	 ADD     #03h             ;
	 CALL    AIC_2ND          ;
	 RET                      ;

AIC_2ND:
	 LDP     #0               ; Data page point is 0  (MM regs)
	 SACH    DXR              ; send ACChi 00
	 CLRC    INTM             ; enable interrupts
	 IDLE                     ; wait for interrupt
	 ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
	 SACH    DXR              ; send ACChi to initiate secondary protocol
	 IDLE                     ; wait for interrupt
	 SACL    DXR              ; send the T register data
	 IDLE                     ; wait for interrupt
	 LACL    #0               ; clear ACClo
	 SACL    DXR              ; send another to make sure 1st word got sent
	 IDLE                     ; wait for interrupt
	 SETC    INTM
	 RET                      ;


	.INCLUDE SINSUB.ASM



	.end

