/****************************************************************************
 * Information
 ****************************************************************************
 PROGRAM    PC controlled octave  generator
				FILE NAME       ; pc_tune.c
				INCLUDE FILES   ; hi5_lib.h, hi5_lib.c {modified from original}
				PROCESSOR       ; TMS320C5x
				AUTHOR          ; irm uh
				DATE/VERSION    ; 4/97  / Ver 1.3
				COMPILER			 ; Borland C version 4
 ****************************************************************************
 * DESCRIPTION
 ****************************************************************************
 This program is the PC Half of the tune generator.
 It resets the DSK, downloads the DSK program and starts execution
 Once the program is running the keys 1-7 control the pitch of the note
 */

#include "HI5_LIB.H"
STRUCT_IMR imr;             /* You need to include external structures, */
PARAMETER prm;              /* variables, constants, etc HERE if you    */
extern MSGRx, MSGRy;        /* plan to use them in MAIN                 */
extern pcom;                /* (commport address)                       */
extern  char appfile[] = "pc_tune.dsk";

int main(void)             /* See HI5_LIB.H for data types             */
{
 /*---------------------------------------------------------------------*/
 /* It is suggested you use the following code to properly initialize   */
 /* the DSK and load your application file to the DSK                   */
  int c,d;
  clrscr();
  prm.com = 0;              /* Set commport (1)                         */
  prm.speed = 19200;        /* Set baudrate                             */
  prm.PGM_CNT = 0x980;      /* Set DSP program counter                  */
  prm.INVERSE = YES;        /* Set inverse pin for most common          */
  GetArguments();           /* Get any command line agruments           */
  InitializeMonitor();      /* Init communication with DSK              */
  LoadDsk();                /* Load the application file to the DSK     */
  InitRegister(YES);        /* Init DSP internal registers (optional)   */
  FreeRun(0x0a00);

  /*--------------------DSK initialization completed -------------------*/
  printf("\n \n\ \n");
  printf("Program Loaded & Running.\n");
  printf("-------------------------\n \n");
  printf("press '1' for the 'do' note.\n");
  printf("press '2' for the 're' note.\n");
  printf("press '3' for the 'mi' note.\n");
  printf("press '4' for the 'fa' note.\n");
  printf("press '5' for the 'sol' note.\n");
  printf("press '6' for the 'la' note.\n");
  printf("press '7' for the 'si' note.\n");
  printf("etc. etc.\n \n");
  printf("press 'q' to quit.\n");
  printf("=============================\n");
  /* set the DSK to play 'do' */
  comout(1);
  delay(20);
  /* flush out any characters on the RS232 port */
  while (newchar())
		d = comin();
  while(1){
	 if (kbhit()){
		c = getch();
		 /* if the user presses 'q' then shut-down the DSK and exit */
		if (c=='q') {
			reset50();
			return 0;
		}
		/* send the value to the DSK to determine the note to  be played */
		switch (c){
		  case '1': c=1;		comout(c); break;
		  case '2': c=2; 		comout(c); break;
		  case '3': c=3; 		comout(c); break;
		  case '4': c=4; 		comout(c); break;
		  case '5': c=5; 		comout(c); break;
		  case '6': c=6; 		comout(c); break;
		  case '7': c=7; 		comout(c); break;
		}
	 }
	 delay(20);
	 while (newchar()){
		/* if we can any data from the DSK then display it on the screen */
		d = comin();
		printf(": %x\n",d);

	 }
  }
}
