;==============================================================================
; Communication routines for the TMS320C50 DSK
; This must be used in conjuction with 'com_init.asm' which holds the values
; for initialising registers
; Code extracted from DSK Kernel
; Ian Munro
; University of Hertfordshire
;==============================================================================


;===================  RXBYTE ==================================================
; Reads a byte (char) from the RS232 port and stores it in the lower 8 bits of
; the accumulator
; Baud rate is defined in 'com_init.asm'
RXBYTE:
		rpt #BITLEN
		nop
wait01:
		bcndd start01,bio ; wait for start bit
		lar  	ar5,#7      ; delayed branch filled
		lacl  #0
		b		wait01
start01:
		rpt	#BITLEN2     ; wait for half bit length
		nop
		mar	*,AR5
wbit01:
		sfr
		rpt	#BITLEN
		nop
		bcnd	zbit01,bio
		add	#80h        ; set bit in accumulator if bio(rx) is one
zbit01:
		banz	wbit01,*-  ; loop 8 times
		ret


;===================  TXBYTE ==================================================
; Transmits a byte (char) held in the lower 8 bits of the accumulator
; Baud rate is defined in 'com_init.asm'
TXBYTE:
		clrc	c          ;start bit = 0
		lar	ar5,#9    ;counter = 1 startbit + 8 data + 2 stop
nextbit01:
		bcnd	sbit01,nc  ;if c=1 send 1 else send 0
		setc 	xf
		b		sbit00
sbit01:
		clrc	xf
sbit00:
		rpt 	#BITLEN     ; delay for data bit
		mar	*,ar5
		ror
		banz	nextbit01,*-
		setc 	xf         ; send stop bits
		rpt	#BITLEN
		nop
		rpt	#BITLEN
		nop
		ret


