
         .MMREGS
         .ds      0f00h
TA       .word    10        ;
RA       .word    10        ;  This set up of AIC registers give
                            ;  a sampling freq of 10,000 Hz
                            ;
TB       .word    50        ;
RB       .word    50        ;
AIC_CTR  .word    08h       ; AIC is in sync mode w/ preamp gain =1
pwidth   .set     0a6h      ; a6h for 115200 baud
                            ; 15ah for 57600 baud

****************************************************************
*   Set up the ISR vector                                      *
****************************************************************
         .ps      0080ah
rint:    B        RCV
xint:    B        XMIT

         .ps       0a00h
         .entry                  ;
         ;--------------------------------------------------------------

         SETC    INTM
         LDP     #0
         OPL     #0834h,PMST
         LACC    #0
         SAMM    CWSR
         SAMM    PDWSR
         SETC    SXM           ;  SXM MUST BE SET
         SPLK    #022h,IMR     ; This turns on transmit interrupt only

         CALL    AICINIT       ;
         SPLK    #012h,IMR     ; turn on receive interrupt
         CLRC    OVM
         SPM     0             ;
         CLRC    SXM           ;
         LACC    #0FFFh,4
         CLRC    INTM          ;
         LDP     #pwidth
WAIT:    NOP                      ; wait for a transmit or receive
         B       WAIT
stop:    B       stop
;------- end of main program ----------;

;
; RECIEVER INTERRUPT SERVICE ROUTINE
;
RCV:
         LAMM    DRR              ; read data from DRR and send it to PC
         RPT     #7
         SFR
xfrbyte:
         CLRC    C
         LAR     AR1,#8
nextbit: BCND    ZERO,NC
ONE:     SETC    XF
         B       send
ZERO:    CLRC    XF
send:    RPT     #pwidth
         MAR     *,AR1
         ROR
         BANZ    nextbit,*-
         SETC    XF
         RPT     #pwidth
         NOP
         RPT     #pwidth
         NOP
         RETE

*
;
; TRANSMIT INTERRUPT SERVICE ROUTINE
;
XMIT:
         RETE

*
******************************************************************
*  DESCRIPTION: This routine initializes the TLC320C40 for       *
*		a 8Khz sample rate with a gain setting of 1	 *
******************************************************************
* aic initialization data
*
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
         SPLK    #01h,PRD           ; for AIC master clock
         MAR     *,AR0
         LACC    #0008h             ; Non continuous mode
         SACL    SPC                ; FSX as input
         LACC    #00c8h             ; 16 bit words
         SACL    SPC
         LACC    #080h            ; Pulse AIC reset by setting it low
         SACH    DXR
         SACL    GREG
         LAR     AR0,#0FFFFh
         RPT     #10000           ; and taking it high after 10000 cycles
         LACC    *,0,AR0          ; (.5ms at 50ns)
         SACH    GREG
         ;------------------------
         LDP     #TA              ;
         SETC    SXM              ;
         LACC    TA,9             ; Initialize TA and RA register
         ADD     RA,2             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #TB
         LACC    TB,9             ; Initialize TB and RB register
         ADD     RB,2             ;
         ADD     #02h             ;
         CALL    AIC_2ND          ;
         ;------------------------
         LDP     #AIC_CTR
         LACC    AIC_CTR,2        ; Initialize control register
         ADD     #03h             ;
         CALL    AIC_2ND          ;
         RET                      ;

AIC_2ND:
         LDP     #0               ; Data page point is 0  (MM regs)
         SACH    DXR              ; send ACChi 00
         CLRC    INTM             ; enable interrupts
         IDLE                     ; wait for interrupt
         ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
         SACH    DXR              ; send ACChi to initiate secondary protocol
         IDLE                     ; wait for interrupt
         SACL    DXR              ; send the T register data
         IDLE                     ; wait for interrupt
         LACL    #0               ; clear ACClo
         SACL    DXR              ; send another to make sure 1st word got sent
         IDLE                     ; wait for interrupt
         SETC    INTM
         RET                      ;
        .END

