;                          LOW-PASS FILTER
;
;  -> FIR FILTER
;     This program uses an 80 tap FIR filter to implement a LOPASS filter.
;     The filter passes frequencies less than 1.0KHz. Blackman filter
;     windowing was used when calculating the filter's coefficients.
;
;  -> AIC
;     AIC set-up parameters. For DSK running at 40 mhz, the sampling
;     frequency is 10,000,000/2/TA/TB for transmit and is
;     10,000,000/2/RA/RB for receive. The max value for TA,TB.RA,RB is 63
;     since the registers are 6 bits.
;
;     RANDOM NOISE GENERATOR
;  -> A random noise generator is included in this code to allow the user
;     to hear the differences in the filtered output or see them using a
;     spectrum analyzer. The random noise generator can be put in by
;      removing
;     the semicolons ; at the leftmost column of every asm statement of the
;     Random Noise Generator.
;
;
;
;
; ------------------------------------------------------------------------

	 .MMREGS
	 .ds      0f00h
TA       .word    16         ;
RA       .word    16         ;  This set up of AIC registers give
			     ;  a sampling freq of 10,081 Hz
			     ;
TB       .word    31         ;
RB       .word    31         ;
AIC_CTR  .word    08h
OUTPUT   .word    0
TEMP     .word    0          ; location of TEMPorary storage
TEMP1    .word    0          ;
seed     .word    07e6dh     ; seed for random noise generator

;Filter Coefficient Generator   lopass @ fcut=1K
h0      .word         0    ;  40        0.0000
h1      .word      -157    ;  39        -0.0048
h2      .word      -261    ;  38        -0.0080
h3      .word      -268    ;  37        -0.0082
h4      .word      -170    ;  36        -0.0052
h5      .word         0    ;  35        -0.0000
h6      .word       180    ;  34        0.0055
h7      .word       301    ;  33        0.0092
h8      .word       310    ;  32        0.0095
h9      .word       198    ;  31        0.0060
h10     .word         0    ;  30        0.0000
h11     .word      -211    ;  29        -0.0065
h12     .word      -354    ;  28        -0.0108
h13     .word      -367    ;  27        -0.0112
h14     .word      -236    ;  26        -0.0072
h15     .word         0    ;  25        -0.0000
h16     .word       255    ;  24        0.0078
h17     .word       431    ;  23        0.0132
h18     .word       451    ;  22        0.0138
h19     .word       292    ;  21        0.0089
h20     .word         0    ;  20        0.0000
h21     .word      -323    ;  19        -0.0098
h22     .word      -551    ;  18        -0.0168
h23     .word      -584    ;  17        -0.0178
h24     .word      -383    ;  16        -0.0117
h25     .word         0    ;  15        -0.0000
h26     .word       438    ;  14        0.0134
h27     .word       763    ;  13        0.0233
h28     .word       827    ;  12        0.0252
h29     .word       557    ;  11        0.0170
h30     .word         0    ;  10        0.0000
h31     .word      -681    ;   9        -0.0208
h32     .word     -1240    ;   8        -0.0378
h33     .word     -1417    ;   7        -0.0432
h34     .word     -1022    ;   6        -0.0312
h35     .word         0    ;   5        -0.0000
h36     .word      1533    ;   4        0.0468
h37     .word      3307    ;   3        0.1009
h38     .word      4960    ;   2        0.1514
h39     .word      6131    ;   1        0.1871
;zero   .word      6554    ;   0        0.2000
h40     .word      6131    ;   1        0.1871
h41     .word      4960    ;   2        0.1514
h42     .word      3307    ;   3        0.1009
h43     .word      1533    ;   4        0.0468
h44     .word         0    ;   5        -0.0000
h45     .word     -1022    ;   6        -0.0312
h46     .word     -1417    ;   7        -0.0432
h47     .word     -1240    ;   8        -0.0378
h48     .word      -681    ;   9        -0.0208
h49     .word         0    ;  10        0.0000
h50     .word       557    ;  11        0.0170
h51     .word       827    ;  12        0.0252
h52     .word       763    ;  13        0.0233
h53     .word       438    ;  14        0.0134
h54     .word         0    ;  15        -0.0000
h55     .word      -383    ;  16        -0.0117
h56     .word      -584    ;  17        -0.0178
h57     .word      -551    ;  18        -0.0168
h58     .word      -323    ;  19        -0.0098
h59     .word         0    ;  20        0.0000
h60     .word       292    ;  21        0.0089
h61     .word       451    ;  22        0.0138
h62     .word       431    ;  23        0.0132
h63     .word       255    ;  24        0.0078
h64     .word         0    ;  25        -0.0000
h65     .word      -236    ;  26        -0.0072
h66     .word      -367    ;  27        -0.0112
h67     .word      -354    ;  28        -0.0108
h68     .word      -211    ;  29        -0.0065
h69     .word         0    ;  30        0.0000
h70     .word       198    ;  31        0.0060
h71     .word       310    ;  32        0.0095
h72     .word       301    ;  33        0.0092
h73     .word       180    ;  34        0.0055
h74     .word         0    ;  35        -0.0000
h75     .word      -170    ;  36        -0.0052
h76     .word      -268    ;  37        -0.0082
h77     .word      -261    ;  38        -0.0080
h78     .word      -157    ;  39        -0.0048
h79     .word         0    ;  40        0.0000


XN       .word     0,0,0,0,0,0,0,0,0,0    ; 80 data locations for 80
XN1      .word     0,0,0,0,0,0,0,0,0,0    ; stage delay line
XN2      .word     0,0,0,0,0,0,0,0,0,0    ;
XN3      .word     0,0,0,0,0,0,0,0,0,0    ;
XN4      .word     0,0,0,0,0,0,0,0,0,0    ;
XN5      .word     0,0,0,0,0,0,0,0,0,0    ;
XN6      .word     0,0,0,0,0,0,0,0,0,0    ;
XN7      .word     0,0,0,0,0,0,0,0,0       ;
XNLAST   .word     0;

	.ps      0080ah
rint:    B       RECEIVE
xint:    B       TRANSMIT

	.ps       0a00h
	.entry                  ;
	;--------------------------------------------------------------

	SETC    INTM
	LDP     #0
	OPL     #0834h,PMST
	LACC    #0
	SAMM    CWSR
	SAMM    PDWSR
	SETC    SXM           ;  SXM MUST BE SET
	SPLK    #022h,IMR     ; This turns on receive interrupt only

	CALL    AICINIT       ;
	SPLK    #12h,IMR
	CLRC    OVM
	SPM     0             ;
	CLRC    INTM          ;

WAIT:                         ; a main program would go here
	B       WAIT          ;

RECEIVE:
	LDP      #XN
	CLRC     INTM         ; ENABLE INTERRUPTS FOR DEBUGGING DSK PURPOSES

; ----- Random Noise Generator --------------------
;        LACC    seed,1        ;
;        XOR     seed          ;
;        SACL    TEMP,2        ;
;        XOR     TEMP ;        ;
;        AND     #8000h        ;
;        ADD     seed,16       ;
;        SACH    seed,1        ; Reduce the output by at least 1/8
;        LACC    seed,11       ; to prevent the overflow
;        AND     #0FFFCh,15    ;
;        RPT     #14           ;
;        SFR                   ;

; ----- End of noise generator --------------------

			      ; Next line should not be commented out if the
			      ; generator code above is commented out.
	LAMM DRR              ; load accumulator with word received from AIC
	SACL     XN           ; store the value of received word to a variable

	LAR      AR0,#XNLAST  ; load AR0 with address of last delay element
	ZAP                   ; ZERO ACC AND PRODUCT REGISTERS
	MAR      *,AR0        ; AR0 is the current AR register.

	RPT      #79          ; Repeat the next instruction 80 times through
	MACD     #h0,*-       ; the complete coeff table.
	APAC                  ; Accumulate last product

	SACH     OUTPUT,1     ; ACC -> OUTPUT.  Get rid of xtra sign bit.
	LACC     OUTPUT
	SFL
	AND      #0fffch      ; Two LSB's must be zero for AIC
	SAMM     DXR          ; write output word to transmit register
	RETE                  ;


TRANSMIT:
	RETE


******************************************************************
;  DESCRIPTION: This routine initializes the 'C50 serial port    *
;               and the TLC320C40's (AIC) TA,RA,TB,RB and        *
;               control registers                                *
;*****************************************************************
;
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
	 SPLK    #01h,PRD           ; for AIC master clock
	 MAR     *,AR0
	 LACC    #0008h             ; Non continuous mode
	 SACL    SPC                ; FSX as input
	 LACC    #00c8h             ; 16 bit words
	 SACL    SPC
	 LACC    #080h            ; Pulse AIC reset by setting it low
	 SACH    DXR
	 SACL    GREG
	 LAR     AR0,#0FFFFh
	 RPT     #10000           ; and taking it high after 10000 cycles
	 LACC    *,0,AR0          ; (.5ms at 50ns)
	 SACH    GREG
	 ;------------------------
	 LDP     #TA              ;
	 SETC    SXM              ;
	 LACC    TA,9             ; Initialize TA and RA register
	 ADD     RA,2             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #TB
	 LACC    TB,9             ; Initialize TB and RB register
	 ADD     RB,2             ;
	 ADD     #02h             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #AIC_CTR
	 LACC    AIC_CTR,2        ; Initialize control register
	 ADD     #03h             ;
	 CALL    AIC_2ND          ;
	 RET                      ;

AIC_2ND:
	 LDP     #0               ; Data page point is 0  (MM regs)
	 SACH    DXR              ; send ACChi 00
	 CLRC    INTM             ; enable interrupts
	 IDLE                     ; wait for interrupt
	 ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
	 SACH    DXR              ; send ACChi to initiate secondary protocol
	 IDLE                     ; wait for interrupt
	 SACL    DXR              ; send the T register data
	 IDLE                     ; wait for interrupt
	 LACL    #0               ; clear ACClo
	 SACL    DXR              ; send another to make sure 1st word got sent
	 IDLE                     ; wait for interrupt
	 SETC    INTM
	 RET                      ;
	.END

