;
;                            AMPLITUDE MODULATOR
;
;  -> FIR FILTER
;     This program uses an 80 tap FIR filter to implement a BANDPASS filter.
;     The filter passes frequencies between 200Hz-1.8KHz. Blackman filter
;     windowing was used when calculating the filter's coefficients.
;
;  -> AIC
;     AIC set-up parameters. For DSK running at 40 mhz, the sampling
;     frequency is 10,000,000/2/TA/TB for transmit and is
;     10,000,000/2/RA/RB for receive. The max value for TA,TB.RA,RB is 63
;     since the registers are 6 bits.
;
;
;  -> MODULATION
;     The incoming signal is captured and loaded into the ACC. The sample is
;     run through a bandpass filter (BW = 200Hz to 1.8Kz). A carrier
;     frequency of 2.0Khz is generated using the coeff, sinx and Yminus1
;     variables. At this point the filtered signal is multiplied with the
;     carrier frequency. The output is an AM modulated signal with one carrier
;     at 2KHz and two side lobes (HS, LS).
;                                     |
;                                |    |    |
;    Low side = Fc-BW    ->    |||||  |  |||||  high side = Fc+BW
;                             ||||||| | |||||||
;
;                             |-LS--| Fc|-HS--|
;
;     The output is shown above. Connect the output to an spectrum analyzer
;     to see the following. The user can also listen to the output by
;     connecting a speaker. You will be able to hear the carrier (Fc), the
;     high side (HS= Fc+bw) and the low side (LS= Fc-Bw). The low side is
;     naturally frequency inverted.
;
; modifications mba, uh 3/97
; out of Q15 format insructions modified 
;
; ------------------------------------------------------------------------
;
	 .MMREGS
	 .ds      0f00h
TA       .word    16         ;
RA       .word    16         ;  This set up of AIC registers give
			     ;  a sampling freq of 10,081 Hz
			     ;
TB       .word    31         ;
RB       .word    31         ;
AIC_CTR  .word    08h
coeff    .word    5219       ; 10438
sinx     .word    15531      ; 31061
Yminus1  .word    02bfh      ;


;Filter Coefficient Generator   bandpass @ flcut=200hz  fhcut= 1800Hz

h0      .word         0    ;  40        0.0000
h1      .word         1    ;  39        0.0001
h2      .word         0    ;  38        0.0000
h3      .word         1    ;  37        0.0001
h4      .word        11    ;  36        0.0013
h5      .word        31    ;  35        0.0037
h6      .word        39    ;  34        0.0047
h7      .word        17    ;  33        0.0020
h8      .word       -11    ;  32       -0.0013
h9      .word        13    ;  31        0.0016
h10     .word       101    ;  30        0.0123
h11     .word       161    ;  29        0.0197
h12     .word        86    ;  28        0.0105
h13     .word       -91    ;  27       -0.0111
h14     .word      -169    ;  26       -0.0206
h15     .word        -0    ;  25       -0.0000
h16     .word       252    ;  24        0.0307
h17     .word       203    ;  23        0.0248
h18     .word      -288    ;  22       -0.0351
h19     .word      -812    ;  21       -0.0991
h20     .word      -772    ;  20       -0.0942
h21     .word      -157    ;  19       -0.0191
h22     .word       206    ;  18        0.0251
h23     .word      -503    ;  17       -0.0614
h24     .word     -1955    ;  16       -0.2386
h25     .word     -2716    ;  15       -0.3315
h26     .word     -1832    ;  14       -0.2237
h27     .word      -294    ;  13       -0.0359
h28     .word      -341    ;  12       -0.0416
h29     .word     -2846    ;  11       -0.3474
h30     .word     -5680    ;  10       -0.6934
h31     .word     -5541    ;   9       -0.6763
h32     .word     -1952    ;   8       -0.2382
h33     .word      1107    ;   7        0.1352
h34     .word     -1191    ;   6       -0.1453
h35     .word     -8518    ;   5       -1.0398
h36     .word     -13568   ;   4       -1.6562
h37     .word     -7758    ;   3       -0.9471
h38     .word      9971    ;   2        1.2171
h39     .word     30016    ;   1        3.6640
h40     .word     30016    ;   1        3.6640
h41     .word      9971    ;   2        1.2171
h42     .word     -7758    ;   3       -0.9471
h43     .word     -13568   ;   4       -1.6562
h44     .word     -8518    ;   5       -1.0398
h45     .word     -1191    ;   6       -0.1453
h46     .word      1107    ;   7        0.1352
h47     .word     -1952    ;   8       -0.2382
h48     .word     -5541    ;   9       -0.6763
h49     .word     -5680    ;  10       -0.6934
h50     .word     -2846    ;  11       -0.3474
h51     .word      -341    ;  12       -0.0416
h52     .word      -294    ;  13       -0.0359
h53     .word     -1832    ;  14       -0.2237
h54     .word     -2716    ;  15       -0.3315
h55     .word     -1955    ;  16       -0.2386
h56     .word      -503    ;  17       -0.0614
h57     .word       206    ;  18        0.0251
h58     .word      -157    ;  19       -0.0191
h59     .word      -772    ;  20       -0.0942
h60     .word      -812    ;  21       -0.0991
h61     .word      -288    ;  22       -0.0351
h62     .word       203    ;  23        0.0248
h63     .word       252    ;  24        0.0307
h64     .word        -0    ;  25       -0.0000
h65     .word      -169    ;  26       -0.0206
h66     .word       -91    ;  27       -0.0111
h67     .word        86    ;  28        0.0105
h68     .word       161    ;  29        0.0197
h69     .word       101    ;  30        0.0123
h70     .word        13    ;  31        0.0016
h71     .word       -11    ;  32       -0.0013
h72     .word        17    ;  33        0.0020
h73     .word        39    ;  34        0.0047
h74     .word        31    ;  35        0.0037
h75     .word        11    ;  36        0.0013
h76     .word         1    ;  37        0.0001
h77     .word         0    ;  38        0.0000
h78     .word         1    ;  39        0.0001
h79     .word         0    ;  40        0.0000


XN       .word     0,0,0,0,0,0,0,0,0,0    ; 80 data locations for 80
XN1      .word     0,0,0,0,0,0,0,0,0,0    ; stage delay line
XN2      .word     0,0,0,0,0,0,0,0,0,0    ;
XN3      .word     0,0,0,0,0,0,0,0,0,0    ;
XN4      .word     0,0,0,0,0,0,0,0,0,0    ;
XN5      .word     0,0,0,0,0,0,0,0,0,0    ;
XN6      .word     0,0,0,0,0,0,0,0,0,0    ;
XN7      .word     0,0,0,0,0,0,0,0,0      ;
XNLAST   .word     0                      ; extra word for the bit bucket
OUTPUT   .word     0

	.ps      0080ah
rint:    B       RECEIVE
xint:    B       TRANSMIT

	.ps       0a00h
	.entry                  ;
	;--------------------------------------------------------------

	SETC    INTM
	LDP     #0
	OPL     #0834h,PMST
	LACC    #0
	SAMM    CWSR
	SAMM    PDWSR
	SETC    SXM           ;  SXM MUST BE SET
	SPLK    #022h,IMR     ; This turns on receive interrupt only

	CALL    AICINIT       ;
	SPLK    #12h,IMR
	CLRC    OVM
	SPM     0             ;
	CLRC    INTM          ;
WAIT:                         ; a main program would go here
	B       WAIT          ;

RECEIVE:
	LDP      #XN
	CLRC     INTM         ; ENABLE INTERRUPTS FOR DEBUGGING DSK PURPOSES
	ZAP
;-------- generate carrier  -----
	LACC    Yminus1,15    ; y1 ==> ACC shift left 15 bit
	NEG                   ; -ACC ==> ACC
	MACD    coeff, sinx   ; coeff * y
	APAC                  ;
	APAC                  ; 2*coeff*y - y1
	SACH    sinx,1        ; Reduce the output by at least 1/8
	ZAP
;-------- get sample and run through bandpass filter ---------

	LAMM    DRR           ; load accumulator with word received from AIC
	SACL     XN,1           ; store the value of received word to a variable
	LAR      AR0,#XNLAST  ; load AR0 with address of last delay element
	ZAP                         ; ZERO ACC AND PRODUCT REGISTERS
	MAR      *,AR0        ; AR0 is the current AR register
	RPT      #79              ; Repeat next instruction 80 times
	MACD     #h0,*-
	APAC                  ; ACC LAST PRODUCT
	SACH     OUTPUT,1
;----------AM modulate bandpass on carrier
	ZAP                     ;clear accumulator and product register
	MAC     sinx,OUTPUT     ; Multiply the carrier with the filtered input
	APAC                    ; Product -> ACC
	SACH    OUTPUT,1        ; Save and discard extra sign bit.
	LACC    OUTPUT,1        ;out of Q15 format
	AND     #0FFFCh             ; Two LSB's must be zero for AIC
	SAMM    DXR                  ; Send to transmit register
	RETE


TRANSMIT:
	RETE


******************************************************************
;  DESCRIPTION: This routine initializes the 'C50 serial port    *
;               and the TLC320C40's (AIC) TA,RA,TB,RB and        *
;               control registers                                *
;*****************************************************************
;
AICINIT: SPLK    #20h,TCR           ; To generate 10 MHz from Tout
	 SPLK    #01h,PRD           ; for AIC master clock
	 MAR     *,AR0
	 LACC    #0008h             ; Non continuous mode
	 SACL    SPC                ; FSX as input
	 LACC    #00c8h             ; 16 bit words
	 SACL    SPC
	 LACC    #080h            ; Pulse AIC reset by setting it low
	 SACH    DXR
	 SACL    GREG
	 LAR     AR0,#0FFFFh
	 RPT     #10000           ; and taking it high after 10000 cycles
	 LACC    *,0,AR0          ; (.5ms at 50ns)
	 SACH    GREG
	 ;------------------------
	 LDP     #TA              ;
	 SETC    SXM              ;
	 LACC    TA,9             ; Initialize TA and RA register
	 ADD     RA,2             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #TB
	 LACC    TB,9             ; Initialize TB and RB register
	 ADD     RB,2             ;
	 ADD     #02h             ;
	 CALL    AIC_2ND          ;
	 ;------------------------
	 LDP     #AIC_CTR
	 LACC    AIC_CTR,2        ; Initialize control register
	 ADD     #03h             ;
	 CALL    AIC_2ND          ;
	 RET                      ;

AIC_2ND:
	 LDP     #0               ; Data page point is 0  (MM regs)
	 SACH    DXR              ; send ACChi 00
	 CLRC    INTM             ; enable interrupts
	 IDLE                     ; wait for interrupt
	 ADD     #6h,15           ; 0000 0000 0000 0011 XXXX XXXX XXXX XXXX b
	 SACH    DXR              ; send ACChi to initiate secondary protocol
	 IDLE                     ; wait for interrupt
	 SACL    DXR              ; send the T register data
	 IDLE                     ; wait for interrupt
	 LACL    #0               ; clear ACClo
	 SACL    DXR              ; send another to make sure 1st word got sent
	 IDLE                     ; wait for interrupt
	 SETC    INTM
	 RET                      ;
	.END

