/*******************************************************************************
 TESINA n5 per esame di: ELABORAZIONI dei SEGNALI ed INFORMAZIONI di MISURA:

 NOMEFILE: Unit3.cpp (Oscilloscopio)

 NOTE: Nel file  riportata l'istanza dell'oggetto Oscilloscopio e gli eventi
       relativi ai Click sui bottoni del pannello.
*******************************************************************************/

#include <vcl.h>
#pragma hdrstop
#include "Interfaccia.h"        // Header del file, di quelli contenenti i
#include "Unit3.h"              // prototipi delle classi necessarie, e delle
#include "decl-32.h"            // funzioni relative alla GPIB

#pragma package(smart_init)
#pragma resource "*.dfm"

TForm3 *Form3;                  // Istanza dell'oggetto Pannello Oscilloscopio
TOscilloscopio *Oscilloscopio;  // Istanza dell'oggetto Oscilloscopio

//---------------------------------------------------------------------------
__fastcall TForm3::TForm3(TComponent* Owner) : TForm(Owner) { }
//---------------------------------------------------------------------------

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata della funzione di AutoSet
  che varia le scale orizzontali e verticali in modo tale da garantire una
  buona visualizzazione del segnale.
*******************************************************************************/
void __fastcall TForm3::Button1Click(TObject *Sender)
{
  Oscilloscopio->AutoSet();
}

/*******************************************************************************
  All'evento Click del tasto  associata la chiamata della funzione di Reset,
  che porta lo strumento nelle condizioni preimpostate(default) dal costruttore.
*******************************************************************************/
void __fastcall TForm3::Button10Click(TObject *Sender)
{
  Oscilloscopio->Reset();
}

/*******************************************************************************
  All'evento Click sul RadioGroupBox "Esecuzione" sono associate,a seconda della
  scelta effettuata, le chiamate di funzione: Run o Stop sull'Oscilloscopio, che
  rispettivamente bloccano/sbloccano la visualizzazione del segnale sullo
  strumento.
*******************************************************************************/
void __fastcall TForm3::EsecuzioneClick(TObject *Sender)
{
  if (Esecuzione->ItemIndex == 0)
    Oscilloscopio->Run();
  else
    Oscilloscopio->Stop();
}

/*******************************************************************************
  All'evento Click sul RadioGroupBox "Pannello" sono associate,a seconda della
  scelta effettuata, le chiamate di funzione: Lock o UnLock sull'Oscilloscopio,
  che rispettivamente bloccano/sbloccano il pannello frontale dello strumento.
*******************************************************************************/
void __fastcall TForm3::PannelloClick(TObject *Sender)
{
  if (Pannello->ItemIndex == 0)
     Oscilloscopio->Lock();
  else
     Oscilloscopio->UnLock();
}

/*******************************************************************************
  All'evento Click sul RadioGroupBox "Canale1"  associata, a seconda della
  scelta effettuata, la chiamata della funzione CH. Con tale richiesta si
  permette di accendere o spegnere la traccia del segnale del canale 1 sullo
  strumento Oscilloscopio rilevato.
*******************************************************************************/
void __fastcall TForm3::Canale1Click(TObject *Sender)
{
  if (Canale1->ItemIndex == 0)
     Oscilloscopio->CH(1,true);
  else
     Oscilloscopio->CH(1,false);
}

/*******************************************************************************
  All'evento Click sul RadioGroupBox "Canale2"  associata, a seconda della
  scelta effettuata, la chiamata della funzione CH. Con tale richiesta si
  permette di accendere o spegnere la traccia del segnale del canale 2 sullo
  strumento Oscilloscopio rilevato.
*******************************************************************************/
void __fastcall TForm3::Canale2Click(TObject *Sender)
{
  if (Canale2->ItemIndex == 0)
    Oscilloscopio->CH(2,true);
  else
    Oscilloscopio->CH(2,false);
}

/*******************************************************************************
 All'evento Change della ScrollBar viene richiamata la funzione Contrasto,
 relativa all'Oscilloscopio, con il valore position della scrollBar.
*******************************************************************************/
void __fastcall TForm3::ContrValChange(TObject *Sender)
{
  Oscilloscopio->Contrasto(ContrVal->Position);
}

/*******************************************************************************
 All'evento Click sul componente UpDown si cambia la scala verticale sul CH1
*******************************************************************************/
void __fastcall TForm3::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
  Oscilloscopio->ScalaV(1,UpDown1->Position);
}

/*******************************************************************************
 All'evento Click sul componente UpDown si cambia la scala verticale sul CH2
*******************************************************************************/
void __fastcall TForm3::UpDown2Click(TObject *Sender, TUDBtnType Button)
{
   Oscilloscopio->ScalaV(2,UpDown2->Position);
}

/*******************************************************************************
 All'evento Click sul componente UpDown sposta verticalmente il segnale sul CH1
*******************************************************************************/
void __fastcall TForm3::UpDown3Click(TObject *Sender, TUDBtnType Button)
{
   Oscilloscopio->PosizV(1,UpDown3->Position);
}

/*******************************************************************************
 All'evento Click sul componente UpDown sposta verticalmente il segnale sul CH2
*******************************************************************************/
void __fastcall TForm3::UpDown4Click(TObject *Sender, TUDBtnType Button)
{
   Oscilloscopio->PosizV(2,UpDown4->Position);
}


/*******************************************************************************
 All'evento Click sul componente UpDown sposta orizzontalmente il segnale
*******************************************************************************/
void __fastcall TForm3::HorizPosChange(TObject *Sender)
{
  Oscilloscopio->CHscalaH(HorizPos->Position);
}

/*******************************************************************************
  All'evento Click sul RadioGroupBox "Sonda"  associata, a seconda della
  scelta effettuata, la chiamata della funzione AttenuaSonda. Con tale richiesta
  si permette di settare il tipo di attenuazione della sonda sul segnale
  acquisito sul canale. I valori leciti sono 1, 10, 100 e 1000.
*******************************************************************************/
void __fastcall TForm3::SondaClick(TObject *Sender)
{
  switch (Sonda->ItemIndex)
  {
    case 0: Oscilloscopio->AttenuazSonda(1000); break;
    case 1: Oscilloscopio->AttenuazSonda(100); break;
    case 2: Oscilloscopio->AttenuazSonda(10); break;
    case 3: Oscilloscopio->AttenuazSonda(1); break;
  }
}


