function res = reorder(num, p)
%p  il numero di cifre in base 4 utilizzate nella rappresentazione 
%num  la posizione di cui si vuole sapere il valore riordinato
%res  la nuova posizione corrispondente

%calcolo delle cifre in base 4 che rappresentano i numero
for i = 1 : p
    c(i) = rem(num,4);
    num = fix(num/4);
end;

%calcolo delvalore ottenuto invertendo le cifre in base 4
res = 0;
for i = 1 : p
    res = res + c(p-i+1)*(4^(i-1));
end


%TEORIA ORDINAMENTO n BIT-REVERSED
%
%Sia n >=1,
%sia B il numero di bit che abbiamo a disposizione
%per rappresentare tutti i numeri che ci interessano, 
%sia x il numero (rappresentabile con B bit) da riordinare,
%
% x = b(B-1) b(B-2)   ...   b4 b3 b2 b1 b0
%
