function y = plotSpec(x, fc, y)
%
%function y = plotSpec(x, fc, y)
%
% fc  la frequenza di campionamento utilizzata per ricavare i campioni
% x  il vettore dei campioni del segnale
% y  il vettore risultante dalla DFT (dopo aver applicato il modulop!!!)

[numRighe, numColonne] = size(x);

for k = 1 : (numColonne)
   n(k) =  fc * (k-1) / numColonne;
end;


% crea una nuova figura
hold on;
plot(n,y);

max = 0;

for k = 1 : (numColonne)
   plot([n(k), n(k)], [0, y(k)],'r-');
   
   if y(k)>max
      max = y(k);   
   end;
end;

% definisco gli estremi degli assi cartesiani x,y
xINF = -fc/20 ;
xSUP = fc/2 + fc/20;
yINF = -1 ;
ySUP = max+1;

% centro il grafico in base agli estremi
axis([xINF xSUP yINF ySUP]);

% traccio gli assi
ax = line([xINF, xSUP],[0 0]);
ay = line([0, 0],[yINF, ySUP]);
set(ax, 'Color', 'black');
set(ay, 'Color', 'black');

% traccio il confine di fc/2
afc = line([fc/2, fc/2],[yINF, ySUP]);
set(afc, 'Color', 'green', 'LineStyle', '-');

% traccio griglia
grid on;

% traccio etichette
xlabel('Hz');
ylabel('|S|');
title('Grafico dello Spettro del segnale S ricavato dalla DFT');

% visualizza informazioni
frequenza_campionamento_Hz = fc
numero_campioni = numColonne
banda_spettrale_Hz = fc/2
risoluzione_in_frequenza_Hz = fc / numColonne




